/***********************************************************************
*
* io.h - IBM 7090 emulator I/O definitions.
*
* Changes:
*   ??/??/??   PP    Original.
*   01/20/05   DGP   Changes for correct channel operation.
*   01/28/05   DGP   Revamped channel and tape controls.
*	
***********************************************************************/

/*
 * I/O device numbering:
 *	0	Card reader (711 Channel A)
 *	1	Card punch  (721 Channel A)
 *	2	Printer     (716 Channel A)
 *	3-12	Tapes channel A
 *	13-22	Tapes channel B
 *	...and so on
 */

#define IODEV (10*NUMCHAN+3)
#define MAXNAME 73

#define READ  1
#define WRITE 2
#define RDWRT 3

#define TAPESIZE 2000000

typedef struct
{
   FILE *iofd;
   int  iochn;
   long iopos;
   char iobin;
   char iorw;
   char iostr[MAXNAME];
} IO_t;

EXTERN IO_t sysio[IODEV];

/* #define IODEBUG /* */

char *devstr(int dev);
char *parsedev(char *s, int *devp);
int opendev(char *s, int dev);
int mount(char *s);
int dismount(char *s);
void mounterr();
void listmount();
int readrec(int dev, char *buf, int len);
void bsr(int ch);
void bsf(int ch);
void writerec(int dev, char *buf, int len);
void dorewind(int dev);
void unload(int dev);
void wef(int ch);
void bincard(char *cnvbuf, unsigned short *crcol);
void cardbin(unsigned short *crcol, char *cnvbuf);
void cardbcd(unsigned short *cbuf, unsigned char *bbuf, int len);
void logstr(char *s);
void ioinit();
void iofin();
