
/*
 * I/O device numbering:
 *	0	Card reader (711 Channel A)
 *	1	Card punch  (721 Channel A)
 *	2	Printer     (716 Channel A)
 *	3-12	Tapes channel A
 *	13-22	Tapes channel B
 *	...and so on
 */

#define IODEV (10*NUMCHAN+3)
#define MAXNAME 73

char iostr[IODEV][MAXNAME];
FILE *iofd[IODEV];
long iopos[IODEV];
char iorw[IODEV];
char iobin[IODEV];

/* #define IODEBUG /* */

char *devstr(int dev);
char *parsedev(char *s, int *devp);
int opendev(char *s, int dev);
int mount(char *s);
int dismount(char *s);
void mounterr();
void listmount();
void readrec(int dev, char *buf, int len);
void bsr(int ch);
void bsf(int ch);
void writerec(int dev, char *buf, int len);
void dorewind(int dev);
void unload(int dev);
void wef(int ch);
void bincard(char *cnvbuf, unsigned short *crcol);
void cardbin(unsigned short *crcol, char *cnvbuf);
void cardbcd(unsigned short *cbuf, unsigned char *bbuf, int len);
void logstr(char *s);
void ioinit();
void iofin();
