      HED ** RTE EDITOR DVICE SUBROUTINE ** JDR 
* SUBROUTINE TO FETCH A DEVICE LOGICAL UNIT NUMBER OR A 
* FILE NAME 
      SPC 1 
* CALL SEQUENCE 
*     DIRECTIVE LINE IN CBUF
*     NCHAR = 1ST CHARACTER WHERE SCAN IS TO START IN CBUF
*     JSB DVICE 
*     RETURN
*     LFMP = 1  & FILE NAME IN LFILE
*     LFMP = 0  & LUN IN LNLU 
*     ELSE GO TO BAD DIRECTIVE BRANCH 
      SPC 1 
DVICE NOP 
      CLA          ZERO 
      STA LFMP      LFMP FLAG 
      JSB SCANR    SCAN COMMAND LINE
      LDA IERR     ERROR
      SZA           DURING SCAN?
      JMP .D8        YES - BAD DIRECTIVE
      LDA TYPE     END
      SZA,RSS       OF LINE?
      JMP .D8        YES - BAD DIRECTIVE
      SSA,RSS        NO - 
      JMP DV1         TYPE &
      LDA NCHAR        CHARACTER COUNT
      SSA               LESS THAN 0?
      JMP .D8            YES - BAD DIRECTIVE
      SPC 1 
* MUST BE EITHER LOGICAL UNIT OR FILE NAME - WHICH IS IT
      SPC 1 
DV1   LDA TYPE     FILE 
      SSA           NAME? 
      JMP DV2        YES - TRANSFER IT TO LFILE 
      LDA TBUF       NO - STORE 
      STA LNLU        LOGICAL UNIT NO. AT LNLU
      JMP DVICE,I      & RETURN 
      SPC 1 
* TRANSFER FILE NAME & SET LFMP FLAG
      SPC 1 
DV2   DLD TBUF     STORE
      DST LFILE     FILE
      LDA TBUF+2     NAME IN
      STA LFILE+2     LFILE 
      ISZ LFMP     SET LFMP FLAG
      JMP DVICE,I  RETURN 
      HED ** RTE EDITOR EJECT SUBROUTINE ** JDR 
* SUBROUTINE TO FORM FEED THE LIST DEVICE 
      SPC 1 
* CALL SEQUENCE 
*     JSB EJECT 
*     RETURN
      SPC 1 
EJECT NOP 
      JSB EXEC      MAKE
      DEF *+4      EXEC 
      DEF D3       I/O
      DEF PAGE     CONTROL
      DEF M1       CALL 
      JMP EJECT,I   RETURN
      HED  ** RTE EDITOR FCLOS SUBROUTINE ** JDR
* SUBROUTE TO CLOSE A FILE MANAGER FILE 
      SPC 1 
* CALLING SEQUENCE
*   A = ADDRESS OF FMP DCB
*   B = ADDRESS OF NUMBER OF BLOCKS TO RELEASE
*     JSB FCLOS 
*     RETURN
      SPC 1 
FCLOS NOP 
      STA FOC1
      STB FOC2
      JSB CLOSE 
      DEF *+4 
FOC1  NOP 
      DEF IERR
FOC2  NOP 
      JMP FCLOS,I 
      HED ** RTE EDITOR FIXUM SUBROUTINE ** JDR 
* SUBROUTINE TO UPDATE THE DCB'S FOR THE COMMAND FILE AND 
* LINE FILE IF BOTH FILES ARE THE SAME. 
      SPC 1 
* CALL SEQUENCE 
*     JSB FIXUM 
*     DEF XDCB
*     DEF YDCB
*     RETURN
*  IF THE DCB'S ARE FOR THE SAME FILE, THE YDCB IS
*  SET EQUAL TO THE XDCB ELSE XDCB & YDCB UNCHANGED 
      SPC 1 
FIXUM NOP 
      LDA FIXUM,I  SET UP 
      STA PNTR1     POINTER 
      ISZ FIXUM      FOR
      LDA FIXUM,I     THE TWO 
      STA PNTR2        DCB'S
      ISZ FIXUM    INDEX TO RETURN ADDRESS
      LDA M10      -10
      STA CNTR1     TO CNTR1
      SPC 1 
* COMPARE THE TWO DCB'S TO SEE IF THEY ARE OPEN TO THE SAME FILE
      SPC 1 
      LDA PNTR1,I  THESE
      CPA PNTR2,I   WORDS EQUAL?
      RSS            YES - CONTINUE 
      JMP FIXUM,I    NO - RETURN
      ISZ PNTR1    INDEX THE
      ISZ PNTR2     DCB POINTERS
      ISZ CNTR1    ALL 10 WORDS COMPARED? 
      JMP *-7       NO - LOOP 
      SPC 1 
* BOTH POINT TO THE SAME FILE - UPDATE THE 2ND WITH THE 1ST 
      SPC 1 
      LDA M134     -134 
      STA CNTR1     TO CNTR1
      LDA PNTR1,I  TRANSFER 
      STA PNTR2,I   A WORD
      ISZ PNTR1    INDEX THE
      ISZ PNTR2     POINTERS
      ISZ CNTR1    DONE?
      JMP *-5       NO - LOOP 
      JMP FIXUM,I   YES - RETURN
      HED ** RTE EDITOR FOPEN SUBROUTINE ** JDR 
* SUBROUTINE TO OPEN A FILE MANAGER FILE
      SPC 1 
* CALLING SEQUENCE
*   A = ADDRESS OF FILE NAME
*   B = ADDRESS OF FMP DCB
*     JSB FOPEN 
*     RETURN
*   A = ERROR CODE
      SPC 1 
FOPEN NOP 
      STA FOP2     STORE FILE NAME &
      STB FOP1      DCB ADDRESSES IN OPEN CALL
      JSB OPEN     MAKE 
      DEF *+5       FMP 
FOP1  NOP            NON-EXCLUSIVE
      DEF IERR        UPDATE
FOP2  NOP              OPEN 
      DEF D3            CALL
      JSB IFMGR    CHECK
      DEF *+5       FOR 
      DEF IERR       FMP
      DEF D8          OPEN
      DEF TTY          ERROR &
      DEF FOP2,I        PRINT ERROR 
      JMP FOPEN,I  RETURN 
      HED ** RTE EDITOR FTYPE SUBROUTINE ** JDR 
* SUBROUTINE TO OPEN A SOURCE FILE TO THE LDCB
      SPC 1 
* CALLING SEQUENCE
*     JSB FTYPE 
*     NORMAL RETURN  -  FILE OPEN TO LDCB 
* 
*     ERROR RETURNS 
*      1. TO .D2 IF FILE IS NOT A TYPE 3 OR 4.
*      2. TO .D8 IF THERE IS AN OPEN ERROR. 
      SPC 1 
FTYPE NOP 
      LDA LFILD     OPEN
      LDB LDCB     FILE TO
      JSB FOPEN    LDCB 
      SSA           OPEN ERROR? 
      JMP .D8      YES - DIRECTIVE ERROR
      CPA D3        TYPE 3? 
      JMP FTYPE,I  YES - RETURN 
      CPA D4        TYPE 4? 
      JMP FTYPE,I  YES - RETURN 
      JMP L.25     NO - OUTPUT FILE TYPE ERROR MESS.
      HED ** RTE EDITOR INSRT SUBROUTINE ** JDR 
* SUBROUTINE TO INSERT LINES INTO THE EDITOR WORKING FILE 
      SPC 1 
* CALL SEQUENCE 
*   ALL POINTERS IN ARRAY WL--
*     JSB INSRT 
*     RETURN
*     A = -1 POINTERS NOT UPDATED OR LINES DID NOT FIT
*     A =  0 LINES INSERTED 
*     A =  1 PREMATURE EOF ON INPUT - LINES NOT INSERTED
      SPC 1 
INSRT NOP 
      LDA WLAST    INITIALIZE WORK
      INA           FILE WRITE RECORD 
      STA START      POINTER
      SPC 1 
* GET LINE TO BE INSERTED 
      SPC 1 
IN30  LDA LFMP     MAKE 
      LDB LDCB      CALL
      JSB READL      TO 
      DEF LFILE       READL TO
      DEF WBUF5        READ A LINE
      LDA IERR     ANY
      SSA           READ ERRORS?
      JMP IN190      YES - EXIT A = -1
      LDA NWDS       NO - 
      SSA,RSS      EOF ENCOUNTERED? 
      JMP IN35      NO - CONTINUE 
      LDA EOF1      YES - EOF 
      SZA            FLAG SET?
      JMP IN85        YES - OKAY - UPDATE POINTERS
      LDA D8          NO - OUTPUT PREMATURE 
      LDB TTY          EOF ERROR
      JSB PRINT         MESSAGE 
      CLA,INA      SET A = 1 &
      JMP INSRT,I   RETURN
      SPC 1 
* CALCULATE LINE NUMBER 
      SPC 1 
IN35  LDA WL13     GET 1ST PART OF LAST INSERT LINE 
      LDB ISERT    IS INSERT
      SZB,RSS       INCREMENT ZERO? 
      JMP IN40       YES - INCREMENT 1ST PART 
      ADB WL23       NO - ADD LAST INSERT 2ND PART
      STB WBUF2       AND SAVE IN WBUF
      ADB M10K     IS 2ND PART >
      SSB           9999? 
      JMP IN45     NO - STORE 1ST PART IN WBUF
IN40  INA          YES - INCREMENT 1ST PART 
      CLB           AND ZERO
      STB WBUF2      2ND PART 
IN45  STA WBUF1    1ST PART TO WBUF 
      SPC 1 
* MAKE SURE THIS LINE WILL FIT
      SPC 1 
      LDA WL12     IS THIS INSERT 
      ADA WL22      AFTER THE 
      SZA,RSS        LAST LINE? 
      JMP IN60     YES - PROCEED WITH INSERT
      DLD WL12     NO - IS 1ST PART OF THIS LINE LT 
      CMA,INA       THE 1ST PART OF LINE
      ADA WBUF1      FOLLOWING
      SSA             THIS INSERT?
      JMP IN60     YES - PROCEED WITH INSERT
      SZA          NO - ARE THEY EQUAL? 
      JMP IN46      NO - LINE WILL NOT FIT
      CMB,INB       YES - IS NOT 2ND PART OF THIS 
      ADB WBUF2      INSERT LESS THAN THE 2ND PART
      SSB             OF THE LINE FOLLOWING INSERT? 
      JMP IN60     YES - PROCEED WITH INSERT
      SPC 1 
* LINE WILL NOT FIT - TRY TO ADJUST ISERT SO THAT IT WILL 
      SPC 1 
IN46  LDA ISERT    DIVIDE INSERT
      MPY D1        INCREMENT 
      DIV D20        BY 20
      STA ISERT     SAVE NEW INSERT INCREMENT 
      SZA          INSERT INCREMENT = 0?
      JMP IN35      NO - RECALCULATE THE LINE NUMBER
IN50  LDA D9        YES - LINES WILL
      LDB TTY        NOT FIT OUTPUT ERROR 
      JSB PRINT       MESSAGE AND TAKE A = -1 
      JMP IN190        ERROR EXIT 
      SPC 1 
* SET PRECEDING & FOLLOWING RECORD POINTERS 
      SPC 1 
IN60  LDA WLAST    GET LAST RECORD OF WORK FILE 
      LDB START    IF LAST RECORD EQUALS START OF 
      ADB M1        THIS RECORD -1 SET WBUF3 =
      CPB WLAST      TO WLAST + 1 ELSE
      INA             WBUF3 
      STA WBUF3        = WLAST
      ISZ WLAST    INCREMENT LAST RECORD POINTER
      LDA WLAST    SET NEXT RECORD POINTER OF THIS
      INA           LINE TO LAST
      STA WBUF4      + 1
      SPC 1 
* WRITE LINE INTO WORK FILE 
      SPC 1 
      LDA WLAST    MAKE 
      JSB WRIWF     CALL TO WRIWF 
      SSA          ANY WRITE ERRORS 
      JMP IN190     YES - EXIT WITH A = -1
      SPC 1 
* UPDATE CURRENT INSERT POINTERS
      SPC 1 
      DLD WBUF1    TRANSFER 
      DST WL13      1ST FOUR WORDS
      DLD WBUF3      OF WBUF TO 
      DST WL33        WLX3 ARRAY
      SPC 1 
* ANYMORE LINES 
      SPC 1 
      LDA EOF1     INSERT TO
      SZA           END OF FILE?
      JMP IN30       YES - CONTINUE INSERTING 
      ISZ LINES      NO - INSERT LINE CNTR ZERO?
      JMP IN30        NO - CONTINUE INSERTING 
      SPC 1 
* UPDATE ARRAY WL-- & EDITOR WORK FILE POINTERS 
      SPC 1 
IN85  LDA WLAST     SET POINTER TO
      STA PNTR1    LAST RECORD NUMBER 
IN85A CLA          CLEAR NEW FIRST &
      STA FIRST     LAST LINE 
      STA LAST       FLAGS
      LDA WL34     IF RECORD POINTER TO 1ST LINE
      SZA,RSS       EQUALS 0 THEN SET 
      ISZ FIRST      THE NEW FIRST LINE FLAG
      LDA PNTR1    GET THE LAST LINE INSERTED   
      JSB REDWF     INTO THE WORK FILE
      SSA          ANYREAD ERRORS?
      JMP IN180     YES - ERROR EXIT
      DLD WL14     GET 1ST LINE POINTERS
      CMA,INA      IF WBUF1 < 
      ADA WBUF1      WL14 
      SSA             OR
      JMP IN86      (WBUF1 = WL14 
      SZA             AND 
      JMP IN87       WBUF2  < WL24) 
      CMB,INB         THEN
      ADB WBUF2        SET NEW
      SSB               1ST LINE
IN86  ISZ FIRST          FLAG 
IN87  DLD WBUF1    IF 
      CMA,INA       WBUF1 > WL15
      ADA WL15      OR
      SSA          (WBUF1 = WL15
      JMP IN88        AND 
      SZA           WBUF2 > WL25) 
      JMP IN89       THEN 
      CMB,INB         SET 
      ADB WL25         THE
      SSB               NEW LAST
IN88  ISZ LAST           FLAG 
      SPC 1 
* UPDATE THE LAST INSERTED LINE'S POINTERS
      SPC 1 
IN89  LDA WL41     IF NOT A NEW FIRST LINE
      LDB FIRST     THE NEXT LINE POINTER 
      SZB            = THE LINE FOLLOWING THIS
      LDA WL34        INSERT ELSE IT EQUALS THE 
      STA WBUF4        OLD 1ST LINE 
      LDA LAST     IS THIS A
      SZA,RSS       NEW LAST LINE?
      JMP IN100      NO - CONTINUE
      LDA PNTR1      YES - SET NEXT LINE  
      STA WBUF4       POINTER TO THIS RECORD
      DLD WBUF1             & 
      DST WL15     UPDATE THE LAST LINE 
      DLD WBUF3     POINTERS IN 
      DST WL35       THE WL ARRAY 
IN100 LDA PNTR1    WRITE THE LAST INSERTED  
      JSB WRIWF     LINE BACK INTO THE WORK FILE
      SSA          ANY ERRORS?
      JMP IN180     YES - ABORT INSERT
      SPC 1 
* UPDATE THE LINE FOLLOWING THIS INSERT 
      SPC 1 
      LDA WL41     RECORD # IS IN WL41
      LDB FIRST     UNLESS THIS INSERT
      SZB            INCLUDES A NEW 
      LDA WL34        1ST LINE THEN IT IS IN WL34 
      LDB LAST     IF THIS INSERT INCLUDES A NEW
      SZB           LAST LINE THEN THERE IS NO LINE 
      JMP IN115      FOLLOWING THIS INSERT
      JSB REDWF    GET LINE TO UPDATE 
      SSA          ANY READ ERRORS
      JMP IN180     YES - ABORT 
      LDB PNTR1     NO - SET PRECEDING RECORD   
      STB WBUF3      POINTER TO LAST RECORD OF
      LDA RCORD       THIS INSERT & 
      JSB WRIWF        REWRITE LINE INTO WORK FILE
      SSA          ANY ERRORS?
      JMP IN180     YES - ABORT 
      SPC 1 
* UPDATE LINE PRECEDING THIS INSERT 
      SPC 1 
IN115 LDA FIRST    IF THIS INSERT INCLUDED A NEW
      SZA           1ST LINE, THERE IS NO LINE
      JMP IN125      PRECEDING THIS INSERT
      LDA WL32     GET PRECEDING LINE RECORD #
      SZA,RSS       ZERO? 
      LDA WL41     YES - RECORD # IS OLD LAST LINE
      JSB REDWF     LINE
      SSA          ANY READ ERRORS? 
      JMP IN180     YES - ABORT 
      LDA START    SET NEXT RECORD POINTER
      STA WBUF4     TO 1ST RECORD OF THIS INSERT
      LDA RCORD    REWRITE THE RECORD 
      JSB WRIWF     BACK INTO THE WORK FILE 
      SSA          ANY ERRORS?
      JMP IN180     YES - ABORT 
      SPC 1 
* UPDATE THE POINTERS OF THE 1ST LINE OF THIS INSERT
      SPC 1 
IN125 LDA START    GET 1ST LINE 
      JSB REDWF     OF INSERT 
      SSA          ANY READ ERRORS? 
      JMP IN180     YES - ABORT 
      LDA WL32     PRECEDING RECORD = 
      SZA,RSS      ZERO?
      LDA WL41     YES - SET TO OLD LAST LINE 
      STA WBUF3      TO WL32
      LDA FIRST    DID THIS INSERT INCLUDE
      SZA,RSS       A NEW FIRST LINE? 
      JMP IN140      NO - REWRITE THE LINE
      LDA START      YES - SET PRECEEDING RECORD
      STA WBUF3       POINTER TO THIS RECORD
      DLD WBUF1    UPDATE NEW 1ST 
      DST WL14      LINE POINTERS 
      DLD WBUF3      IN 
      DST WL34        ARRAY WL
IN140 LDA START    REWRITE RECORD 
      JSB WRIWF     INTO THE WORK FILE
      SSA          ANY ERRORS?
      JMP IN180     YES - ABORT 
      CLA           NO -
      JMP INSRT,I    RETURN 
      SPC 1 
* ERROR EXIT - POINTERS NOT UPDATED 
      SPC 1 
IN180 LDA D10      OUTPUT 
      LDB TTY       ERROR 
      JSB PRINT      MESSAGE
IN190 CCA          SET A TO -1
      JMP INSRT,I    RETURN 
      HED ** RTE EDITOR - KEYS SUBROUTINE ** JDR
* SUBROUTINE USED TO SET THE ECHO BIT AND KEYBOARD FLAG 
* FOR TTY & KYBD/CRT TYPE DEVICES.
      SPC 1 
* ENTER WITH LOGICAL UNIT IN A REG. 
*     JSB KEYS
*     DEF LOCATION TO STORE FLAG
*     DEF LOCATION TO STORE LOGICAL UNIT
      SPC 1 
KEYS  NOP 
      LDB KEYS,I    SAVE
      STB PNTR2    ADDRESSES
      ISZ KEYS     OF 
      LDB KEYS,I   KYBD FLAG &
      STB PNTR3    LUN
      ISZ KEYS      INDEX TO RETURN ADDRESS 
      LDB KYBDS    INTIALIZE POINTER TO KEYBOARD
      STB PNTR1     DEVICES' LIST 
      CLB          RESET KYBD 
      STB PNTR2,I   FLAG
KEYS1 LDB PNTR1,I  GET A LOGICAL UNIT IN KYBD LIST
      ISZ PNTR1    INDEX POINTER
      SZB,RSS      END OF LIST
      JMP KEYS2     YES - STORE LOGICAL UNIT  
      CPB AREG      NO - DOES THIS LUN MATCH? 
      RSS            YES - SET FLAG & ECHO BIT
      JMP KEYS1      NO - TRY NEXT ONE
      CLB,INB      SET THE
      STB PNTR2,I   KYBD FLAG 
      IOR ECHO     OR IN THE ECHO BIT 
KEYS2 STA PNTR3,I   STORE LUN 
      JMP KEYS,I   RETURN 
      HED ** RTE EDITOR LEADR SUBROUTINE ** JDR 
* SUBROUTINE TO PUNCH LEADER ON A LOGICAL UNIT
      SPC 1 
* CALL SEQUENCE 
*     JSB LEADR 
*     RETURN
      SPC 1 
LEADR NOP 
      LDA LNUM      LINE NUMBER 
      SZA          FLAG SET?
      JMP LEADR,I  YES - SKIP LEADER REQUEST
      LDA LNLU      FORM LEADER 
      IOR B1000    REQUEST CONTROL
      STA IERR     WORD 
      JSB EXEC      MAKE EXEC 
      DEF *+3      I/O
      DEF D3       CONTROL
      DEF IERR     CALL 
      JMP LEADR,I   RETURN
      HED ** RTE EDITOR LNUMB SUBROUTINE ** JDR 
* SUBROUTINE TO FETCH A NUMBER OR A LINE NUMBER FROM THE
* COMMAND DIRECTIVE LINE. 
      SPC 1 
* CALL SEQUENCE 
*    COMMAND DIRECTIVE IN CBUF ARRAY
*    NCHAR = 1ST CHARACTER TO BEGIN SCAN
*     JSB LNUMB 
*     RETURN
*     A = 1 ERROR! SCAN DID NOT CONTAIN A VALID LINE NUMBER 
*     A = 0 LINE NUMBER IN TBUF1 & TBUF2
*     A = -1 END OF DIRECTIVE LINE ENCOUNTERED
*     B = 0  NUMBER WAS NOT A PLUS SIGN 
*     B = 1  NUMBER WAS A PLUS SIGN - TBUF1 & TBUF2 = LAST LINE # 
      SPC 1 
LNUMB NOP 
      JSB SCANR     SCAN DIRECTIVE LINE 
      LDA IERR      ANY ERRORS
      SZA          ENCOUNTERED IN SCAN? 
      JMP LNUM2    YES - TAKE ERROR EXIT
      LDA TYPE     NO - END OF
      SZA,RSS      DIRECTIVE LINE?
      JMP LNUM1    YES - TAKE EOL EXIT
      SSA           POSSIBLE PLUS SIGN
      JMP LNUM3    YES - CHECK IT OUT 
LNUM0 CLB          NO - NUMBER
      CLA,RSS       IN TBUF1 & TBUF2
LNUM1 CCA           EOL EXIT A = -1 
      RSS           SKIP ERROR EXIT 
LNUM2 CLA,INA       ERROR EXIT A = 1
      JMP LNUMB,I   RETURN
      SPC 1 
* CHECK DIRECTIVE FOR A PLUS SIGN 
      SPC 1 
LNUM3 LDA TBUF      A PLUS SIGN 
      CPA PLUS     IN DIRECTIVE?
      RSS          YES - CONTINUE 
      JMP LNUM2    NO - TAKE ERROR EXIT 
      DLD WL15      PUT LAST LINE NUMBER
      DST TBUF     IN TBUF1 & TBUF2 
      CLB,INB       SET B = 1 
      JMP LNUM0    AND RETURN 
      HED ** RTE EDITOR LS? SUBROUTINE ** 
* SUBROUTINE TO CHECK LUN INPUT DEVICE FOR LUN 2 (LS TRACKS)
* IF LS TRACKS THEN INTIALIZE AND IF DECLARED RETURN ELSE PRINT 
* LS TRACKS EMPTY AND RETURN FOR NEW DIRECTIVE. 
* IF NOT LS TRACKS THEN OR IN ECHO BIT IF A KYBD TYPE DEVICE. 
      SPC 1 
* CALL SEQUENCE 
*     LUN STORED AT LOCATION LNLU 
*     JSB LS? 
*     RETURN (NORMAL) 
      SPC 1 
LS?   NOP 
      LDA LNLU      LUN 
      CPA D2       = 2? 
      JMP LS?1     YES - LS TRACKS
      JSB KEYS     NO - IF LUN IS A KYBD DEVICE THEN
      DEF LKYBD    OR ECHO BIT AND SET KYBD 
      DEF LNLU     FLAG 
      JMP LS?,I     RETURN
      SPC 1 
* MAKE SURE LS TRACKS HAVE BEEN DECLARED
      SPC 1 
LS?1  LDA SFCUN     ARE LS TRACKS 
      SZA          DECLARED?
      JMP LS?2     YES - INITIALIZED
      LDA D24      NO - PRINT 
      LDB TTY      LS TRACKS
      JSB PRINT    EMPTY MESSAGE &
      JMP .D2      FETCH NEXT DIRECTIVE 
      SPC 1 
* INITIALIZE LS TRACKS
      SPC 1 
LS?2  CLB           CLEAR THE 
      STB LKYBD    KYBD FLAG
      LSL 1        FORM LUN-TRACK 
      ADB D2       NUMBER AND 
      LSL 8        SET READ 
      STB RTRK1    TRACK NO. 1
      STB RTRKC    = CURRENT TRACK
      JSB %JFIL     INITIALIZE FOR 1ST READ 
      JMP LS?,I    AND RETURN 
      HED ** RTE EDITOR LSREL SUBROUTINE ** JDR 
* SUBROUTINE TO RELEASE THE LS TRACKS.
      SPC 1 
* CALL SEQUENCE 
*     1ST TRACK & LUN IN RTRK1
*     LAST TRACK & LUN IN RTRKC 
*     JSB LSREL 
*     RETURN
      SPC 1 
LSREL NOP 
      LDA RTRK1     GET LUN-TRACK NUMBER
      CLB           SPLIT 
      LSL 8        LUN - TRACK
      ALF,ALF      NUMBERS & SAVE 
      STB LUNDK    LUN AND
      STA TAK      TRACK
      JSB EXEC      CALL EXEC 
      DEF *+5      TO 
      DEF D5       RELEASE
      DEF D1       1 TRACK
      DEF TAK      TRACK #
      DEF LUNDK    LUN #
      LDA RTRK1     ALL TRACKS
      CPA RTRKC    RELEASED?
      JMP LSRL1    YES - FINISH UP
      LDB SECT2    NO - GET SYSTEM DISK SECTORS 
      ALF,ALF       LUN TO LOW A
      SLA           SYSTEM DISC?
      INB          NO - B1760 IS LOC OF AUX DISC
      ALF,ALF       RESET A 
      LDB BREG,I    GET # OF SECTORS/TRACK
      ADB M1       ADD -1 TO GET LAST SECTOR
      JSB %RDSC    READ LAST SECTOR OF TRACK
      STA RTRK1    PUT NEXT TRACK IN RTRK1
      JMP LSREL+1  AND RELEASE IT.
      SPC 1 
* CLEAR LS TRACK BASE PAGE WORD 
      SPC 1 
LSRL1 CLA 
      STA RTRK1     ZERO 1ST TRACK #
      JSB SETLS     CLEAR BASE PAGE LS WORD & 
      JMP LSREL,I  RETURN 
      HED ** RTE EDITOR MLINE SUBROUTINE ** JDR 
* SUBROUNTINE TO DETERMINE IF THE LAST LINE IS >= 
* TO THE 1ST LINE NUMBER
      SPC 1 
* CALL SEQUENCE 
*     1ST LINE # IN WL11 & WL21 
*     LAST LINE # IN LAST1 & LAST2
*     JSB MLINE 
*     RETURN IF LAST >= 1ST ELSE GO TO BAD DIRECTIVE BRANCH 
      SPC 1 
MLINE NOP 
      DLD WL11      GET 1ST LINE #
      CMA,INA      MAKE PART 1 NEGATIVE 
      ADA LAST1     & ADD IT TO PART 1 OF 1ST 
      SSA          1ST < LAST?
      JMP .D8       NO - BAD DIRECTIVE
      SZA          ARE 1ST PART EQUAL?
      JMP *+5       NO - 1ST < LAST RETURN
      CMB,INB      MAKE 2ND PART OF 1ST NEGATIVE
      ADB LAST2    ADD TO 2ND PART OF 1ST 
      SSB          1ST < LAST?
      JMP .D8       NO - BAD DIRECTIVE
      JMP MLINE,I   & RETURN
      HED ** RTE EDITOR OUT SUBROUTINE ** JDR 
* SUBROUTE TO OUTPUT NWDS VIA AN EXEC CALL
      SPC 1 
* CALLING SEQUENCE
*     A = BUFFER ADDRESS
*     B = LOGICAL UNIT NUMBER 
*     JSB OUT 
*     RETURN
      SPC 1 
OUT   NOP 
      STA *+6      PUT BUFFER AND 
      STB *+4       LUN ADDRESSES IN CALL 
      JSB EXEC     MAKE 
      DEF *+5       OUTPUT
      DEF D2         REQUEST
      NOP             TO
      NOP              EXEC 
      DEF NWDS          FOR NWDS OUT
      JMP OUT,I    RETURN 
      HED  ** RTE EDITOR POSNT SUBROUTINE ** JDR
* SUBROUTINE TO POSITION AN INPUT LOGICAL UNIT OR FMP FILE
* FORWARD X RECORDS.
      SPC 1 
* CALLING SEQUENCE
*     A = RECORD NUMBER OF FIRST RECORD TO BE READ
*     JSB POSIT 
*     RETURN - NORMAL 
* IF EOF OR READ ERROR RETURN IS TO NEW COMMAND DIRECTIVE AFTER 
* THE APPROPRIATE DIAGNOSTIC MESSAGE HAS BEEN PRINTED.
      SPC 1 
POSIT NOP 
      CMA,INA      MAKE RECORD NUMBER NEGATIVE &
      INA           INCREMENT BY ONE
      SSA,RSS      ARE THERE ANY RECORDS TO SKIP? 
      JMP POSIT,I   NO, RETURN
      STA CNTR1     YES - SET UP A COUNTER
      SPC 1 
* POSITION INPUT
      SPC 1 
P01   LDA LFMP     MAKE CALL
      LDB LDCB      TO READL
      JSB READL      TO READ
      DEF LFILE       ONE 
      DEF WBUF5        RECORD 
      LDA IERR     WAS THERE
      SZA           A FMP ERROR 
      JMP .D2        YES - GET NEW DIRECTIVE
      LDA NWDS       NO - END OF
      SSA             FILE ENCOUNTERED? 
      JMP P02          YES - PRINT ERROR MESSAGE
      ISZ CNTR1    INCREMENT COUNTER - DONE?
      JMP P01       NO - SPACE FORWARD ANOTHER ONE
      JMP POSIT,I   YES - RETURN
      SPC 1 
* EOF ENCOUNTERED DURING POSITION - OUTPUT ERROR MESSAGE
*         AND RETURN FOR NEW DIRECTIVE
      SPC 1 
P02   LDA D8       PRINT EOF ON INPUT 
      LDB TTY       ERROR MESSAGE 
      JSB PRINT      AND
      JMP .D2         FETCH NEW DIRECTIVE 
                                                                                                                                                                               