
*  MITTING STATION.
* 
* 
* EXECUTION:
* 
*  1. WAIT FOR 2 SECONDS.
*  2. SEND "DLE WABT" TO THE TERMINAL.
*  3. TRML SENDS BACK "ENQ".
*  4. GO TO STEP 1.
      SPC 3
* 
*           *** DEACTIVATION SEGMENT. ***
* 
* THIS SEGMENT DEACTIVATES THE "TTD" GENERATOR AS WELL AS THE "WABT"
* GENERATOR.
* 
SGEN  NOP           ENTRY POINT.
      CLB
      LDA WACT      IN CRITICAL PART
      SZA           OF 'WABT' GENERATOR?
      JMP SGEN,I    YES, WAIT.
      LDA DACT      IN CRITICAL PART
      SZA,RSS       OF 'TTD' GENERAOTR?
      STB TACT      NO, DISABE TIMEOUT CLOCK.
      JMP SGEN,I    RETURN.
* 
*           *** SEGMENT ONE: ACTIVATOR. ***
* 
WACTV NOP           ENTRY POINT.
* 
WACTR LDA =D200     ACTIVATE
      LDB ADWT1     TIME INTERRUPT
TLP   JSB TACTV     LOOP.
      JMP WACTV,I   RETURN.
      SPC 3
* 
*           *** SEGMENT TWO: EXECUTES ONE "WABT". ***
* 
WABT1 CLA,INA       SET STATUS
      STA WACT      TO "BUSY".
      STA SCASE     SET UP FOR "SPECIAL CASE".
      JSB UPCAR     TURN ON CARRIER.
      LDA PAD       PUT PAD CHARACTER
      STA RSEND     IN STRING BUFFER.
      LDA DLE       NEXT, PLACE
      STA RSEND+1   "DLE WABT"
      LDA WABT      IN
      STA RSEND+2   STRING BUFFER.
      LDA RESH      GET STRING S.A..
      LDB =B3       GET STRING LENGTH
      STB RESLN     AND SAVE IN REPEAT STRING LGTH.
      JSB CNTRL     OUT-PUT STRING.
      LDA =D200     ACTIVATE
      LDB ADWT1     TIME INTERRUPT
      JSB TACTV     LOOP.
      JSB .IO.      CLEAR
      OCT 100011    FLAG.
      CLA           CLEAR
      STA WACT      BUSY FLAG
      STA SCASE     AND SPECIAL CASE FLAG.
      JMP EXIT      EXIT.
      SPC 3
* 
*           *** DATA ***
* 
ADWT1 DEF WABT1     POINTS TO EXECUTION SEG OF WABT.
WACT  OCT 0         IF = 1, THEN WABT IS BUSY.
      HED "TEMPORARY TEXT DELAY" GENERATOR.
* 
*           *** "TTD" SUBROUTINE ***
* 
* 
* USE:
* 
*  WHILE IN RECEIVE MODE THIS SUBROUTINE WILL HOLD OFF THE RECEIVING
*  STATION.
* 
* 
* EXECUTION:
* 
*  1. WAIT FOR 2 SECONDS.
*  2. SEND "STX ENQ" TO THE TERMINAL.
*  3. TERMINAL SENDS BACK "NAK".
*  4. GO TO STEP 1.
      SPC 3
* 
*           *** SEGMENT ONE: ACTIVATOR. ***
* 
DACTV NOP           ENTRY POINT.
* 
DACTR LDA =D200     ACTIVATE
      LDB ADTD1     TIME INTERRUPT
DLP   JSB TACTV     LOOP.
      JMP DACTV,I   RETURN.
      SPC 3
* 
*           *** SEGMENT ONE: EXECUTES ONE "TTD". ***
* 
DABT1 CCA           SET STATUS
      STA DACT      TO BUSY.
      STA SCASE     SET UP FOR "SPECIAL CASE".
      JSB UPCAR     TURN ON CARRIER.
      LDA PAD       PUT PAD CHARACTER
      STA RSEND     IN STRING BUFFER.
      LDA STX       NEXT, PLACE
      STA RSEND+1   "STX ENQ"
      LDA ENQ       IN
      STA RSEND+2   STRING BUFFER.
      LDA RESH      GET STRING S.A..
      LDB =B3       GET STRING LENGTH
      STB RESLN     AND SAVE IN REPEAT STRING LGTH.
      JSB CNTRL     OUT-PUT STRING.
      LDA =D200     ACTIVATE
      LDB ADTD1     TIME INTERRUPT
      JSB TACTV     LOOP.
      JSB .IO.      CLEAR
      OCT 100011    FLAG.
      CLA           CLEAR
      STA DACT      BUSY FLAG
      STA SCASE     AND SPECIAL CASE FLAG.
      JMP EXIT      EXIT.
      SPC 3
* 
*           *** DATA ***
* 
ADTD1 DEF DABT1     POINTS TO EXECUTION SEG OF TTD.
DACT  OCT 0         IF = 1, THEN TTD PROCESSOR ACTVE
      HED I/O BOARD COMMUNICATIONS SUBROUTINES.
* 
*           *** I/O BOARD CONTROL. ***
* 
* THIS MODULE DIRECTS AN I/O BOARD REQUEST TO THE APPROPRIATE I/O
* BOARD PROCESSOR.
      SPC 3
* 
* CONFIGURE SEGMENT.
* 
.IOI. NOP           ENTRY POINT.
* 
      LDA EQT1A,I   GET DEVICE'S EQT TABLE ENTRY.
      LDB JSYNC     GET
      AND =B100     THE
      SZA,RSS       PROPER
      LDB JASNC     JUMP INSTRUCTION
      STB .IO.+1    AND STORE.
* 
      JSB .IO.      CONFIGURE
      OCT 4         I/O BOARD MODULE.
* 
      JMP .IOI.,I   RETURN.
      SPC 3
* 
* REQUEST SEGMENT.
* 
.IO.  NOP           ENTRY POINT.
      JMP *         JUMP TO APPROPRIATE DRIVER.
JASNC JMP ASYNR
      SKP
* 
*    *** SYNCHRONOUS I/O BOARD MODULE ***
* 
*   CALLING SEQUENCE:
* 
*      JSB .IO.
*      OCT (CODE)
* 
*   CODE FUNCTIONS:
* 
*        0    TURN OFF SEND I/O BOARD
*  100000    TURN OFF RECEIVE I/O BOARD
*        1    CLEAR FLAG ON SEND BOARD
*  100001    CLEAR FLAG ON RECEIVE BOARD
*        2    SET CONTROL AND CLEAR FLAG ON SEND BOARD
*  100002    SET CONTROL AND CLEAR FLAG ON RECEIVE BOARD
*        3    GET SEND BOARD STATUS
*  100003    GET RECEIVE BOARD STATUS
*        4    CONFIGURE I/O INSTUCTIONS
*        5    OUTPUT SEND CONTROL WORD
*        6    OUTPUT RECEIVE CONTROL WORD
*        7    SEND CHARACTER TO I/O BOARD
*       10    GET RECEIVED CHARACTER FROM BOARD
*       11    CLEAR CONTROL,CLEAR FLAG ON SEND BOARD
*  100011    CLEAR CONTROL,CLEAR FLAG ON RECEIVE BOARD
*       12    OUTPUT ^SYNC^ CHARACTER TO SEND BOARD
*  100012    OUTPUT ^SYNC' CHARACTER TO RECEIVE BOARD
*       13    WAIT UNTIL FLAG IS SET ON SEND BOARD
*  100013    WAIT UNTIL FLAG IS SET ON RECEIVE BOARD
* 
      STB BSV       SAVE B REG
      LDA .IO.      NOTE CALL
      LDB =B2       IN TRACE
      JSB TRACE
      LDB BSV       RESTORE B REG
* 
      LDA .IO.,I    GET FUNCTION CODE
      SSA    I/O FOR RECEIVE BOARD?
      ADA =D12      YES,CHANGE TABLE LOOKUP
      AND =B37      GET TABLE INDEX
      ADA ADSPS     ADD TO TABLE STARTING ADDR
      JMP A,I      JUMP TO APPROPRIATE PROCESSOR
      SPC 3
* 
* 
SYN0S LDA =B140000    GET CONTROL WORD.
SCLC1 CLC 0,C     DISABLE INTERRUPTS
OTA1S OTA 0,C   TURN OFF I/O BOARD (SEND)
      JMP SRET     RETURN
* 
SYN0R LDA =B140000   RECEIVE BOARD
SCLC2 CLC 0,C    CLEAR CONTROL
OTA1R OTA 0,C
      JMP SRET
* 
* CLEAR FLAG
* 
SYN1S CLF 0   CLEAR FLAG ON I/O BOARD
      JMP SRET    RETURN
* 
SYN1R CLF 0
      JMP SRET   RECIEVE BOARD INSTRS
* 
* SET CONTROL,CLEAR FLAG (NOT EXECUTED UNTIL "EXIT" COMMAND
* 
SYN2S LDA STC1S    CONFIGURE INSTRUCTIONS FOR
      STA STC1     SEND BOARD
      STA STC2
      LDA =B-1
      STA SETCN     SET CONTROL AND CLEAR FLAG
      JMP SRET   UPON EXIT
* 
SYN2R LDA STC1R    CONFIGURE INSTRUCTIONS
      STA STC1
      STA STC2    FOR RECEIVE BOARD
      LDA =B-1    SET CONTROL AND
      STA SETCN    CLEAR FLAG UPON
      JMP SRET    EXIT
* 
* GET BOARD STATUS
* 
SYN3S LIA 0   LOAD A-REG
      JSB UNSCS     WITH STATUS BITS COMPATIBLE
      JMP SRET    TO ASYNC STANDARDS
* 
SYN3R LIA 0    LOAD A REG
      JSB UNSCR     WITH STATUS BITS COMPATIBLE
      JMP SRET   TO ASYNC STANDARDS
* 
* CONFIGURE I/O INSTRUCTIOHS
* 
SYN4  LDA EQT1A,I    GE TDEVICES
      AND =B77      CHANNEL NUMBER
      STA B    IN B-REG
* 
      IOR OTA   FORM CONFIGURED OTA
      STA OTA1R
      STA OTA6R   CONFIGURE RECEIVE BOARD
      STA OTA4R
      INA
      STA OTA1S     CONFIGURE SEND BOARD
      STA OTA2S
      STA OTA3S
      STA OTA4S
      STA OTA6S
      STA OTA7S
* 
      LDA CLC    FORM CONFIGURED
      IOR B    CLC XX,C
      STA SCLC2
      STA SYNBR
      INA      INCREMENT FOR SEND BOARD
      STA SCLC1    CONFIGURE
      STA SYNBS    REQUIRED INSTR.
* 
      LDA STC    FORM CONFIGURED
      IOR B    STC XX,C
      STA STC1R
      INA
      STA STC1S
* 
      LDA LIA    FORM CONFIGURED
      IOR B    LIA XX
      STA LIA1R
      STA SYN3R
      INA
      STA SYN3S
* 
      LDA SFS    FORM CONFIGURED
      IOR B   SFS XX
      STA SYNDR
      INA
      STA SYNDS
* 
      LDA CLF    FORM CONFIGURED
      IOR B   CLF XX
      STA SYN1R
      INA
      STA SYN1S
* 
      CLA           CONFIGURE 'READ' PROCESSOR
      STA .RSS      TO IGNORE VERTICAL PARITY.
      JMP SRET
* 
* SET UP BOARD TO SEND
* 
SYN5  LDA SSEND    GET SYNC CONFIGURED CONTROL WORD
OTA3S OTA 0,C    OUTPUT TO I/O BOARD
      JMP SRET    RETURN
* 
*  SET UP BOARD TO RECEIVE
* 
SYN6  LDA STOR      CHANGE SEND BOARD.
OTA4S  OTA 0,C   TO RECEIVE CONDITION
      LDA SREVC   GET SYNC CONFIGURED CONTROL WORD
OTA4R OTA 0,C    OUTPUT TO I/O BOARD
      JMP SYNCR     RETURN
* 
* SEND CHARACTER TO THE I/O BOARD (CHAR IN B-REG)
* 
* 
SYN7  LDA B
      AND MASK    MASK EXTRANEOUS BITS
OTA2S OTA 0,C    OUTPUT TOI/O BOARD
      JSB ISENT   INCREMENT CHAR'S SENT COUNT
      JMP SRET   RETURN
* 
* GET RECEIVED CHARACTER AND PLACE IN A-REG
* 
SYN10 JSB IRECV   INCREMENT # CHARS RECEIVED COUNT
LIA1R LIA 0   GET CHAR FROM I/O BOARD
      AND MASK
      JMP SRET   RETURN
* 
* CLEAR CONTROL,CLEAR FLAG
* 
SYNBS CLC 0,C   CLEAR CONTROL & FLAG
      JMP SRET   RETURN
* 
SYNBR CLC 0,C     CLEAR CONTROL & FLAG
      JMP SRET     RETURN
* 
* OUTPUT SYNC CHARACTER CODE TO I/O BOARD'S SPECIA  BUFFER
* 
SYNCS LDA SYNC    GET CONFIGURED CONTROL WORD
      AND =B177577    MASK PARITY BIT
OTA6S OTA 0,C    OUTPUT TO I/O BOARD
      JMP SRET    RETURN
* 
* 
SYNCR   LDA SYNC
OTA6R OTA 0,C
      JMP SRET
* 
* SKIP IF FLAG IS SET LOOP
* 
SYNDS SFS 0
      JMP *-1
      JMP SRET
* 
SYNDR SFS 0
      JMP *-1
* 
SRET  ISZ .IO.    RETURN TO
      JMP .IO.,I    CALL+2
* 
      SKP
* 
*     *** SUBROUTINE TO POSITION DRIVER PERTINENT
*    SYNCHRONOUS I/O BOARD DATA BITS TO THE SAME POSITION
*    AS FOR THE ASYNCHRONOUS I/O BOARD
* 
UNSCS NOP
      LDB A    GET STATUS IN B-REG
      AND =B101777   MASK OFF PERTINENT BITS
      STA TEMP9    SAVE OTHERS
      CLA
      RBL,RBL    POSITION BITS 13&14
      SLB    BIT 14 ON?
     IOR =B4000    YES,TURN ON 11
      SSB     BIT 13 ON?
      IOR =B10000   YES,TURN ON 12
      RBL,RBL     POSITION BITS 12 & 11
      SLB        BIT 12 ON?
      IOR =B2000    YES,TURN ON 10
      SSB       BIT 11 ON?
      IOR =B40000     YES  TURN ON 14
      IOR TEMP9    MERGE WITH OTHERS
      JMP UNSCS,I    RETURN
* 
* 
UNSCR NOP
      LDB A
      AND =B140377
      STA TEMP9
      LDA B      GET STATUS IN A-REG
      RAR      MOVE 13,12,11 TO
      AND =B16000    12,11,10    POSITIONS
      BLF,BLF    POSITON BIT 8
      SLB    SET?
       IOR =B1000     YES TURN ON 9
      IOR TEMP9   MERGE WITH OTHERS
      JMP UNSCR,I   RETURN
      SPC 2
* 
*    *** ROUTINE TO SYNCHRONIZE BOARD WITH REMOTE'S
* 
SYNRZ NOP
* 
      STB BSV       SAVE B-REG.
      LDA SYNRZ     NOTE CALL IN TRACE.
      LDB =B6
      JSB TRACE
      LDB BSV       RESTORE B-REG.
* 
      LDA .IO.+1
      CPA JASNC   ASYNCHRONOUS MODE ?
      JMP ASYRT     RETURN WITH NO OPERATION.
* 
      SZB     SEND OR RECEIVE SYNC CHARS?
      JMP IN    RECEIVING...EXECUTE ACCORDINGLY
* 
* 
      LDA RP1  CAUSE INTERRUPTS TO GO
      JSB PADRS   TO SEGMENT ONE
      LDA =D-2      SET UP LOOP FOR
      STA WORK      TWO SYNC CHARS.
* 
OTPUT LDB SYNC    GET SYNC CONTROL WORD
      JSB .IO.    OUTPUT TO
      OCT 7   I/O BOARD
* 
      JSB .IO.
      OCT 2  STC,C ON BOARD
* 
      JMP EXIT
      SPC 2
* 
*    *** SEGMENT ONE. SEND INTERRUPTS ARE CHANNELED HERE. ***
* 
SYNIT ISZ WORK   ALL SYNC'S SENT YET?
      JMP OTPUT    NO,SEND ANOTHER.
      JMP OBTND   YES,RETURN
      SPC 2
* 
*    *** THIS SECTION WAITS TILL BOARD HAS OBTAINED
*         SYNCHRONIZATION WITH THE REMOTE. ***
* 
IN    LDA RP2   CAUSE INTERRUPTS TO GO
      JSB PADRS    TO SEGMENT TWO
      LDA =D300     SET UP 3 SEC TIMEOUT.
      LDB SYNPT     CLOCK GOING.
      JSB TACTV
* 
HERE  JSB .IO.
      OCT 100002    STC,C ON BOARD
      JMP EXIT    WAIT FOR INTERRUPT
      SPC 2
* 
*    *** SEGMENT TWO. RECEIVE INTERRUPTS
*        ARE CHANNELED HERE. ***
* 
INPUT JSB .IO.      GET CHARACTER.
      OCT 100010
* 
      IOR =B40000   CLUDGE.
      CPA SYNC      SYNC CHARACTER?
      JMP OBTND     YES, RETURN.
* 
NOSYN CLB           NO.
      JSB .IO.      PRIME BOARD TO
      OCT 6         HUNT FOR SYNC
      JMP HERE      WAIT FOR INTERRUPT.
* 
OBTND JSB .IO.    SYNC HAS BEEN OBTAINED,
      OCT 100011    DISABLE FURTHER INTERRUPTS
      JSB .IO.     ON BOTH SEND & RECEIVE
      OCT 11     BOARDS  AND
      CLA           DISABLE SYNC TIMEOUT
      JSB TACTV     CLOCK.
ASYRT CLA           SET A-REG FOR SYNC OBTAINED.
      JMP SYNRZ,I   RERTURN
      SPC 4
.TOUT CLA           SYNCHRONIZATION HAS FAILED.
      JSB TACTV     DISABLE CLOCK.
      ISZ RCR       INDICATE CHARACTER RECEPTION.
      CCA           SET A-REG FOR SYNC NOT
      JMP SYNRZ,I   ACQUIRED AND EXIT.
      SPC 4
* 
*    *** DATA SECTION  ***
* 
RP1   DEF SYNIT
RP2   DEF INPUT
SYNPT DEF .TOUT     POINTER TO SYNC TIMEOUT.
      SKP
* 
*           *** ASYNCHRONOUS I/O BOARD MODULE. ***
* 
* CALLING SEQUENCE:
*     JSB .IO.
*     OCT (CODE)
*  CODE FUNCTION
* 
*  0    TURN OFF I/O BOARD.
*  1    CLEAR FLAG.
*  2    SET CONTROL AND CLEAR FLAG.
*  3    GET STATUS.
*  4    CONFIGURE I/O INSTRUCTIONS.
*  5    OUTPUT SEND CONTROL WORD.
*  6    OUTPUT RECEIVE CONTROL WORD.
*  7    SEND CHAR TO I/O BOARD.
*  10   GET RECEIVED CHARACTER.
*  11   CLEAR CONTROL AND CLEAR FLAG.
*  12  OUTPUT SYNC CODE TO I/O BOARD.  (SYNCHRONUS MODE ONLY)
*  13   WAIT UNTIL FLAG IS SET.
* 
* 
ASYNR LDA .IO.,I    DO
      AND =B17      TABLE LOOK UP
      ADA ADSPR     TO FIND
      JMP A,I       APPROPRIATE PROCESSOR.
* 
ASY0  LDA =B100000  GET CNTRL WRD TO TURN OFF BRD.
CLC1  CLC 0,C       DISABLE INTERRUPTS.
OTA1  OTA 0,C       TURN OFF I/O BOARD.
      JMP ARET      RETURN.
* 
* CLEAR FLAG.
* 
ASY1  CLF 0         CLEAR I/O BOARD'S FLAG.
      JMP ARET      RETURN.
* 
* SET CONTROL, CLEAR FLAG.
* 
ASY2  LDA =B-1      CAUSE INTERRUPT
      STA SETCN     UPON EXIT.
      JMP ARET      RETURN.
* 
* GET STATUS
* 
ASY3  LIA 0         LOAD INTO THE A-REG.
      JMP ARET      RETURN.
* 
* CONFIGURE I/O INSTRUCTIONS.
* 
ASY4  LDA EQT1A,I   GET
      AND =B77      DEVICE'S SELECT CODE.
      STA B         SAVE SELECT CODE IN B-REGISTER.
* 
      IOR OTA       FORM CONFIGURED OTA XX,C
      STA OTA1      AND SAVE.
      STA OTA2
      STA OTA3
      STA OTA4
* 
      LDA CLC       FORM
      IOR B         CONFIGURED CLC XX,C
      STA CLC1      AND SAVE.
      STA ASY11
* 
      LDA CLF       FORM
      IOR B         CONFIGURED CLF XX
      STA ASY1      AND SAVE.
* 
      LDA STC       FORM
      IOR B         CONFIGURED STC XX,C
      STA STC1      AND
      STA STC2      SAVE.
* 
      LDA LIA       FORM
      IOR B         CONFIGURED LIA XX
      STA ASY3      AND SAVE
      STA LIA1
* 
      LDA SFS       FORM
      IOR B         CONFIGURED
      STA ASY13     AND SAVE.
* 
      LDA RSS       INCLUDE VERTICAL PARITY
      STA .RSS      IN 'READ' PROCESSOR.
      JMP ARET      RETURN.
* 
* SET I/O BOARD UP TO SEND.
* 
ASY5  LDA ASEND     GET ASYNCH CONFIGURED CNTRL WORD.
OTA3  OTA 0,C       OUPUT CONTROL WORD TO I/O BOARD.
      JMP ARET      RETURN.
* 
* SET I/O BOARD UP TO RECEIVE.
* 
ASY6  LDA ARECV     GET ASYNCH CONFIGURED CNTRL WORD.
OTA4  OTA 0,C       OUPUT CONTROL WORD TO I/O BOARD.
      JMP ARET      RETURN.
* SEND CHARACTER TO THE I/O BOARD (CHAR IN B-REG).
* 
ASY7  LDA B         GET CHARACTER.
      AND MASK      MASK,
OTA2  OTA 0,C       AND SEND TO THE I/O BOARD.
      JSB ISENT     INCREMENT # CHAR'S SENT.
      JMP ARET      RETURN.
* 
* GET RECEIVED CHARACTER AND PLACE IN A-REG.
* 
ASY10 JSB IRECV     INCREMENT # CHAR'S RECEIVED.
LIA1  LIA 0         GET CHARACTER FROM I/O BOARD.
      AND MASK      MASK EXTRANEOUS BITS.
      JMP ARET      RETURN.
* 
* CLEAR CONTROL, CLEAR FLAG.
* 
ASY11 CLC 0,C       CLEAR CONTROL AND CLEAR FLAG.
      JMP ARET      RETURN.
* 
*     *** DUMMY ASYNCHRONOUS CALL. (SYNC CODE OUTPUT)
* 
ASY12 JMP ARET      RETURN WITH NO OPERATION.
* 
* SKIP IF FLAG IS SET LOOP.
* 
ASY13 SFS 0         SKIP NEXT INSTR IF FLAG IS SET.
      JMP *-1       GET NEW FLAG STATUS.
* 
ARET  ISZ .IO.      RETURN
      JMP .IO.,I    TO CALL+2.
      SKP
* 
*           *** DATA ***
* 
CLC   CLC 0,C       UNCONFIGURED CLEAR CONTROL INST
CLF   CLF 0         UNCONFIGURED CLEAR FLAG INSTR.
OTA   OTA 0,C       UNCONFIGURED OUT A INSTRUCTION.
LIA   LIA 0         UNCONFIGURED LOAD INTO A INSTR.
STC   STC 0,C       UNCONFIGURED SET CONTROL INSTR.
SFS   SFS 0         UNCONFIGURED SKIP IF FLAG SET.
STC1S BSS 1    CONFIGURED STC XX,C (SEND BOARD )
STC1R BSS 1   CONFIGURED STC XX,C (RECEIVE BOARD )
TEMP9 BSS 1
JSYNC RSS     SKIP NEXT INSTRUCTION
SETCN OCT 0    IF -1 THEN SET CONTROL ON BRD
* 
ADSPR DEF ASY00,I
ASY00 DEF ASY0
      DEF ASY1
      DEF ASY2
      DEF ASY3
      DEF ASY4
      DEF ASY5
      DEF ASY6
      DEF ASY7
      DEF ASY10
      DEF ASY11
      DEF ASY12
      DEF ASY13
      SPC 5
* 
* SYNCHRONOUS FUNCTION POINTERS (SEND BOARD )
* 
ADSPS DEF SYN00,I
SYN00 DEF SYN0S
      DEF SYN1S
      DEF SYN2S
      DEF SYN3S
      DEF SYN4
      DEF SYN5
      DEF SYN6
      DEF SYN7
      NOP
      DEF SYNBS
      DEF SYNCS
      DEF SYNDS
* 
*      *** SYNCHRONOUS FUNCTION POINTERS (RECEIVE BOARD )
* 
      DEF SYN0R
      DEF SYN1R
      DEF SYN2R
      DEF SYN3R
      OCT 0,0,0,0
      DEF SYN10
      DEF SYNBR
      DEF SYNCR
      DEF SYNDR
* 
* 
      HED COMPLETOR SECTION.
* 
*           *** COMPLETION SECTION ***
* 
* 
* THIS SECTION IS CALLED BY A PROCESSOR WHEN AN OPERATION HAS BEEN
* COMPLETED.
* 
* EXECUTION SEQUENCE:
* 
*         1. UPDATE TRANSMISSION LOG.
*         2. UPDATE STATUS.
*         3. CLEAR EQUIPMENT BUSY.
*         4. CLEAR DRIVER BUSY.
*         5. RESTORE REGISTERS.
*         6. EXIT.
      SPC 3
* 
* UPDATE TRANSMISSION LOG.
* 
COMPT LDA TLOG      GET TRANSMISSION LOG.
      LDB EQT2A     STORE
      INB           TRANSMISSION LOG
      STA B,I       IN WORD 3 OF DEVICE'S EQT TABLE.
* 
* UPDATE LINE STATUS.
* 
      JSB .IO.      OBTAIN
      OCT 3         DEVICE'S STATUS.
      STA TLOG     SAVE TEMPORARLY
      JSB .IO.    GET SYNC^S RECEIVE BOARDS
      OCT 100003    STATUS (SAME BOARD IF ASYNCH )
      IOR TLOG     MERGE WITH SEND BOARD'S STATUS
      STA B         SAVE STATUS IN B-REGISTER.
      CLA           GIVE STATUS A "CLEAN SLATE".
* 
      BLF           DATA SET
      SLB           READY?
      IOR =B10      YES, SET BIT 3 OF STATUS WORD.
* 
      SSB           CARRIER ON?
      IOR =B1       YES, SET BIT 1 OF STATUS WORD.
* 
* UPDATE LOGICAL STATUS.
* 
      LDB OVRFL     BUFFER
      SZB           OVERFLOW?
      IOR =B2       YES, SET BIT 1.
* 
      LDB EOF       IF LAST RECORD
      SZB           WAS AN END OF FILE
      IOR =B200     THEN TURN ON BIT 7 OF STATUS.
                                                                                                                                                                  24380-18030 1409                                                                                           