
      STA RSEND     IN SEND BUFFER.
      LDA ENQ       PUT ENQ CHARACTER
      STA RSEND+1   IN SEND BUFFER.
      LDA RESH      GET BUFFER ADRS IN A-REG.
      LDB =B2       GET
      STB RESLN     BUFFER LENGTH IN B-REG.
      JSB CNTRL     SEND "ENQ" TO REMOTE.
* 
* TEST IF REMOTE SENT BACK "ACK0" OR "RVI" CHARACTER.
* 
      CPA ACK0      RECEIVED CHARACTER = "ACK0"?
      JMP SHDSK     YES, ACTIVATE "TTD" MODULE.
      CPA RVI       CHARACTER A REVERSE INTERRUPT?
      JMP SHDSK     YES, ACTIVATE "TTD" MODULE.
      CPA NAK       ALLOW A 'NAK' AS A
      JMP SHDSK     SUCCESSFUL HANDSHAKE RESPONCE.
* 
      JSB UPCAR     BRING UP CARRIER.
      JSB IERR      INCREMENT # LINE ERRORS.
      ISZ DD2       IS THIS THE 8TH TRY?
      JMP DD3       NO, TRY AGAIN.
* 
* REMOTE REFUSES TO SEND "ACK0", DISCONNECT.
* 
      JSB ENDAL     SEND "DLE EOT" TO REMOTE.
* 
* "ACK0" OR "RVI" CHARACTER RECEIVED, UPDATE STATUS.
* 
SHDSK CLB           ZERO
      STB EOF       LAST RECORD NOT AN END-OF-FILE.
      CPA RVI       REMOTE REQUEST TO SEND?
      INB           YES, SET "REQ TO SEND".
      STB RQ2SD     UPDATE REQUEST TO SEND.
      CCA           SET NEXT REPLY
      STA BCONT     FOR ACK1.
      STA RCSND     PUT IN SEND MODE.
* 
* ENABLE "TEMPORAY TEXT DELAY" MODULE.
* 
      JSB OLNE      SET "ON LINE".
      CLA,INA       ACTIVATE
      JSB DACTV     "TTD" MODULE.
       JSB .IO.
      OCT 100011    CLEAR CONTROL ON BOARD
* 
      JMP COMPT     FREE THE DRIVER.
      SPC 5
* 
*           *** SEND "DLE EOT" TO REMOTE AND DROP LINE. ***
* 
ENDAL NOP           ENTRY POINT.
      CLA          IF ANY ABORT OCCURS, CLEAR
      STA NORET     THE READ PROCESSOR FLAG
* 
      CLA,INA       SET
      STA INERR     "IN ERROR" BIT.
* 
EDALL CLB      SEND ABURST OF SYNCS
      JSB SYNRZ   IF IN SYNC MODE
      LDA PAD
      STA RSEND     "PAD, DLE, EOT"
      LDA DLE       SEQUENCE
      STA RSEND+1   IN
      LDA EOT       RESEND
      STA RSEND+2   BUFFER.
* 
      LDA RESH      GET BUFFER S.A. IN A-REG.
      LDB =B3       GET BUFFER LENGTH IN B-REG.
* 
      JSB CNTRL     SEND "DLE EOT", RETRN AT "CLOSE"
      SPC 5
* 
* "DLE EOT" WAS SENT, TAKE TERMINAL OFF LINE.
* 
CLOSE CLA,INA       YES, SET FOLLOWING STATUS BITS:
      STA INERR     "IN ERROR",
CLOSS STA EOF       "LAST REC SENT IS END-OF-FILE",
      JSB OFLNE     SET TRML "OFF LINE".
      JSB .IO.      TURN OFF
      OCT 0         I/O BOARD.
      JSB .IO.
      OCT 100000
      LDA =D25      SET UP
      LDB ADCN5     250 MILISECOND DELAY
      JSB TACTV     (WAIT FOR I/O BRD TO TURN OFF).
      JMP EXIT      EXIT.
* 
CNTR5 CLA           DISABLE
      JSB TACTV     TIME INTERRUPT LOOP.
      JMP COMPT     TERMINATE COMMAND.
      SPC 3
* 
*           *** DATA ***
* 
CCADR DEF EOT       S.A. OF CONTROL CHARACTER LIST.
EOT   BSS 1         END OF TRANSMISSION.
ETB   BSS 1         END OF TRANSMISSION BLOCK.
ETX   BSS 1         END OF TEXT.
NAK   BSS 1         NEGATIVE ACKNOWLEDGEMENT.
RVI   BSS 1         REVERSE INTERRUPT.
SOH   BSS 1         START OF HEADER.
STX   BSS 1         START OF TEXT.
ACK0  BSS 1         AFFIRMATIVE ACKNOWLEDGEMENT 0.
ACK1  BSS 1         AFFIRMATIVE ACKNOWLEDGEMENT 1.
WABT  BSS 1         WAIT BEFORE TRANSMIT.
DLE   BSS 1         DATA LINK ESCAPE.
ITB   BSS 1         INTERMEDIATE TEXT BLOCK.
ENQ   BSS 1         ENQUIRY.
PADD  BSS 1    PADDING CHARACTER
ASEND BSS 1         CONFIGURED ASYNCH SEND COMMAND.
ARECV BSS 1         CONFIGURED ASYNCH RECV COMMAND.
SSEND BSS 1         CONFIGURED SYNCH SEND COMMAND.
SREVC BSS 1         CONFIGURED SYNCH RECEIVE COMMAND
MASK  BSS 1         CONFIGURED CHARACTER MASK.
BCCLN BSS 1         LENGTH OF BCC.
CODE  BSS 1         0=EBCDIC, 1=ASCII, 2=TRANSCODE.
BCNT  BSS 1         NO. BITS IN CHARACTER.
SYNC  BSS 1         SYNCR.
STOR  BSS 1   CONFIGURED SEND TO RECEIVE COMMAND
PAD   EQU SYNC
* 
CDESA DEF EBCCC
EBCCC DEF ECCC      EBCDIC CONTROL CHAR TABLE.
ASCCC DEF ACCC      ASCII CONTROL CHAR TABLE.
TRNCC DEF TCCC      6 BIT TRANSCODE CONTROL CHAR TABLE.
ECCC  OCT 67,46,3,75,174,1,2,160,141,153,20,37,55,377
      OCT 160010,140010,170010,151030,377,2,0,-10
      OCT 40062,160010
ACCC  OCT 4,27,3,25,100,1,2,60,61,54,20,37,5,177
      OCT 160607,140607,171010,151030,377,1,1,-10
      OCT 40026,161010
TCCC  OCT 36,17,56,75,62,0,12,40,43,46,37,35,55,77
      OCT 160010,140010,171010,151030,377,2,0,-10
      OCT 40072,161010
DD2   BSS 1         COUNTER.
TEMP1 BSS 1         TEMPORARY STORAGE.
TEMP3 BSS 1         TEMPORARY STORAGE.
TEMP7 BSS 1         TEMPORARY STORAGE.
TEMP8 BSS 1         TEMPORARY STORAGE.
UPCAD DEF UPCA1
FLAG  BSS 1
NORET OCT 0         NO RETRY
      HED      COMMON SUBROUTINES-CONTROL SUB.
* 
*           *** CONTROL SUBROUTINE ***
* 
* 
* USE:         PERFORMS LINE TURNAROUND (FROM SEND TO RECEIVE).
* 
* EXECUTION: 1.TRANSMITS A STRING OF CHARACTERS.
* 
*            2.DROPS CARRIER.
* 
*            3.WAITS FOR CARRIER FROM REMOTE.
* 
*              IF NO INTELLIGIBLE RESPONSE IS RECEIVED WITHIN 3 SECS:
*               A. NO CHARACTERS RECEIVED - THE ORIGINAL STRING OF
*                  CHARACTERS IS RE-SENT.
*               B. CHARACTERS WERE RECEIVED - THE CONTENTS OF "RESEND
*                  BUFFER ARE SENT.
*              IF THE EIGTH TIME STILL FAILS TO GET A RESPONSE, THEN:
*              "DLE EOT" IS SENT AND THE LINE IS DROPPED.
* 
*            4.WAITS FOR A CONTROL CHARACTER SEQUENCE FROM REMOTE.
*               A. IF CHARACTER = "WABT", THEN RETURN TO STEP 1
*                  WITH CHARACTER STRING = "ENQ".
*               B. IF CHARACTER = "ENQ" AND IN "SEND TO RECEIVE",
*                  "AUTO-ANSWER", OR "WAIT BEFORE TRANSMIT" PROCES-
*                   SOR THEN RETURN TO THE PROCESSOR.  IF IN ANOTHER
*                   PROCESSOR THEN THERE WAS A TRANSMISSION ERROR,
*                   THE ERROR RECOVERY PROCEDURE DESCRIBED IN STEP
*                   3.A IS UTILIZED.
*               C. IF "DLE EOT" IS RECEIVED OR SENT, THE LINE WILL
*                  BE DROPPED AND THE DRIVER FREED.
*               D. ANY OTHER CONTROL CHAR SEQ WILL CAUSE A RETURN
*                  TO THE CALLING PROCESSOR.
* 
* CALLING
* SEQUENCE:  1.PRIME A-REG WITH STARTING ADRS OF STRING TO BE SENT.
* 
*            2.PRIME B-REG WITH STRING LENGTH (MUST BE UNPACKED).
* 
*            3.PLACE CHARACTER SEQUENCE TO BE RE-SENT (FOR ERROR RE-
*              COVERY) IN "RESEND".  PLACE LENGTH OF SEQUENCE IN
*              "RESLN" (MAXIMUM LENGTH IS 5 CHAR'S).
* 
*            4.JSB CNTRL.
* 
*            5.IF IN "SEND TO RECEIVE", "AUTO-ANSWER", "WAIT BEFORE
*              TRANSMIT" PROCESSOR THEN SET "SCASE" = 1, OTHERWISE
*              SET "SCASE" = 0.
* 
*            6. I/O BOARD MUST HAVE CARRIER ON.
* 
* 
* UPON RETURN:
* 
*               A-REG: RECEIVED CONTROL CHARACTER.
* 
*               B-REG: IF = 1, THEN "DLE" CHAR PRECEEDED RECEIVED
*                      CONTROL CHARACTER.
* 
      SPC 2
* 
*           *** INITIALIZATION SECTION ***
* 
CNTRL NOP           ENTRY POINT.
* 
      STA ADRS1     SAVE STRING STARTING ADDRESS.
      STA ADRS2     SAVE AGAIN.
      CMB,INB       SAVE NEGATIVE
      STB CONT1     STRING LENGTH.
      STB CONT3     SAVE AGAIN.
* 
      LDA CNTRL     NOTE CALL
      CLB,INB       IN TRACE
      JSB TRACE
* 
      LDA =D-8      INITIALIZE
      STA ERROR     ERROR COUNTER.
      LDA PAD       STORE PAD CHAR
      STA REPLY-1   INTO REPLY BUFFER.
* 
CNTR7 CLA           DE-ACTIVATE
      JSB TACTV     TIMER.
      LDA ADCN1     STORE SEGMENT ONE'S ENTRY ADRS
      JSB PADRS     IN INTERRUPT ADDRESS.
* 
      LDA ADRS1,I   GET FIRST CHAR
      LDB A         OF STRING
      AND MASK      PUT IT IN TRACE
      IOR =B110000  WITH PROPER CODE
      JSB TRAC1
* 
      JSB .IO.      AND
      OCT 7         SEND TO REMOTE.
      JSB .IO.      ENABLE
      OCT 2         INTERRUPTS.
* 
      JMP EXIT      EXIT.
      SPC 2
* 
*           *** SEGMENT ONE: OUTPUT CHARACTER STRING. ***
* 
CNTR1 ISZ CONT1     FINISHED SENDING STRING?
      JMP PCHK      PERHAPS, CHECK IF SENT PAD CHAR.
      LDB PADD
      JSB .IO.      OUTPUT
      OCT 7         TRAILING PAD CHARACTER.
      JSB .IO.      ENABLE
      OCT 2         INTERRUPTS.
      JMP EXIT      EXIT.
* 
PCHK  LDA CONT1     FINISHED
      SSA,RSS       SENDING STRING?
      JMP DCHK      YES, CHECK IF SHOULD DROP LINE.
* 
      ISZ ADRS1     NO
      LDA ADRS1,I   GET NEXT CHARACTER.
      LDB A
      AND MASK      PUT IT IN TRACE
      IOR =B110000  WITH PROPER CODE.
      JSB TRAC1
* 
      JSB .IO.      OUTPUT NEXT
      OCT 7         CHARACTER.
      JSB .IO.      ENABLE
      OCT 2         INTERRUPTS.
      JMP EXIT      EXIT.
* 
DCHK  LDA ADRS1,I   WAS LAST CHARACTER SENT
      CPA EOT       AN END-OF-TAPE CHARACTER?
      RSS           YES, SEE IF "IN ERR" BIT IS SET.
      JMP SETUP     NO, SET UP FOR SEGMENT 2.
      LDA ADRS1     WAS
      ADA =B-1      NEXT-TO-LAST
      LDA A,I       CHARACTER
      CPA DLE       A "DLE"?
      JMP CLOSS     YES, TAKE TRML OFF LINE.
* 
* CHARACTER STRING HAS BEEN SENT, SET UP TO RECEIVE FROM REMOTE.
* 
SETUP CLB           INITIALIZE
      STB LOGC1     '"DLE" CHARACTER RECEIVED'.
      STB RCR       LOGICAL VARIABLE.
      JSB .IO.      CLEAR FLAG AND CONTROL
      OCT 11        ON I/O BOARD.
      JSB .IO.      WAIT
      OCT 3         UNTIL
      RAL,RAL       I/O BOARD'S BUSY FLAG
      SSA           (BIT 13 OF I/O STATUS)
      JMP *-4       GOES OFF.
* 
*     *** PATCH FOR IBM SYSTEMS*
S.RTO LDA EOTCK     SHOULD WE NOT
      SZA           LOOK FOR A RESPONCE TO EOT?
      JMP FOUND     YES, JUST RETURN.
* 
CNTRX JSB .IO.      SET UP I/O BOARD
      OCT 6         TO RECEIVE.
      SPC 2
* 
*      ***  SEGMENT TWO :  WAIT 100 MILASECS.
* 
CNTR2 CLB,INB       WAIT FOR SYNC ACQUIRED
      JSB SYNRZ    IF IN SYNC MODE
      SZA           SYNC OBTAINED?
      JMP CNTR3     NO, RESEND SEQUENCE.
      LDA =D300     ACTIVATE TIMER TO INTERRUPT
      LDB ADCN3     TO SEGMENT #3
      JSB TACTV     IN 3 SECONDS.
* 
      LDA ADCN4     FORCE INTERRUPTS
      JSB PADRS     TO SEGMENT 4.
* 
      JSB .IO.      CLEAR I/O BOARD
      OCT 100003      OF STRAY INTERRUPT
      JSB .IO.      ENABLE
      OCT 100002    INTERRUPTS
* 
      JMP EXIT      EXIT.
      SPC 2
* 
*           *** SEGMENT THREE: THIS SEGMENT IS ENTERED AT ITS HEAD
*               WHEN NO CONTROL CHARACTER HAS BEEN RECEIVED WITHIN
*               3 SECONDS.  IT INCREMENTS AN ERROR COUNTER, IF EQUAL
*               TO EIGHT THE LINE IS DROPPED, OTHERWISE:
*                A. IF NO CHARACTERS WERE RECEIVED FROM REMOTE, SEND
*                   ORIGINAL STRING AGAIN.
*                B. IF AT LEAST 1 CHARACTER HAS BEEN RECEIVED, SEND
*                   CONTENTS OF RESEND BUFFER.
* 
CNTR3 JSB IERR      INCREMENT # LINE ERRORS
      ISZ ERROR     IS THIS THE 8TH TIME?
      JMP RETRY     NO, TRY AGAIN
      JSB UPCAR     BRING UP CARRIER FOR DLE/EOT
* 
* 
      LDA =B3       RETURN TO USER
      STA LERR      WITH "USER TIMEOUT" CODE
      JSB ENDAL     SEND "DLE EOT" AND DROP LINE.
* 
RETRY LDA NORET     CHECK FOR READ PROC
      SZA           SKHQ IF NOT FOR RESEND
      JMP CNTRX     OTHERWISE TRY SYNC
      JSB UPCAR     BRING UP CARRIER
      LDA RCR       WAS ANY CHARACTER
      SZA            RECEIVED?
      JMP RRRR      YES, SEND BACK 'RESEND BUFFER'
* 
OOOO  LDA ADRS2     NO,, SEND
      LDB CONT3     ORIGINAL
      STA ADRS1     BUFFER
      STB CONT1     BACK
      JMP NNN    TO THE REMOTE
* 
RRRR  LDA RESH      GET S.A. OF BUFFER IN A-REG
      STA ADRS1     AND STORE IN STRING START ADRS.
      LDB RESLN     GET BUFFER LENGTH,
      CMB,INB       MAKE NEGATIVE,
      STB CONT1     AND STORE IN STRING LENGTH.
NNN   JMP CNTR7     SEND RE-TRY MESSAGE.
      SPC 3
* 
*           *** SEGMENT FOUR: THIS SEGMENT ANALYZES CHARACTERS
*               RECEIVED FROM REMOTE. ***.
* 
CNTR4 JSB .IO.      GET CHARACTER
      OCT 100010     FROM I/O BOARD
      ISZ RCR       INCREMENT NO. CHAR'S RECEIVED.
* 
      STA ASV       SAVE A REG
      IOR =B120000  MERGE WITH TRACE CODE AND
      JSB TRAC1     PUT IN TRACE.
      LDA ASV       RESTORE A REG
* 
      CPA ENQ       CHARACTER = "ENQ"?
      JMP AENQ      YES, GO ANALYZE.
* 
      CPA DLE       CHARACTER = "DLE"?
      RSS           YES, SKIP NEXT INSTRUCTION.
      JMP ANALY     NO, CONTINUE CHECKING.
      CLA,INA       SET, "LAST CHAR WAS DLE"
      STA LOGC1     FLAG.
      JSB .IO.      ENABLE
      OCT 100002    INTERRUPTS
      JMP EXIT      EXIT.
* 
ANALY LDB LOGC1     LAST CHARACTER
      SLB,RSS       A "DLE"?
      JMP ANALZ     NO, CONTINUE CHECKING.
* 
      CPA ACK0      PRESENT CHARACTER AN "ACK 0"?
      JMP FOUND     YES, RETURN TO THE CALLING PROC.
* 
      CPA ACK1      PRESENT CHARACTER AN "ACK 1"?
      JMP FOUND     YES, RETURN TO THE CALLING PROC.
* 
* 
      CPA EOT       PRESENT CHARACTER AN "EOT"?
      JMP CLOS      YES, DROP THE LINE.
      CPA WABT      PRESENT CHARACTER A "WABT"?
      RSS           YES, SKIP NEXT INSTRUCTION?
      JMP ANALZ     NO, CONTINUE CHECKING.
* 
      JSB UPCAR     BRING UP CARRIER.
      LDA ENQ       RECEIVED CHARACTER WAS "WABT",
      STA REPLY     SEND
      LDA REPAD     "ENQ"
      LDB =B2       AND
      JMP CNTRL+1   AWAIT REPLY.
* 
ANALZ LDB CCADR     SEARCH
      STB TEMP      FOR
      LDB =B-7      MATCH
LOOP1 CPA TEMP,I    AMONGST
      JMP FOUND     REMAINING
      ISZ TEMP      CONTROL CHARACTERS
      INB,SZB       (IF FOUND GO TO "FOUND", OTHER-
      JMP LOOP1     WISE DROP OUT OF SEARCH LOOP).
* 
      CLB           SET 'LAST
      STB LOGC1     CHAR A "DLE"'
      IOR =B40000   TO FALSE
      CPA SYNC      SYNC CHAR?
      JMP WAIT      YES
* 
      JSB IERR      NO/INCREMENT # OF LINE ERRORS
      ISZ ERROR     EIGHTH TIME?
      JMP CNTR2-2   NO/GO HUNT FOR SYNC
* 
      JSB UPCAR     YES/SET FLAG,SEND
      JMP CLOS-3    "DLE EOT" DROP LINE
* 
WAIT  JSB .IO.      RECEIVED CHAR NOT A CONTROL
* 
      OCT 100002    CHARACTER,ENABLE INTERRUPT
      JMP EXIT      AND EXIT.
* 
FOUND STA TEMP      SAVE RECEIVED CHARACTER.
RETN1 CLA           DE-ACTIVATE
      JSB TACTV     TIMER
      JSB .IO.      CLEAR FLAG AND CONTROL
      OCT 100011    ON RECEIVE BOARD.
      LDA TEMP      GET CHARACTER IN THE A-REG.
      LDB LOGC1     GET "DLE" FLAG IN B-REG.
      JMP CNTRL,I   RETURN TO PROCESSER.
* 
AENQ  LDB SCASE     CHAR="ENQ", IS DRIVER IN WABT,
      SZB           AUTO ANSWER, OR SEND2REC MODE?
      JMP FOUND     YES, GIVE CONTROL TO PROCESSOR.
* 
      JSB UPCAR     BRING UP CARRIER.
      JSB IERR      INCREMENT # LINE ERRORS.
      ISZ ERROR     TRANSMISSION ERROR, 8TH TIME?
      JMP OOOO      NO, PREPARE TO RESEND STRING.
      LDA =B2       YES,
      STA LERR      SET "REMOTE SENT INCORRECT RE-
      JSB ENDAL     PLY", SEND "DLE EOT" DROP LINE.
* 
CLOS  LDA =B4       SENSED "DLE EOT",
      STA LERR      SHOW SAME IN STATUS,
      STA INERR     SET "OPERATION IN ERROR".
      JMP CLOSE     GO END OPERATION.
      SPC 3
* 
*           *** DATA ***
* 
ADCN1 DEF CNTR1     S.A. OF SEG#1 IN CONTROL SUBRTN.
ADCN3 DEF CNTR3     S.A. OF SEG #3 IN CONTROL SUBRTN
ADCN4 DEF CNTR4     S.A. OF SEG #4 IN CONTROL SUBRTN
ADCN5 DEF CNTR5
ADTO  DEF S.RTO
ADRS1 BSS 1    STRING ADDRESS OF CONTROL SEQUENCE.
ADRS2 BSS 1         ORIGINAL BUFFER START ADRS.
CONT1 BSS 1         STRING LENGTH OF CONTROL SEQUENCE.
CONT3 BSS 1         ORIGINAL BUFFER LENGTH.
ERROR BSS 1         ERROR COUNTER FOR RE-TRY.
LOGC1 BSS 1         LOGICAL VARIABLE.
RCR   BSS 1         COUNTS # CHAR'S RECEIVED.
REPAD DEF REPLY-1   S.A. OF RE-TRY MESSAGE.
PAD1  BSS 1         RE-TRY
REPLY BSS 2         BUFFER.
RESH  DEF RSEND     POINTS TO START ADRS OF RSEND BF
RESLN BSS 1         LENGTH OF "RESEND" BUFFER.
RSEND BSS 5         RE-SEND CHARACTER SEQUENCE.
SCASE OCT 0         SET TO 1 IF IN "WABT", "AUTO
*                                   ANSWER", OR "SEND2REC" MODE.
TEMP  BSS 1         TEMPORARY STORAGE.
      HED CALLING TERMINAL HANDSHAKE PROCESSOR.
* 
* 
*           *** HANDSHAKE PROCESSOR ***
* 
* EXECUTION STEPS:
*                 1. WAIT FOR OPERATOR TO DIAL REMOTE.
*                 2. SEND "ENQ" CHARACTER TO THE REMOTE.
*                 3. WAIT FOR "ACK0" OR "RVI" CHARACTER TO BE SENT
*                    FROM THE REMOTE.
*                 4. ACTIVATE THE "TTD" (TEMPORARY TEXT DELAY)
*                    MODULE.
* 
* A CLEAR REQUEST WILL TURN OFF THE I/O BOARD.
* 
*********************
* INITIATOR SEGMENT ************************************************
*********************
* 
* 
* 
* SEPERATE TRANSMISSION CODE.
* 
HNDSK LDA =B2       PRIME A-REG FOR TRANSCODE.
      LDB FUNCT     IS REQUEST
      CPB =B303     FOR EBCDIC?
      CLA           YES, SET UP FOR EBCDIC.
* 
      CPB =B304     REQUEST FOR ASCII?
      CLA,INA       YES, SET UP FOR ASCII.
* 
      JSB CCAR      SET UP CNTRL CHAR'S, MASK, I/O
* 
* SET UP I/0 BOARD.
* 
      JSB .IO.      DISABLE
      OCT 11        INTERRUPTS.
      JSB .IO.   OUTPUT SYNC CODE
      OCT 12      TO BOTH
      JSB .IO.    SEND & RECEIVE
      OCT 100012   BOARDS
      JSB .IO.      PRIME I/O BOARD
      OCT 5         TO BE A SENDER.
      LDB SYNC      HAVE BOARD SEND SYNC
      JSB .IO.     CHARACTERS   WHILE IN
      OCT 7    TIMEOUT LOOP
* 
* HOUSEKEEPING
* 
      LDA =D15      SET TIMER FOR 150 MILASEC INTRPT
      LDB ADHK1     AT
      JSB TACTV     "HDSK1".
* 
      JSB EBUSY     SET EQUIP TABLE ENTRY TO BUSY.
* 
      JSB ISTAT     INITIALIZE STATUS.
* 
      LDA =D-5      SET COUNTER
      STA D2        TO -5.
      CLA           CLEAR
      STA TLOG      TRANSMISSION LOG.
      JMP D.50,I    RETURN TO .IOC..
      SPC 3
***********************
* CONTINUATOR SEGMENT **********************************************
***********************
* 
HDSK1 JSB .IO.      GET
      OCT 3         I/O BOARD STATUS.
      ALF     DATA SET
      SLA,RSS       DATA SET READY?
      JMP EXIT      NO, EXIT.
      SSA,RSS       CLEAR TO SEND?
      JMP EXIT      NO, WAIT.
* 
      ISZ D2        WAIT 600 M.S.
      JMP EXIT        AFTER DATA SET CONNECTED
* 
      JMP SENQ      SEND "ENQ" AND AWAIT "ACK0".
      SPC 3
*           *** DATA ***
* 
ADHK1 DEF HDSK1
D2    BSS 1         COUNTER.
      HED "WAIT BEFORE TRANSMIT" GENERATOR.
* 
*           *** "WABT" SUBROUTINE ***
* 
* 
* USE:
* 
*  WHILE IN RECEIVE MODE THIS SUBROUTINE WILL HOLD OFF THE TRANS-
                                                                                                                                                                 24380-18029 1409                                                                                          