ASMB,R,L
      HED LINE PRINTER PAGE ROUTINE.   T. WINKER   7-7-71 
      NAM PAGE,3
      SPC 15
********************************************************************
*                                                                  *
*                                                                  *
*                                                                  *
*                          :PR,PAGE[,N]                            *
*                                                                  *
*                                                                  *
*        THIS PROGRAM CAUSES THE LINE PRINTER TO FORM-FEED         *
*        N TIMES. (TO TOP OF CURRENT PAGE IF N NOT PRESENT.)       *
*                                                                  *
*                                                                  *
*                                                                  *
*                                                                  *
*                                                                  *
********************************************************************
      SKP 
      EXT EXEC
      ENT PAGE
PAGE  NOP 
      LDA B,I       GET PARAMETER 
      SSA           IS PRAM -?
      JMP COMP      YES, IGNORE CALL. 
      CMA,INA       SET - 
      SZA,RSS       IF ZERO,
      CCA             SET TO -1 
      STA PCNT      SAVE PAGE COUNT 
      ADA CO
      SSA           IS PRAM GREATER THAN 6? 
      JMP COMP      YES, IGNORE CALL. 
LOOP  JSB EXEC      CALL FOR PAGE 
      DEF *+4 
      DEF R 
      DEF CTL 
      DEF PRAM
      ISZ PCNT
      JMP LOOP      DO IT AGAIN 
COMP  JSB EXEC      CALL FOR COMPLETION.
      DEF *+2 
      DEF CO
* 
*   CONSTANTS 
* 
B     EQU 1 
.     EQU 53B 
R     EQU .+3 
CO    EQU .+6 
PCNT  BSS 1 
CTL   OCT 1106
PRAM  DEC -1
      END PAGE
                                                    ASMB,R,L
      HED H.S. PUNCH LEADER ROUTINE.   T. WINKER   7-7-71 
      NAM LDR,3 
      SPC 15
********************************************************************
*                                                                  *
*                                                                  *
*                                                                  *
*                        :PR,LDR[,N]                               *
*                                                                  *
*                                                                  *
*        THIS PROGRAM PRODUCES LEADER ON THE HIGH SPEED PUNCH      *
*        [N] IF PRESENT, PRODUCES N*2' OF LEADER. IF [N] NOT       *
*        PRESENT, ONLY 2' OF LEADER IS PRODUCED.                   *
*                                                                  *
*                                                                  *
*                                                                  *
*                                                                  *
*                                                                  *
********************************************************************
      SKP 
      EXT EXEC
      ENT LDR 
LDR   NOP 
      LDA B,I       GET PARAMETER 
      SSA           IS PRAM -?
      JMP COMP      YES, IGNORE CALL. 
      CMA,INA       SET - 
      SZA,RSS       IF ZERO,
      CCA             SET TO -1 
      STA PCNT      SAVE LDR COUNT. 
      ADA CO
      SSA           IS PRAM GREATER THAN 6? 
      JMP COMP      YES, IGNORE CALL. 
LOOP  JSB EXEC      CALL FOR LEADER 
      DEF *+3 
      DEF R 
      DEF CTL 
      ISZ PCNT
      JMP LOOP      DO IT AGAIN 
COMP  JSB EXEC      CALL FOR COMPLETION.
      DEF *+2 
      DEF CO
* 
*   CONSTANTS 
* 
B     EQU 1 
.     EQU 53B 
R     EQU .+3 
CO    EQU .+6 
PCNT  BSS 1 
CTL   OCT 1004
      END LDR 
                                                    ASMB,R,L      WRITE :: TO MAG TAPE. 
      HED WRITE :: TO MAG TAPE.   T. WINKER   7-7-71
      NAM COLN,3
      SPC 20
***************************************************************** 
*                                                               * 
*                    :PR,COLN [,N]                              * 
*                                                               * 
*    COLN CAUSES THE MAG TAPE TO WRITE A DOUBLE COLON.          * 
*                                                               * 
*    N IS THE LOGICAL UNIT # OF THE MAG TAPE UNIT.              * 
*    (SET TO 8 IF NOT SPECIFIED.)                               * 
*                                                               * 
***************************************************************** 
      SKP 
      EXT EXEC
      ENT COLN
      SUP PRESS UNWANTED LISTING. 
COLN  NOP 
      LDB B,I       GET PARAMETER & 
      SZB,RSS        IF ZERO, LEAVE UNIT SET TO 8.
      JMP UN
      LDA B 
      ADA .-11      IS N RESONABLE? 
      SSA,RSS 
      JMP COMP      NO! 
      LDA CTL       GET CONTROL WORD
      AND .+20       & STRIP OFF UNIT # 
      IOR B           THEN SET IN NEW UNIT #. 
      STA CTL 
* 
      LDA DST       SET 
      AND .+20       LU # 
      IOR B           IN
      STA DST          STATUS CALL. 
* 
* 
UN    JSB STAT      CHECK STATUS
      JSB EXEC      CALL EXEC 
      DEF *+5        FOR
      DEF .+2 
      DEF CTL         MAG TAPE
      DEF BUF          COLON
      DEF .+1           WRITE 
* 
COMP  JSB EXEC      CALL EXEC 
      DEF *+2        FOR
      DEF .+6         COMPLETION. 
* 
STAT  NOP 
      JSB EXEC      CALL
      DEF *+3        DYNAMIC
      DEF .+3         STATUS
      DEF DST 
* 
      SLA           IS UNIT 
      JMP LOC        IN LOCAL?
      RAR,RAR       HAS 
      SLA           IS WRITE
      JMP NOWR       RING PRESENT?
      RAR,RAR        CALL 
      SSA             BEEN
      JMP REJ          REJECTED?
      RAR           IS
      SLA            UNIT 
      JMP EOT         AT EOT? 
      JMP STAT,I    ALL O.K. RETURN.
* 
LOC   LDA AM1       GET LOCAL MSG ADD.
      RSS 
REJ   LDA AM2       GET REJ MSG ADD.
      RSS 
EOT   LDA AM3       GET EOT MSG ADD.
      RSS 
NOWR  LDA AM4       GET WRITE RING MSG ADD. 
      STA MSGA      STORE ADDRESS.
      JSB EXEC      WRITE 
      DEF *+5        MESSAGE
      DEF .+2         ON CONSOLE
      DEF .+1          FOR
MSGA  BSS 1 
      DEF .+9 
      JMP COMP
      SKP 
*   PROGRAM CONSTANTS 
* 
A     EQU 0 
B     EQU 1 
.     EQU 53B 
CTL   DEC 8         UNIT 8
DST   OCT 610 
AM1   DEF M1
AM2   DEF M2
AM3   DEF M3
AM4   DEF M4
M1    ASC 9,TAPE UNIT IN LOCAL. 
M2    ASC 9,CALL REJECTED.
M3    ASC 9,TAPE UNIT AT EOT. 
M4    ASC 9,NO WRITE RING.
BUF   ASC 1,::
      END COLN
                                                    ASMB,R,L     MAG TAPE REWIND.   T. WINKER   4-9-71
      HED REWIND MAG TAPE.   T. WINKER   7-7-71 
      NAM REW,3 
      SPC 20
***************************************************************** 
*                                                               * 
*                    :PR,REW [,N]                               * 
*                                                               * 
*    REW (REWIND) CAUSES THE MAG TAPE TO REWIND TO LOAD POINT.  * 
*                                                               * 
*    N IS THE LOGICAL UNIT # OF THE MAG TAPE UNIT.              * 
*    (SET TO 8 IF NOT SPECIFIED.)                               * 
*                                                               * 
***************************************************************** 
      SKP 
      EXT EXEC
      ENT REW 
      SUP PRESS UNWANTED LISTING. 
REW   NOP 
      LDB B,I       GET PARAMETER & 
      SZB,RSS        IF ZERO, LEAVE UNIT SET TO 8.
      JMP UN
      LDA B 
      ADA .-11      IS N RESONABLE? 
      SSA,RSS 
      JMP COMP      NO! 
      LDA CTL       GET CONTROL WORD
      AND .+20
      IOR B           THEN SET IN NEW UNIT #. 
      STA CTL 
* 
      LDA DST       SET 
      AND .+20       LU # 
      IOR B           IN
      STA DST          STATUS CALL. 
* 
* 
UN    JSB STAT      CHECK STATUS
      JSB EXEC      CALL EXEC 
      DEF *+3        FOR
      DEF .+3         REWIND
      DEF CTL          COMMAND. 
* 
COMP  JSB EXEC      CALL EXEC 
      DEF *+2        FOR
      DEF .+6 
* 
STAT  NOP 
      JSB EXEC      CALL
      DEF *+3        DYNAMIC
      DEF .+3         STATUS
      DEF DST 
* 
      SLA           IS UNIT 
      JMP LOC        IN LOCAL?
      RAR,RAR       HAS 
      RAR,RAR        CALL 
      SSA             BEEN
      JMP REJ          REJECTED?
      RAR,RAR       IS
      SLA            UNIT 
      JMP BOT         AT BOT? 
      JMP STAT,I    ALL O.K. RETURN.
* 
LOC   LDA AM1       GET LOCAL MSG ADD.
      RSS 
REJ   LDA AM2       GET REJ MSG ADD.
      RSS 
BOT   LDA AM3       GET BOT MSG ADD.
      STA MSGA      STORE ADDRESS.
      JSB EXEC      WRITE 
      DEF *+5        MESSAGE
      DEF .+2         ON CONSOLE
      DEF .+1          FOR
MSGA  BSS 1 
      DEF .+9 
      JMP COMP
      SKP 
*   PROGRAM CONSTANTS 
* 
A     EQU 0 
B     EQU 1 
.     EQU 53B 
CTL   OCT 410 
DST   OCT 610 
AM1   DEF M1
AM2   DEF M2
AM3   DEF M3
M1    ASC 9,TAPE UNIT IN LOCAL. 
M2    ASC 9,CALL REJECTED.
M3    ASC 9,TAPE UNIT AT BOT. 
      END REW 
                                                    ASMB,R,L        REVERSE SPACE FILE(S) 
      NAM RSPCF,3 
      SPC 20
****************************************************************
*                                                              *
*                  :PR,RSPCF [,N1,N2]                          *
*                                                              *
*    RSPCF (REVERSE SPACE FILE'S) CAUSES THE MAG TAPE TO       *
*    REVERSE SPACE N1 FILE(S). (SET TO 1 IF NOT SPECIFIED.)    *
*                                                              *
*    N2 IS THE LOGICAL UNIT # OF THE MAG-TAPE UNIT.            *
*    ( SET TO 8 IF NOT SPECIFIED.)                             *
*                                                              *
****************************************************************
      HED REVERSE SPACE FILE(S).   T. WINKER   4-9-71 
      ENT RSPCF 
      EXT EXEC
      SUP PRESS UNWANTED LISTING. 
RSPCF NOP 
      LDA B,I       GET N1
      CMA,INA        SET -
      SZA,RSS         & IF ZERO,
      CCA              SET TO -1. 
      STA RCNT      SAVE
* 
      INB           GET 
      LDA B,I        N2 
      SZA,RSS         & IF ZERO,
      JMP LOOP         LEAVE LU# AT 8 
      LDB A 
      ADA .-11      IS N2 RESONABLE?
      SSA,RSS 
      JMP COMP      NO, END PROGRAM.
      LDA CTL       YES,
      AND .+20       SET
      IOR B           NEW 
      STA CTL          LU # 
* 
      LDA DST       SET 
      AND .+20       LU # 
      IOR B           IN
      STA DST          STATUS CALL
LOOP  JSB STAT      CHECK STATUS
      JSB EXEC      CALL FOR
      DEF *+3        RECORD SPACE 
      DEF .+3         FORWARD 
      DEF CTL 
* 
      JSB STAT      CHECK FOR 
      SLA,RSS        EOF
      JMP LOOP+1    NOT EOF, CONTINUE.
      ISZ RCNT      MORE? 
      JMP LOOP       YES. 
* 
COMP  JSB EXEC      CALL FOR
      DEF *+2        COMPLETION.
      DEF .+6 
* 
STAT  NOP 
      JSB EXEC      CALL
      DEF *+3        DYNAMIC
      DEF .+3         STATUS
      DEF DST 
* 
      SLA           IS UNIT 
      JMP LOC        IN LOCAL?
      RAR,RAR       HAS 
      RAR,RAR        CALL 
      SSA             BEEN
      JMP REJ          REJECTED?
      RAR,RAR       IS
      SLA            UNIT 
      JMP BOT         AT BOT? 
      RAR           POSITION EOF TO BIT 0 
      JMP STAT,I    ALL O.K. RETURN.
* 
LOC   LDA AM1       GET LOCAL MSG ADD.
      RSS 
REJ   LDA AM2       GET REJ MSG ADD.
      RSS 
BOT   LDA AM3       GET BOT MSG ADD.
      STA MSGA      STORE ADDRESS.
      JSB EXEC      WRITE 
      DEF *+5        MESSAGE
      DEF .+2         ON CONSOLE
      DEF .+1          FOR
MSGA  BSS 1 
      DEF .+9 
      JMP COMP
* 
AM1   DEF M1
AM2   DEF M2
AM3   DEF M3
M1    ASC 9,TAPE UNIT IN LOCAL. 
M2    ASC 9,CALL REJECTED.
M3   ASC 9,TAPE UNIT AT BOT.
RCNT  BSS 1 
A     EQU 0 
B     EQU 1 
.     EQU 53B 
CTL   OCT 210 
DST   OCT 610 
      END RSPCF 
                                                    ASMB,R,L        REVERSE SPACE RECORD
      NAM RSPCR,3 
      SPC 20
****************************************************************
*                                                              *
*                   :PR,RSPCR [,N1,N2]                         *
*                                                              *
*    RSPCR (REVERSE SPACE RECORD) CAUSES THE MAG TAPE TO       *
*    REVERSE SPACE N1 RECORDS. (SET TO 1 IF NOT SPECIFIED.)    *
*                                                              *
*    N2 IS THE LOGICAL UNIT # OF THE MAG-TAPE UNIT.            *
*    ( SET TO 8 IF NOT SPECIFIED.)                             *
*                                                              *
****************************************************************
      HED REVERSE SPACE RECORD.   T. WINKER   4-9-71
      ENT RSPCR 
      EXT EXEC
      SUP PRESS UNWANTED LISTING. 
RSPCR NOP 
      LDA B,I       GET N1
      CMA,INA        SET -
      SZA,RSS         & IF ZERO,
      CCA              SET TO -1. 
      STA RCNT      SAVE
* 
      INB           GET 
      LDA B,I        N2 
      SZA,RSS         & IF ZERO,
      JMP LOOP         LEAVE LU# AT 8 
      LDB A 
      ADA .-11      IS N2 RESONABLE?
      SSA,RSS 
      JMP COMP      NO, END PROGRAM.
      LDA CTL       YES,
      AND .+20       SET
      IOR B           NEW 
      STA CTL          LU # 
* 
      LDA DST       SET 
      AND .+20       LU # 
      IOR B           IN
      STA DST          STATUS CALL
LOOP  JSB STAT      CHECK STATUS
      JSB EXEC      CALL FOR
      DEF *+3        RECORD SPACE 
      DEF .+3       REVERSE 
      DEF CTL 
* 
      ISZ RCNT      MORE? 
      JMP LOOP       YES. 
* 
COMP  JSB EXEC      CALL FOR
      DEF *+2        COMPLETION.
      DEF .+6 
* 
STAT  NOP 
      JSB EXEC      CALL
      DEF *+3        DYNAMIC
      DEF .+3         STATUS
      DEF DST 
* 
      SLA           IS UNIT 
      JMP LOC        IN LOCAL?
      RAR,RAR       HAS 
      RAR,RAR        CALL 
      SSA             BEEN
      JMP REJ          REJECTED?
      RAR,RAR       IS
      SLA            UNIT AT
      JMP BOT         BEG. OF TAPE? 
      JMP STAT,I    ALL O.K. RETURN.
* 
LOC   LDA AM1       GET LOCAL MSG ADD.
      RSS 
REJ   LDA AM2       GET REJ MSG ADD.
      RSS 
BOT   LDA AM3       GET BOT MSG ADD.
      STA MSGA      STORE ADDRESS.
      JSB EXEC      WRITE 
      DEF *+5        MESSAGE
      DEF .+2         ON CONSOLE
      DEF .+1          FOR
MSGA  BSS 1 
      DEF .+9 
      JMP COMP
* 
AM1   DEF M1
AM2   DEF M2
AM3   DEF M3
M1    ASC 9,TAPE UNIT IN LOCAL. 
M2    ASC 9,CALL REJECTED.
M3    ASC 9,TAPE UNIT AT BOT. 
RCNT  BSS 1 
A     EQU 0 
B     EQU 1 
.     EQU 53B 
CTL   OCT 210 
DST   OCT 610 
      END RSPCR 
                                                    ASMB,R,L       FORWARD SPACE FILE(S)
      NAM FSPCF,3 
      SPC 20
****************************************************************
*                                                              *
*                  :PR,FSPCF [,N1,N2]                          *
*                                                              *
*    FSPCF (FORWARD SPACE FILE) CAUSES THE MAG TAPE TO         *
*    FORWARD SPACE N1 FILES. (SET TO 1 IF NOT SPECIFIED.)      *
*                                                              *
*    N2 IS THE LOGICAL UNIT # OF THE MAG-TAPE UNIT.            *
*    ( SET TO 8 IF NOT SPECIFIED.)                             *
*                                                              *
****************************************************************
      HED FORWARD SPACE FILE(S).   T. WINKER   4-9-71 
      ENT FSPCF 
      EXT EXEC
      SUP PRESS UNWANTED LISTING. 
FSPCF NOP 
      LDA B,I       GET N1
      CMA,INA        SET -
      SZA,RSS         & IF ZERO,
      CCA              SET TO -1. 
      STA RCNT      SAVE
* 
      INB           GET 
      LDA B,I        N2 
      SZA,RSS         & IF ZERO,
      JMP LOOP         LEAVE LU# AT 8 
      LDB A 
      ADA .-11      IS N2 RESONABLE?
      SSA,RSS 
      JMP COMP      NO, END PROGRAM.
      LDA CTL       YES,
      AND .+20       SET
      IOR B           NEW 
      STA CTL          LU # 
* 
      LDA DST       SET 
      AND .+20       LU # 
      IOR B           IN
      STA DST          STATUS CALL
LOOP  JSB STAT      CHECK STATUS
      JSB EXEC      CALL FOR
      DEF *+3        RECORD SPACE 
      DEF .+3         FORWARD 
      DEF CTL 
* 
      JSB STAT      CHECK FOR 
      SLA,RSS        EOF
      JMP LOOP+1    NOT EOF, CONTINUE.
      ISZ RCNT      MORE? 
      JMP LOOP       YES. 
* 
COMP  JSB EXEC      CALL FOR
      DEF *+2        COMPLETION.
      DEF .+6 
* 
STAT  NOP 
      JSB EXEC      CALL
      DEF *+3        DYNAMIC
      DEF .+3         STATUS
      DEF DST 
* 
      SLA           IS UNIT 
      JMP LOC        IN LOCAL?
      RAR,RAR       HAS 
      RAR,RAR        CALL 
      SSA             BEEN
      JMP REJ          REJECTED?
      RAR           IS
      SLA            UNIT AT
      JMP EOT         END OF TAPE?
      RAR,RAR       POSITION EOF TO BIT 0 
      JMP STAT,I    ALL O.K. RETURN.
* 
LOC   LDA AM1       GET LOCAL MSG ADD.
      RSS 
REJ   LDA AM2       GET REJ MSG ADD.
      RSS 
EOT   LDA AM3       GET EOT MSG ADD.
      STA MSGA      STORE ADDRESS.
      JSB EXEC      WRITE 
      DEF *+5        MESSAGE
      DEF .+2         ON CONSOLE
      DEF .+1          FOR
MSGA  BSS 1 
      DEF .+9 
      JMP COMP
* 
AM1   DEF M1
AM2   DEF M2
AM3   DEF M3
M1    ASC 9,TAPE UNIT IN LOCAL. 
M2    ASC 9,CALL REJECTED.
M3    ASC 9,TAPE UNIT AT EOT. 
RCNT  BSS 1 
A     EQU 0 
B     EQU 1 
.     EQU 53B 
CTL   OCT 310 
DST   OCT 610 
      END FSPCF 
                                                    ASMB,R,L     FORWARD SPACR RECORD 
      NAM FSPCR,3 
      SPC 20
****************************************************************
*                                                              *
*                  :PR,FSPCR [,N1,N2]                          *
*                                                              *
*    FSPCR (FORWARD SPACE RECORD) CAUSES THE MAG TAPE TO       *
*    FORWARD SPACE N1 RECORDS. (SET TO 1 IF NOT SPECIFIED.)    *
*                                                              *
*    N2 IS THE LOGICAL UNIT # OF THE MAG-TAPE UNIT.            *
*    ( SET TO 8 IF NOT SPECIFIED.)                             *
*                                                              *
****************************************************************
      HED FORWARD SPACE RECORD.   T. WINKER   4-9-71
      ENT FSPCR 
      EXT EXEC
      SUP PRESS UNWANTED LISTING. 
FSPCR  NOP
      LDA B,I       GET N1
      CMA,INA        SET -
      SZA,RSS         & IF ZERO,
      CCA              SET TO -1. 
      STA RCNT      SAVE
* 
      INB           GET 
      LDA B,I        N2 
      SZA,RSS         & IF ZERO,
      JMP LOOP         LEAVE LU# AT 8 
      LDB A 
      ADA .-11      IS N2 RESONABLE?
      SSA,RSS 
      JMP COMP      NO, END PROGRAM.
      LDA CTL       YES,
      AND .+20       SET
      IOR B           NEW 
      STA CTL          LU # 
* 
      LDA DST       SET 
      AND .+20       LU # 
      IOR B           IN
      STA DST          STATUS CALL
LOOP  JSB STAT      CHECK STATUS
      JSB EXEC      CALL FOR
      DEF *+3        RECORD SPACE 
      DEF .+3         FORWARD 
      DEF CTL 
* 
      ISZ RCNT      MORE? 
      JMP LOOP       YES. 
* 
COMP  JSB EXEC      CALL FOR
      DEF *+2        COMPLETION.
      DEF .+6 
* 
STAT  NOP 
      JSB EXEC      CALL
      DEF *+3        DYNAMIC
      DEF .+3         STATUS
      DEF DST 
* 
      SLA           IS UNIT 
      JMP LOC        IN LOCAL?
      RAR,RAR       HAS 
      RAR,RAR        CALL 
      SSA             BEEN
      JMP REJ          REJECTED?
      RAR           IS
      SLA            UNIT AT
      JMP EOT         END OF TAPE?
      JMP STAT,I    ALL O.K. RETURN.
* 
LOC   LDA AM1       GET LOCAL MSG ADD.
      RSS 
REJ   LDA AM2       GET REJ MSG ADD.
      RSS 
EOT   LDA AM3       GET EOT MSG ADD.
      STA MSGA      STORE ADDRESS.
      JSB EXEC      WRITE 
      DEF *+5        MESSAGE
      DEF .+2         ON CONSOLE
      DEF .+1          FOR
MSGA  BSS 1 
      DEF .+9 
      JMP COMP
* 
AM1   DEF M1
AM2   DEF M2
AM3   DEF M3
M1    ASC 9,TAPE UNIT IN LOCAL. 
M2    ASC 9,CALL REJECTED.
M3    ASC 9,TAPE UNIT AT EOT. 
RCNT  BSS 1 
A     EQU 0 
B     EQU 1 
.     EQU 53B 
CTL   OCT 310 
DST   OCT 610 
      END FSPCR 
                                                    ASMB,R,L,C
      HED CARD TO PAPER TAPE   T. WINKER   7-7-71 
      NAM CRDTP,3 
      SPC 20
***************************************************************** 
*                                                               * 
*                      :PR,CRDTP [,N]                           * 
*                                                               * 
*     THIS PROGRAM TRANSFERS CARD INFORMATION TO TAPE.          * 
*     ONLY 72 COLUMNS ARE COPIED AND IF THE LAST CHARACTERS     * 
*     ARE BLANK, THE RECORD IS CUT TO ELIMINATE THE UNECESSARY  * 
*     SPACES ON THE TAPE.                                       * 
*                                                               * 
*     N, IF PRESENT, CHANGES THE LOGICAL UNIT FROM 4 (PUNCH)    * 
*     TO N. (ALLOWS MAG TAPE.)                                  * 
*                                                               * 
***************************************************************** 
      SKP 
      SUP 
      ENT CRDTP 
      EXT EXEC
CRDTP NOP 
      LDA B,I       GET PARAMETER 
      SZA           IS N # 0
      STA PU         YES, SET NEW LU
      JSB PUNLD     PUNCH 
      JSB PUNLD      LEADER 
AGAIN JSB RDCD      READ A CARD 
      AND .+15      CHECK FOR DONE? 
      CPA D40 
      JMP COMP      NO MORE CARDS.
      JSB SORT      ELIMINATE TRAILING SPACES 
      JSB PUNL      PUNCH THE LINE
      JMP AGAIN     DO IT AGAIN 
* 
COMP  JSB EXEC      PRINT 
      DEF *+5 
      DEF W           DONE? 
      DEF R 
      DEF MSG1        MESSAGE.
* 
      JSB EXEC       GET
      DEF *+5 
      DEF R          ANSWER 
      DEF RD
      DEF TEMP        AND SET IN TEMP 
      DEF .+1 
* 
      LDA TEMP
      CPA MSG2      IS "YES"? 
      JMP PLD        YES, FINISH
      CPA MSG3      IS "NO"?
      JMP AGAIN      YES, READ ANOTHER CARD.
      JMP COMP      ITS NEITHER, ASK AGAIN. 
* 
PLD   JSB PUNLD     PUNCH TRAILER 
      JSB COMPL     CALL COMPLETION 
* 
*   PUNCH LEADER
* 
PUNLD NOP 
      LDA PU
      CPA .+4       IF NOT PUNCH, 
      RSS 
      JMP PUNLD,I    IGNORE.
      JSB EXEC
      DEF *+3 
      DEF CTL 
      DEF LDR 
      JMP PUNLD,I 
* 
*   READ A CARD 
* 
RDCD  NOP 
      JSB EXEC
      DEF *+5 
      DEF R 
      DEF CU
      DEF BUF 
      DEF BUFL
      JMP RDCD,I
* 
*   ELIMINATE TRAILING SPACES 
* 
SORT  NOP 
      LDA EBUF
      STA NDX 
LOOP  LDA NDX,I 
      CPA SPC 
      RSS 
      JMP NOSP
      LDA NDX 
      CPA ABUF
      JMP AGAIN 
      ADA .-1 
      STA NDX 
      JMP LOOP
* 
NOSP  LDA ABUF
      CMA,INA 
      ADA NDX 
     INA
      STA NBUFL 
      JMP SORT,I
* 
*   PUNCH A LINE
* 
PUNL  NOP 
      JSB EXEC
      DEF *+5 
      DEF W 
      DEF PU
      DEF BUF 
      DEF NBUFL 
      JMP PUNL,I
* 
*   COMPLETION CALL 
* 
COMPL NOP 
      JSB EXEC
      DEF *+2 
      DEF CO
      SKP 
*   CONSTANTS 
* 
B     EQU 1 
.     EQU 53B       POINTER IN BASE PAGE
R     EQU .+1 
W     EQU .+2 
CTL   EQU .+3 
CO    EQU .+6 
CU    EQU .+7 
RD    OCT 401 
LDR   OCT 1004
SPC   OCT 20040 
PU    DEC 4 
BUFL  DEC 36
D40   DEC 40
NDX   BSS 1 
NBUFL BSS 1 
TEMP  BSS 1 
BUF   BSS 36
EBUF  DEF *-1 
ABUF  DEF BUF 
MSG1  ASC 3,DONE? 
MSG2  ASC 1,YE
MSG3  ASC 1,NO
      END CRDTP 
                                                                                                                                                                                                                                                                                                                                                                                                                                            