      ORG 77B 
      HLT 77B 
      JMP START,I 
      BSS 4 
      DEF CBUFR+1 
      BSS 2 
      ORG 110B
START DEF BGN
*
*   CSTR CHECKS VALIDITY AND STORES COMMANDS
*
*
CSTR  NOP
      CLA
      STA L1
      STA THRO     THRO=1: PRESENT LABEL A THROUGH
      STA NO       STOPS N1,N2,M3
      LDA CBUF
      STA WRK1     SET CONTROL POINTER
      LDA RBUF
      ADA O2
      LDB A,I
      CPB SPACE
      JMP NNE
      INA
      STA WRK2     RECORD POINTER
SEARH JSB LABEL
      CLA
      CPA SIZE
      JMP E1       INVALID SIZE
*
*
      CLA,INA
      CPA THRO     THRO=1?
      JMP SEC      THROUGH LABEL
      LDA CBUF
      STA WRK1     NEW LABEL RESET CONTROL POINTER
*
*
      CLA
      STA NO       RESET NO
      CLA,INA
      CPA LIT      LIT=1?
      JMP LIT1     A LITERAL
*
*
*
      JSB LOOK     A NUMERIC STORE IT
      STA NO.
      ISZ WRK1
      SZA
      JMP OTH
      CCB
      CPB VAL
      JMP OTH
      JMP E1
*
*
*
LIT1  CLA
      STA SAVE4
      LDA BIAS
      STA NO.
      LDA TAG
      STA MTAG     NOT A THROUGH!  CLEAR MTAG
TRY1  LDA WRK1,I
      CPA ENDFI    FIND END OF FILE
      JMP ROT      FOUND IT!  ROTATE
      ISZ WRK1
      JMP TRY1
ROT   LDA O2
      STA NUMB
      JSB ROTAT    ROTATE 2 WDS FROM END OF FILE
      LDA TAG
      STA WRK1,I   INSERT TAG
      ISZ WRK1
      LDA BIAS
      STA WRK1,I   INSERT BIAS FOR LABEL
      ISZ WRK1
      JSB LITR     STORE THE LITERAL
      JMP OTH      OTHER LABELS?
*
*
*
SEC   CLB,INB
      CPB VAL      VAL=1?
      JMP E1       /I:N1,N2 INVMD
      CPB NO
      JMP E1       N1,N2,N3 INVALID
      STB NO
      LDA TAG
      IOR TMSK     040000B
      STA MTAG     SET MTAG
      STB NUMB     NUMB=1
      JSB ROTAT    ROTATE COMMAN TER
*
*   1 WORD RIGHT. PLACE SET TO ROTATE BY FIRST LABEL
*
      CLB,INB
      CPB LIT
      JMP LIT2     A LITERAL
      JSB DECIF    A NUMBER!  DECIFER
      JMP E1
      LDB SAVE4
      CMB,INB
      ADB A
      SSB
      JMP E1
      STA WRK1,I    INSERT IT IN CONTROL FILE
      JMP OTH      OTHER LABELS?
*
*
*
LIT2  JSB LITR     STORULITERAL
      LDA BIAS
      STA WRK1,I     INSERT BIAS
OTH   CCA
      CPA THR
      JMP RT
      LDA THR
      STA THRO     SET THR=THRO!
      JMP SEARH    ANALYZE NEXT LABEL
RT    JSB RTRN
      JMP CSTR,I
NNE   LDA WRK1,I
      CPA ENDFI
      JMP *+7
      AND MDTK
      SZA
      JMP NNE.
      CCA
      ADA WRK1
      STA WRK1
      CLA,INA
      STA NUMB
      JSB ROTAT    ROTATE CONTROL BUFFER
      LDA TAG
      STA WRK1,I    INSERT TAG
      JMP CSTR,I   RETUR^
NNE.  ISZ WRK1
      JMP NNE
SLEND LDA ENDFI
      STA WRK7,I
      STA WRK6,I    TAG NOW IN LIT AND EDIT FILES
      LDA CBUF
      STA WRK1
      LDA LBUF
      STA WRK7
      LDA EBUF
      STA WRK6     RESET ALL FILES
      JMP PHS.2,I
E1    CLA,INA
      CPA L1
      JMP LKTG     LITERALS STORED FIND TAG!
CHK.1 JSB CNU
      JMP REP
CNU   NOP
      LDA CBUF
      STA WRK1     SET CONTROL POINTER
T1    LDA WRK1,I
      CPA TAG      TAG FOUND?
      JMP PST      INSERT ENDFI
      CPA ENDFI    END OF FILE?
      JMP CNU,I
      ISZ WRK1
      JMP T1       TRY NEXT ELEMENT
LKTG  LDA LBUF
      STA WRK7     SET LITERAL POINTER
T2    LDA WRK7,I
      AND ENDFI 
      CPA TAG      TAG FOUND?
      JMP CHK.2
      ISZ WRK7
      JMP T2       TRY NEXT ELEMENT
CHK.2 LDA ENDFI
      STA WRK7,I
      JMP CHK.1
PST   CLB,INB
      STB NUMB
      LDB WRK1
LP8   INB
      LDA B,I       NEXT ELEMENT
      AND MDTK      A TAG?
      SZA
      JMP SH        YES! SHIFT
      ISZ NUMB      NO!
      JMP LP8
SH    LDA B         S.A.
      LDB NUMB      NUMBER
      JSB SHIFT
      JMP T1        GET NEXT OCCURANCE OF TAG
SHIFT NOP
      CMB,INB       -NUMBER
      ADB A         S.A.-NUMBER
      STA WRK       S.A.
LP9   LDA WRK,I     COMING FROM!
      STA B,I       GOING TO!
      CPA ENDFI     FINISHED?
      JMP SHIFT,I   YES!
      INB
      ISZ WRK
      JMP LP9
RTRN  NOP
      CCA
      STA SAVE5
      STA SAVE8 
      CLA 
      STA WRK12 
      LDA CBUF
      STA WRK1
*
LP15  LDA WRK1,I
      CPA ENDFI
      JMP RTRN,I
      AND MDTK3
      CPA MDTK3
      JMP CHCMD
      LDA WRK1,I
      AND MDTK1 
      CPA MDTK1 
      JMP SEQ.1 
*
      ISZ WRK1
      LDA WRK1,I
      CPA BIAS
      JMP CHCMD
SEQ.3 CMA,INA 
      ADA SAVE5
      SZA,RSS
      JMP QST
      SSA,RSS
      JMP ER3
      CLA,INA 
      CPA WRK12 
      JMP SEQ.2 
*
SEQ.4 LDA WRK1,I
      STA SAVE5
      LDB WRK1,I
      CMB,INB 
      ADB SAVE8 
      ISZ WRK1
*
      LDA WRK1,I
      AND MDTK
      SZA
      JMP LP15
      SZB,RSS 
      JMP SEQ.5 
SEQ.6 LDA WRK1,I
      CPA BIAS
      JMP CHCMD
      STA SAVE5
CHCMD ISZ WRK1
      LDA WRK1,I
      AND MDTK
      SZA
      JMP LP15
      JMP CHCMD
SEQ.5 LDB WRK1,I
      CPB BIAS
      JMP CHCMD 
      CMB,INB 
      ADB SAVE8 
      SSB,RSS 
      JMP SEQ.6 
      JMP ER3 
ER3   CLA
      CPA FL14
      JMP E1
      JSB ERR
      JMP NGD
QST   CLA,INA
      CPA WRK12 
      JMP SEQ.2 
      JMP ER3
SEQ.1 CLA,INA 
      STA WRK12 
      ISZ WRK1
      LDA WRK1,I
      CPA BIAS
      JMP SEQ.2 
* 
      CMA,INA 
      ADA SAVE8 
      SSA,RSS 
      JMP ER3 
      LDA WRK1,I
      STA SAVE8 
      JMP SEQ.3 
SEQ.2 CLA 
      STA WRK12 
      JMP CHCMD 
*
*
*   THR=1NEXT A THROUGH THR=0: NEXT A NEW THR=-1 : NO MOPE
*   SIZE=0:IVALID  SZ NOT =0: SIZE TO +
*   AND SIZE IS SIZE AFTER +  IF SZ=0 SIZE = SIZE OD LABEL
*   WPK1 MUST BE PRESET
*
*
*
LABEL NOP
      CLB
      STB SZ       OVERSTORE ASSUME NO + IN LABEL
      STB SIZE     SET SIZE
      LDA WRK2
      STA WRK      PRESERVE WRK2
*
*
*
      STB LIT      OVERSTORE ASSUME NOT A LITERAL
      LDA WRK,I     BRING IN CHAR
      CPA DASH     DASH?
      JMP L2
OVER  LDA WRK,I    NEXT CHAR!
      ISZ WRK      SET BUFFER
      ISZ SIZE     INC SIZE
      CPA SPACE    SEPARATOR A SPACE?
      JMP NMORE     NO MORE LABELS!
      CPA COMMA
      JMP THRW     NEXT LABEL A THROUGH
      CPA COLEN    COLEN?
      JMP NEW      NEXT LABEL A NEW
      CPA PLUS
      JMP PL
      LDA SIZE
      CPA O6        SIZE TOO BIG?
      JMP E1
      JMP OVER     GET NEXT CHAR
NMORE CCA
OUT   STA THR
      CCA
      ADA SIZE
      STA SIZE
      JMP LABEL,I
THRW  CLA,INA
      JMP OUT
NEW   CLA
      JMP OUT
L2    CLA,INA       A LITERAL!
      STA LIT
      ISZ WRK      SET WRK AT FIRST REAL CHAR OF LABEL
      ISZ WRK2     DO SAME FOR RECORD BUFFER
      JMP OVER
PL    CLA,INA
      CPA LIT
      JMP FORM
      JMP E1       NUMERIC HAS A + IN IT
FORM  CCA
      ADA SIZE
      STA SZ       SIZE UP TO +
      SZA 
      CCA 
      INA 
      STA SIZE     RESET SIZE
      JMP OVER
*
*
*
*   PUTS LABELS IN PROPER FORM
*   STORES THEM AND TAG IN LITERAL FILE
*   CHECKS SIZE OF N AFTER +
*   WRK2 MUST BE PRESET FOR THE ROUTINE
*
*
*
LITR  NOP
      LDA SZ
      SZA,RSS
      LDA SIZE
      CMA,INA
      STA CNT      CNT=-SIZE OF LABEL UP TO +
      LDA MTAG
      STA WRK7,I
      ISZ WRK7
      AND TMSK
      CPA TMSK
      JMP CH63
OVR18 CLA,INA
      STA L1
BC    LDA WRK2,I
      ISZ WRK2
      STA WRK7,I
      ISZ WRK7
      LDA ENDFI
      STA WRK7,I
      ISZ CNT      STORE LABEL
      JMP BC
      ISZ WRK2     SET RECORD POINTER PAST SEPARATOR
      LDA SZ
      SZA,RSS      DOES LABEL HAVE A +N
      JMP LITR,I   NO! RETURN
      JSB DECIF    YES! DECIFER IT
      JMP E1       BAD RETURN
      ALF,ALF      N IS IN UPPER HALF OF WD
      STA WRK7,I   STORE N
      ISZ WRK7     INC LITERAL POINTER
      LDB ENDFI
      STB WRK7,I
      ALF,ALF      RESTORE N
      ADA N99
      SSA          N>99?
      JMP LITR,I   NO! VALID
      JMP E1        YES! ERROR
CH63  LDA NO.
      STA WRK7,I
      ISZ WRK7
      JMP OVR18
ERR   NOP
      LDA TAG
      AND BIAS1
      JSB ASCI,I
      LDA T19
      LDB MSGE2
      JSB 102B,I
      JMP ERR,I
*
*
*   STARTING ADDRESS OF THE LABEL IN ASCI FORM
*   MUST BE PUT IN WRK1
*   WRK1 REFERS TO COMMAND BUFFER
*
*
*
LOOK  NOP 
      JSB DECIF
      JMP E1
*
*
      STA LAB       BINARY LABEL STORED IN LAB
*
*
*
BCK   LDA WRK1,I    START OF CONTROL BUFFER
*
*   IT MUST BE RESET EXTERNALLY
*
      CPA ENDFI
      JMP ST1
      AND MDTK      100000B
      SZA           IS A TAG DETECTED
      JMP ST2
      LDA WRK1,I
      CMA,INA
      ADA LAB
      SSA,RSS
      JMP INC       NO!
      CCA           YES! INSERT IT
      ADA WRK1
      STA WRK1      BACK UP ONE TO TAG!
ST1   LDA O2
      STA NUMB
      JSB ROTAT     ROTATE 2 WORDS RIGHT
      LDA TAG
      STA WRK1,I
      ISZ WRK1
      LDA LAB
      STA SAVE4
      STA WRK1,I    STORE LABEL
      JMP LOOK,I    RETURN
INC   ISZ WRK1
      LDA WRK1,I
      CPA ENDFI
      JMP ST1
ST2   ISZ WRK1
      JMP BCK
*
*
*   WRK1 IS THE STARTING ADDRESS TO ROTATE
*   NUMB IS THE NUMBER OF WORDS TO ROTATE
*   WRK1 IS NOT DESTROYED
*   PROGRAM ROTATES AS DESIRED
*   WRK1 REFERS TO PLACE IN COMMAND BUFFER
*   END OF FILE=137777B
*
*
*
ROTAT NOP
      LDA WRK1     WHERE TO START ROTATING
      STA WRK      TO PRESERVE WRK1
TRY  LDA WRK,I
      CPA ENDFI    ARE WE AT THE END OF THE FILE
      JMP DO       YES  START ROTATING
      ISZ WRK
      JMP TRY      TRY NEXT ELEMENT
DO    LDA WRK
      STA B
      ADB NUMB     B HAS ADDRESS OF WHERE IT IS GOING
      LDA A,I      BRING WORD INTO A
      STA B,I      STORE IT IN NEW PLACE
      LDA WRK
      CPA WRK1     ARE WE DONE?
      JMP ROTAT,I  YES
      CCA
      ADA WRK      DECREMENT ADDRESS IN WRK
      STA WRK
      JMP DO       CONTINUE TO ROTATE
*
*
*   NORMAL RETUR IF INVALID
*   MAKES SURE THAT NUMBER DOESN'T EXCEED 4 DIGITS
*   MAKES SURE THAT NO LITERALS APPEAR
*   CHECKS FOR SEPERATOR
*   SETS RECORD FILE FOR NEXT TIME NEEDED
*   TRANSLATES ASCI TO BINARY
*   PUTS RESULT IN A REG.
*   PUT S.A. IN WRK2
*
*
*
DECIF NOP
      LDA N5
      STA CNT1      CNT1=-5
      LDA D1
      STA WRK       PROTECT BUFFER
      LDA WRK2,I    TO STORE DIGITS
      ADA N60
      SSA           CHAR IN A<60B?
      JMP DECIF,I   YES! NO GOOD
      ADA N12
      SSA,RSS       CHAR >71B?
      JMP DECIF,I   YES! NO GOOD
BC1   ADA T12
      STA WRK,I     STORE DIGIT
      ISZ WRK       PLACE FOR NEXT DIGIT
      ISZ WRK2      TO GET NEXT CHAR
*
*
*
      ISZ CNT1      MORE THAN 4 DIGITS?
      JMP CNTN1
      JMP DECIF,I   YES! NO GOOD
CNTN1 LDA WRK2,I    NEXT CHAR
      ADA N60
      SSA
      JMP Q1        NO MORE DIGITS
      ADA N12
      SSA,RSS
      JMP Q1        NO MORE DIGITS
      JMP BC1       JUMP BACK TO STORE
*
*
*
Q1    LDA WRK2,I
      CPA COMMA
      JMP GOOD
      CPA SPACE
      JMP GOOD
      CPA COLEN
      JMP GOOD
      JMP DECIF,I   ILLEGAL SEPERATOR
*
*
*
GOOD  ISZ WRK2      FOR NEXT USE OF RECORD
      ISZ DECIF     GOOD RETURN
      LDA N5
      CMA
      ADA CNT1      NUMBER OF DIGITS READ IN -1
      ADA D1
      STA WRK       GET TO END OF BUFFER
*
*
*
      CLA
      STA TEMP
      LDA WRK,I     ONES DIGIT
      JSB SEE       10*TENS DIGIT
      JSB MPY
      JSB SEE
      JSB MPY
      JSB MPY
      JSB SEE
      JSB MPY
      JSB MPY
      JSB MPY
      RSS
SEE   NOP
      ADA TEMP      NUMBER SO FAR
      LDB D1
      CPB WRK       ARE WE AT THE FIRST DIGIT
      JMP DECIF,I   YES! RETURN
      STA TEMP      STORE NUMBER SO FAR
      CCA
      ADA WRK
      STA WRK       DECREMENT WRK
      LDA WRK,I     BRING IN NEXT DIGIT
      JMP SEE,I
MPY   NOP
      STA SAVE1
      ALS,ALS
      ALS
      STA SAVE2
      LDA SAVE1
      ALS
      ADA SAVE2     10*N
      JMP MPY,I
*
*
BGN   LDA CBUF
      CMA,INA 
      ADA 106B
      ARS,ARS 
      LDB CBUF
      ADB A 
      STB LBUF
      ADB A 
      STB EBUF
      CLA 
      STA ECNT     SET EDIT COUNT
      STA PNTR     SET POINTER
      STA SAVE7 
      LDA LMGE3 
      LDB .MGE3 
      JSB 102B,I     INITIAL MONOLOG FOR EDIT 
TLK1  JSB .TALK,I   INITIAL DIALOG: PHASE 1 
*
*
*
RSTRT LDA EBUF
      STA WRK6     SET EDIT BFFER
      LDA LBUF
      STA WRK7     SET LITERAL BUFFER
      LDA ENDFI
      STA CBUF,I    END OF FILE IN CONTROL BUFFER
      STA LBUF,I
      CLA
      STA FL14
*
*
*
AG2   CLA
      JSB RDNXT    READ A LINE UNCONDITIONALLY
      RSS
      JMP GD1      A COMMAND!
REP   JSB INV      INVALID!
      JMP AG2      TRY AGAIN
*
*
*
INV   NOP
      CLA,INA
      CPA TTY      INPUT FROM TTY?
      JMP OPUT     YES!
      LDB SBUF
      LDA SAVE7
      JSB 102B,I
NGD   LDA T72
      LDB RBUF
      JSB 101B,I
      SZA
      JMP *-4
TLK2  JSB .TALK,I   BAD EDIT; RESTART PHASE 1 
      JMP BGN      START OVER!
OPUT  LDA O2
      LDB QMRK
      JSB 102B,I   OUTPUT ?SP
      JMP INV,I
*
*
*
GD1   CLA
      STA VAL      RESET VAL=0
      ISZ ECNT     INCREMENT EDIT COUNT
*
*   RBUF MUST BE UNPACKED
*
      LDA RBUF
      STA WRK2
      ISZ WRK2     2ND WORD
      LDA WRK2,I
      ISZ WRK2
      ALF,ALF
      IOR WRK2,I
      CPA LINS     /I:
      JMP ST.1
      CPA END       /E
      JMP SLEND
      CPA LRE      /R:
      JMP ST.3
      CPA LDE      /D:
      JMP ST.9
      CPA CINS     /I;
      JMP ST.4
      CPA ACINS     /I
      JMP ST.4
      CPA CRE      /R;
      JMP ST.5
      CPA ACRE     /R
      JMP ST.5
      CPA CDE      /D;
      JMP ST.10
      CPA ACDE     /D
      JMP ST.10
      CPA LIST     /L
      JMP ST.6
      CPA LCO      /L:
      JMP ST.6
      JMP REP       WASN'T RECOGNIZED
ST.10 JSB CMN1
REP16 JSB UNPCK
      LDB SAVE3
      CMB,INB
      STB C4
      LDB RBUF
LP40  LDA B,I
      CPA BKAR
      JMP E2
      INB
      ISZ C4
      JMP LP40
      JSB CMN3
      JMP REP16
ST.9  LDA ECNT
      IOR MDTK
      STA WRK6,I
      ISZ WRK6
      CLB
      STB WRK6,I
      ISZ WRK6
      JMP ST9
*
*   /I: GOES TO ST.1
*
ST.1  CLA,INA
      STA VAL      VAL=1
      LDA ECNT
      IOR MDTK1    FORM TAG   12XXXXB
JOIN1 STA TAG      STORE IT
      STA WRK6,I
      ISZ WRK6
      JSB CSTR     STORE LABELS AND LITERALS
AG10  JSB RD
      JMP AG11
ST3   CLA,INA
      JSB RDNXT
      RSS
      JMP GD1
AG11  LDB SAVE3
      INB
      BRS           TRANSMISSION LOG IN WORDS
      STB SAVE3
      LDA RBUF
      LDB A,I      FIRST WD OF RECORD
      CPB EXDSH    !-
      JMP HD
      LDB SAVE3    TRANSMISSION LOG
ON6   JSB STORE    STORE EDIT!
      JMP ST3
HD    INA
      CCB
      ADB SAVE3    TRANSMISSION LOG-1
      JMP ON6
*
*   /R:  GOES TO ST.3
*
ST.3  LDA ECNT
      IOR MDTK      FORM TAG 10XXXXB
      CCB
      STB VAL
      JMP JOIN1
*
*
*
RD    NOP
      CLA,INA
      JSB RDNXT    READ A LINE
      JMP RD,I     EDIT,RETURN
      ISZ ECNT
      JMP E2       COMMAND! ERROR
*
*   /E GOES TO SLEND
*   /L AND /L: GO TO ST.6
*
ST.6  LDA MDTK7
      IOR ECNT
ST9   STA TAG
      JSB CSTR
      CLA,INA
      JSB RDNXT
      JMP REP      AN EDIT INVALID!
      JMP GD1      A COMMAND
*
*   /I; AND /I GO TO ST.4
*
ST.4  JSB CMN1     FORM TAG,CSTR,READ EDIT
REP3  JSB UNPCK    UNPACK RECORD
      LDA SAVE3
      ADA RBUF
      LDB ENDFI
      STB A,I      END OF FILE MARK AT END OF RECORD
      JSB CMN2     WHERE TO START!
      JSB INSRT    CHANGE TO REPLACE FORMAT
      JSB CMN3     STORE AND READ NEXT LINE
      JMP REP3
*
*   /R; AND /R AND /D; AND /D GO TO ST.5
*
ST.5  JSB CMN1     FORM TAG,CSTR,READ EDIT
REP4  JSB UNPCK    UNPACK RECORD
ON18  JSB CMN3
      JMP REP4
*
*
*
CMN1  NOP
      LDA ECNT
      IOR MDTK3    11XXXXB=TAG
      STA TAG
      STA WRK6,I
      ISZ WRK6
      JSB CSTR
      JSB RD       READ EDIT
      JMP CMN1,I
*
*
*
CMN2  NOP
      LDB RBUF
      LDA B,I 
      INB 
      ALF,ALF 
      IOR B,I 
      LDB RBUF
      CPA EXDSH 
      ADB O2
      LDA B 
      JMP CMN2,I
*
*
*
CMN3  NOP
      JSB CMN2
      LDB A,I      1ST VALID WORD
      CPB BKAR
      JMP E2
      LDB O2
      CMB,INB 
      ADB SAVE3    TRANSMISSION LOG-1
      CPA RBUF      POINTING TO 1ST WORD
      ADB O2
      JSB STORE    STORE EDIT
      CLA,INA
      JSB RDNXT    READ NEXT LINE
      JMP CMN3,I   AN EDIT
      JMP GD1       A COMMAND
*
*   READS RECORD AND PUTS SPACE AT END OF COMMANDS
*   CHECKS AVAILABLE MEMORY
*   A=0 MEANS UNCONDITIONAL READ
*   INCREMENTED RETURN IF A COMMAND
*
RDNXT NOP
      SZA,RSS
      JMP UNC
REP.  LDA 106B
      CMA,INA
      ADA WRK6
      ADA T72       ARE WE OUT OF MEMORY?
      SSA,RSS      ARE WE THERE?
      JMP MEMRY    YES
      LDA T36 
      ADA WRK7
      CMA,INA 
      ADA EBUF
      SSA 
      JMP MEMRY 
* 
      LDB CBUF
      LDA B,I 
      CPA ENDFI 
      JMP *+3 
      INB 
      JMP *-4 
* 
      ADB T36 
      CMB,INB 
      ADB LBUF
      SSB 
      JMP MEMRY 
      LDA T72
      CLB,INB
      CPB TTY      READ FROM TTY?
      JMP TY1       YES!
      LDB RBUF
      JSB 101B,I    USE SIO DRIVER
      SZA,RSS
      JMP ET       END OFAPE     JMP PST1
PST1  STA SAVE3
      LDA RBUF,I
      ALF,ALF
      AND MASK
      CPA SLASH    A COMMAND?
      JMP PST2     YES
      CPA UPAR
      RSS
      JMP RDNXT,I
      LDA TAG
      STA TAG.
      JSB UNPCK
      LDA RBUF
      ADA O2
      STA WRK2
      LDA RBUF
      ADA SAVE3
      LDB SPACE
      STB A,I
*
      JSB DECIF
      JMP TT2
      STA SAVE8
*
      LDB CBUF
TG4   LDA B,I
      CPA ENDFI
      JMP TT2
*
      AND MDTK
      SZA
      JMP *+3
CHCM  INB
      JMP TG4
*
      LDA B,I
      AND BIAS1
      CPA SAVE8
      RSS
      JMP CHCM
      LDA B,I
      STA TAG
      JMP *+3
*
TT2   JSB INV
      JMP REP.
*
*
      LDA LBUF
      STA WRK7
*
CYC1  LDA WRK7,I
      CPA ENDFI
      JMP DLTE
      AND ENDFI
      CPA TAG
      JMP BLOT.
CYC2  ISZ WRK7
      JMP CYC1
*
BLOT. LDA BLOT
      STA WRK7,I
      JMP CYC2
*
DLTE  JSB CNU
CYC3  LDA TAG.
      CPA TAG 
      JMP AG2 
      STA TAG
      JMP REP.
TLK3  JSB .TALK,I   MEMORY LIMIT; RESTART PHASE 1 
      JMP BGN
PST2  LDB SAVE3 
      STB SAVE7 
      LDB RBUF
      STB WRK
      LDB T36
      CMB,INB       -36
      STB C4
      LDB SBUF
LP27  LDA WRK,I
      ISZ WRK
      STA B,I
      INB
      ISZ C4
      JMP LP27
      ISZ RDNXT
      JSB UNPCK    UNPACK COMMAND
      LDA SAVE3
      ADA RBUF
      LDB SPACE
      STB A,I      PUT SPACE AT END
      JMP RDNXT,I
TLK4  JSB .TALK,I   END OF TAPE ACTION: PHASE 1 
UNC   CLA,INA
      CPA TTY
      JMP TY1
      JSB READ
      JMP PST1
TY1   LDA T72
      LDB RBUF
      JSB 104B,I
      JMP PST1
UNPCK NOP 
      JSB U.PCK,I 
      JMP UNPCK,I 
STORE NOP 
      JSB ST.OR,I 
      JMP STORE,I 
READ  NOP
      LDA T72
      LDB RBUF
      JSB 101B,I
      SZA,RSS
      JMP *-4
      JMP READ,I
*
*
*   CHANGES A,B TO A,AB
*   RBUF MUST BE UNPACKED WITH ENDFI AT END
*   TELL WHERE TO START LOOKING IN A REG.
*
*
INSRT NOP 
      JSB IN.RT,I 
      JMP INSRT,I 
.TALK DEF TALK
ASCI  DEF ASC1
IN.RT DEF I.SRT 
U.PCK DEF UNPAC 
ST.OR DEF S.ORE 
BLOT  OCT 177777
MDTK7 OCT 130000
TAG.  OCT 0
PHS.2 DEF PH.2
T19   DEC 38
PNTR  OCT 0
ABU   DEF ABU1
MEM   OCT 0
TTY   OCT 0
QMRK  DEF MSGE
MSGE  ASC 1,? 
MDTK1 OCT 120000
MDTK3 OCT 110000
SAVE3 OCT 0
EXDSH OCT 20455
EXCLM OCT 41
T72   DEC 72
MASK  OCT 377
SLASH OCT 57
T36   DEC 36
LINS  OCT 44472
END   OCT 42440
LRE   OCT 51072
LDE   OCT 42072
CINS  OCT 44473
ACINS OCT 44440
CDE   OCT 42073
ACDE  OCT 42040
LIST  OCT 46040
LCO   OCT 46072
CRE   OCT 51073
ACRE  OCT 51040
VAL   OCT 0
O7    OCT 7
THRO  OCT 0
BIAS  OCT 77777
SN    OCT 0
TMSK  OCT 040000
O3    OCT 3
NO    OCT 0
WRK6  OCT 0
ECNT  OCT 0
CBUF  DEF CBUFR
LBUF  NOP 
RBUF  DEF RBUFR
EBUF  NOP 
D1    DEF DIGIT
BKAR  OCT 137
WRK   OCT 0
WRK2  OCT 0
SAVE4 OCT 0
SAVE5 OCT 0
A     EQU 0
O6    DEC 6
SAVE8 OCT 0
SAVE7 OCT 0
THR   OCT 0
LIT   OCT 0
DASH  OCT 55
PLUS  OCT 53
B     EQU 1
WRK1  OCT 0
NUMB  OCT 0
ENDFI OCT 137777
TEMP  OCT 0
COMMA OCT 54
SPACE OCT 40
COLEN OCT 72
SBUF  DEF SBUFR
C4    OCT 0
LAB   OCT 0
MDTK  OCT 100000
SZ    OCT 0
SIZE  OCT 0
MTAG  OCT 0
L1    OCT 0
CNT   OCT 0
WRK7  OCT 0
N99   DEC -99
O2    DEC 2
TAG   OCT 0
N5    DEC -5
N60   OCT -60
N12   OCT -12
T12   OCT 12
CNT1  OCT 0
SAVE1 OCT 0
SAVE2 OCT 0
PNT1  OCT 0
MSGE2 DEF MGE2
BIAS1 OCT 7777
UPAR  OCT 136
ABUF  DEF ABUFR
FL6   OCT 0
NO.   OCT 0
FL14  OCT 0
PAGE  OCT 0
WRK12 OCT 0
FL15  OCT 0
NH150 DEC -150
RADR  DEF RDR
RADR1 DEF RDR1
NO.2  OCT 0
WRK3  OCT 0
WRK4  OCT 0
OTMSK EQU ENDFI
NO.3  OCT 0
NO.FS OCT 0
.MGE3 DEF MGE3
LMGE3 DEC 66
CNT2  OCT 0
O8    DEC 8
T60   DEC 60
SP    OCT 020000
SPCE  DEF SP
ADD   OCT 0
L1ST  OCT 0
N     OCT 0
WRK11 OCT 0
TH   DEC 1000
H100  DEC 100
T10    DEC 10
P     OCT 0
O9    DEC 9
T60B  OCT 60
E2    EQU E1
*
*   CHANGES A,B TO A,AB
*   RBUF MUST BE UNPACKED WITH ENDFI AT END
*   TELL WHERE TO START LOOKING IN A REG.
*
*
I.SRT NOP 
      CLB
      STB NUMB
      STA WRK1
      STA WRK2
OVER1 LDA WRK1,I
      CPA ENDFI    END OF RECORD?
      JMP E2
      CPA BKAR
      JMP PUT      ROTATE NUMB UNITS RIGHT
      ISZ NUMB     INC COUNT
      ISZ WRK1
      JMP OVER1     TRY NEXT ELEMENT
PUT LDA NUMB
      SZA,RSS
      JMP E2
      ADA SAVE3
      STA SAVE3     FIX TRANSMISSION LOG
      LDA NUMB
      ISZ WRK1
      JSB ROTAT     ROTATE
      LDB NUMB
      CMB,INB      -SIZE IN B
OVER2 LDA WRK2,I    INSERT SYMBOLS UP TO SEPARATOR
      STA WRK1,I    NOTE: WRK2 WAS NOT CHANGED BY THE ABOVE
      ISZ WRK1
      ISZ WRK2
      INB,SZB
      JMP OVER2
      JMP I.SRT,I 
*
*   UNPACKS RECORD BUFFER
*
UNPAC NOP 
      CCA
      ADA T36
      ADA RBUF
      STA WRK      LAST ELEMENT
      LDA T36
      ALS
      CCB
      ADA B
      ADA RBUF
      STA WRK2     GOES TO WRK2
      LDA T36
      CMA,INA
      STA NUMB
LP1   LDA WRK,I
      AND MASK     377B
      STA WRK2,I
      CCA
      ADA WRK2     NEXT ELEMENT GOES TO WRK2
      STA WRK2
      LDA WRK,I
      ALF,ALF
      AND MASK
      STA WRK2,I   STORE IT
      CCA
      ADA WRK
      STA WRK
      CCB
      ADB WRK2
      STB WRK2     SET FOR NEXT ELEMENT!
      ISZ NUMB     ARE WE DONE?
      JMP LP1      NO!
      JMP UNPAC,I 
*
*
*   STORE RECORD BUFFER IN EDIT FILE: NUMBER IN NUMB
*   PUT S.A. IN A; NUMBER OF ELEMENTS IN B
*
*
S.ORE NOP 
      STB WRK6,I
      ISZ WRK6
      SZB,RSS
      JMP S.ORE,I 
      CMB,INB
      STB NUMB      - COUNT
LP2   LDB A,I
      INA
      STB WRK6,I
      ISZ WRK6
      ISZ NUMB
      JMP LP2
      JMP S.ORE,I 
                                                                                                                                                         