ASMB,R,L,B,T,C
      HED A-05470-94002-1 REV. C  NAM ADD.  ERS & LISTING 
      NAM ADD.
* 
******
* 
* 5451 - 5470 
* 
******
* PURPOSE:           TO EXECUTE ADD AND SUBTRACT COMMANDS FOR 
*                    THE 5451-5470 FOURIER SYSTEM 
* 
* SIZE:              305 WORDS (461 OCTAL)
* 
* ENTRY POINTS:      ADD., SUBT., KEYB
* 
*   1. ADD. 
* 
*     CALLING SEQUENCE: 
*                    INS1 _ N1
*                    INSMX _ 1
*                    INS _ ASCII SP: RESULT GOES INTO BLOCK N1
*                          ELSE INTO BLOCK 0. 
*                    JSB ADD. 
* 
*     PARAMETERS USED:
*                    FLG1 
*                    K1, K2 (SEE RUN7)
*                    NB 
*                    SCAL0
*                    SCALN
*                    CALB0
*                    CALBN
*                    PRE07
*                    PREN7
*                    TIME0
*                    TIMEN
*                    REAK 
* 
*     CONSTANTS USED: 
*                    P.1
*                    P3276
*                    N5 
* 
*     SUBROUTINES CALLED: 
*                    MAXIM
*                    PTSC0
*                    .DIV.
*                    .MPY.
*                    SHR6B
*                    MAXI0
*                    DPREC
*                    MAXC0
*                    IXE0 
*                    INUPC
*                    LOCAT
*                    LOCIT
*                    OFF0 
*                    SAS7S
*                    RUN7 
*                    PGM17
*                    PGM33
*                    PGM39
*                    PGM21
*                    PGM16
*                    PGM22
*                    PGM20
*                    PGM24
*                    PGM40
*                    PGM41
*                    PGM42
*                    PGM43
*                    PGM47
*                    PGM48
*                    PGM49
* 
*     OPERATION:     SETS FLG1 _ 0
*                    EXECUTES "+" : A+ N1 COMMAND.
*                    ADDS DATA BLOCK N1 TO DATA BLOCK 0. RESULT 
*                    STORED IN BLOCK 0. 
*                    IF CALLED FROM SPEC, RESULT STORED IN
*                    BLOCK N1, WIPING OUT THE CORRECT DATA IN 
*                    BLOCK 0. 
*                    IF THE TWO DATA BLOCKS ARE OF DIFFERENT
*                    DOMAINS OR COORDINATES, THE RESULT WILL
*                    BE THAT OF BLOCK 0.
*                    IF BLOCK N1 IS SINGLE PRECISION AND BLOCK 0
*                    IS DOUBLE PRECISION, BLOCK 0 WILL BE TRUN- 
*                    CATED TO SINGLE PRECISION BEFORE OPERATION.
* 
*     NORMAL RETURN: WHEN OPERATION COMPLETED.
* 
*     ERROR CONDITIONS: 
*                    IF BLOCK N1 IS NON-EXISTENT, A "WHAT"
*                    MESSAGE WILL RESULT AND RETURN IS TO CNTRL 
*                    TO RESTART FOURIER PROGRAM.
* 
*   2. SUBT.
* 
*     CALLING SEQUENCE: 
*                    INS1 _ N1
*                    INSMX _ 1
*                    JSB SUBT.
* 
*     PARAMETERS USED:
*                    SAME AS ADD. 
* 
*     CONSTANTS USED: 
*                    SAME AS ADD. 
* 
*     SUBROUTINES CALLED: 
*                    SAME AS ADD. 
* 
*     OPERATION:     SETS FLG1 _ 1
*                    EXECUTES "-" : A- N1 COMMAND.
*                    SUBTRACTS DATA BLOCK N1 FROM DATA BLOCK 0. 
*                    RESULT IS STORED INTO BLOCK 0. 
*                    IF THE TWO DATA BLOCKS ARE OF DIFFERENT
*                    DOMAINS OR COORDINATES, THE RESULT WILL
*                    BE THAT OF BLOCK 0.
*                    IF BLOCK N1 IS SINGLE PRECISION AND BLOCK 0
*                    IS DOUBLE PRECISION, BLOCK 0 WILL BE TRUN- 
*                    CATED TO SINGLE PRECISION BEFORE THE OPERA-
*                    TION.
* 
*     NORMAL RETURN: WHEN OPERATION COMPLETED.
* 
*     ERROR CONDITIONS: 
*                    SAME AS FOR ADD. 
* 
*   3. KEYB 
* 
*     CALLING SEQUENCE: 
*                          LDA L
*                          ALS,ALS
*                          ALS,ALS
*                          ALS,ALS
*                          STA TL 
*                          LDA K
*                          STA TK 
*                          JSB KEYB 
*                    TL    BSS 1
*                    TK    BSS 1
* 
*     PARAMETERS USED:
*                    SCALN
*                    CALBN
*                    PREN7
*                    TIMEN
* 
*     CONSTANTS USED: 
*                    P.1
*                    P3276
*                    N5 
* 
*     SUBROUTINES CALLED: 
*                    .DIV.
*                    PTSCN
*                    .MPY.
*                    SHR6B
* 
*     OPERATION:     THIS SUBROUTINE ATTEMPTS TO FIT FLOATING 
*                    POINT NUMBER K TIMES 10^L  (WHERE K IS A 
*                       16 BIT NUMBER & L IS ITS SCALE FACTOR)
*                    INTO DATA BLOCK, WHOSE ADDRESS IS DRE.,
*                        CALIBRATOR IS CALBN, & SCALE FACTOR- 
*                        MODE NUMBER IS SCALN.
*                    DURING THIS PROCESS, THE DATA BLOCK MAY
*                    BE SCALED DOWN IF K & L ARE LARGER THAN
*                    CALBN, SCALN RESPECTIVELY. 
* 
*     NORMAL RETURN: RETURNS THE SCALE FACTOR OF THE DATA BLOCK 
*                    OR L, WHICHEVER IS THE LARGER, IN BITS 
*                    15 - 6 OF SCALN. RETURNS THE ADJUSTED K VALUE
*                    IN TK. RETURNS TO ADDRESS FOLLOWING TK.
* 
      SKP 
*                     NAM ADD.
      ENT ADD.,SUBT.
      ENT KEYB
      EXT FLG1
      EXT MAXIM 
      EXT PTSC0 
      EXT .DIV. 
      EXT P.1 
      EXT PTSCN 
      EXT SCAL0 
      EXT SCALN 
      EXT CALB0 
      EXT CALBN 
      EXT .MPY. 
      EXT P3276 
      EXT N5
      EXT SHR6B 
      EXT MAXI0 
      EXT DPREC 
      EXT PRE07 
      EXT PREN7 
      EXT TIME0 
      EXT TIMEN 
      EXT K1,K2 
      EXT IXE0
      EXT RUN7
      EXT PGM17 
      EXT PGM33 
      EXT PGM21 
      EXT INS 
      EXT LOCAT 
      EXT LOCIT 
      EXT NB
      EXT PGM47 
      EXT PGM48 
      EXT PGM49 
      EXT PGM22 
      EXT PGM20 
      EXT SAS7S 
      EXT OFF0
      EXT PGM24 
      EXT INS1
      EXT INUPC 
      EXT MAXC0 
      EXT PGM39 
      EXT REAK
      EXT PGM40 
      EXT PGM41 
      EXT PGM42 
      EXT PGM43 
* 
* 
* 
ADD.  NOP 
      CLA 
      JSB ADSUB 
      JMP ADD.,I
* 
SUBT. NOP 
      CLA,INA 
      JSB ADSUB 
      JMP SUBT.,I 
* 
* 
ADSUB NOP 
      STA FLG1   =0: ADD ELSE SUBTRACT
      CLA 
      STA ADKY   =0: ADSUB ELSE KEYBOARD ENTRY
      STA K1K2      =0: K1 & K2 NOT 1 ELSE K1 & K2 =1 
      JSB MAXI0 
      JSB MAXIM 
      JSB SAS7S 
      JSB OFF0
      JSB SAS7S 
      LDA INS1
      SZA 
      JMP SAD1
      LDB FLG1
      SZB 
      STA CALB0 
      JSB INUPC 
      JSB MAXC0 
      JSB MAXI0 
      JMP ADSUB,I 
SAD1  JSB AD0 
      JSB IXE0
      JMP ADSUB,I 
* 
KEYB  NOP    KEYBOARD ENTY
      LDB KEYB
      LDA B,I 
      STA SCAFN     SCALE FACTOR
      INB 
      LDA B,I 
      STA SIGN
      SSA 
      CMA,INA 
      STA MULN   ABS(NUMBER)
      CLA,INA 
      STA ADKY
      ISZ KEYB
      JSB AD0 
      LDB SCAF0 
      JSB PTSCN 
      LDA MULN
      LDB SIGN
      SSB 
      CMA,INA 
      LDB KEYB
      STA B,I     RETURN NUMBER 
      ISZ KEYB
      JMP KEYB,I
* 
* 
AD0   NOP 
      LDA N5
      STA CNT1
      LDA ADKY
      LDB SCAL0 
      SZA 
      LDB SCALN    KEYBOARD 
      JSB SHR6B 
      STB SCAF0 
* 
      SZA 
      JMP *+4 
      LDB SCALN 
      JSB SHR6B 
      STB SCAFN 
* 
      LDB CALB0 
      SZA 
      LDB CALBN    KEYB 
      SSB 
      CMB,INB 
      STB MUL0
      SZA 
      JMP AD01
      LDB CALBN 
      SZB,RSS 
      JMP AD0,I 
      SSB 
      CMB,INB 
      STB MULN
      LDB MUL0
      SZB,RSS 
      JMP AD01A 
* 
* 
AD01  LDA SCAFN    MAKE SCAFN=SCAF0 
      CMA,INA 
      ADA SCAF0    SCAFN-SCAF0
      SSA,RSS 
      JMP AD02
* 
      ISZ SCAF0    SCAF0<SCAFN
      NOP 
      LDB MUL0
      JSB DIV10   DIVIDE MUL0 BY 10 
      STB MUL0
      ISZ CNT1
      JMP AD01
AD01A LDA SCAFN 
      STA SCAF0 
      JMP AD03
* 
AD02  SZA,RSS    SCAF0>=SCAFN 
      JMP AD03   SCAF0=SCAFN
      ISZ SCAFN  SCAF0>SCAFN
      NOP 
      LDB MULN
      JSB DIV10 
      STB MULN
      ISZ CNT1
      JMP AD01
* 
* 
AD03  LDB ADKY
      SZB 
      JMP AD05
      LDA MUL0
      SZA 
      JMP AD04
AD03A LDA SCALN    AND IF ADDSUB THEN 
      STA SCAL0   SCAL0=SCALN 
      LDA TIMEN 
      STA TIME0 
      LDA PREN7 
      STA PRE07 
      JMP AD05
* 
AD04  LDB PREN7 
      SZB,RSS 
      JSB DPREC 
AD05  LDA MULN
      SZA,RSS 
      JMP AD0,I    MULN=0 
      CMA,INA 
      ADA MUL0    MUL0-MULN 
      SSA,RSS 
      JMP AD06
* 
      LDB MUL0   MUL0<MULN
      CLA 
      JSB .DIV. 
MULN  NOP 
      STA MUL0   MULTIPLIER FOR TARGET BLOCK
      LDB REAK
      JSB .MPY. 
      STB REAK
      LDB MULN
      LDA ADKY
      SZA,RSS 
      STB CALB0 
      STB CALBN 
      LDB P3276 
      STB MULN
      SZA,RSS 
      JMP AD08
* 
AD07  LDA MUL0     KEYB ENTRY, MULT. TARGET BLOCK 
      STA K1
      LDB PREN7 
      SZB 
      JMP DPA0
      LDA SCALN 
      SLA 
      JMP POLA
      JSB RUN7
      DEF PGM17 
      JMP AD08
POLA  JSB RUN7
      DEF PGM33 
       JMP AD08 
DPA0  JSB RUN7
      DEF PGM22 
      JMP AD08
* 
AD06  LDB MULN    MUL0>=MULN
      CLA 
      JSB .DIV. 
MUL0  NOP 
      STA MULN    MULTIPLIER OF BLOCK N 
      LDA MUL0
      LDB ADKY
      SZB 
      STA CALBN    KEYB 
      SZB,RSS 
      STA CALB0 
      LDB P3276 
      STB MUL0
* 
AD08  LDA ADKY
      LDB SCAF0 
      SZA 
      JMP AD0,I 
* 
AD09  JSB PTSC0    ADD/SUB ONLY 
      LDA FLG1
      LDB MULN
      SZA 
      CMB,INB 
      STB K2
      LDA MUL0
      STA K1
      AND MULN
      CPA P3276     DO BOTH MULTIPLIERS = 1?
      STA K1K2      YES, SET K1K2 FLAG
      LDB INS 
      CPB SP        IS CALL FROM POWER SPECTRUM?
      JMP POWER     YES 
      LDA FLG1
      LDB PREN7     IS BLOCK IN DOUBLE PRECISION? 
      SZB 
      JMP AD099     YES 
      LDB K1K2
      SZB           DO BOTH MULTIPLIERS = 1?
      JMP NSSP1     YES 
      LDB MULN
      CPB P3276 
      JMP AD09A     BLOCK N MULTIPLIER IS 1 
      SZA           ADD OR SUBTRACT?
      CMB,INB 
      STB K1
      JSB RUN7
      DEF PGM47     NA _ NA + K1(NB)
      JMP AD0,I 
* 
* 
AD09A SZA           ADD OR SUBRRACT?
      JMP AD09B     SUBTRACT
      JSB RUN7
      DEF PGM48     NA _ K1(NA) + NB
      JMP AD0,I 
* 
* 
AD09B JSB RUN7
      DEF PGM49     NA _ K1(NA) - NB
      JMP AD0,I 
* 
* 
AD099 LDB PRE07 
      SZB 
      JMP AD098 
      JSB RUN7
      DEF PGM39     SP DP 
      JMP AD0,I 
* 
NSSP1 SZA            ADD OR SUBTRACT? 
      JMP NSSP2 
      JSB RUN7       ADD S.P BLOCKS WITH
      DEF PGM40      NO SCALING 
      JMP AD0,I 
* 
NSSP2 JSB RUN7       SUBTRACT S.P BLOCKS WITH 
      DEF PGM41      NO SCALING 
      JMP AD0,I 
* 
AD098 LDB K1K2
      SZB 
      JMP NSDP1      K1=K2=1
      LDB MULN
      CPB P3276 
      JMP AD097 
      LDB K2
      STB K1
      JSB RUN7
      DEF PGM20 
      JMP AD0,I 
NSDP1 SZA            ADD OR SUBTRACT? 
      JMP NSDP2 
      JSB RUN7       ADD D.P BLOCKS WITH
      DEF PGM42      NO SCALING 
      JMP AD0,I 
* 
NSDP2 JSB RUN7       SUBTRACT D.P BLOCKS WITH 
      DEF PGM43      NO SCALING 
      JMP AD0,I 
* 
AD097 SZA 
      JMP *+4 
      JSB RUN7
      DEF PGM21 
      JMP AD0,I 
      JSB RUN7
      DEF PGM24 
      JMP AD0,I 
* 
POWER LDA INS1
      JSB LOCAT 
      ISZ ADD.
      ISZ AD0 
      CLA 
      STA NB
      LDA MUL0
      STA K1
      STA K2
      LDA MULN
      LDB PREN7 
      SZB 
      JMP AD096 
      LDB K1K2
      SZB           DO BOTH MULTIPLIERS = 1?
      JMP NSSP3     YES, K1 = K2 = 1
      CPA P3276 
      JMP AD09C 
      STA K1
      JSB RUN7
      DEF PGM48     NA _ K1(NA) + NB
      JMP ENDE
* 
* 
AD09C LDB MUL0
      STB K1
      JSB RUN7
      DEF PGM47     NA _ NA + K1(NB)
      JMP ENDE
* 
* 
AD096 LDB K1K2
      SZB 
      JMP NSDP3 
      CPA P3276 
      JMP *+5 
      STA K1
      JSB RUN7
      DEF PGM21 
      JMP ENDE
      JSB RUN7
      DEF PGM20 
ENDE  LDA SCAL0 
      STA SCALN 
      LDA CALB0 
      STA CALBN 
      JSB LOCIT 
      JMP AD0,I 
* 
* 
NSSP3 JSB RUN7       ADD S.P BLOCKS WITH
      DEF PGM40      NO SCALING 
      JMP ENDE
* 
* 
NSDP3 JSB RUN7
      DEF PGM42      ADD D.P BLOCKS WITH
      JMP ENDE       NO SCALING 
* 
DIV10 NOP 
      LDA P.1 
      JSB .MPY. 
      SSA 
      INB 
      JMP DIV10,I 
* 
* 
* 
SP    OCT 051520
CNT1  BSS 1 
SCAF0 BSS 1 
SCAFN BSS 1 
SIGN  BSS 1 
ADKY  BSS 1 
K1K2  BSS 1 
* 
* 
* 
A     EQU 0 
B     EQU 1 
      END 
                                                                                                                                                                                 