ASMB,R,L,C
      HED ** RTMDE - RTE MICRO DEBUG EDITOR ** JDR
      NAM RTMDE 
      EXT EXEC,.OPSY,TEST,MACRO 
      EXT CLOSE,IFMGR,READF,WRITF 
      EXT OPEN
      ENT START 
* 
*  MICRO DEBUG EDITOR 
* 
*  THIS PROGRAM FACILITATES LOADING AND DEBUGGING 
*  A USERS MICRO PROGRAM. SPECIFICALLY IT ALLOWS
*  HIM TO LOAD OR READ WCS; EXECUTE HIS MICROCODE 
*  WITH BREAKPOINTS THAT WILL DISPLAY THE FIRMWARE
*  REGISTERS; AND GENERATES MASK TAPES THAT ARE 
*  USED TO PROGRAM PROM CHIPS.0EACH FUNCTION OF 
*  THE MDE IS MODULAR AND WILL BE EXPLAINED IN MORE 
*  DETAIL WITHIN EACH MODULE. 
* 
* TO SCHEDULE MDE - *ON,MDE,A - WHERE A = LOGICAL UNIT NUMBER 
* OF KEYBD/DISPLAY DEVICE FOR OPERATOR COMMUNICATION WITH THE 
* MICRODEBUG EDITOR. DEFAULT FOR A = 1 SYSTEM CONSOLE.
* 
* MODIFY FOR RTE BY  J. D. REED  HUGHES AIRCRAFT CO. TUCSON, AZ.
* 
* 7/19/74 
* 
START NOP 
      LDA 1,I       FETCH TTY LOGICAL UNIT. 
      SZA           LOGICAL UNIT SPECIFIED? 
      STA TTY      YES - SAVE IT. 
      LDA CNWD3     SETUP LOGICAL UNIT
      IOR TTY      FOR KEYBOARD 
      STA CNWD3    INPUTS.
      LDA RTURN     SET 
      AND LOMSK 
      IOR PRTRN+1   P-REG.
      STA PRTRN+1 
      LDA RTURN 
      AND HIMSK     RETURN
      ALF,ALF 
      IOR PRTRN+3 
      STA PRTRN+3   ADDRESS.
      LDA RGSTR     SET 
      ADA .+3 
      LDB 0 
      AND LOMSK     REGISTER
      IOR ADREG+1 
      STA ADREG+1 
      AND LOMSK 
      IOR RESET+1  DUMP 
      STA RESET+1 
      SWP 
      AND HIMSK 
      ALF,ALF 
      IOR ADREG+3   ADDRESS.
      STA ADREG+3 
      AND LOMSK 
      IOR RESET+3 
      STA RESET+3 
      JSB MSOUT     PRINT 
      DEF MES00   HEADING.
      DEF .20 
      LDA MORG      INITIALIZE
      JSB MOVE      LOAD/DUMP ROUTINE.
      JSB SPACE     SPACE 
      JSB SPACE     3 
INCMD JSB SPACE     LINES 
      JSB MSOUT     ASK FOR 
      DEF MES01   NEXT
      DEF .+4     COMMAND 
      JSB RDTTY     READ
      DEF LINE      RESPONSE. 
      DEF .M80
      LDB ALINE     GET 
      RBL         1ST INPUT 
      STB BACMD 
      JSB LOADB     CHARACTER.
      CPA .L        COMMAND IS
      JMP ILOAD     LOAD
      CPA .W
      JMP IWRIT     WRITE 
      CPA .R
      JMP IREAD     READ
      CPA .D
      JMP IDUMP     DUMP
      CPA .S
      JMP ISHOW     SHOW
      CPA .P
      JMP IPREP     PREPARE 
      CPA .V
      JMP IVER      VERIFY
      CPA .B
      JMP IBRAK     BREAK 
      CPA .C
      JMP ICHAN     CHANGE
      CPA .E
      JMP IEXEC     EXECUTE 
      CPA .F
      JMP IEND      END.
      CPA .M        MOVE OR MODIFY? 
      JMP *+5 
      JSB ERROR     NO,ERROR
      DEF MES02    ILLEGAL
      DEF .+8 
      JMP INCMD     GO GET NEXT.
      INB           CHECK NEXT
      JSB LOADB     BYTE. 
      CPA .O        COMMAND POSSIBLY MOVE 
      RSS 
      JMP IMOD      NO, COMMAND IS MODIFY 
      INB    !!#'#YES CHECK 
      JSB LOADB     NEXT BYTE 
      CPA .V        V?
      RSS 
      JMP IMOD      NO, MODIFY
      INB 
      JSB LOADB 
      CPA .E        E 
      JMP IMOVE     YES, MOVE 
      JMP IMOD      NO, MODIFY
* 
*   END PROGRAM 
* 
IEND  JSB MSOUT 
      DEF MSEND 
      DEF .+7 
      LDA .-3       SET UP
      STA MCNTR    A -3 CNTR
      LDA MPNTR    & POINTER
      STA BYMOD    TO MODULE IN USE FLAG
      LDA BYMOD,I   FETCH MODULE IN USE FLAG. 
      SZA          BUSY?
      JSB CLMOD     YES - CLEAR IT. 
      ISZ BYMOD     BUMP POINTER ADDRESS. 
      ISZ MCNTR     ALL MODULES CLEARED?
      JMP *-5      NO - LOOP
      JSB EXEC
      DEF *+2 
      DEF .+6 
* 
* ROUTINE TO CLEAR A WCS MODULE IN USE FLAG 
* 
CLMOD NOP 
      STA LUN       SAVE LOGICAL UNIT 
      JSB EXEC      REQUEST 
      DEF *+3      EXEC TO
      DEF .+3      CLEAR
      DEF LUN      IN USE BIT.
      JMP CLMOD,I   RETURN
* 
* 
* 
LINE  BSS 40
ALINE DEF LINE
.L    OCT 114 
.W    OCT 127 
.R    OCT 122 
.D    OCT 104 
.S    OCT 123 
.P    OCT 120 
.V    OCT 126 
.B    OCT 102 
.C    OCT 103 
.E    OCT 105 
.M    OCT 115 
.F    OCT 106 
.O    OCT 117 
      DEC -10 
      DEC -9
      DEC -8
      DEC -7
      DEC -6
      DEC -5
      DEC -4
      DEC -3
      DEC -2
      DEC -1
.     DEC 0 
      DEC 1 
      DEC 2 
      DEC 3 
      DEC 4 
      DEC 5 
      DEC 6 
      DEC 7 
      DEC 8 
      DEC 9 
      DEC 10
.11   DEC 11
.13   DEC 13
.14   DEC 14
.18   DEC 18
.20   DEC 20
.64   DEC 64  
.60   DEC 60
.ASTR OCT 52
.M80  DEC -80 
BACMD NOP 
.M12  DEC -12 
.A    OCT 101 
.Q    OCT 121 
.M32  DEC -32 
.12   DEC 12
B61   OCT 61
B62   OCT 62
B63   OCT 63
B64   OCT 64
BBASE DEF BUFUR 
BLANK OCT 40
BUFUR BSS 512 
CNT   BSS 1 
.32   DEC 32
.M256 DEC -256
.M22  DEC -22 
BADR  BSS 1 
HBASE DEF *+1 
      BSS 256 
      DEC -1
.17   DEC 17
MDLE BSS 1
      SUP 
MES00 ASC 20,                  HP MICRO DEBUG EDITOR
MES01 ASC 4,COMMAND?
MES02 ASC 8,ILLEGAL COMMAND 
MSEND ASC 7,END OF PROGRAM
.M54  DEC -54 
.M66  DEC -66 
B360  OCT 360 
* 
* 
* THIS MODULE LOADS USER MICRO PROGRAM FROM 
* A FMP TYPE 0 OR 7 FILE OR OTHER DEVICE. 
* 
* COMMAND FORMAT: 
*                 LOAD[,UNIT #]  DEFAULT=5. 
* 
ILOAD CLA,INA 
      JSB GTPAR     GET PARAMETER.
      LDA PRAM
      SZA,RSS       ONE FOUND?
      JMP *+3 
      LDA PRAM+1    YES GET IT
      RSS 
      LDA .+5       NO, USE DEFAULT 
      STA RDR       SAVE. 
      CPA .+2       DISC INPUT? 
      RSS 
      JMP IL3  NO, GO START LOAD. 
      JSB MSOUT      YES ENTER
      DEF MESA      FILE NAME 
      DEF .+7 
      JSB RDTTY     READ
      DEF LINE      RESPONSE. 
      DEF .M80
      LDB ALINE     GET 
      RBL           1ST 
      JSB LOADB     BYTE
      STB TMP00      SAVE B-REG.
      LDB .-6 
      STB WTCNT 
      LDB BLNK2     BLANK 
      STB FNAME 
      STB FNAME+1   6 CHAR
      STB FNAME+2   NAME
      LDB ANAME     GET BYTE
      CLE,ELB       ADDRESS OF NAME 
IL2   JSB STORB     STORE 1ST BYTE
      ISZ WTCNT 
      RSS 
      JMP IL3 
      STB TMP01     SAVE NAME ADR.
      LDB TMP00     GET 
      INB           NEXT
      JSB LOADB     BYTE. 
      STB TMP00     SAVE ADRS.
      LDB TMP01     GET  NAME ADRS. 
      SZA           END OF LINE?
      JMP IL2       NO GO BACK
IL3   JSB FOPEN     OPEN FILE.
      JMP INCMD     NO SUCH FILE - GET NXT CMND.
* 
* START LOAD PROCESS
* 
      CLA            INITIALIZE 
      STA FIRST       FIRST 
IL3A  LDA RDR        READ 
      JSB BREAD     1ST 
      DEF *+3       RECORD
      DEF BUF1
      RSS            IF EOT AND 
      JMP IL3B
      LDA RDR        NOT DISC THEN
      CPA .+2 
      RSS 
      JMP IL3A       TRY AGAIN ELSE 
      JSB ERROR      DISC FILE
      DEF MES09 
      DEF .+9        EMPTY. 
      JMP INCMD 
IL3B  LDB HBASE      CLEAR
      LDA .M256 
      STA TMP10     HEADER
      CLA 
      STA 1,I       BUFUR.
      INB 
      ISZ TMP10     FINISHED? 
      JMP *-3       NO, GO BACK.
IL5   CLA           INITIALIZE
      STA CKSUM     CHECKSUM. 
      LDA BUF1+1    GET  RELATIVE 
      AND LOMSK     ORIGIN
      STA TMP10     SAVE. 
      ADA HBASE     COMPUTE 
      STA HEADR     HEADER ADDRESS
      LDA BUF1+1    GET 
      AND HIMSK     MODUE 
      STA MDLE      BASE #. 
      LDA BUF1+2
      STA DBUG
      LDA BUF1      GET RECORD
      ALF,ALF       COUNT OF
      ADA .-5       ACTUAL CODE.
      STA HEADR,I   SET HEADR 
      LDB 0         TO
      BRS           INDICATE
      CMB,INB       GOOD
      INB           DATA. 
      SZB,RSS       DO SAME 
      JMP *+6       FOR NEXT
      ISZ HEADR     N 
      STA HEADR,I   LOCS.  WHERE
      INB           N 
      SZB           = RECORD CNT-5. 
      JMP *-4 
      CMA,INA       NEGATE +
      STA TMP10+1   SAVE COUNT-5
      LDA TMP10     COMPUTE 
      ALS           ACTUAL
      ADA BBASE     BUFUR ADDRESS 
      STA BUFAD     AND SAVE. 
      LDB ABUF1     GET 
      INB           READY 
      INB 
IL4   INB           TO
      LDA 1,I       TRANSFER TO 
      STA BUFAD,I   CORE BUFUR
      ADA CKSUM     KEEP RUNNING
      STA CKSUM     CHECKSUM
      ISZ BUFAD 
      ISZ TMP10+1   FINISHED? 
      JMP IL4       NO, GO BACK 
      LDA BUF1+1   MAKE 
      ADA BUF1+2   FINAL
      ADA CKSUM     ADJUSTMENT
      STA CKSUM     TO
      INB           CHECKSUM
      INB           AND 
      LDA 1,I       COMPARE  WITH 
      CPA CKSUM     THAT ON TAPE
      JMP *+5 
      JSB ERROR     IF NOT
      DEF MES06     SAME THEN 
      DEF .+7       CHECKSUM ERROR
      JMP INCMD     RETURN
      LDA RDR       ELSE
      JSB BREAD     READ
      DEF *+3       NEXT
      DEF BUF1      RECORD AND
      RSS           IF NOT EOT THEN 
      JMP IL5       GO BACK 
      CCA 
      STA EMPTY 
      LDA RDR 
      CPA .+2 
      JSB CLOSF     CLOSE FMP FILE
      JMP INCMD     FETCH NEXT COMMAND
* 
MESA  ASC 7,ENTER FILENAME
BLNK2 ASC 1,
TMP00 BSS 1 
TMP01 BSS 1 
FNAME BSS 5 
ANAME DEF FNAME 
BUF1  BSS 60
RDR   BSS 1 
HEADR BSS 1 
BUFAD BSS 1 
EMPTY NOP 
MES06 ASC 7,CHECKSUM ERROR
CKSUM BSS 1 
ABUF1 DEF BUF1
DBUG  BSS 1 
* 
* DUMP COMMAND MODULE.
*  THIS MODULE ALLOWS USER TO DUMP MICROCODE TO 
* TO A FMP TYPE 0 RO 7 FILE OR EXTERNAL PUNCH. IN THE CASE OF 
* A DUMP TO DISC FILE THE FILE MUST BE AN EXSITING FILE.
* 
*  COMMAND FORMAT:
*                 DUMP[,UNIT #]  DEFAULT=4. 
* 
IDUMP CLA          GET
      STA FIRST 
      INA          DECIMAL
      JSB GTPAR     PARAMETERS. 
      LDA PRAM
      SZA,RSS       MISSING?
      JMP *+3       NO
      LDA PRAM+1    GET 
      RSS           IT. 
      LDA .+4       YES USE DEFAULT.
      STA PCH 
      CPA .+2       UNIT IS DISC? 
      RSS 
      JMP ID1 
      JSB MSOUT     YES 
      DEF MESA      GET 
      DEF .+7 
      JSB RDTTY     DISC
      DEF LINE
      DEF .M80      FILE
      LDB ALINE     NAME
      RBL 
      LDA .-5 
      STA WTCNT     TO
      JSB LOADB 
      STB TMP00 
      LDB BLNK2 
      STB FNAME     FNAME 
      STB FNAME+1 
      STB FNAME+2   AND 
      LDB ANAME 
      CLE,ELB       SAVE
ID0   JSB STORB 
      ISZ WTCNT     FOR 
      RSS 
      JMP ID1       LATER 
      STB TMP01 
      LDB TMP00     USE 
      INB 
      JSB LOADB 
      STB TMP00 
      LDB TMP01 
      SZA 
      JMP ID0 
      JSB FOPEN     OPEN FILE 
      JMP INCMD     NO SUCH FILE - GET NXT CMND.
ID1   LDB HBASE     SEARCH
      LDA 1,I 
      SZA           FOR 
      JMP *+3 
      INB           NON ZER0
      JMP *-4       HEADER
      SSA,RSS       NEGATIVE? 
      JMP *+3 
      JSB BWEOF      YES WRITE EOF
      JMP INCMD      GO GET NEXT COMMAND. 
      STB TMP10     SAVE HEADER ADDRESS 
      STA TMP10+3   SAVE VALUE
      CLB           CLEAR 
      STB CKSUM     CHECKSUM. 
      ADA .+5       SET RECCNT
      STA CCNT
      ALF,ALF       SHIFT HIGH. 
      STA BUF1      SET IN RECORT 
      ALF,ALF 
      CMA,INA       COMPUTE 
      INA 
      INA           ORIGINAL
      INA 
      STA TMP10+1 
      LDA HBASE 
      CMA,INA 
      ADA TMP10     ORGIN.
      STA TMP10+2 
      IOR MDLE
      STA BUF1+1
      ADA CKSUM     KEEP RUNNING
      STA CKSUM     CHECKSUM. 
      ISZ TMP10+1 
      LDA DBUG    GET 
      STA BUF1+2    NEXT WORD.
      ADA CKSUM 
      STA CKSUM 
      ISZ TMP10+1   BUMP COUNT
      LDA TMP10+2   PICK UP REL ADRS OF HEADR 
      ALS           DOUBLE
      ADA BBASE     COMPUTE STARTING
      STA BUFAD     BUFUR ADDRS.
      LDB ABUF1     PICK
      INB           UP
      INB           DATA
DM1   INB           WORD
      LDA BUFAD,I   AND 
      STA 1,I       MOVE TO OUTPUT BUFUR. 
      ADA CKSUM     KEEP
      STA CKSUM     CHECKSUM. 
      ISZ BUFAD     BUMP ADRS.
      ISZ TMP10+1   FINISHED? 
      JMP DM1       NO, GO BACK 
      INB           YES 
      CLA           ZERO
      STA 1,I       NEXT WORD 
      LDA CKSUM     STORE 
      INB 
      STA 1,I       CKSUM.
      LDA PCH       OUTPUT
      JSB BWRIT      RECORD 
      DEF BUF1
      DEF CCNT
      LDB TMP10+3   BEGIN 
      BRS           SEARCH
      ADB TMP10     FOR 
      JMP ID1+1     NEXT HEADR. GO BACK.
* 
TMP10 BSS 4     
CCNT  BSS 1 
PCH   BSS 1 
* 
*  THIS ROUTINE OUTPUTS BINARY MICROCODE TO 
*  DISC FILE OR OTHER DEVICE. 
* 
*  CALLING SEQUENCE:
*                     LDA UNIT# 
*                     JSB BWRIT 
*                     DEF BUFUR 
*                     DEF BUFL
* 
BWRIT NOP 
      CPA .+2       WRITE TO DISC?
      RSS 
      JMP BW4       NO,GO PUNCH 
      ISZ BWRIT     PICK UP BUFFER
      LDA BWRIT,I  ADDRESS AND PLACE IT 
      STA FBUFF    IN WRITF CALL. 
      ISZ BWRIT     PICK UP BUFFER
      LDA BWRIT,I  LENGTH AND  PLACE IT 
      STA FLEN     IN WRITF CALL. 
      ISZ BWRIT     INDEX TO RETURN ADDRESS.
      JSB WRITF     REQUEST 
      DEF *+5      FMP
      DEF DCB      TO 
      DEF FERR     WRITE
FBUFF NOP          A
FLEN  NOP          RECORD.
WERR  JSB IFMGR     WAS 
      DEF *+5      THERE
      DEF FERR     A
      DEF .13      FMP
      DEF TTY      WRITE
      DEF FNAME    ERROR
      SSA,RSS      ?
      JMP BWRIT,I  NO - RETURN
      JSB CLOSF    YES - CLOSE FILE 
      JMP INCMD    AND FETCH NEXT COMMAND.
* 
*  OUTPUT TO EXTERNAL DEVICE
* 
BW4   IOR B2200     SET 
      STA LUN       CONTROL WORD. 
      LDA BWRIT,I   GET 
      STA BBUF      BUFUR ADDRESS 
      ISZ BWRIT     & 
      LDA BWRIT,I 
      STA BBUFL     BUFUR LENGTH. 
      ISZ BWRIT 
      LDA FIRST     FIRST 
      SZA           TIME? 
      JMP *+3 
      ISZ FIRST     YES 
      JSB LEADR     PUNCH LEADR 
      JSB EXEC      OUTPUT
      DEF *+5 
      DEF .+2       BUFUR 
      DEF LUN 
BBUF  BSS 1 
BBUFL BSS 1 
      JMP BWRIT,I   RETURN. 
* 
* THIS ENTRY WRITES END OF FILE 
* 
BWEOF NOP 
      LDA PCH 
      CPA .+2       DEVICE DISC?
      JMP *+3 
      JSB LEADR     NO,PUNCH
      JMP BWEOF,I   TRAILER.
      JSB WRITF     REQUEST 
      DEF *+5      FMP
      DEF DCB      TO 
      DEF FERR     WRITE
      DEF FBUFF    AN 
      DEF .-1      EOF. 
      JMP WERR      CHECK FOR ERRORS
* 
B102  OCT 102 
.15   DEC 15
MES15 ASC 12,INSUFFICIENT FILE SPACE
LEADR NOP 
      LDA PCH 
      IOR =B1000
      STA DEVIC 
      JSB EXEC
      DEF *+3 
      DEF .+3 
      DEF DEVIC 
      JMP LEADR,I 
DEVIC BSS 1 
* 
* THIS ROUTINE CONVERTS AN ASCII
* STRING TO A DECIMAL OR OCTAL NUMBER 
* 
* ON ENTRY A=0 => OCTAL 
*          A#0 => DECIMAL 
*          B= BYTE ADDRESS OF STRING. 
* ON EXIT B<0 => ERROR
* 
CNVRT NOP 
      STB TMPC      SAVE BYTE ADDRESS 
      LDB .+8       PUT OCTAL BASE IN B.
      SZA           WANT DECIMAL
      LDB .+10      YES PUT DECIMAL BASE IN B 
      STB TMPC+1    SAVE BASE 
      CLA           SET 
      STA CFLG      DATA FALG + 
      STA TMPC+2    TEMPORARY.
CN1   LDB TMPC      LOAD ASCII
      JSB LOADB     DIGIT 
      ADA .M48      CONVERT TO #. 
      STA TMPC+3    IS
      CLA           IT
      LDB TMPC+1    REALLY
      JSB LCHEK     A 
      DEF TMPC+3    #?
      SSA 
      JMP CN4       NO, NON DIGIT 
      LDA TMPC+2    YES COMPUTE 
      MPY TMPC+1    NEXT RESULT 
      SZB           OVERFLOW? 
      JMP CN2       YES ERROR 
      CLO 
      ADA TMPC+3    ADD IN CURRENT DIGIT. 
      SOC 
      JMP CNVRT,I   ERROR 
      STA TMPC+2    SAVE TEMP RESULT
      ISZ CFLG      SET GOOD DATA FLAG. 
      ISZ TMPC      BUMP ADDRESS
      JMP CN1       GO BACK.
CN4   LDA CFLG      NON DIGIT FOUND. ANY GOOD 
      LDB TMPC     DATA?
      SZA,RSS 
      STO          NO SET OVERFLOW
      LDA TMPC+2    PICK UP RESULT
      JMP CNVRT,I   EXIT
CN2   STO          OVERFLOW 
      JMP CNVRT,I   EXIT
* 
TMPC  BSS 4 
.M48  DEC -48 
CFLG  BSS 1 
* 
*  THIS ROUTINE  READS BINARY 
*  INPUT FROM A FMP FILE OR OTHER 
*  DEVICE 
* 
*  CALLING SEQUENCE:
*                    LDA LUN   (2=FILE"#2OTHER DEVICE)
*                    JSB BREAD* 
*              DEF *+3
*              DEF BUFUR
*                    EOT RETURN 
*                    NORMAL RETURN
*  ERROR CONDITIONS;
*        FILE NOT ON DISK-COMMAND ABORTED 
*        END OF FILE -COMMAND ABORTED 
BREAD NOP 
      LDB BREAD,I 
      STB EXIT
      ISZ BREAD 
* 
*  READ FROM FILE OR OTHER DEVICE 
* 
      CPA .+2       DEVICE DISC?
      JMP BR7       YES FILE INPUT. 
* 
*  OTHER DEVICE INPUT 
* 
      IOR B300      NO, 
      STA LUN       SET CONTROL WORD. 
      LDA BREAD,I   SET 
      STA BADD      BUFUR ADDRESS.
      ISZ BREAD     SET EOT RETURN. 
      JSB EXEC      READ
      DEF *+5 
      DEF .+1       1 
      DEF LUN 
BADD  NOP           RECORD
      DEF .60 
      SZB,RSS       EOT?
      JMP BREAD,I   YES 
      JMP EXIT,I    NO, 
B300  OCT 300 
* 
*   FILE INPUT
* 
BR7   LDA BREAD,I   FETCH 
      STA FRBUF    TARGET ADDRESS.
      ISZ BREAD     SET EOF RETURN. 
      JSB READF     REQUEST 
      DEF *+6      FMP
      DEF DCB      TO 
      DEF FERR     READ 
FRBUF NOP          A
      DEF .60      RECORD 
      DEF RDLEN     WAS 
      LDA RDLEN    AN EOF 
      SSA          READ?
      JMP BREAD,I   YES 
      JSB IFMGR     WAS 
      DEF *+5      THERE
      DEF FERR     A
      DEF .11      FMP
      DEF TTY      READ 
      DEF FNAME    ERROR
      SSA          ?
      JMP INCMD    YES - FETCH NEW COMMAND
      JMP EXIT,I   NO - NORMAL RETURN 
* 
EXIT  BSS 1 
LUN   BSS 1 
B100  OCT 100 
MES09 ASC 9,NO PROGRAM LOADED 
MES13 ASC 8,FILE NOT ON DISC
MES14 ASC 4,END FILE
TTY   DEC 1 
B2200 OCT 2200
FERR  NOP 
RDLEN NOP 
DCB   BSS 144 
.128  DEC 128 
W/SCT BSS 1 
SBUF  BSS 128 
SBUFA DEF SBUF
SBFAD BSS 1 
SEND  BSS 1 
TBFAD BSS 1 T BSS 1 
FIRST NOP 
                                                                                                                                                                   