* 
* FOPEN OPENS AN FMP FILE 
* 
*  CALLING SEQUENCE:
*                      JSB FOPEN
*                      RTN IF FILE NOT OPEN OR NOT TYPE 0 OR 7
*                      RTN IF FILE IS OPENNED 
* 
FOPEN NOP 
      JSB OPEN      REQUEST 
      DEF *+5      FMP
      DEF DCB      TO 
      DEF FERR     OPEN 
      DEF FNAME    THE
      DEF .+2      FILE 
      LDA FERR      DOES FILE 
      CPA .-6      EXSIST?
      RSS           NO. 
      JMP FOPN1     MAYBE.
NOFIL JSB MSOUT     OUTPUT
      DEF MES13    NO SUCH
      DEF .+8      FILE AND 
      JMP FOPEN,I  RETURN 
FOPN1 JSB IFMGR     WAS 
      DEF *+5      THERE
      DEF FERR     A
      DEF .+8      FMP
      DEF TTY      OPEN 
      DEF FNAME    ERROR
      SSA          ?
      JMP FOPEN,I  YES - TAKE ERROR RETURN
      CPA .         TYPE 0? 
      JMP FYES     FILE OK
      CPA .+7       TYPE 7? 
      RSS          FILE OK
      JMP NOFIL     NEITHER OUTPUT ERROR MESSAGE. 
FYES  ISZ FOPEN     ADJUST RETURN & 
      JMP FOPEN,I  RETURN 
* 
* CLOSF CLOSES THE OPEN FMP FILE
* 
CLOSF NOP 
      JSB CLOSE     CLOSE 
      DEF *+3      FMP
      DEF DCB      FILE 
      DEF FERR     AND
      JMP CLOSF,I  RETURN 
* 
*  RDTTY READS FROM SYSTEM TTY AND
*  WAITS FOR RESPONSE. IT ALSO PUTS 
*  AN END OF DATA FLAG AT END OF INPUT STRING.
* 
*  CALLING SEQUENCE:
*                    JSB RDTTY
*                    DEF BUFUR
*                   DEC BUFL
* 
* 
RDTTY NOP 
      LDA RDTTY,I   PICK UP 
      STA RDBUF     BUFUR ADRESS
      ISZ RDTTY     PICK
      LDA RDTTY,I  UP COUNT 
      STA RDCNT     ADDRESS 
      ISZ RDTTY     SET RETURN. 
      JSB EXEC      READ
      DEF *+5 
      DEF .+1       LINE
      DEF CNWD3     FROM
RDBUF NOP 
RDCNT NOP           TTY.
      STB TMP00 
      LDA RDBUF     COMPUTE 
      RAL      BYTE ADDRESS OF BUFUR. 
      SWP           (TLOG IN B) 
      ADB 0         ADB A 
      CLA           SET EOD 
      JSB STORB     FLAG
      LDB TMP00 
      JMP RDTTY,I   EXIT. 
CNWD3 OCT 400 
*  PARAMETER FETCH ROUTINE
* 
*  CALLING SEQUENCE:
*                   LDA TYPEFLAG (=0,OCTAL CONVERSION 
*                                 #0,DECIMAL  11) 
*                   JSB GTPAR 
* 
* 
* 
*  ROUTINE EXAMINES COMMAND INPUT STRING FOR
*  PARAMETERS. PERFORMS NECESSARY CONVERSION
*  AND RETURNS RESULT IN PARAMETER TABLE. TABLE 
*  FORMAT IS ILLUSTRATED BELOW. 
* 
*        PARAMETER TABLE
*       ****************
*       *              *
*       * # OF ENTRIES *   WORD 1 
*                      *
*       ****************
*       *              *
*       * ENTRY # 1    *   WORD 2 
*       *              *
*       ****************
*       *              *
*       * ENTRY # 2    *   WORD 3 
*       *              *
*       ****************
* 
*              *
* 
*              *
* 
*              *
* 
*       ****************
*       *              *
*       * ENTRY # N    *   WORD N+1 
*       *              *
*       ****************
* 
*  IF ERROR DETECTED COMMAND MUST BE RE-INPUTED.
* 
GTPAR NOP 
      STA PTYPE     SAVE CONVERSION FLAG. 
      CLA           SET 
      STA PRAM      # PARAMETERS=0
      LDA PRAM2     POINT TO 2ND
      STA APRAM     WORD OF PARAMETER TABLE 
      LDA M.5 
      STA CNT 
      LDB BACMD     SKIP
GT0   LDA COMA      TO
      JSB SKPTO     COMA. 
      SZA,RSS       FOUND?
      JMP GTPAR,I   NO, RETURN
      INB      POINT TO NEXT CHAR PAST ",". 
      LDA BLANK  SKIP OVER
      JSB SKIP      BLANKS. 
      SZA           DID WE REACH END OF LINE? EOL 
      JMP *+5       NO
      JSB ERROR     YES,ERROR 
      DEF MES04     MISSING 
      DEF .+9 
      JMP INCMD     GO GET NEXT COMMAND.
      LDA PTYPE     CONVERT 
      JSB CNVRT     ASCII TO BINARY 
      SOS           NUMBER LEGAL? 
      JMP *+5       YES 
      JSB ERROR     NO, ERROR 
      DEF MES08     ILLEGAL 
      DEF .11     DIGIT.
      JMP INCMD     GO GET NEXT COMMAND 
      STA APRAM,I   PUT PARAMETER IN TABLE
      ISZ APRAM     BUMP POINTER
      ISZ PRAM      BUMP UP PARAMETER COUNT 
      ISZ CNT       CANT HANDLE 6 PARAMETERS. 
      JMP GT0       GO BACK & GET NEXT. 
      JMP GTPAR,I 
* 
PTYPE BSS 1 
PRAM  BSS 6 
PRAM2 DEF PRAM+1
APRAM BSS 1 
COMA  OCT 54
MES08 ASC 11,ILLEGAL DIGIT/OVERFLOW 
M.5   DEC -5
* 
*   MODIFY COMMAND MODULE 
* 
*   COMMAND FORMAT: 
*                 MODIFY,<ADR1>[,<ADR2>]
* 
*   THIS COMMAND ALLOWS USER TO MODIFY ADDRESS
*  <ADR1> OR OPTIONALLY ADDRESS <ADR1> THROUGH
*    <ADR2> 
* 
IMOD  CLA 
      JSB GTPAR     GET PARAMETERS. 
      LDA PRAM      SOME
      SZA,RSS       FOUND?
      JMP ERR4      NO ERROR
      LDB PRAM+1    YES PICK UP 1ST 
      ADA .-2       IS THERE
      SSA   ANOTHER?
      STB PRAM+2    NO, SET 2ND = 1ST.
      LDA PRAM+2    PICK UP 2ND.
      AND LOMSK     SAVE
      STA TMP50+1   END 
      LDA 1         AND 
      AND LOMSK     START 
      STA TMP50     ADDRESS.
      CMA,INA       ARE THEY
      ADA TMP50+1 
      SSA,RSS       LEGAL?
      JMP *+5 
ERR3  JSB ERROR     NO,ERROR
      DEF MES03     ILLEGAL 
      DEF .+10
      JMP INCMD     GO GET NEXT COMMAND.
      INA           SET 
      CMA,INA       COUNT.
      STA WTCNT 
      JSB SPACE     SPACE.
      LDA TMP50     COMPUTE ACTUAL
      ALS           BUFUR 
      ADA BBASE     ADDRESS.
      STA ADBUF     SAVE. 
      LDA TMP50 
      ADA HBASE 
      STA TMP50+2 
MD0   STA GFLG
      LDA A.M22      SET
      STA SH1       VALUES
      LDA A.M10     TO SURPRESS 
      STA GRB1      LINE FEED AFTER SHOW
      LDA TMP50     IS
      JSB GRBGE     LOCATION
      JMP MD6       GARBAGE?
      LDA TMP50    CALL SHOW
      LDB 0        TO DISPLAY 
      JSB SHOW   CURRENT CONTENTS 
      CLA 
      STA GFLG
MD6   LDA AD.9      RESET 
      STA SH1       LINE FEED 
      LDA AD.3    SURPRESS
      STA GRB1      PARAMETERS. 
      JSB RDTTY     READ
      DEF LINE      NEW 
      DEF .M80
      LDB ALINE   MAKE
      CLE,ELB        BYTE 
      STB BADR      ADDRESS.
      JSB LOADB     GET 1ST BYTE? 
      CPA .ASTR     ="*"
      JMP MD2 
      CPA .F        NO, F-TYPE CONVERSION?
      RSS 
      JMP MD1 
      LDB BADR   YES
      INB 
      JSB FCONV     CONVERT INPUT.
      SOS             LEGAL?
      JMP *+5 
BADNM JSB ERROR     ILLEGAL 
      DEF MES07      NUMERIC
      DEF .11 
* 
      JMP MD0 
      STB MSBTS     YES,SAVE
      STA LSBTS     RESULTS 
      JMP MD5 
MD1   CLA           NOT E-TYPE
      JSB CNVRT     CONVERT 1ST NO. 
      SOC            LEGAL? 
      JMP BADNM     NO, BAD NUMBER. 
      AND LOMSK     SAVE
      STA MSBTS     1ST NO. 
MD3   INB           NEXT
* 
      JSB LOADB     BYTE
      CPA .ASTR     ="*"? 
      JMP MD4 
      CLA           NO
      JSB CNVRT     CONVERT 2ND NO. 
      SOC            LEGAL? 
      JMP BADNM     NO, BAD NUMBER
      STA LSBTS     SAVE RESULTS
      JMP MD5 
MD2   LDA ADBUF,I   * INSTEAD OF 1ST NO.
      AND LOMSK 
      STA MSBTS     DONT CHANGE ANYTHING. 
      CLA 
      STA GFLG
      INB 
      JMP MD3       GO CHECK SECOND.
MD4   LDA ADBUF     * INSTEAD OF 2ND NO.
      INA           DONT
      LDA 0,I       CHANGE
      STA LSBTS     ANYTHING
      CLA 
      STA GFLG
MD5   LDA GFLG
      SZA,RSS 
      JMP *+3 
      LDA .+2 
      STA TMP50+2,I 
      ISZ TMP50+2 
      LDA TMP50     SHIFT 
      ALF,ALF       ADDRESS HIGH. 
      IOR MSBTS     OR IN MOST SIGNIFIGANT BITS.
      STA ADBUF,I   IN BUFUR
      ISZ ADBUF     BUMP ADDRESS. 
      LDA LSBTS     MODIFY
      STA ADBUF,I   NEXT WORD.
      ISZ ADBUF     BUMP ADDRESS OF BUFUR 
      ISZ TMP50     BUMP ADDRESS
      ISZ WTCNT     FINISHED? 
      RSS 
      JMP INCMD 
      CCA 
      JMP MD0       NO, GO BACK 
* 
MES03 ASC 10,ILLEGAL PARAMETER(S) 
TMP50 BSS 3 
ADBUF BSS 1 
GFLG  BSS 1 
A.M10 DEF .-10
A.M22 DEF .M22
AD.9  DEF .+9 
AD.3  DEF .+3 
MES07 ASC 11,ILLEGAL NUMERIC INPUT
LSBTS BSS 1 
MSBTS BSS 1 
* 
*  THIS MODULE DISPLAYS ALLOCATION OR 
*  A GROUP OF CONSECUTIVE LOCATIONS ON
*  THE SYSTEM TTY.
* 
*  COMMAND FORMAT:
*                 SHOW, <ADR1> [,<ADR2>]
* 
* 
ISHOW CLA 
      JSB GTPAR     GET 
      LDA PRAM      PARAMETRS.
      SZA,RSS       ANY PRESENT 
      JMP ERR4      NO,ERROR
      LDB PRAM+1    GET 1ST.
      ADA .-2 
      SSA   ANY MORE? 
      STB PRAM+2    NO SET 2ND TO 1ST.
      LDA PRAM+2    PICK UP 2ND.
      JSB SHOW      GO DISPLAY. 
      JMP INCMD 
SHOW  NOP 
      AND LOMSK     SAVE
      STA TMP20+1   END 
      LDA 1         AND 
      AND LOMSK     START 
      STA TMP20     ADDRESSES.
      CMA,INA       ARE 
      ADA TMP20+1   THEY
      SSA    LEGAL? 
      JMP ERR3  NO ILLEGAL PARAMETERS 
      INA           SET 
      CMA,INA       COUNT 
      STA SCNT
      JSB SPACE     SPACE.
SH3   LDA TMP20     ADDRESS 
      JSB GRBGE     GARBAGE?
      JMP SH2 
      RAL           NO, GET 
      ADA BBASE     BUFUR 
      STA BUFAD     ADDRESS 
SH0   LDA BUFAD,I   PICK UP 
      AND HIMSK    1ST WORD.
      ALF,ALF       GET ADDRESS PORTION 
      IOR MDLE      OR IN BASE
      LDB ADMES     CONVERT 
      RBL           TO
      JSB ASCII     AND 
      STB TMP20+2   SAVE BYTE ADDRESS 
      LDA BUFAD,I   GET 
      AND LOMSK     UPPER 8-BITS OF INSTR 
      JSB ASCII     CONVERT TO ASCII
      STB TMP20+3 
      LDB TMP20+2 
      LDA BLANK     BLANK 
      JSB STORB     1ST 
      LDA BLANK     3 
      JSB STORB     CHARACTERS
      LDA BLANK 
      JSB STORB 
      LDB TMP20+3 
      LDA BLANK     POSITION
      JSB STORB     FOR LOWER 16 BITS.
      ISZ BUFAD     POINT TO LOWE WORD. 
      LDA BUFAD,I 
      JSB ASCII     CONVERT  LOWER 16 TO ASCII
      JSB MSOUT     PRINT 
      DEF MESGE+1   LINE
SH1   DEF .+9       ON TTY
      ISZ BUFAD     BUMP BUFUR ADDRESS
SH4   ISZ SCNT      FINISHED? 
      RSS 
      JMP SHOW,I    YES EXIT. 
      ISZ TMP20     NO BUMP LOC. ADDRESS
      LDA TMP20     GARBAGE?
      JSB GRBGE 
      RSS 
      JMP SH0       NO GO BACK
      ISZ BUFAD     YES SKIP
      ISZ BUFAD     TO NEXT 
      JMP SH4       GO CHECK AGAIN
SH2   ISZ TMP20 
      ISZ SCNT
      JMP SH3 
      JMP SHOW,I
MESGE ASC 10, 
      ASC 3,<= _     X
ADMES DEF MESGE 
SCNT  BSS 1 
TMP20 BSS 4 
* 
*  THIS ROUTINE SPACES 1 LINE ON TTY
* 
SPACE NOP 
      JSB EXEC
      DEF *+5 
      DEF .+2 
      DEF TTY   
      DEF * 
      DEF .+0 
      JMP SPACE,I 
* 
* 
*  READ COMMAND MODULE 1
* 
*  THIS MODULE READS CODE FROM  WCS.
* 
* 
IREAD CLA,INA       GET DECIMAL 
      JSB GTPAR     PARAMETER.
      LDA PRAM      ONE 
      SZA,RSS       FOUND?
      JMP ERR4      NO ERROR
      LDA PRAM+1    YES PUT IN
      STA WCS       WCS 
      JSB EXEC      READ
      DEF *+6 
      DEF .+1 
      DEF WCS       FROM
      DEF BUFUR 
      DEF B400      WCS.
      DEF . 
      LDA .M256   SET 
      STA WTCNT     HEADERS 
      LDB HBASE 
      LDA .32   TO
      STA 1,I       SHOW
      INB           16 RECORDS OF 
      ISZ WTCNT     16 WCS WORDS
      JMP *-3       EACH. 
      JMP INCMD     GO GET NEXT COMMAND.
* 
*  THIS MODULE CONTROLS EXECUTION OF
*  USERS MICRO-PROGRAM. 
* 
*  COMMENT FORMAT:
*                  EXECUTE[,ADDRESS]
*     ADDRESS =0 => CALL TEST PROGRAM 
*             #0 => EXECUTE FROM GIVEN ADDRESS
*             MISSING => EXECUTE FROM LAST BREAK. 
* 
IEXEC CLA           GET 
      JSB GTPAR     PARAMETER 
      LDA PRAM      IF ANY. 
      SZA           IF
      JMP E0
      LDA LSTBK     NOT US
      CCB           LAST BREAK. 
      STB LSTBK 
      SSA           IF NOT ONE THEN 
      JMP ERR4      MISSING PARAMETER.
      RSS 
E0    LDA PRAM+1    GET NEW PARAMETERS
      AND LOMSK 
      SZA           =0? 
      JMP E1
      LDA WCS       YES  DO I 
      SZA,RSS    KNOW WCS UNIT #? 
      JSB GTWCS     NO,GET WCS UNIT #.
      JSB WRITE     WRITE MICROCODE.
      JSB MWRIT     WRITE LOAD DUMP ROUTINE.
      JSB TEST      CALL TEST PROGRAM.
      LDA INST1     RETURN HERE IF PROGRAM
      LDB JTADR     RUNS TO COMPLETION
      SZB,RSS 
      JMP *+5 
      STA 1,I       FIX 
      INB           UP
      LDA INST2     JUMP TABLE
      STA 1,I 
      JSB MSOUT     PRINT END 
      DEF MES11     PROGRAM 
      DEF .17       MESSAGE.
      CLA 
      JSB BREAK 
      JMP INCMD     GO GET NEXT COMMAND.
* 
E1    STA TMP51     SAVE ADDRESS
      LDA ORGIN     IS ADDRESS
      LDB LDLEN     IN
      ADB 0         LOAD/DUMP 
      JSB LCHEK     ROUTINE?
      DEF TMP51 
      SSA,RSS 
      JMP ERR3      YES ILLEGAL PARAMETER.
      LDA MACRO     GET MACRO 
      AND B360      DECODE
      ALF,ALF       MAPPER
      ALF           ADDRESS.
      ALS           DOUBLE AND COMPUTE
      ADA BBASE     BUFUR ADDRESS.
      STA JTADR     SAVE IT.
      LDA MDLE      WE ARE IN 
      CMA,INA 
      ADA LOMSK 
      SSA 
      JMP *+4 
      CLA           MODULE
      CLB           0 
      JMP E2
      ADA B400
      SSA 
      JMP *+4 
      LDA .+2       MODULE
      CLB           1 
      JMP E2
      ADA B400
      SSA 
      JMP *+4 
      CLA           MODULE
      LDB =B10000   2 
      JMP E2
      LDA .+2       MODULE
      LDB =B10000   3.
E2    STA MASK1     SAVE
      STB MASK2     MASKS.
      LDB JTADR     SAVE
      LDA 1,I       JUMP
      STA INST1     TABLE 
      AND HIMSK     INSTRUCTION.
      IOR SJMP1     PUT IN JMP
      IOR MASK1     TO
      STA 1,I       REGISTER
      INB           RESTORE 
      LDA 1,I       ROUTINE.
      STA INST2 
      LDA SJMP2     PUT 
      IOR MASK2 
      STA 1,I       IN
      LDA LJMP1 
      IOR MASK1     JMP TO
      STA LJMP1 
      LDA LJMP2     NEXT
      AND HIMSK 
      IOR TMP51     START 
      IOR MASK2 
      STA LJMP2     ADDRESS.
      LDA WCS 
      SSA 
      JSB GTWCS     WRITE 
      JSB WRITE     CODE
      JSB MWRIT     TO WCS. 
* 
* RESET SOFTWARE REGISTERS. 
* 
      LDA MACRO     GET MACRO 
      STA MAC 
      LDA REG+11    RESET 
      CLE           E 
      SLA           REG.
      CME 
      LDA REG+10
      CLO           O 
      SLA           REG.
      STO 
      LDB REG+1     B-REG AND 
      LDA REG       A-REG.
MAC   NOP           EXECUTE MAC.
      JMP IEND      SHOULD NOT RETURN HERE
RTURN DEF *+1 
* 
* RETURN FROM BREAK 
* 
      NOP 
      STA REG       SAVE A-REG
      STB REG+1     B-REG 
      CLA 
      SEZ           E 
      INA 
      STA REG+11    REG 
      CLA           AND 
      SOC           O 
      INA 
      STA REG+10    REG.
      LDA TMP70     SET 
      STA LSTBK     LAST BREAK ADDRESS
      LDB JTADR     FIX 
      SZB,RSS 
      JMP *+5 
      LDA INST1     JP
      STA 1,I       JUMP
      INB           TABLE 
      LDA INST2     ADDR- 
      STA 1,I       ESS.
      CLA           REMOVE
      JSB BREAK     CURRENT BREAK.
      LDB ARGBF     GET 
      RBL           READY 
      ADB .+4       TO
      LDA LSTBK 
      IOR MDLE      DUMP
      JSB ASCII     ADDRESS,
      ADB .+3 
      LDA REG 
      JSB ASCII     A-REG,
      ADB .+3 
      LDA REG+1 
      JSB ASCII     B-REG,
      ADB .+3 
      LDA REG+2 
      JSB ASCII     F-REG,
      ADB .+3 
      LDA REG+3 
      JSB ASCII     Q-REG,
      ADB .+4 
      LDA REG+4 
      JSB ASCII     S1-REG
      ADB .+4       & 
      LDA REG+5 
      JSB ASCII     S2-REG, 
      JSB MSOUT     PRINT 
      DEF RGBUF     1ST 
      DEF .M66      LINE. 
      LDB ARGB2     DUMP
      RBL 
      ADB .+3 
      LDA REG+6 
      JSB ASCII     S3-REG, 
      ADB .+4 
      LDA REG+7 
      JSB ASCII     S4-REG, 
      ADB .+3 
      LDA REG+8 
      JSB ASCII     P-REG 
      ADB .+6 
      LDA REG+9 
      IOR B60 
      JSB STORB     FLAG
      ADB .+3 
      LDA REG+10
      IOR B60 
      JSB STORB     8-REG 
      ADB .+3 
      LDA REG+11    AND 
      IOR B60 
      JSB STORB     E-REG.
      JSB MSOUT     PRINT 
      DEF RGBF2     LAST
      DEF .M54      LINE OF REGISTERS.
      JMP INCMD     GO GET NEXT COMMAND.
* 
*  THIS ROUTINE  GETS WCS LOGICAL UNIT #
* 
GTWCS NOP 
      JSB MSOUT     ASK 
      DEF MES12     USER
      DEF .11       FOR 
      JSB RDTTY     WCS 
      DEF LINE      LOGICAL 
      DEF .M80      UNIT
      LDB ALINE     #.
      RBL           CONVERT 
      CLA,INA     INPUT TO
      JSB CNVRT     BINARY
      SOS           LEGAL?
      JMP GTWCS,I   YES RETURN WITH RESULT IN A.
      JSB MSOUT     NO ILLEGAL
      DEF MES07     NUMERIC 
      DEF .11       INPUT.
      JMP GTWCS+1   TRY AGAIN.
* 
MES12 ASC 11,WCS LOGICAL UNIT NO.?_ 
MES11 ASC 17,MICRO PROGRAM EXECUTION COMPLETED
B2000 OCT 2000
TMP51 BSS 2 
INST1 BSS 1 
INST2 BSS 1 
JTADR BSS 1 
LSTBK DEC -1
ARGBF DEF RGBUF 
RGBUF ASC 19,ADR=123456 A=123456 B=123456 F=123456
      ASC 14,Q=123456 S1=123456 S2=123456 
ARGB2 DEF RGBF2+5 
RGBF2 ASC 15,          S3=123456 S4=123456
      ASC 12,P=123456 FLAG=1 O=1 E=1
* 
* ROUTINE TO FETCH STATUS OF WCS MODULE 
* 
WSTAT NOP 
      JSB EXEC      REQUEST 
      DEF *+4      WCS
      DEF .13      MODULE 
      DEF WCS      STATUS 
      DEF FERR     (EQT 4). 
      LDA FERR      IS MODULE 
      SLA,RSS      BUSY?
      ISZ WSTAT     NO - RETURN P+2 
      JMP WSTAT,I   YES - RETURN P+1
* 
MOD1  NOP           WCS MODULE 1 IN USE FLAG
MOD2  NOP           WCS MODULE 2 IN USE FLAG
MOD3  NOP           WCS MODULE 3 IN USE FLAG
MPNTR DEF MOD1
MCNTR NOP 
* 
* ROUTINE TO SET MODULE IN USE FLAG.
* 
STMOD LDA .-3       SET UP
      STA MCNTR    A -3 COUNTER.
      LDB MPNTR     FETCH POINTER TO IN USE FLAGS.
SLOOP LDA 1,I       FETCH IN USE FLAG.
      SZA,RSS       MODULE IN USE?
      JMP SETIT    NO - SET IT & RETURN 
      CPA WCS      ALREADY SET? 
      JMP BYMOD,I  YES - RETURN 
      INB          NO - INDEX FLAG ADDRESS. 
      ISZ MCNTR     ALL THREE TESTED? 
      JMP SLOOP    NO - LOOP
      JMP BYMOD,I  YES - RETURN.
SETIT LDA WCS       SET WCS MODULE IN USE FLAG
      STA 1,I      TO WCS LOGICAL UNIT NO.
      JMP BYMOD,I   RETURN. 
* 
* ROUTINE TO SEE IF MDE IS USING THE MODULE 
* 
BYMOD NOP 
      JSB EXEC      FETCH 
      DEF *+4      EQT
      DEF .13      WORD 
      DEF WCS      NUMBER 
      DEF STATS    FOUR.
      LDA STATS     MODULE IN 
      SLA,RSS      USE? 
      JMP STMOD    NO - SET IN USE FLAG.
      LDA .-3       SET UP
      STA MCNTR    -3 COUNTER 
      LDB MPNTR    & MOD BUSY FLAG POINTER. 
BLOOP LDA 1,I       FETCH BUSY FLAG 
      CPA WCS       ARE WE USING IT?
      JMP BYMOD,I  YES - OK RETURN. 
      INB           TRY 
      ISZ MCNTR    NEXT 
      JMP BLOOP    MODULE.
      JMP MSOUT     WE ARE NOT USING IT.
      DEF MESBY    MUST BE SOME 
      DEF .20      OTHER
      JMP INCMD    PROGRAM. 
MESBY ASC 20,REQUESTED MODULE IN USE - UNABLE TO LOAD 
STATS NOP 
MWRIT NOP 
      LDA WCS      SET
      IOR B2000     SET UNCONDITIONAL WRITE BIT.
      STA LUN       WORD. 
     JSB BYMOD     IS WCS MODULE IN USE?
      JSB EXEC     NO - WRITE 
      DEF *+5 
      DEF .+2       LOAD/DUMP ROUTINE 
      DEF LUN     
      DEF RESET     TO WCS. 
      DEF LDLEN 
      JMP MWRIT,I    RETURN 
                                                                                                                                       