ASMB,R,B,L
      HED RELOCATABLE UTILITY PACKAGE
      NAM UTILY
*********************************************
* RELOCATABLE UTILITY PACKAGE
*********************************************
*
SIZE  EQU FIN-.DL   SIZE OF PACKAGE
*               C. WOOD,   SEPT 15, 1970
*
* THE UTILITY PACKAGE CONTAINS THE FOLLOWING SUBROUTINES:
*
*  BCD TO FLOATING POINT CONVERSION
*  FLOATING POINT TO BCD CONVERSION
*  LOAD NEXT CALL PARAMETER
*  CHECK CALL PARAMETER ADDRESS
*  WAIT
*
      ENT .WAIT,.ACHK,TM1,.DL,.BCD6,.CONV
      EXT .2,.10,.15,.48,IFIX,M1000,M10,M1,M2
      EXT BADR,CCNT,CONST,SBPTR,M12
*
M.12  EQU M12
B17   EQU .15       OCT 17
B60   EQU .48       OCT 60
M.2   EQU M2
M.10  EQU M10       DEC -10
*
      DEF .DL       ADDR OF 1ST PROGRAM WORD
*
**************************************************
*SUBROUTINE TO LOAD NEXT CALL STATEMENT PARAMETER
*     INTO A AND B,AND ADVANCE POINTER
**************************************************
*
* CALLING SEQUENCE:
*     ADDRESS OF PARAMETER STACK IS IN A ON ENTRY
*     TO A BASIC- CALLED SUBROUTINE. IMMEDIATLY:
*     STA TM1
*         THEN WHEN PARA WANTED:
*     JSB .DL
*
.DL   NOP
      LDB TM1,I
      LDA TM1      ADVANCE
      ADA M1         POINTER
      STA TM1
      LDA 1,I      MS PART OF ARGUMENT
      INB
      LDB 1,I      LS PART OF ARGUMENT
      JMP .DL,I
*
TM1   BSS 1         ADDR OF PARAM STACK
      SKP
*             *****************************
*             WAIT UTILITY SUBROUTINE
*             *****************************
*
.WAIT EQU *
WAIT  NOP
      STB K         SAVE B
      STA WSAVA     SAVE A
      IOR SFS       FORM SFS
      SSB,RSS       FLAG OPERATION?
      CLA      NO, LET SKIP = NOP
      STA SKIP      INSTRUCTION SFS OR NOP
      SSB,RSS      FLAG OPERATION?
      CMB,INB       NO, COMPLEMENT POSITIVE #
      ADB M1        TO TEST FOR ZERO DELAY
MORE  INB,SZB,RSS
      JMP END       NO MORE WAIT
LDA   LDA M208      INNER LOOP COUNT
      INA,SZA,RSS
      JMP MORE      END OF A MILLISECOND
SKIP  NOP           SKIP ON FLAG SET OR NOP
      JMP LDA+1     CONTINUE INNER LOOP
      ISZ WAIT      BUMP RETURN FOR FLAG SET
END   LDA WSAVA     RESTORE A
      LDB K         RESTORE B
      JMP WAIT,I    EXIT
*
M208  DEC -208
SFS   SFS 0
      SKP
****************************************
*SUBROUTINE TO CHECK PARAMETER ADDRESSES
*     IN A BASIC CALL STATEMENT
****************************************
*
*     G.WOODLEY
*     30 JAN 69
*
*CALLING SEQUENCE:
*     ADDRESS OF PARAMETER IN B
*     JSB .ACHK,I
*     DEF TYPE
*         1=CONSTANT
*         2=VARIBLE
*         3=ARRAY (COMMON)
*         4=ARRAY (NOT IN COMMON)
*         5=EXPRESSION
*     ERROR RETURN (TYPE IS WRONG)
*     NORMAL RETURN (A,B INTACT)
*
.ACHK EQU *
ACHK  NOP           ***ENTER***
      STA TEMPA     SAVE A
      STB TEMPB     SAVE B
      LDA ACHK,I    GET TYPE
      ISZ ACHK      ADVANCE TO ERROR RETURN
      ALS
      ADA .TAB      ADD ADDRESS OF TABLE
      CMB           -VAR. ADDRESS
      ADB 0,I       COMPARE WITH LOWER LIM
      SSB,RSS       GREATER?
      JMP BACK      NO-ERROR
      INA           STEP TO ADDRESS OF UPPER LIM
      LDA 0,I       GET UPPER LIM
      CMA,INA
      ADA TEMPB     COMPARE WITH ADDRESS
      SSA,RSS       LESS?
      JMP BACK      NO-ERROR
      ISZ ACHK      ADVANCE TO NORMAL RETURN
BACK  LDA TEMPA
      LDB TEMPB     RESTORE REGISTERS
      JMP ACHK,I    ***RETURN***
.TAB  DEF TAB-2,I   ADDRESS OF TABLE
TAB   OCT 00112    POINTERS TO ADDRESSES OF PARAMS
      OCT 00113       CONSTANT
      OCT 00116
      OCT 00117       VARIBLE
      OCT 00110
      OCT 00112       COMMON
      OCT 00113
      OCT 00115       ARRAY
      OCT 00115
      OCT 00120       EXPRESSION
      SKP
******************************************
*BCD/FLOATING POINT CONVERSION SUBROUTINES
******************************************-:*
*     ***BCD TO FLOATING POINT CONVERSION***
*
*    CALLING SEQUENCE:
*
*     LDA (RG FN D6 D5)
*     LDB (D4 D3 D2 D1)
*     JSB .CONV,I
*     JMP ERROR
*      -  (A=MS B=LS FLOATING PT NO.)
*
.CONV EQU *
CONV  NOP           ***ENTER***
      STA SAVA
      STB SAVB      SAVE OPERANDS
      AND HIMSK     ISOLATE RG
      LDB M.12      INIT. COUNT
      ARS
      ISZ 1
      JMP *-2       SHIFT R 12
      STA 1         RG IS ARITHMETICALLY CORRECT
      LDA SAVA
      ALF           SHIFT INTO MS CHAR
      AND HIMSK     ISOLATE FN
      SSA           FN >7?
      LDA FN1       CHANGE TO FN 1 (+DCV)
      ALF           SHIFT INTO LS CHAR
      STA FN        SAVE FUNCTION
      ADA .MTAB     ADD BASE ADDRESS OF MOD TABLE
      ADB 0,I       MODIFY RANGE
      LDA EMNS      E-
      SSB           RANGE IS POS
      ADA M.2       CHANGE TO E+
      STA ESTR      STORE E AND PROPER SIGN
      SSB
      CMB,INB       ABS RG
      LDA 1         TRANSFER TO A
      AND B17       -9<RG<+9
      JSB ASCII     CONVERT TO ASCII
      STB XSTR      STORE EXPONENT
      LDB SPPLS     SPACE-PLUS
      LDA FN
      CPA .2        IS FUNCTION= -VOLTS?
      ADB .2        YES - CHANGE TO SPACE-MINUS
      STB SIGN      STORE SIGN
      LDA SAVA
      JSB ASCII     CONVERT D6 AND D5
      STB SORCE
      LDA SAVB
      ALF,ALF
      JSB ASCII     CONVERT D4 AND D3
      STB SORCE+1
      LDA SAVB
      JSB ASCII     CONVERT D2 AND D1
      STB SORCE+2
      LDA M.13      13 CHARS
      STA CCNT      SET UP COUNTER
      LDB .DEST
      STB SBPTR     SET DESTINATION ADDRESS
      LDA .SCR      SOURCE ADDRESS
      ALS           THAT'S RIGHT,ALS:
      STA BADR      SET UP BUFFER ADDRESS
      JSB CONST     CONVERT TO FLOATING PT
      JMP CONV,I    ***ERROR RETURN***
      ISZ CONV      BUMP RETURN TO NORMAL
      LDA DEST
      LDB DEST+1    LOAD CONVERTED VALUE
      JMP CONV,I    ***RETURN***
*
ASCII NOP          *CONVERT TO ASCII SUB
      STA TEMP      SAVE OPERAND
      RAR,RAR
      RAR,RAR       GET MS DIG INTO LS POS
      CLB
      JSB CHEK      OCHECK IF BCD CHAR
      BLF,BLF       POSITION
      LDA TEMP      GET LS DIG
      JSB CHEK      CHECK IF BCD CHAR
      JMP ASCII,I  *RETURN
*
CHEK  NOP          *CHECKIO IF BCD CHAR
      AND B17       ISOLATE LS CHAR
      ADA M.10      DEC-10
      SSA,RSS       >10?
      JMP CONV,I    ***ERROR RETURN***
      ADA .10       RESTORE
      ADB 0         PR INTP B
      ADB B60       ASCII ZERO
      JMP CHEK,I  *RETURN
*
*          RANGE MODIFICATION TABLE
MTAB  DEC 3         MSEC
      DEC 0          VOLTS
      DEC 0         -VOLTS
      DEC -3        KHZ
      DEC -3        KOHM
      DEC -6        MOHM
      DEC +6        MUSEC
      DEC -9        GHZ
.MTAB DEF MTAB
*
*         BUFFER AREAS
DEST  BSS 2         DESTINATION FOR CONV.RTN
.DEST DEF DEST-1
SIGN  BSS 1         SIGN OF VALUE
SORCE BSS 3         SOURCE FOR CONV.RTN
ESTR  ASC 1,E+      E+OR-
XSTR  BSS 1         EXPONENT
SPSP  ASC 1,        TWO SPACES
.SCR  DEF SIGN
*
*         CONSTANTS AND STORAGE
HIMSK OCT 170000    ISOLATES MS CHAR
M.13  DEC -13
SPPLS ASC 1, +
EMNS  ASC 1,E-
FN1   OCT 10000     FUNCTION 1 (+DCV)
FN    BSS 1         FUNCTION IN LS 4 BITS
TEMP  BSS 1         TEMP STORAGE
SAVA  EQU DEST      REDEFINE TEMP STORAGE
SAVB  EQU DEST+1
WSAVA EQU SAVA
TEMPA EQU SAVA
K     EQU SAVB
TEMPB EQU SAVB
*
*
      SKP
*
*               ****FLOATING POINT TO BCD CONVERSION****
*
*               ENTER WITH FLOATING POINT NUMBER
*               IN  A  AND  B  .RETURNS WITH 6 BCD DIGITS
*               4  LSD-S IN  A
*               2  MSD-S IN  B  BITS 0 - 7
*
.BCD6 EQU *
BCD6  NOP           ***ENTER***
LP1   FSB .100K     SUB 100,000 FROM NO.
      SSA           RESULT POS.?
      JMP *+3       NO.
      ISZ TCNTA     YES.
      JMP LP1       DO AGAIN
      FAD .100K     ADD 100,000 TO NO.
      STA .T1.      STORE # IN TEMP
      LDA TCNTA     POSITION
      ALF           FIRST
      STA TCNTA     DIGIT.
      LDA .T1.      GET NO.
LP2   FSB .10K      SUB 10,000
      SSA           RESULT POS.?
      JMP *+3
      ISZ TCNTA
      JMP LP2
      FAD .10K      ADD BACK 10,000
      JSB IFIX      CONVERT REMAINING
      NOP
      LDA 1         DIGITS TO INTEGER
      LDB TCNTA
      STB .T1.        SAVE MSD'S
      CLB
      STB TCNTA     ZERO COUNTER FOR NEXT CALL
      RSS           CONVERT LAST 4 DIGITS TO BINARY
      INB           FROM INTEGER
      ADA M1000     -1000
      SSA,RSS
      JMP *-3
      BLF
      ADA ..E3
      RSS
      INB
      ADA ..ME2     -100
      SSA,RSS
      JMP *-3
      BLF
      ADA ..E2      +100
      RSS
      INB
      ADA M.10      -10
      SSA,RSS
      JMP *-3
      BLF
      ADA .10
      ADA 1         LSD'S
      LDB .T1.      GET MSD'S
      JMP BCD6,I    ***RETURN***
*
.100K DEC 1.0E+5
.10K  DEC 1.0E+4
..E3  DEC 1000
..ME2 DEC -100
..E2  DEC 100
TCNTA OCT 0
.T1.  BSS 1
FIN   EQU *
      END
                                                                                                                                 