ASMB,R,L,C
      HED ** SFMTR - SHORT FORMATTER SUBROUTINE ** JDR
      NAM SFMTR,7 
      ENT SFMTR 
      EXT .ENTR,.FLUN,FLOAT 
      EXT EXEC
      SUP 
      SPC 2 
* SFMTR IS A SHORT FORMATTER ROUTINE TO CONVERT A BINARY NUMBER TO
* AN ASCII CHARACTER STRING AND STORE THE STRING IN A USER SPECIFIED
* BUFFER. ALL STANDARD E, F, K & I FORMATS ARE HANDLED WITH THE 
* EXCEPTION THAT THE MAXIUM CHARACTER FIELD IS 14.
* THE USER MAY EITHER REQUEST THE BUFFER TO BE WRITTEN ON A 
* LUN OR CONTROL RETURNED TO HIM WITHOUT OUTPUT.
      SPC 1 
* CALLING SEQUENCE
* 
*   FORTRAN 
*     CALL SFMTR (NUMBR,FMT,IBUFR,NPNTR)
* 
*   ALGOL 
*     PROCEDURE SFMTR (NUMBR,FMT,IBUFR,NPNTR);
*     INTEGER FMT,IBUFR,NPNTR;
*     REAL OR INTEGER NUMBR;
*     CODE; 
* 
*   ASSEMBLY
*     JSB SFMTR 
*     DEF *+5 
*     DEF NUMBR 
*     DEF FMT 
*     DEF IBUFR 
*     DEF NPNTR 
* 
*   WHERE:
*     NUMBR = INTEGER OR REAL BINARY NUMBER TO BE CONVERTED TO ASCII
*     FMT   = ASCII CHARACTER STRING DEFINING FORMAT. FOR EXAMPLE - 
*             I3, F5.2  E10.6, K6, ETC. THE LAST CHARACTER MUST 
*             BE A BLANK. 
*     IBUFR = BUFFER FOR ASCII REPRESENTATION OF NUMBR. 
*             NOTE: FIELD SIZE IN FMT MUST NOT BE GREATER THAN
*                   2 * IBUFR'S WORD LENGTH - NPNTR.
*     NPNTR = OFFSET OF 1ST CONVERSION CHARACTER INTO BUFFER
*             IF 0 OR POSITIVE OR OUTPUT TO LUN IF NEGATIVE.
*             I.E. 0 = NO OFFSET, 1ST CHARACTER STATRS IN HI-HALF 
*                      OF BUFFER'S 1ST WORD.
*                  1 = OFFSET 1 CHARACTER, 1ST CHARACTER STARTS 
*                      IN LOW-HALF OF BUFFER'S 1ST WORD.
*                  ETC. 
*               -LUN = WRITE BUFFER ON LUN. 
*          -100 -LUN = WRITE BUFFER ON LUN AND SUPPRESS 
*                      CR/LF. NOTE: A BACKARROW WILL BE 
*                      PLACED IN THE BUFFER AFTER THE LAST
*                      CHARACTER, THEREFORE, THE BUFFER WILL
*                      HAVE TO BE ONE CHARACTER LARGER THAN 
*                      THE W FIELD SPECIFICATION. 
*             NO OFFSET IS ALLOWED IN THE OUTPUT OPTION.
* 
* ERROR CONDITIONS - 1. BUFFER IS FILLED WITH DOLLAR SIGNS ($$) 
*                       IF THE NUMBER BEING CONVERTED IS TO LARGE 
*                       FOR THE FIELD SPECIFIED.
*                    2. BUFFER IS FILLED WITH PERCENT SIGNS (%%)
*                       IF AN ILLEGAL CHARACTER IS IN THE FORMAT
*                       SPECIFICATION OR IF THE SPECIFICATION IS
*                       ILLEGAL.
      SPC 1 
* J.D. REED   HAC-TEL   1/8/74
      SPC 2 
NUMBR NOP           ADDRESS OF NUMBER TO BE CONVERT 
FMT   NOP           CONVERSION FORMAT ADDRESS 
BUFFR NOP           CONVERSION BUFFER ADDRESS 
PNTR  NOP           BUFFER OFFSET POINTER 
      SPC 1 
SFMTR NOP 
      JSB .ENTR     FETCH PARAMETER 
      DEF NUMBR    ADDRESSES. 
      SPC 1 
* INITIALIZE ROUTINE FLAGS, CONSTANTS & POINTERS
      SPC 1 
      CLA           CLEAR THE CRLF
      STA FLAG     SUPPRESS FLAG. 
      LDA FMT       CONVERT 
      RAL          FORMAT 
      CMA,INA,SZA  ADDRESS TO 
      CMA          CHARACTER
      STA FCR      ADDRESS
      LDA N7        SET FORMAT CHARACTER
      STA FCNTR    COUNTER FOR A MAXIUM OF 6 CHARS. 
      CCA           FETCH 
      ADA BUFFR    BUFFER 
      ADA BUFFR    ADDRESS
      LDB PNTR,I    IF POINTER IS NEGATIVE, DO
      SSB,RSS      NOT ADD OFFSET TO BUFFER ADDRESS 
      ADA PNTR,I    ADD CHARACTER OFFSET TO ADDRESS 
      STA BCR      IN BCR 
      STA BCRS     & BCRS 
      CLA,INA       SET CCNT = 1
      STA CCNT     FOR INTERNAL CONVERSION
      LDA N2        SET WSAVE TO -2 (1WD) TO PROTECT
      STA WSAVE    USER'S BUFFER FROM HIMSELF.
      LDA MONEY     RESET BUCKS 
      STA $$%%     ASCII CONSTANT 
      SSB,RSS       SET UP LUN FOR OUTPUT?
      JMP REQST    NO - CONTINUE
      ADB D100     YES - IF CRLF SUPPRESS B WILL BE 
      STB FLAG     STILL NEG. SAVE AS FLAG
      SSB,RSS       LUN IN B? 
      LDB PNTR,I   NO - FETCH IT FROM PNTR
      CMB,INB      MAKE IT POSITIVE 
      STB LUN      AND SAVE 
      SPC 1 
* FORMAT REQUEST ANALYZER 
      SPC 1 
REQST JSB FCHAR     FETCH THE 1ST, TYPE, CHARACTER
      CPA E         E TYPE? 
      JMP ETYPE    YES - PROCESS USING E GROUNDRULES
      CPA F         F TYPE? 
      JMP FTYPE    YES - PROCESS USING F GROUNDRULES
      CPA I         I TYPE? 
      JMP ITYPE    YES - PROCESS USING I GROUNDRULES
      CPA K         K TYPE? 
      JMP KTYPE    YES - PROCESS USING K GROUNDRULES
      JMP ERROR    NONE OF THE ABOVE - GIVE HIM $$$ 
      SPC 1 
* E FORMAT SPECIFICATION PROCESSOR
      SPC 1 
ETYPE JSB .IOR.     FETCH THE REAL NUMBER 
      LDA D4        SET THE SIGN
      STA SIGN     = 4 FOR WGET.
      JSB WDGET     FETCH THE W & D SPECIFICATIONS
      JSB WDSET     SET UP W & D SPECIFICATIONS 
      JSB FLABS     SET THE NUMBER POSITIVE 
      CLB           INITIALIZE EXPON
      STB EXPON    TO ZERO
      CPB EXP       IF NUMBER = 0,
      JMP EOUT1    SKIP THIS NEXT PART
* AJUST NUMBER TO BE AT LEAST 0.1 * 
EOUT2 JSB MBY10     MULTIPLY BY 10
      LDA EXP      IF 10 TIMES
      CMA,INA      NUMBER IS
      SSA          < 1 ( EXP <= 0)
      JMP *+3      THEN 
      ISZ EXPON    BUMP EXPON 
      JMP EOUT2    AND CONTINUE 
      JSB DBY10    ELSE UNDO THE LAST MULTIPLY. 
* NOW CONVERT THE FRACTION PART TO ASCII *
EOUT1 LDA EXPON 
      JSB OUTPT 
      CMA,INA       SAVE FINAL VALUE OF EXPONENT
      STA EXPON 
      JSB OUTP1 
* TRANSFER THE EXPONENT SIGN *
      LDA E         FIRST THE 
      JSB OUTCR    DESCRIPTIVE E
      LDA MINUS     ASCII MINUS SIGN
      LDB EXPON     EXPONENT NEGATIVE 
      SSB          OR POSITIVE? 
      CMB,INB,RSS  NEGATIVE - TAKE 2'S COMPLE & SKIP
      LDA PLUS     POSITIVE - CHANGE A TO ASCII + 
      STB EXPON     SAVE EXPONENT 
      JSB OUTCR     OUTPUT THE SIGN 
* TRANSFER THE EXPONENT MAGNITUDE * 
      LDB EXPON     FETCH EXPONENT
      LDA B60       ASCII 0 TO A
      ADB N10       SUBTRACT 10 FROM EXPONENT 
      SSB           STILL NEGATIVE? 
      JMP *+3      NO - EXPONENT TENS IN A
      INA          YES - INCREMENT EXPONENT TENS
      JMP *-4      DIGIT AND LOOP 
      ADB B72       FORM EXPONENT UNITS DIGIT 
      STB EXPON    AND SAVE 
      JSB OUTCR     TRANSFER
      LDA EXPON    THE
      JSB OUTCR    EXPONENT 
      JMP EXIT      ALL DONE - CHECK FOR OUTPUT 
      SPC 1 
* F FORMAT SPECIFICATION PROCESSOR
      SPC 1 
FTYPE JSB .IOR.     FETCH THE REAL NUMBER 
      CLA           SET SIGN
      STA SIGN     EQUAL 0 FOR WGET 
      JSB WDGET     GET W & D FIELD SPECIFICATIONS
FCONV JSB WDSET     RESET 
      CMA          W &
      JSB WDFIX    D
      JSB FLABS     GET ABSLOUTE VALUE OF NUMBER
      LDA BCNT      CONVERT NUMBER TO ASCII & 
      JSB OUTPT    TRANSFER TO BUFFER 
      STA BCNT      IF NUMBER 
      ADA WSAVE    WAS ZERO,
      SZA,RSS      THEN 
      JMP .OUT.    FORCE 1
      JSB OUTP1    LESS BLANK 
      JMP EXIT      ALL DONE - CHECK FOR OUTPUT 
      SPC 1 
* I FORMAT SPECIFICATION PROCESSOR
      SPC 1 
ITYPE LDA NUMBR,I   FETCH THE NUMBER AND FLOAT IT 
      JSB FLOAT    FOR BETTER CONVERSION ACCURACY 
      STA MANT      SAVE THE MSB OF THE MANTISSA
      JSB .FLUN     SEPERATE LSB FROM EXPONENT
      STA EXP       SAVE THE EXPONENT 
      STB MANT+1   AND LSB OF THE MANTISSA. 
      CLA           SIGN BIT IS SET 
      STA SIGN     TO ZERO FOR THE USE OF 
      JSB WGET     WGET.
      CCA           D = -1
      JSB WDFIX    FOR INTEGERS 
      JMP FCONV     DO ASCII CONVERSION 
      SPC 1 
* K FORMAT SPECIFICATION PROCESSOR
      SPC 1 
KTYPE LDA NUMBR,I   FETCH THE 
      STA MANT     NUMBER 
      CLA           GET 
      STA SIGN     THE
      JSB WGET     W - FIELD
      CCA           SET UP
      JSB WDSET    THE W & D FIELDS 
OCCUT LDA BLANK     GET AN ASCII BLANK
      LDB W         IS W
      ADB D6       > =   ?
      SSB          -6?
      JMP OCT4     YES - OUTPUT A BLANK 
      LDA MANT      GET THE NUMBER
      CMB 
      RAR,RAR  POSITION OVER 2 FOR 16TH BIT 
      CPB N1
      ALR,RAR 
      ALF,RAR       ROTATE 3
      INB,SZB       DONE ROTATING?
      JMP *-2      NOT YET
      AND B7        MASK OFF REST OF DIGITS 
      IOR B60      AND IOR ASCII 0
OCT4  JSB OUTCR     TRANSFER THE CHARACTER
      ISZ W         END OF VALUE? 
      JMP OCCUT    NO - DO NEXT DIGIT 
      JMP EXIT      YES - CHECK FOR OUTPUT
      SPC 1 
* ROUTINE TO FETCH A FORMAT CHARACTER 
      SPC 1 
FCHAR NOP 
      ISZ FCNTR     PROCESSED MAXIUM FMT CHARS.?
      RSS          NO - CONTINUE
      JMP SPACE    YES - RETURN WITH A BLANK
      ISZ FCR       ADVANCE FMT STRING POINTER
      LDB FCR       GET FMT ADDRESS AND SET E 
      CLE,ERB      = TO CHARACTER POSITION
      LDA B,I       FETCH WORD CONTAINING FMT CHAR. 
      SEZ,RSS       IF E = 0, ROTATE TO PUT 
      ALF,ALF      CHARACTER IN LOW A.
      AND B177      MASK OUT EXTRANEOUS BITS. 
      RSS           RETURN WITH CHARACTER IN A
SPACE LDA BLANK     FORCE A BLANK IN A
      JMP FCHAR,I   RETURN
      SPC 1 
* ROUTINE TO SAVE THE W & D FORMAT SPECIFICATIONS 
      SPC 1 
WDFIX NOP 
      CMA           -D -1 
WDFX1 STA DSAVE     SET DSAVE TO INCLUDE POINT
      CMA           D 
      ADA WSAVE     D-W 
      CMA,SSA       W-D-1 
      JMP *+3       JUMP IF W<D+1 
      STA BCNT      NUMBER OF LEADING BLANKS
      JMP WDFIX,I   RETURN
      LDA WSAVE     SET D=W TO
      JMP WDFX1    GIVE THE GUY A CHANCE
      SPC 1 
* ROUTINE TO OBTAIN THE FORMAT W & D SPECIFICATIONS 
      SPC 1 
WDGET NOP 
      JSB WGET      FIRST W 
      JSB FCHAR     MAKE SURE NEXT CHARACTER
      CPA POINT    IS A DECMAL POINT. 
      RSS           IT IS - OK
      JMP ERROR     IT IS NOT - TOO BAD!
      JSB INT       GET D 
      JSB WDFIX     FIX IT UP 
      JMP WDGET,I 
      SPC 1 
* ROUTINE TO OBTAIN FORMAT FIELD SPECIFICATION
      SPC 1 
WGET  NOP 
      JSB INT       FETCH W FIELD INTEGER 
      CMA           -W-1
      STA CCNT      SET UP CHARACTER COUNTER
      INA           A NOW = -W
      STA LEN       SAVE LENGTH FOR OUTPUT
      ADA SIGN      = 4 FOR E-FORMAT, 0 OTHERWISE 
      SSA,RSS       IF NOT NEGATIVE THEN
      JMP ERROR    TAKE ERROR EXIT. 
      STA WSAVE     SAVE W SPECIFICATION
      LDB FLAG      CR/LF SUPPRESS
      SSB,RSS      FLAG SET?
      JMP WGET,I   NO - RETURN
      LDA LEN       FETCH FIELD LENGHT
      ADA N1        ADD 1 TO  
      STA LEN      BUFFER LENGTH
      CMA,INA       MAKE CHARACTER COUNT POSITIVE 
      ADA BCR      AND CALCULATE BUFFER 
      STA B        ADDRESS FOR BACKARROW
      LDA ARROW     FETCH AN ASCII BACKARROW CHAR.
      JSB A2BUF    AND PUT IT IN THE BUFFER.
      LDA WSAVE     RESTORE -W IN A 
      JMP WGET,I   AND RETURN.
      SPC 1 
* ROUTINE TO COMPUTE THE NUMBER IN THE FORMAT STRING
      SPC 1 
INT   NOP 
      JSB FCHAR     FETCH A CHARACTER 
      JSB DIGIT     TEST FOR DIGIT
      JMP ERROR     NOT A DIGIT - USE ERROR EXIT
      JSB FINTG     GET THE REST OF THE INTEGER 
      JMP INT,I     RETURN
      SPC 1 
* ROUTINE TO TEST A CHARACTER FOR A DIGIT 
      SPC 1 
DIGIT NOP 
      LDB A         PLACE CHARACTER IN B
      ADB N72B      CHARACTER > 
      SSB,RSS      THAN 9?
      JMP DIGIT,I  YES - RETURN NOT A DIGIT 
      ADB B12       CHARACTER < 
      SSB          THAN 0?
      JMP DIGIT,I  YES - RETURN NOT A DIGIT 
      ISZ DIGIT     WE HAVE A DIGIT - PUT IT IN A 
      LDA B        A BUMP RETURN ADDRESS
      JMP DIGIT,I   RETURN
      SPC 1 
* ROUTINE TO COMPUTE THE INTEGER IN THE FORMAT STRING 
      SPC 1 
FINTG NOP 
FINT1 STA TEMP1     SAVE CURRENT VALUE
      JSB FCHAR     FETCH THE NEXT CHARACTER
      JSB DIGIT     IS IT A DIGIT?
      JMP GOTIT    NO - END OF INTEGER
      LDB TEMP1    YES - MULTIPLY RESULT
      BLS,BLS      SO FAR 
      ADB TEMP1    BY 
      BLS          10.
      ADA B         ADD TO NEW DIGIT
      JMP FINT1     LOOP
GOTIT CCB           BACK UP 
      ADB FCR      FORMAT 
      STB FCR      POINTER
      LDA TEMP1     RETURN WITH 
      JMP FINTG,I  RESULT IN A REGISTER 
      SPC 1 
* ROUTINE TO FETCH THE REAL NUMBER TO BE CONVERTED
      SPC 1 
.IOR. NOP 
      DLD NUMBR,I   FETCH THE NUMBER
      STA MANT      SAVE THE MSB OF THE MANTISSA
      JSB .FLUN     SEPERATE LSB FROM EXPONENT
      STA EXP       SAVE THE EXPONENT AND 
      STB MANT+1   THE LSB OF THE MANTISSA. 
      JMP .IOR.,I   RETURN
      SPC 1 
* ROUTINE TO LOAD MANTISSA INTO A & B 
      SPC 1 
LODEM NOP 
      DLD MANT      FETCH THE MANTISSA ONLY 
      JMP LODEM,I 
      SPC 1 
* ROUTINE TO CALCULATE THE ABSOLUTE VALUE OF THE MANTISSA 
      SPC 1 
FLABS NOP 
      JSB LODEM     FETCH THE MANTISSA
      CMA,SSA       COMPLEMENT IT. WAS IT POSITIVE? 
      JMP POSIT    YEA - FORGET ABOUT CHANGING IT.
      CMB,INB,SZB,RSS NE - TWO'S COMPLEMENT FOR B.
      INA          AND IF B = 0, BUMP IT. 
      SSA,RSS       IF A IS NEG., THEN
      JMP NEGIT    WE HAVE MAX. NEGATIVE. 
      RAR           THAT GIVES THE RIGHT FRACTION 
      ISZ EXP      WHEN WE BUMP THE EXPONENT. 
      NOP 
NEGIT STA MANT      SAVE THE NEW FRACTION 
      CCA,RSS       SET SIGN FLAG FOR NEGATIVE
POSIT CLA           SET SIGN FLAG FOR POSITIVE
      STA SIGN      SAVE SIGN 
      LDA MANT      MAKE SURE MANTISSA
      JSB NORML    IS NORMALIZED
      JMP FLABS,I   RETURN
      SPC 1 
* ROUTINE TO SAVE THE MANTISSA
      SPC 1 
STORM NOP 
      DST MANT      SAVE MANTISSA AT MANT 
      JMP STORM,I 
      SPC 1 
* ROUTINE TO NORMALIZE THE MANTISSA 
      SPC 1 
NORML NOP 
      SZA,RSS       IF A = B = 0
      SZB          THEN SET THE EXP = 0,
      JMP NRML1    ELSE CHECK THE SIGN. 
      STA EXP       STORES 0 IN EXP.
NRML3 JSB STORM     SAVE NORMALIZE MANTISSA & 
      JMP NORML,I  RETURN 
NRML1 SSA,RSS       IF SIGN OF A IS SET 
      JMP NRML2 
      CLE,ERA      SHIFT RIGHT, 
      ERB 
      ISZ EXP      BUMP EXPONENT &
      NOP 
      JMP NRML3    RETURN 
NRML2 STA MANT      SUBTRACT
      CCA          ONE
      ADA EXP      FROM 
      STA EXP      EXP
      LDA MANT     AND
      CLE,ELB      SHIFT
      ELA          MANTISSA 
      JMP NRML1     CHECK MANTISSA AGAIN
      SPC 1 
* ROUTINE TO MULTIPLY THE MANTISSA BY 10
      SPC 1 
MBY10 NOP 
      LDA MANT      IF THE NUMBER 
      SZA,RSS      IS ZERO, 
      JMP MBY10,I  RETURN 
      LDB EXP       MULTIPLY
      ADB D3       BY 8.
      STB EXP 
      LDB MANT+1    GET MANTISSA
      CLE,ERA      DIVIDE 
      ERB          BY 
      CLE,ERA      4. 
      ERB,CLE 
      ADB MANT+1    DOUBLE ADD, PRODUCING 1.25*MANT.
      SEZ 
      INA 
      ADA MANT
      SSA,RSS       IF OVERFLOW,
      JMP *+5 
      CLE,ERA      SHIFT RIGHT
      ERB          AND
      ISZ EXP      BUMP EXPONENT
      NOP 
      DST MANT      SAVE MANTISSA & 
      JMP MBY10,I  RETURN 
      SPC 1 
* ROUTINE TO DIVIDE THE MANTISSA BY 10
      SPC 1 
DBY10 NOP 
      LDA MANT      IF NUMBER 
      SZA,RSS      IS ZERO, 
      JMP DBY10,I  RETURN 
      LDB N2        ADJUST
      ADB EXP      THE
      STB EXP      EXPONENT 
      LDA MANT+1    MULTIPLY LOWER MANTISSA 
      CLE,ERA      BY 63146B AFTER SHIFTING SO
      MPY TENTH    THAT SIGN BIT IS ZERO. 
      CLE,ELA       SHIFT 
      ELB,CLE      BACK 
      ADA B         ADD HIGH PART OF RESULT 
      SEZ          TO LOW PART FOR
      INB          THE CROSS PRODUCT. 
      STB MANT+1    SAVE LOW PART OF MANTISSA 
      LDA MANT      NOW MULTIPLY HIGH MANTISSA
      MPY TENTH    THE SAME WAY.
      CLE 
      ADA B 
      ADA MANT+1
      SEZ 
      INB 
      STB MANT      EXCHANGE
      STA B        REGISTERS
      LDA MANT     AND
      JSB NORML    NORMALIZE. 
      JMP DBY10,I   RETURN
      SPC 1 
* ROUTINE TO DO THE FINAL CONVERSION TO ASCII 
      SPC 1 
OUTPT NOP 
OUTP3 STA BCTEM 
* REDUCE NUMBER TO < 1 *
      LDB EXP 
      SZB 
      JMP NGATE 
      LDB MANT
      CPB B7777 
      CLB,INB,RSS 
LDEXP LDB EXP 
NGATE CMB,INB      THE
      SSB,RSS      EXPONENT, IF POSITIVE
      JMP OUTPT,I  THEN THE REDUCTION IS DONE,
      JSB DBY10    ELSE DIVIDE BY 10. 
.OUT. CCA 
      ADA BCTEM     BCTEM 
      JMP OUTP3    LOOP 
OUTP1 NOP 
      LDB BCNT      OUTPUT LEADING BLANKS 
      ADB SIGN     SUBTRACT 1 FOR SIGN IF NEGATIVE
      SSB,RSS      SKIP IF NEGATIVE 
      JMP OUTP4 
* IF BCNT >= D, WE CAN STILL OUTPUT THE NUMBER *
      CMB           - BCNT - 1
      ADB D         D - BCNT - 1
      SSB,INB,RSS   SKIP IF BCNT >= D & SET B=D-BCNT
      JMP BUCKS     OUTPUT DOLLARS ELSE 
      STB D        SET NEW VALUE OF D 
      JMP OUTP6 
OUTP4 LDA BLANK     OUTPUT THE
      JSB MULTO    LEADING BLANKS 
OUTP6 ISZ SIGN      OUTPUT A MINUS? 
      JMP OUTP8    NO.
      ISZ W 
      LDA MINUS 
      JSB OUTCR 
* NOW TRANSFER THE DIGITS ONE AT A TIME AS DESCRIBED ABOVE *
OUTP8 LDB W  -      IF W = D
      LDA POINT    THEN WE HAVE 
      CPB D        TO TRANSFER A
      JMP OUTDP    DECIMAL POINT
      JSB GETDG     GET THE DIGIT,
      ADA B60      CONVERT TO ASCII AND 
OUTDP JSB OUTCR    TRANSFER CHARACTER TO BUFFER 
      ISZ W         SKIP IF DONE
      JMP OUTP8    ELSE LOOP
* GET ONE MORE DIGIT TO ROUND * 
      JSB GETDG     FETCH DIGIT 
      ADA N5       AND SUBTRACT 5 
      ISZ OVTOG     IF BUFFER IS BOMBED, FORGET IT! 
      SSA           SKIP IF DIGIT WAS 5 OR MORE 
      JMP OUTP1,I 
* ROUNDING SECTION *
      JSB WDSET     RESET W SO WE DON'T BACK TOO FAR
      LDB BCR       GET THE LAST
OUT11 JSB BUF2A    CHARACTER TRANSFERED.
      JSB DIGIT     WAS IT A DIGIT? 
      JMP OUTP9    NO.
      LDB BCR 
      CPA NINE     YES. WAS IT A NINE?
      JMP OUT10    YES. 
* SINCE THE DIGIT WAS < 9, WE JUST BUMP IT UP. *
      ADA B61 
      JMP OUT14 
OUT10 LDA B60       CHANGE THE
      JSB A2BUF    NINE TO A ZERO 
OUT12 JSB BACKB     BACK UP BUFFER POINTER
      ISZ W         TEST FOR BEGINNING OF FIELD 
      JMP OUT11 
BUCKS LDA WSAVE     RESET CHARACTER COUNTER 
      ADA N1
      STA CCNT     AND BUFFER POINTER.
      LDA BCRS
      STA BCR 
      LDA $$%%  
      LDB WSAVE 
      CMB,INB 
      JSB MULTO 
      JMP OUTP1,I 
OUTP9 CPA POINT     WAS THE CHARACTER A DECIMAL PT.?
      JMP OUT12     NOTHING TO DO IF IT WAS.
      CPA BLANK     WAS IT A BLANK? 
      JMP OUT13     YES. REST IS EASY.
* OTHERWISE IT HAS TO BE A MINUS. * 
      ISZ W         CHECK W/
      RSS           CAN WE MOVE IT BACK?
      JMP BUCKS    NO - SORRY ABOUT THAT
      JSB BACKB 
      JSB A2BUF 
      ISZ BCR       NOW PUT IN A '1'. 
OUT13 LDB BCR 
      LDA B61   
OUT14 JSB A2BUF 
      LDA WSAVE     PUT BCR BACK AT THE END 
      CMA,INA      OF THE FIELD.
      ADA BCRS
      STA BCR 
      JMP OUTP1,I 
      SPC 1 
* ROUTINE TO BACK UP THE CHARACTER BUFFER POINTER ONE CHARACTER 
      SPC 1 
BACKB NOP 
      CCB           SUBTRACT
      ADB BCR      ONE
      STB BCR      FROM 
      JMP BACKB,I  BCR
      SPC 1 
* ROUTINE  TO TRANSFER THE CHARACTER IN A BY B TIMES
      SPC 1 
MULTO NOP 
      CMB,INB       SET B NEGATIVE AND
      SSB,RSS      SKIP IF B IS NOW POSITIVE
      JMP MULTO,I  RETURN - B WAS 0 OR LESS 
      STB MULT2     SAVE COUNT
      STA MULT1    & CHARACTER
MULTL LDA MULT1     RESTORE CHARACTER 
      JSB OUTCR     TRANSFER THE CHARACTER
      ISZ W        & INDEX THE W SPECIFICATION
      NOP           JUST IN CASE
      ISZ MULT2     DONE? 
      JMP MULTL    NO - LOOP
      JMP MULTO,I  YES - RETURN 
      SPC 1 
* ROUTINE TO TRANSFER THE CHARACTER IN A TO THE USER'S BUFFER 
      SPC 1 
OUTCR NOP 
      ISZ CCNT      END OF THE BUFFER 
      JMP OUTC1    NO - TRANSFER CHARACTER
      CCA          YES - RESET
      STA CCNT     CCNT 
      JMP OUTC2    AND RETURN 
OUTC1 ISZ BCR       ADVANCE 
      LDB BCR      BUFFER POINTER 
      JSB A2BUF     STORE CHARACTER IN BUFFER.
      CLA           CLEAR OVTOG AND WERE OKAY 
OUTC2 STA OVTOG 
      JMP OUTCR,I   RETURN. 
      SPC 1 
* ROUTINE TO MULTIPLY THE NUMBER BY 10 AND PEEL OFF THE INTEGER PART
      SPC 1 
GETDG NOP 
      JSB MBY10     MULTIPLY BY 10
      LDB EXP       GET THE EXPONENT IN 
      CMB,INB      B AS NEGATIVE. 
      AND HIMSK     KEEP HIGH ORDER 5 BITS OF A 
      RAL           NORMALIZE TO BIT 15 
      SSB,INB       ROTATE LEFT UNTIL EXP GETS TO 
      JMP *-2      ZERO: THIS PUTS THE INTEGER IN A 
      AND B177      GET RID OF THE OTHER STUFF
      STA TEMP1 
      LDB EXP       NOW ROTATE BACK 
      CMB,INB 
      RAR 
      SSB,INB 
      JMP *-2 
      XOR MANT      REMOVE THE INTGER PART
      LDB MANT+1    NORMALIZE THE REMAINDER.
      JSB NORML 
      LDA TEMP1 
      JMP GETDG,I   RETURN
      SPC 1 
* ROUTINE TO FETCH INTO A THE CHARACTER WHOSE POSITION IS IN A
      SPC 1 
BUF2A NOP 
      CLE,ERB       POSITION ADDRESS AND SET E=C-BIT
      LDA B,I      WORD CONTAINING CHARACTER TO A.
      SEZ,RSS       IF E=0, ROTATE TO GET THE CHAR- 
      ALF,ALF      ACTER IN LOW A 
      AND B177      MASK OUT EXTRANEOUS BITS. 
      JMP BUF2A,I   RETURN WITH CHAR IN A.
      SPC 1 
* ROUTINE TO TRANSFER THE CHARACTER IN A TO THE LOCATION OF B 
      SPC 1 
A2BUF NOP 
      STA TEMP1     SAVE THE CHARACTER
      SLB,INB       COMPLEMENT THE LOW
      ADB N2       ORDER BIT OF B.
      JSB BUF2A     GET THE OTHER CHARACTER IN THE
      ALF,ALF      MEMORY WORD AND ROTATE TO HI END,
      IOR TEMP1    AND MERGE THE CURRENT CHARACTER
      SEZ           ROTATE
      ALF,ALF      IF NECESSARY.
      STA B,I       STORE THE NEW WORD
      JMP A2BUF,I   RETURN
      SPC 1 
* ROUTINE TO RESTORE THE W & D SPECIFICATIONS 
      SPC 1 
WDSET NOP 
      LDA WSAVE     RESTORE 
      STA W        W
      LDA DSAVE    AND
      STA D        D
      JMP WDSET,I   RETURN
      SPC 1 
* FORMAT SPECIFICATION ERROR SUBROUTINE 
      SPC 1 
ERROR LDA %SIGN     REPLACE $ WITH  
      STA $$%%     INSTRUCTION
      JMP BUCKS     FILL BUFFER WITH % SIGNS
      SPC 1 
* CHECK FOR OUTPUT REQUEST
      SPC 1 
EXIT  LDA PNTR,I    DID CONVERSION REQUEST INCLUDE
      SSA,RSS      OUTPUT?
      JMP SFMTR,I  NO - RETURN
      JSB EXEC     YES -
      DEF *+5      OUTPUT 
      DEF D2       THE
      DEF LUN      BUFFER 
      DEF BUFFR,I  TO THE 
      DEF LEN      LUN
      JMP SFMTR,I   RETURN
      SPC 1 
* CONSTANTS & STORAGE ALLOCATIONS 
      SPC 1 
A     EQU 0 
B     EQU 1 
%SIGN OCT 45
$$%%  NOP 
ARROW OCT 137 
B7    OCT 7 
B12   OCT 12
B60   OCT 60
B61   OCT 61
B72   OCT 72
B177  OCT 177 
B7777 OCT 77777 
BCNT  NOP 
BCR   NOP 
BCRS  NOP 
BCTEM NOP 
BLANK OCT 40
CCNT  NOP 
D     NOP 
D2    DEC 2 
D3    DEC 3 
D4    DEC 4 
D6    DEC 6 
D100  DEC 100 
DSAVE NOP 
E     OCT 105 
EXP   NOP 
EXPON NOP 
F     OCT 106 
FCR   NOP 
FCNTR NOP 
FLAG  NOP 
HIMSK OCT 174000
I     OCT 111 
K     OCT 113 
LEN   NOP 
LUN   NOP 
MANT  BSS 2 
MINUS OCT 55
MONEY OCT 44
MULT1 NOP 
MULT2 NOP 
N1    DEC -1
N2    DEC -2
N5    DEC -5
N7    DEC -7
N10   DEC -10 
N72B  OCT -72 
NINE  DEC 9 
PLUS  OCT 53
POINT OCT 56
OVTOG NOP 
SIGN  NOP 
TENTH OCT 63146 
TEMP1 NOP 
W     NOP 
WSAVE NOP 
      SPC 1 
      END 
                                                                                                                                                                                   