ASMB,A,B,L,T,C           ** BASIC CALLABLE DRIVER **
      HED COMPLETE BASIC CALLABLE PLOTTER DRIVER FOR HP 7210
* 
* 
* 
***** COMPLETE BASIC CALLABLE PLOTTER DRIVER FOR HP 7210 *****
* 
*     SOURCE TAPE 1     PART NO. 72003-80001
*     SOURCE TAPE 2     PART NO. 72003-80002
*     LISTING           PART NO. 72003-90001
* 
* 
*     THIS DRIVER IS DESIGNED TO OPERATE THE HP 7210 DIGITAL
* PLOTTER USING HP BASIC AS SUPPLIED BY BASIC SYSTEM PART NO. 
* 20392A AND AS DOCUMENTED IN THE HP BASIC MANUAL PART NO.
* 02116-9077.  THE FUNCTION OF THIS DRIVER IS TO PROCESS
* POSITION CALLS, LETTERING CALLS, AND CHARACTER CODE BUFFERS 
* GENERATED BY HP BASIC.
* 
*     THE DRIVER PROCESSES POSITION CALLS BY CONVERTING THE 4 
* FLOATING POINT ARGUMENTS SUPPLIED INTO CONTROL BITS AND FIXED 
* POINT POSITION COMPONENTS AND THEN TRANSMITTING THIS INFORMATION
* TO THE PLOTTER. 
* 
*     THE DRIVER PROCESSES LETTERING CALLS BY CONVERTING THE 4
* FLOATING POINT ARGUMENTS SUPPLIED INTO 4 STORED COEFFICIENTS
* WHICH SPECIFY THE GEOMETRIC CHARACTERISTICS OF THE CHARACTERS 
* TO BE LETTERED AND THEN CHANGING THE TTY DRIVER ENTRY POINT 
* ADDRESS CONTAINED IN LOCATION 102B TO THE CHARACTER CODE BUFFER 
* PROCESSING ENTRY POINT ADDRESS. 
* 
*     THE DRIVER PROCESSES CHARACTER CODE BUFFERS BY CONVERTING 
* EACH CHARACTER CODE IN THE BUFFER INTO THE SEQUENCE OF SCALED 
* MOVES REQUIRED TO LETTER THAT CHARACTER AND TRANSMITTING THESE
* MOVES TO THE PLOTTER. 
* 
*        IF THE CHARACTER COUNT FOR A GIVEN BUFFER IS EXPRESSED 
*   AS A NON-NEGATIVE NUMBER THEN WHEN THE LAST CHARACTER IN THIS 
*   BUFFER HAS BEEN PROCESSED A CARRIAGE RETURN AND LINE FEED 
*   WILL BE SIMULATED AND THE CONTENTS OF LOCATION 102B WILL BE 
*   RESET TO THE ENTRY POINT ADDRESS OF THE TTY DRIVER. 
* 
*        IF THE CHARACTER COUNT FOR A GIVEN BUFFER IS EXPRESSED 
*   AS A NEGATIVE NUMBER THEN WHEN THE LAST CHARACTER IN THIS 
*   BUFFER HAS BEEN PROCESSED THE PEN WILL REMAIN RAISED AT THE 
*   STARTING POINT FOR THE NEXT CHARACTER IN THAT LINE AND THE
*   CONTENTS OF LOCATION 102B WILL REMAIN UNCHANGED SO THAT THE 
*   CONTENTS OF THE NEXT BUFFER WILL BE LETTERED STARTING AT
*   THIS POINT. 
* 
* 
*     INSTRUCTIONS FOR USING THIS DRIVER IN HP BASIC ARE GIVEN IN 
* THE OPERATING AND SERVICE MANUAL FOR THE HP 17210 INTERFACE KIT,
* PART NO. 17210-90000. 
* 
* 
*     TO OBTAIN THE ABSOLUTE BINARY TAPE REQUIRED TO CONFIGURE AN 
* OTHERWISE UNMODIFIED BASIC SYSTEM CHANGE LINE 108 OF THIS TAPE
* (SOURCE TAPE 1) TO GIVE THE VALUE OF THE PLOTTER SELECT CODE
* WHICH WILL BE USED AND THEN ASSEMBLING THIS MODIFIED CODE AND 
* SOURCE TAPE 2 TOGETHER AS ONE PROGRAM.
* 
* 
* 
***** LINKAGES AND MEMORY ALLOCATION *****
* 
* 
* 
* FIRST WORD OF AVAILABLE MEMORY (FWA)
* 
      ORG 110B           LOCATION FOR VALUE OF FWA
      DEF PEND2          SET NEW VALUE OF FWA 
* 
* LINKAGE TABLE (LT) ADDRESSES
* 
      ORG 121B           LOCATION FOR LT ADDRESS
      DEF EPTAB          STARTING ADDRESS OF LT 
      DEF TEND2          LAST ADDRESS OF LT +1
* 
* 
***** START OF SUBROUTINE AREA USED FOR DRIVER *****
* 
* 
      ORG 13142B         =1ST WORD OF AVAILABLE AREA
* 
* LINKAGE TABLE 
* 
EPTAB OCT 002001         4 ARGUMENTS FOR CALL(1,--- 
      DEF EPT01          ENTRY POINT FOR CALL(1,--- 
      OCT 002002         4 ARGUMENTS FOR CALL(2,--- 
      DEF EPT02          ENTRY POINT FOR CALL(2,--- 
TEND2 EQU *              DEFINES LAST WORD OF LT+1
* 
* 
* EXTERNAL ADDRESSES
* 
* 
.FDVA EQU 241B           ADD. FOR FLOATING DIVIDE 
MPYA  EQU 243B           ADD. FOR FLOATING MULTIPLY 
FLUNA EQU 244B           ADDRESS FOR FLOATING UNPACK
* 
* 
* 
***** PLOTTER SELECT CODE - ENTER CORRECT VALUE BEFORE ASSEMBLING 
* 
* 
* 
PLTSC EQU 15B            VALUE OF PLOTTER S.C.
* 
* 
* 
***** POSITION CALL PROCESSING *****
* 
* 
* 
EPT01 NOP                POSITION CALL ENTRY POINT
      STA ARGAD          INITIALIZE ARGUMENT ADDRESS
      JSB ARGET          GET 1ST ARGUMENT 
      RAL,SLA            ROTATE AND TEST FOR NOT UP 
      JMP *+3            ELSE A=(PCTST) FOR PEN UP
      CMA,SSA,RSS        COMPLIMENT AND TEST FOR PNT
      CLA                CLEAR FOR DOWN IF NOT POINT
      STA PCTST          SET PEN CONTROL FLAG = A 
      JSB ARGET          GET 2ND ARGUMENT 
      CLB                SET B FOR ABSOLUTE 
      STB XRETN          CLEAR X RETURN DISTANCE
      STB YRETN          CLEAR Y RETURN DISTANCE
      SSA                TEST FOR ABSOLUTE MODE 
      LDB MASK4          SET B FOR RELATIVE IF A<0
      STB MASK3          SET MODE CONTROL = B 
      JSB COGET          GET 3RD ARG AND CONVERT
      STA XWORD          SET VALUE OF X COMPONENT 
      JSB COGET          GET 4TH ARG AND CONVERT
      STA YWORD          SET VALUE OF Y COMPONENT 
      JSB PTOUT          TRANSMIT MOVE TO PLOTTER 
      JMP EPT01,I        RETURN TO CALLING PROGRAM
* 
* 
***** ARGUMENT REFFERENCE SUBROUTINE *****
* 
*     ASSUMES (ARGAD)=HEAD OF ARGUMENT LIST ON 1ST ENTRY
*     RETURNS FLOATING POINT ARGUMENT VALUE IN A AND B
* 
* 
ARGET NOP                ENTRY POINT
      LDB ARGAD,I        B=ADDRESS OF CURRENT ARG 
      CCA                A=-1 
      ADA ARGAD          A=NEXT ARG LIST ADDRESS
      STA ARGAD          SET NEW ARG LIST ADDRESS 
      LDA 1B,I           A=1ST WORD OF ARGUMENT 
      INB                B=ADDRESS OF 2ND ARG WORD
      LDB 1B,I           B=2ND WORD OF ARGUMENT 
      JMP ARGET,I        RETURN TO CALL 
* 
* 
****** COMPONENT REFFERENCE AND CONVERSION SUBROUTINE ***** 
* 
*     ASSUMES SUBROUTINE ARGET HAS BEEN INITIALIZED AND PROPER
*     NUMBER OF ARGUMENTS HAVE BEEN REFFERENCED PREVIOUSLY. 
* 
*     THIS SUBROUTINE REFFERENCES AN APPROPRIATE FLOATING POINT 
*     ARGUMENT, CONVERTS IT TO FIXED POINT, TESTS IT FOR VALIDITY 
*     AND GENERATES ANY ERROR MESSAGES REQUIRED.
* 
*     THE COMPONENT PRODUCED IS RETURNED IN THE A REGISTER AS A 
*     2'S COMPLEMENT FIXED POINT NUMBER OF THE FORM 
* 
*                 XXXXXXXXXXXXXXX.X 
* 
* 
COGET NOP                ENTRY POINT
      JSB ARGET          GET NEXT ARGUMENT
      STA ARGET          SAVE HIGH ORDER FRACTION 
      SSA                TEST SIGN OF ARGUMENT
      CLA,RSS            A=ABSOLUTE IF ARG<0
      CLA,INA            A#MODE CONTROL IF ARG>=0 
      CPA MASK3          TEST FOR ARG<0 AND ABSOLUTE
      JMP PLPER          ERROR IF ARG<0 AND ABSOLUTE
      JSB FLUNA,I        GET EXP FROM WORD 2 OF ARG 
      INA                MULTIPLY BY 2 TO GET 0.X 
      SSA                TEST FOR ARG >=0.1B
      JMP LTONE          ELSE PROCESS FRACTIONAL ARG
      ADA M0016          ADJUST EXP FOR RT JUSTFY 
      SSA,RSS            TEST FOR VALID RT JUSTFY 
      JMP PLPER          ERROR IF INVALID RT JSTFY
      LDB ARGET          A=HIGH ORDER FRACTION
      RSS                SKIP 1ST SHIFT 
      BRS                RIGHT SHIFT TO JUSTIFY 
      INA,SZA            INCREMENT SHFT CNT AND TEST
      JMP *-2            SHIFT AGAIN IF CNT<0 
      LDA 1B             A=B=JUSTIFIED ARGUMENT 
      SSB                TEST SIGN OF ARGUMENT
      CMB,INB            NEGATE IF ARG<0
      ADB PLPTC          B_B-MAX COMP-0.1B
      SSB                TEST FOR MAGNITUDE TO BIG
      JMP COGET,I        RETURN TO CALL - NOT TO BIG
PLPER LDA PLPEL          A=ERROR MESSAGE LENGTH 
      LDB PLPEA          B=ERROR MESSAGE ADDRESS
      JSB 102B,I         TRANSMIT ERROR MESSAGE 
      LDA PLPTC          GET STANDARD BAD ARGUMENT
      JMP COGET,I        RETURN TO CALL - BAD ARG 
LTONE LDA ARGET          A=HIGH ORDER FRACTION
      SSA                TEST SIGN OF ARGUMENT
      CCA,RSS            SET A=-0.1B IF ARG<0 
      CLA                ELSE SET A=0.0B
      JMP COGET,I        RETURN TO CALL - NOT TO BIG
* 
* 
***** MOVE TRANSMISSION SUBROUTINE *****
* 
*     ON ENTRY THE FOLLOWING CONDITIONS MUST BE SATISFIED 
* 
*     (XWORD)=X COMPONENT IN FORM XXXXXXXXXXXXXXX.X 
*     (YWORD)=Y COMPONENT IN FORM YYYYYYYYYYYYYYY.Y 
*     (PCTST)=0##############0 FOR PEN DOWN 
*            =0##############1 FOR PEN UP 
*            =1##############1 FOR POINTS 
*     (MASK3)=MODE CONTROL BITS 
* 
*     THE NECESSARY PASSES TO CONTROL AND MOVE THE PEN ARE SENT 
*     NO VALUES ARE RETURNED ON COMPLETION
* 
* 
PTOUT NOP                ENTRY POINT
      SFS PLTSC          TEST FOR PLOTTER READY 
      JMP *-1            ELSE TRY AGAIN 
      LIA PLTSC          SET A=PLOTTER STATUS 
      XOR PCTST          A=0 IF PEN SPEC=PEN STATUS 
      LDB PCTST          SET B=PEN CONTROL SPEC 
      SLA                TEST FOR PEN CHANGE NEEDED 
      JMP PASS1          ELSE TRANSMITT POSITION
      LDA PDWRD          SET A=PEN DOWN PASS
      SLB                TEST FOR PEN DOWN SPEC 
      LDA PUWRD          ELSE SET A=PEN UP PASS 
      JSB PASOT          SEND PEN CHANGE PASS 
PASS1 LDA XWORD          SET A=X COMPONENT
      ARS                REMOVE .X BIT
      ALF,ALF            POSITION HIGH ORDER BITS 
      AND MASK1          EXTRACT HIGH ORDER BITS
      IOR MASK2          INSERT PASS 1 CONTROL BITS 
      JSB PASOT          SEND 1ST PASS
      LDA XWORD          SET A=X COMPONENT
      ARS                REMOVE .X BIT
      AND MASK1          EXTRACT LOW ORDER BITS 
      JSB PASOT          SEND 2ND PASS
      LDA YWORD          SET A=Y COMPONENT
      ARS                REMOVE .Y BIT
      ALF,ALF            POSITION HIGH ORDER BITS 
      AND MASK1          EXTRACT HIGH ORDER BITS
      JSB PASOT          SEND 3RD PASS
      LDA YWORD          SET A=Y COMPONENT
      ARS                REMOVE .Y BIT
      AND MASK1          EXTRACT LOW ORDER BITS 
      IOR MASK3          INSERT PASS 4 CONTROL BITS 
      JSB PASOT          SEND 4TH PASS
      SSB,RSS            TEST PEN SPEC FOR POINTS 
      JMP PTOUT,I        ELSE RETURN TO CALL
      LDA PDWRD          A=PEN DOWN PASS
      JSB PASOT          SEND PEN DOWN PASS 
      LDA PUWRD          A=PEN UP PASS
      JSB PASOT          SEND PEN UP PASS 
      JMP PTOUT,I        RETURN TO CALL 
* 
* 
***** PASS TRANSMISSION SUBROUTINE *****
* 
*     ON ENTRY A REGISTER CONTAINS PASS 
*     TO BE TRANSMITTED 
* 
* 
PASOT NOP                ENTRY POINT
      SFS PLTSC          TEST FOR PLOTTER READY 
      JMP *-1            ELSE TRY AGAIN 
      OTA PLTSC          SET PASS IN OUTPUT REGISTER
      STC PLTSC,C        TRANSMIT OUTPUT REGISTER 
      JMP PASOT,I        RETURN TO CALL 
* 
* 
* CONSTANT AND VARIABLE STORAGE 
* 
* 
MASK1 OCT 000377         EXTRACTS LOW ORDER 8 BITS
MASK2 OCT 102000         1ST PASS CONTROL BITS
MASK3 OCT 000000         4TH PASS CONTROL BITS,ABS M
MASK4 OCT 004000         4TH PASS CONTROL BITS,REL M
PDWRD OCT 101400         PEN DOWN PASS
PUWRD OCT 101000         PEN UP PASS
M0016 DEC -16            CONSTANT FOR ARG. CONV.
PLPTC DEC -19999         CONSTANT FOR VALIDITY TEST 
PCTST OCT 0              PEN CONTROL WORD 
ARGAD OCT 0              ARG. LIST ENTRY ADD. 
XWORD OCT 0              X COMPONENT BUFFER 
YWORD OCT 0              Y COMPONENT BUFFER 
PLPEL DEC 12             ERROR MESSAGE CH. COUNT
PLPEA DEF *+1            ERROR MESSAGE ADDRESS
      ASC 6,BAD CMP XMTD
* 
* 
* 
***** LETTERING CALL PROCESSING ***** 
* 
* 
* 
EPT02 NOP                LETTERING CALL ENTRY POINT 
      STA ARGAD          INITIALIZE ARGUMENT ADDRESS
      LDA MXMAX          A=X NORMALIZING FACTOR 
      LDB XCNST          B=X BIT COUNT
      JSB SCSET          SET UP X NORMALIZING VALUE 
      JSB DIVDR          GET AND NORMALIZE 1ST ARG. 
      STA COEF1+1        SET 1ST COEF. EXPONENT 
      STB COEF1          SET 1ST COEF. FACTOR 
      JSB DIVDR          GET AND NORMALIZE 2ND ARG. 
      STA COEF3+1        SET 3RD COEF. EXPONENT 
      STB COEF3          SET 3RD COEF. FACTOR 
      LDA MYMAX          A=Y NORMALIZING FACTOR 
      LDB YCNST          B=Y BIT COUNT
      JSB SCSET          SET UP Y NORMALIZING VALUE 
      JSB DIVDR          GET AND NORMALIZE 3RD ARG. 
      STA COEF2+1        SET 2ND COEF. EXPONENT 
      STB COEF2          SET 2ND COEF FACTOR
      JSB DIVDR          GET AND NORMALIZE 4TH ARG. 
      STA COEF4+1        SET 4TH COEF. EXPONENT 
      STB COEF4          SET 4TH COEF. FACTOR 
* 
* 
***** INITIALIZE TRANSFER TO CHARACTER BUFFER PROCESSING *****
* 
* 
      LDA 102B           A=CURRENT PRINT DEVICE T.A.
      CPA LTLAD          TEST FOR T.A. NOT SET
      JMP *+2            ELSE USE OLD T.A. FOR RESET
      STA TTYAD          USE CURRENT T.A. FOR RESET 
      LDA LTLAD          A=CH BUFFER PROCESSING T.A.
      STA 102B           SET NEW PRINT DEVICE T.A.
      JMP EPT02,I        RETURN TO CALL - FINISHED
* 
* 
***** NORMALIZING VALUE SET UP SUBROUTINE ***** 
* 
*     ON ENTRY
*     A=NORMALIZING FACTOR PROVIDED BY CHARACTER SET TAPE 
*     B=CORRESPONDING BIT COUNT PROVIDED BY CHARACTER SET TAPE
* 
*     AFTER EXECUTION 
*     (XWORD) AND (YWORD) =F.P. NORMALIZING VALUE 
*     (PCTST)=NEGATED AND DECREMENTED BIT COUNT 
* 
* 
SCSET NOP                ENTRY POINT
      CMA,INA            NEGATE NORMALIZING FACTOR
      STA XWORD          SET F.P. FRACTION FOR VALUE
      CMB                NEGATE AND DECREMENT 
      STB PCTST          SAVE ADJUSTED BIT COUNT
      BLS                INSERT F.P. EXPONENT SIGN
      STB YWORD          SET F.P. EXPONENT FOR VALUE
      JMP SCSET,I        RETURN TO CALL 
* 
* 
***** LETTERING CALL ARGUMENT REFFERENCE AND *****
***** NORMALIZATION SUBROUTINE               *****
* 
*     ON ENTRY IT IS ASSUMED THAT 
*     THE SUBROUTINE ARGET HAS BEEN INITIALIZED 
*     THE SUBROUTINE SCSET HAS BEEN USED TO SET REQUIRED VALUES 
* 
*     AFTER EXECUTION 
*     A=EXPONENT AND SIGN (BIT 0) FOR GEOMETRIC COEFFICIENT 
*     B=(COEF4)=MAGNITUDE OF FACTOR FOR GEOMETRIC COEFFICIENT 
* 
* 
DIVDR NOP                ENTRY POINT
      JSB ARGET          GET NEXT ARGUMENT
      SZA,RSS            TEST FOR NON-ZERO ARG. 
      JMP DIVDR,I        ELSE RETURN - COMPLETED
      JSB .FDVA,I        NORMALIZE TO F.P. QUOTIENT 
      DEF XWORD          DIVIDING BY F.P. NORM.VALUE
      STA ARGET          SAVE RAW F.P. FRACTION 
      JSB FLUNA,I        UNPACK F.P. EXPONENT 
      ADA PCTST          BIAS BY DECREMENTED BIT CNT
      ADA BITNO          BIAS BY PROCESS CONSTANT 
      STA COEF4+1        SAVE RAW COEF. EXPONENT
      LDA ARGET          RESTORE RAW F.P. FRACTION
      SSA,RSS            TEST FOR COEF. >= 0
      JMP *+6            ELSE SHIFT ALL BITS LEFT 1 
      CMB,CLE,INB        NEGATE LOW BITS,CARY TO E
      CMA,SEZ            NEGATE HIGH BITS,NO CARY ? 
      INA                ELSE CARY TO HIGH BITS 
      CCE,SSA            SET E=1,TEST FOR LEFT SHIFT
      JMP *+3            ELSE SAVE COEF. FRACTION 
      ELB                BIT FROM B TO E
      ELA,CLE            BIT FROM E TO A,SET E=0
      STA COEF4          SAVE COEF. MAGNITUDE 
      LDA COEF4+1        GET RAW EXPONENT 
      LDB ARGET          GET RAW FRACTION 
      ELB,SLB            SIGN TO E,E TO LB,TEST LB=0
      INA                ELSE INCREMENT EXP. FOR SHFT 
      SSA,RSS            TEST FOR VALID EXPONENT
      CCA                ELSE SET EXP=-1IF OVERFLOW 
      ELA                INSERT SIGN OF FRACTION
      LDB COEF4          RESTORE MAGNITUDE OF COEF. 
      JMP DIVDR,I        RETURN TO CALL 
* 
* 
***** CHARACTER CODE BUFFER PROCESSING *****
* 
* INITIALIZATION AND PRINT DEVICE ENTRY POINT ADDRESS PROCESSING
* 
* 
LTLNE NOP                ENTRY POINT
      STB BUFAD          SAVE BUFFER ADDRESS
      LDB TTYAD          B=ORIGINAL ADDRESS 
      SSA                TEST FOR RESET ADDRESS 
      CMA,INA,RSS        ELSE NEGATE CHARACTER COUNT
      STB 102B           RESET ENTRY POINT ADDRESS
      STA BUFLN          SAVE ADJUSTED CHARACTER CNT
      CLA                SET A=0
      STA MANDT          CLEAR CHAR. COUNTER
      LDA MASK4          SET A= RELATIVE CONTROL BITS 
      STA MASK3          SET MODE TO RELATIVE 
* 
* 
* CONTROL, CHARACTER IDENTIFICATION AND EXIT PROCESSING 
* 
* 
CHCNT LDB MANDT          B=CHARACTER COUNT
      CPB BUFLN          TEST FOR MORE CHARACTERS 
      JMP EOCHX          ELSE EXIT PROCESSING 
      ISZ MANDT          INCREMENT CHARACTER COUNT
      LDA BUFAD,I        A=CURRENT BUFFER WORD
      SLB,RSS            TEST FOR 2ND CHAR
      ALF,ALF            ELSE POSITION 1ST CHAR 
      AND CMSK1          EXTRACT 7 BIT CHARACTER
      SLB                TEST FOR 1ST CHAR
      ISZ BUFAD          ELSE REFFERENCE NEXT WORD
      STA ARGET          SAVE CHARACTER CODE
      AND CMSK3          EXTRACT BITS 6 AND7
      SZA                TEST FOR BOTH=0
      XOR CMSK3          SET A=0 IF BOTH=1
      SZA,RSS            TEST FOR PRINTING CHAR 
      JMP *+7            ELSE TEST FOR SPECIAL CHARS
      LDA ARGET          RESTORE CHARACTER CODE 
      AND CMSK2          ISOLATE 6 BIT CHARACTER
      ADA CHTAD          SET UP ABSOLUTE CH.TAB.ADD.
      JSB CHGET          PROCESS CHAR. REFFERENCED
      JSB RTSET          UPDATE CARRIAGE RETURN 
      JMP CHCNT          PROCESS NEXT BUFFER ENTRY
      LDA CRCHC          A=CARRIAGE RETURN CHAR.CODE
      CPA ARGET          TEST FOR NOT CARRIAGE RTN
      JSB CRGET          ELSE SIMULATE CARRIAGE RTN 
      LDA LFCHC          A=LINE FEED CHAR. CODE 
      CPA ARGET          TEST FOR NOT LINE FEED 
      JSB LFGET          ELSE SIMULATE LINE FEED
      JMP CHCNT          PROCESS NEXT BUFFER ENTRY
EOCHX LDA LTLAD          A=CH. BUFFER ENTRY ADD 
      CPA 102B           TEST FOR LINE FINISHED 
      JMP LTLNE,I        ELSE RETURN - MORE COMMING 
      JSB CRGET          SIMULATE CARRIAGE RETURN 
      JSB LFGET          SIMULATE LINE FEED 
      JMP LTLNE,I        RETURN TO CALL - FINISHED
* 
* 
***** CHARACTER TABLE ENTRY PROCESSING SUBROUTINE ***** 
* 
*     ON ENTRY
*     A=ADDRESS OF CHARACTER TABLE ENTRY TO BE PROCESSED
*     (COEF1) THROUGH (COEF4+1) GIVE CORRECT GEOMETRIC COEFFICIENTS 
* 
*     AFTER EXECUTION 
*     THE CHARACTER CORRESPONDING TO (A) HAS BEEN LETTERED
*     THE PEN IS CORRECTLY POSITIONED TO START THE NEXT CHARACTER 
*     THE CARRIAGE RETURN HAS BEEN UPDATED FOR ALL BUT THE LAST 
*     MOVE OF THE CHARACTER JUST LETTERED - THIS MOVE IS STILL  
*     AVAILABLE FOR PROCESSING BY THE SUBROUTINE RTSET
* 
* 
* 
CHGET NOP                RETURN ADDRESS 
      LDA 0B,I           GET CH. TABLE ENTRY FOR CH.
      STA BMASK          SAVE COMPLETE ENTRY
      AND CMSK1          A=RELATIVE BLOCK ADDRESS 
      STA CHMCT          SAVE RELATIVE BLOCK ADDRESS
      JSB MPYA,I         RELATIVE WORD ADD.=PRODUCT 
      DEF BLKLN          WITH BLOCK LENGTH IN WORDS 
      ADA MVTAD          A=ABSOLUTE MOVE ADDRESS
      STA CHMAD          SET CURRENT MOVE LOCATION
      LDA BMASK          GET COMPLETE ENTRY 
      XOR CHMCT          EXTRACT COUNT AND MASK DATA
      ALF,RAL            POSITION COUNT DATA
      STA 1B             SAVE COUNT AND MASK DATA 
      AND CMSK1          ISOLATE COUNT DATA 
      STA BMASK          SAVE COUNT DATA
      CMA,INA            NEGATE 
      STA CHMCT          SET CHAR. MOVE COUNTER 
      LDA 1B             GET COUNT AND MASK DATA
      XOR BMASK          ISOLATE MASK DATA
      ALF                POSITION MASK DATA 
      CMA                NEGATE AND DECREMENT 1 
      CLB,INB            SET BIT POSITION 15
      RBR                MOVE BIT TO NEXT POSITION
      INA,SZA            INCREMENT COUNTER AND TEST 
      JMP *-2            INCOMPLETE -ROTATE AGAIN 
      STB BMASK          SET BMASK FOR THIS CHAR. 
* 
* 
* GET CURRENT MOVE AND SCALE FOR TRANSMISSION 
* 
* 
MVGET LDA CHMAD          A=CURRENT MOVE LOCATION
      STA CHMPT          RESET CH. MOVE WORD POINTER
      LDA COEAD          GET COEFFICIENT ADDRESS
      STA COEPT          SET COEFFICIENT POINTER
      LDA XCNST          GET X COMPONENT BIT COUNT
      JSB SCALE          PERFORM AXX*X
      LDA XWORD          GET PREVIOUS X COMPONENT 
      SLA                TEST OLD MOVE FOR 0.XB=0.0B
      INB                ELSE BRING 0.1B FOREWARD 
      STB XWORD          SAVE AXX*X 
      LDA YCNST          GET Y COMPONENT BIT COUNT
      JSB SCALE          PERFORM AYX*Y
      ADB XWORD          FORM AXX*X+AYX*Y 
      STB XWORD          SET X=AXX*X+AYX*Y
      LDA CHMAD          GET CHAR. MOVE WORD ADDRESS
      STA CHMPT          RESET CH. MOVE POINTER 
      LDA XCNST          GET X COMPONENT BIT COUNT
      JSB SCALE          PERFORM AXY*X
      LDA YWORD          GET PREVIOUS Y COMPONENT 
      SLA                TEST OLD MOVE FOR 0.YB=0.0B
      INB                ELSE BRING 0.1B FOREWARD 
      STB YWORD          SAVE AXY*X 
      LDA YCNST          GET Y COMPONENT BIT COUNT
      JSB SCALE          PERFORM AYY*Y
      ADB YWORD          FORM AXY*X+AYY*Y 
      STB YWORD          SET Y=AXY*X+AYY*Y
* 
* 
* PROCESS PEN CONTROL BIT FOR CURRENT MOVE
* 
* 
PCBIT CLB                SET B=PEN DOWN 
      LDA CHMPT,I        GET PEN CONTROL WORD 
      AND BMASK          ISOLATE PEN CONTROL BIT
      SZA                TEST FOR PEN UP
      INB                CHANGE TO PEN UP 
      STB PCTST          SET PEN CONTROL FLAG 
      JSB PTOUT          SEND MOVE
      ISZ CHMCT          INCREMENT  MOVE COUNTER
      JMP NMOVE          SET  UP FOR NEXT MOVE
      JMP CHGET,I        RETURN, CHARACTER FINISHED 
* 
* 
* SET UP TO PROCESS NEXT MOVE 
* 
* 
NMOVE JSB RTSET          UPDATE CARRIAGE RETURN 
      LDA BMASK          A=CURRENT BIT MASK 
      LDB CHMAD          B=CURRENT ABS. WORD ADDRESS
      RAR                A=BIT MASK FOR NEXT MOVE 
      STA BMASK          SAVE NEW BIT MASK
      SSA                USE OLD ADD. IF BIT15#1
      ADB BLKLN          B=NEW ADDRESS IF BIT15=1 
      STB CHMAD          SAVE NEW ABS. WORD ADDRESS 
      JMP MVGET          PROCESS NEXT MOVE
* 
* 
***** CARRIAGE RETURN SIMULATION SUBROUTINE ***** 
* 
* 
CRGET NOP                ENTRY POINT
      LDA XRETN          GET X RETURN DISTANCE
      CMA,INA            NEGATE 
      STA XWORD          SET X RETURN COMPONENT 
      LDA YRETN          GET Y RETURN DISTANCE
      CMA,INA            NEGATE 
      STA YWORD          SET Y RETURN COMPONENT 
      JSB PTOUT          SEND MOVE
      JSB RTSET          CLEAR CARRIAGE RETRUN
      JMP CRGET,I        RETURN TO CALL 
* 
* 
***** LINE FEED SIMULATION SUBROUTINE ***** 
* 
*     NOTE: 
*     FOR PROPER OPERATION CARRIAGE RETRUN SHOULD NOT BE
*     UPDATED AFTER EXECUTING THIS SUBROUTINE 
* 
* 
LFGET NOP                ENTRY POINT
      LDA LFCAD          A=L.F. CH. TABLE ADDRESS 
      JSB CHGET          GENERATE THE L.F. CHARACTER
      JMP LFGET,I        RETURN TO CALL 
* 
* 
***** CARRIAGE RETURN UPDATING SUBROUTINE ***** 
* 
*     ON ENTRY
*     (XWORD)=X COMPONENT JUST TRANSMITTED
*     (YWORD)=Y COMPONENT JUST TRANSMITTED
* 
*     AFTER EXECUTION 
*     COMPONENTS JUST TRANSMITTED HAVE BEEN ACCUMULATED IN
*     LOCATIONS XRETN AND YRETN 
* 
* 
RTSET NOP                ENTRY POINT
      LDA XWORD          A=CURRENT X COMPONENT
      ERA,CLE,ELA        SET 0.XB = 0.0B
      ADA XRETN          A=NEW X RETURN DISTANCE
      STA XRETN          SAVE NEW X RETURN DISTANCE 
      LDA YWORD          A=CURRENT Y COMPONENT
      ERA,CLE,ELA        SET 0.YB = 0.0B
      ADA YRETN          A=NEW Y RETURN DISTANCE
      STA YRETN          SAVE NEW Y RETURN DISTANCE 
      JMP RTSET,I        RETURN TO CALL 
* 
* 
***** CHARACTER MOVE SCALING SUBROUTINE ***** 
* 
* 
* 
*     THIS SUBROUTINE PERFORMS THE MULTIPLICATION REQUIRED TO SCALE 
* THE CHARACTER MOVE COMPONENTS BEFORE THEY ARE TRANSMITTED.
* THE X AND Y COMPONENTS OF A GIVEN MOVE ARE PROCESSED AS AN ORDERED
* PAIR WITH THE X COMPONENT BEING PROCESSED ON THE 1ST ENTRY. 
* BEFORE ENTERING THIS SUBROUTINE THE FOLLOWING CONDITIONS MUST 
* BE SATISFIED. 
* 
*     A=NEGATED BIT COUNT FOR COMPONENT TO BE SCALED
*     (CHMPT)=ADDRESS OF 1ST WORD OF CHAR. IN CHAR. MOVE TABLE
*     (BMASK)=BIT ON IN POSITION CORRESPONDING TO REQUIRED MOVE 
*     (COEPT)=ADDRESS OF WORD PRECEDING 1ST WORD OF DESIRED COEF. 
* 
*     THE SCALED COMPONENT PRODUCED IS RETURNED IN THE B REGISTER 
* 
* 
SCALE NOP                ENTRY POINT
      STA BCNTR          INITIALIZE BIT COUNTER 
      CLB                SET B=0
      STB ARGET          CLEAR PRODUCT ACCUMULATOR
      ISZ COEPT          INCREMENT CEOFICIENT PNTR
      LDB COEPT,I        B=UNSIGNED COEF. FACTOR
      ISZ COEPT          ADDRESS COEF. EXP AND SIGN 
NEXTB LDA CHMPT,I        GET MOVE WORD
      AND BMASK          ISOLATE MOVE BIT 
      ISZ CHMPT          INCREMENT WORD POINTER 
      ISZ BCNTR          INCREMENT BIT COUNTER
      JMP ADDER          ADD IF BIT COUNT#0 
      SZB,RSS            ELSE TEST FOR COEF.#0
      JMP SCALE,I        ELSE RETURN - PRODUCT = 0
      CCB                SET B=-1 IF COMPONENT IS + 
      SZA                TEST FOR COMPONENT POSITIVE
      CLB                ELSE SET B=0 FOR COMP -
      LDA COEPT,I        GET COEF. EXP. AND SIGN
      SLA,ARS            TEST FOR COEF>=0,SHFT EXP
      CMB                ELSE CHANGE SIGN OF PRODUCT
      STB SCSET          SAVE SIGN OF PRODUCT 
      LDB ARGET          GET RAW PRODUCT
      INA,SZA,RSS        INC SHFT CNT,TEST-NOT DONE 
      INB                ELSE ROUND UP ON #.#1
      CLE,ERB            RIGHT SHFT 16 BIT MAGNITUDE
      SZA                TEST FOR SHIFTS COMPLETE 
      JMP *-4            ELSE SHIFT AGAIN 
      ISZ SCSET          TEST FOR PRODUCT + 
      CMB,INB            ELSE NEGATE PRODUCT
      JMP SCALE,I        RETURN TO CALL 
ADDER CLE,ERB            RIGHT SHFT 16 BIT MAGNITUDE
      SZA                TEST FOR PARTIAL PROD. =0
      LDA 1B             ELSE A=SHIFTED MAGNITUDE 
      ADA ARGET          ACCUMULATE PARTIAL PRODUCT 
      STA ARGET          SAVE NEW PARTIAL SUM 
      JMP NEXTB          PROCESS NEXT BIT OF COMP.
* 
* 
* 
***** CHARACTER PROCESSING CONSTANTS AND VARIABLES *****
* 
* 
* 
CRCHC OCT 000015         CARRIAGE RETURN CHAR. CODE 
LFCHC OCT 000012         LINE FEED CHARACTER CODE 
CMSK1 OCT 000177         EXTRACTS 7 BIT CHAR. CODE
CMSK2 OCT 000077         EXTRACTS 6 BIT CHAR. CODE
CMSK3 OCT 000140         FOR TESTING BITS 6 AND 7 
BITNO DEC -15            PROCESS EXPONENT BIAS
CHTAD DEF CHTAB          ORIGINE OF CHARACTER TABLES
MVTAD DEF MVTAB          ORIGINE OF MOVE TABLE
COEAD DEF COEF1-1        COEF TABLE STARTING ADDRESS
LFCAD DEF MVTAB-1        ADDRESS OF LINE FEED ENTRY 
MANDT OCT 000000         CHARACTER COUNTER
BUFAD OCT 000000         CHARACTER BUFFER ADDRESS 
BUFLN OCT 000000         CHARACTER BUFFER LENGTH
CHMCT OCT 000000         CHARACTER MOVE CNTR
CHMAD OCT 000000         CURRENT MOVE LOCATION
CHMPT OCT 000000         ABSOLUTE MOVE WORD POINTER 
COEPT OCT 000000         COEF. TABLE POINTER
BMASK OCT 000000         CURRENT BIT ADDRESS OF MOVE
BCNTR OCT 000000         UTILITY BIT COUNTER
XRETN OCT 000000         X RETURN DISTANCE
YRETN OCT 000000         Y RETURN DISTANCE
COEF1 OCT 000000         UNSIGNED FACTOR FOR AXX
      OCT 000000         EXPONENT AND SIGN FOR AXX
COEF2 OCT 000000         UNSIGNED FACTOR FOR AYX
      OCT 000000         EXPONENT AND SIGN FOR AYX
COEF3 OCT 000000         UNSIGNED FACTOR FOR AXY
      OCT 000000         EXPONENT AND SIGN FOR AXY
COEF4 OCT 000000         UNSIGNED FACTOR FOR AYY
      OCT 000000         EXPONENT AND SIGN FOR AYY
TTYAD OCT 000000         OLD PRINT DEVICE ENTRY ADD 
LTLAD DEF LTLNE          CH.BUF.PROCESSING ENTRY ADD
* 
* 
* 
* 
*     THE CHARACTER TABLES WHICH FOLLOW ARE GIVEN ON SOURCE TAPE 2
* (PART NO. 72003-80002). 
* 
*     THIS CHARACTER TABLE TAPE WAS PUNCHED BY USING A CHARACTER
* TABLE GENERATING PROGRAM. BECAUSE OF THE BIT PACKING USED IN THE
* CHARACTER TABLE SUCH A PROGRAM SHOULD ALWAYS BE USED TO SET UP
* ALTERNATE CHARACTER SETS. 
* 
*     FOR INFORMATION ON ALTERNATE CHARACTER SETS CONTACT YOUR
* NEAREST HEWLETT-PACKARD SALES AND SERVICE OFFICE. 
* 
* 
* 
* 
* 
* 
* 
* 
                                                                                                                                                                                                                              72003-80001 A     01 OF 01
                                                      