
* 
      SKP
* 
*     *** INITIALIZATION ***
* 
INITZ LDA WCALL     DID CONVERSATIONAL WRITE
      SZA,RSS       CALL THIS SECTION?
      JMP GETSA     NO.
* 
      JSB GETWR     YES, GO GET BUFFER S.A. & LENGTH.
      JMP SETLG
* 
GETSA LDB USER2
      ADB =B2       POINT B-REG TO BUFFER S.A.
      LDA B,I       GET STARTING ADDR IN A-REG.
      STA BUFSA     STORE.
      STA S.A.      STORE IN BCC PARAMETER.
* 
      INB
      LDA B,I       GET WORD COUNT.
      SSA           NEG COUNT (I.E. CHARACTERS)?
      JMP *+4       YES.
      ALS           CONVERT TO CHARACTER COUNT.
      CMA,INA       CONVERT TO NEG VALUE.
      STA WCFLG     TURN ON 'WORD' INDICATOR FLAG.
      STA COUNT     STORE.
      STA BFLN      STORE FOR PARITY RETRY
* 
SETLG CLB
      STB FLOP      SET WORD PACKING FLAG.
      STB TLOG      SET TRANSMISSION LOG TO ZERO.
* 
RESND JSB UPCAR     BRING UP CARRIER.
* 
      SPC 4
      LDA RVIFG     REVERSE INTERRUPT FLAG ON?
      SZA,RSS
      JMP NORVI     NO.
      LDA PAD       YES, CALL CONTROL ROUTINE
      STA RSEND     TO SEND A 'PAD' 'RVI'
      STA CCBUF     CHARACTER SEQUENCE WITH
      LDA DLE
      STA RSEND+1   CHARACTER SEQUENCE.
      STA CCBUF+1
      LDA RVI
      STA RSEND+2
      STA CCBUF+2
      LDA PADD      ADD PAD CHAR TO STRING.
      STA RSEND+3
      STA CCBUF+3
      LDA PNT1
      LDB =D4
      STB RESLN
      JMP CALLC
* 
NORVI LDA NAKFG     'NAK' FLAG ON?
      SZA,RSS
      JMP NONAK     NO.
      LDA PAD       YES, CALL CONTROL ROUTINE
      STA RSEND     TO SEND 'PAD' 'NAK' AS BOTH
      STA CCBUF     THE SEND & RESEND CHARACTER
      LDA PADD
      STA CCBUF+2
      STA RSEND+2
      LDA NAK       SEQUENCES.
      STA RSEND+1
      STA CCBUF+1
      LDA PNT1
      LDB =B3
      STB RESLN
      JMP CALLC
* 
NONAK LDA PAD       CALL CONTROL TO SEND
      STA RSEND     A 'PAD' 'ACK0' OR 'PAD' 'ACK1'
      STA CCBUF     ACCORDING TO 'BCONT'.
      LDA DLE
      STA RSEND+1   RESEND SEQUENCE).
      STA CCBUF+1
      LDA ACK0
      LDB BCONT
      SZB
      LDA ACK1
      STA RSEND+2
      STA CCBUF+2
      LDA PNT1
      LDB =D3
      STB RESLN
* 
CALLC STB SCASE     SET SPECIAL CASE FOR CONTROL.
      ISZ NORET     READ PROCESSOR TO CONTROL
      JSB CNTRL     TRANSFER TO CONTROL SUBROUTINE.
* 
* 
*     *** EXAMINE 1'ST CHAR. RETURNED FROM CNTRL.  IF NOT
*         AN ENQ,STX,OR SOH, THEN SET THE 'NAK' FLAG ON. ***
* 
      STB XPAR      SET TRANSPARENT TEXT FLAG.
* 
      CPA ENQ       CHAR = 'ENQ'?
      JMP RESND     YES, RESEND ACKNOWLEDGEMENT CHAR.
* 
      CLB
      STB SCASE     RESET SPECIAL CASE.
      STB NORET     CLEAR READ PROCESSOR
      CPA EOT       CHAR = 'EOT'?
      RSS
      JMP OVER      NO.
      JSB BUFFR     YES, BUFFER CHAR,
      CLA,INA       SET 'EOF'
      STA EOF       = TO 1, AND
      STA TLOG      TRANSMISSION LOG = TO 1.
      JSB .IO.
      OCT 100011    CLEAR CONTROL ON BOARD
      JMP COMPT     GO TO COMPLETOR SECTION.
* 
OVER  STA WORK      SAVE CHARACTER.
      CLA
      STA RVIFG
      STA NAKFG     TURN OFF FLAGS.
      LDA CONTP     CAUSE INTERRUPTS TO
      JSB PADRS     GO TO CONTINUATOR SECTION.
      LDA WORK      RELOAD CHARACTER.
* 
STXCK CPA STX       CHAR = 'STX'?
      JMP TTEST     YES,
      CPA SOH       CHAR = 'SOH'?
      JMP TTEST     YES
* 
      CLB,INB       CONTROL CHAR IS INCORRECT.
      STB NAKFG     TURN ON 'NAK' FLAG.
      JMP T.O.      GO WAIT FOR "ENQ."
* 
TTEST STA WORK      SAVE CHARACTER.
      LDA PADD      BUFFER EITHER A
      LDB XPAR      'PAD' OR 'DLE' BEFORE
      SZB           THE 'STX' ACCORDING TO
      LDA DLE       TRANSPARANCY.
      JSB BUFFR     EXTRA CHAR IS NEC TO MAINTAIN
      LDA WORK      CHARACTER TO WORD RELATIONSHIP.
      JMP RTURN     CONTINUE.
* 
      SPC 4
T.O.  LDA =D-8
      STA ERROR
* 
T.O.1 JSB .IO.      NO/STX. PUT BOARD
      OCT 6         IN "HUNT FOR SYNC."
* 
      CLB,INB
      JSB SYNRZ     WAIT FOR SYNC.
      SZA           OBTAINED?
      JMP NAK1      NO
* 
      LDA =D300     ACTIVATE TIMER TO INTERRUPT
      LDB ANAK1     TO NAK1 IN 3 SECONDS
      JSB TACTV
* 
      LDA ANAK2     FORCE INTERRUPTS
      JSB PADRS     TO NAK2
* 
      OCT 100002    INTERRUPTS.
      JMP EXIT      EXIT.
* 
*     THIS SEGMENT IS ENTERED IF NO SYNQ OR ENQ
*     IS OBTAINED WITHIN THREE SECONDS.
* 
NAK1  JSB UPCAR
      JSB IERR
      ISZ ERROR     EIGTH TIME?
      JMP T.O.1     NO, TRY AGAIN.
* 
      LDB =B3       RETURN TO USER
      STB LERR      WITH "USER TIMEOUT" CODE.
      JSB ENDAL     SEND "DLE EOT" AND DROP LINE.
* 
*     I/O INTERRUPTS ARE CHANNELED HERE.
* 
NAK2  JSB .IO.      GET CHARACTER.
      OCT 100010
      CPA ENQ       = "ENQ"?
      JMP NENQ      YES.
* 
      IOR =B40000   CLUDGE.
      CPA SYNC      SYNC CHARACTER?
      RSS           YES.
      JMP T.O.1     NO/TRY AGAIN
* 
      JSB .IO.      ENABLE
      OCT 100002    INTERRUPTS.
      JMP EXIT      EXIT.
* 
NENQ  CLA           "ENQ" RECEIVED, DEACTIVATE
      JSB TACTV     TIMER.
      JMP NOCHA     GO SEND "NAK".
* 
ANAK1 DEF NAK1
ANAK2 DEF NAK2
      SKP
***********************
* CONTINUATOR SECTION **********************************************
***********************
* 
CONTN JSB .IO.      GET CHARACTER OFF
      OCT 100010     FROM I/O BOARD
* 
      STA WORK      SAVE CHARACTER
* 
.RSS  RSS
      JMP IGNOR     SYNC, IGNORE VERTICAL PARITY.
* 
      LDA CODE      ASCII CODE?
      CPA =B1
      JSB BIT9      YES, CHECK VERTICAL PARITY.
* 
* 
IGNOR LDA =D50      ACTIVATE A 500 M.S.
      LDB PNT2      CHARACTER TIMEOUT DELAY.
      JSB TACTV
* 
      LDA WORK      RELOAD CHARACTER
* 
*     *** TEST FOR CONTROL CHARACTER ***
* 
      LDB BCCFG     IS A 'BCC' CHAR
      SZB           EXPECTED?
      JMP BCCAR     YES, GO PROCESS.
* 
      LDB ITBFG     ARE WE PROCESSING ITB BCC'S?
      SZB,RSS
      JMP *+4       NO, CONTINUE.
      ISZ ITBFG     YES, INCREMENT COUNTER.
      JMP RTURN     RETURN.
      JMP RTURN     RETURN.
* 
      LDB XPAR      TRANSPARENT
      SZB           TEXT?
      JMP DLE?      YES, ALLOW SYNCS AS DATA.
      LDB WORK
      LDA SYNC      NO, IF THIS CHAR IS
      AND MASK      A SYNC, THEN
      CPB A         IGNORE IT.
      JMP RTURN+1   YES, IGNORE.
      RSS           SKIP NEXT INSTRUCTION.
DLE?  JSB DLECK     CHECK IF CHAR IS A 'DLE'?
      LDA WORK      RELOAD CHARACTER.
* 
ETXCK CPA ENQ       CHAR = 'ENQ'?
      JMP ENQCH     YES, GO PROCESS.
* 
      CPA ITB       DOES THIS CHARACTER = AN 'ITB'.
      RSS           YES.
      JMP *+6
      LDB CODE
      SZB,RSS
      LDB =B2
      CMB,INB
      STB ITBFG     SET ITB FLAG AND COUNTER.
      CLB
      CPA ETB       CHAR = 'ETB'?
      JMP *+4       YES.
      CPA ETX       NO, = 'ETX'?
      JMP *+2       YES.
      JMP RTURN     NO, GO BUFFER CHAR.
      LDA DLE
      LDB XPAR
      SZB
      JSB BUFFR
      LDA WORK
      CCB
      STB ETXFG
      STA BCCFG     TURN ON 'BCC' INDICATOR.
      SPC 4
* 
*     *** BUFFER CHARACTER & RETURN ***.
* 
RTURN JSB BUFFR     BUFFER CHARACTER.
      JSB .IO.      SET CONTROL & CLEAR FLAG.
      OCT 100002    INTERRUPTS
      JMP EXIT      RETURN TO INTERRUPT LOCATION.
      SKP
* 
*     *** A CONTROL CHARACTER HAS BEEN RECEIVED.
*         PROCESS ACCORDINGLY. ***
* 
BCCAR JSB GETPR     CALL ROUTINE TO HANDLE PARITY.
      CLA
      STA CNTR8     CLEAR PARITY CONTROL
      STA BCCFG     FLAGS.
      JMP COMPR     GO COMPLETE OPERATION.
* 
      SPC 4
DLECK NOP
      LDB DLEFG     CHECK IF THE
      SZB,RSS       PREVIOUS CHAR WAS A 'DLE'.
      JMP *+4       NO
      CLB           YES, TURN FLAG OFF.
      STB DLEFG     AND RETURN.
      JMP DLECK,I
* 
      CPA DLE       DOES THIS CHAR
      RSS           EQUAL A 'DLE'?
      JMP RTURN     NO, GO BUFFER CHAR.
      STA DLEFG     YES, TURN FLAG ON
      JMP RTURN+1   EXIT.
      SPC 4
BKEND STA BCCFG     TURN ON 'BCC' FLAG.
      JMP RTURN     BUFFER CHAR AND EXIT.
      SPC 4
ENQCH STA NAKFG     TURN ON 'NAK' FLAG.
      JMP AGAIN
      SKP
*********************
* COMPLETOR SECTION ***************************************************
*********************
* 
COMPR LDA OVERF    BUFFER OVERFLOW ?
      SZA
      JMP ACKIT     YES, RETURN TO USER PROGRAM.
* 
      LDA NAKFG     NO, GET 'NAK' FLAG.
      SZA,RSS       ON?
      JMP NAKNO     NO.
NOCHA ISZ RETRI   YES, TRY RECEIVING BUFFER AGAUN
      JMP AGAIN
      CLA,INA       SET A-REG TO 1.
      STA INERR     SET 'INERR' VARIABLE.
      STA LERR      SET 'LINE ERROR' VARIABLE.
      JMP GIVUP     SEND "DLE EOT" TO TRML, DROP LINE
* 
NAKNO LDB TLOG      GET TLOG (IN CHARACTERS)
      LDA WCFLG     GET WORD-CHAR FLAG.
      SZA,RSS
      JMP *+4
      SLB
      INB
      BRS           YES, CONVERT.
      STB TLOG
* 
      LDA ETXFG     ETX FLAG ON?
      SZA,RSS
      JMP ACKIT     NO, THUS CONV. NOT POSSIBLE.
* 
EOFIN LDA CONVR     CONVERSATIONAL FLAG ON?
      SZA,RSS
      JMP ACKIT     NO.
* 
      CLA,INA
      STA RCSND     SET MODE TO 'SEND'.
      JSB DACTV     ACTIVATE 'TTD'.
      JMP COMPT     GO TO COMPLETOR SECTION.
      SPC 4
ACKIT LDA BCONT     COMPLEMENT ACK0,1
      CMA           FLAG.
      STA BCONT
* 
      JSB WACTV     ACTIVATE 'WACT'
* 
      JMP COMPT     COMPLETE IOC CALL.
      SPC 4
GIVUP JSB UPCAR     YES, BRING UP CARRIER.
      JSB ENDAL     GIVE UP PARITY RECOVERY TRY.
* 
TIMEO  CCA     500 MS WITHOUT ACHAR
      STA NAKFG   SET ^NAK FLAG AND
      JMP NOCHA  RE-RECEIVE MESSAGE
* 
AGAIN LDA S.A.      RESET BUFFER
      STA BUFSA     ADDRESS AND
      LDA BFLN      LENGTH TO ORIGINAL
      STA COUNT     VALUES
      JMP SETLG     GO NAK + RE-RECEIVE RECORD
      SKP
*     *** SUBROUTINE TO PACK AND BUFFER INPUT CHARACTERS. ***
* 
BUFFR NOP
      LDB OVERF     CHECK BLOCK OVERFLOW.
      SZB,RSS       HAS OVERFLOW OCCURRED?
      JMP PAKIT     NO, CONTINUE PROCESSING.
      ISZ TLOG      YES, INCREMENT TRANS-LOG.
      STB OVRFL     SET OVERFLOW FLAG ON.
      JMP BUFFR,I   RETURN.
* 
PAKIT LDB FLOP      CHECK PACKING FLAG.
      SZB           CHAR GO IN RIGHT HALF OF WORD?
      JMP RIGHT     YES.
* 
      ALF,ALF       NO, POSITION TO LEFT HALF.
      STA BUFSA,I   STORE IN BUFFER.
* 
ISZ   CMB           COMPLEMENT PACKING FLAG
      STB FLOP      AND STORE.
      ISZ TLOG      INCREMENT TRANSMISSION LOG.
      ISZ COUNT     ALL CHARS IN YET?
      JMP BUFFR,I   NO, RETURN.
* 
      CCA           YES, TURN ON
      STA OVERF     OVERFLOW FLAG.
      STA NAKFG
      JMP BUFFR,I   RETURN.
* 
RIGHT IOR BUFSA,I   COMBINE WITH LEFT CHAR.
      STA BUFSA,I   AND RESTORE.
      ISZ BUFSA     INCREMENT BUFFER POINTER.
      JMP ISZ
      SPC 4
* 
*     *** SUBROUTINE TO HANDLE PARITY CALCULATION. ***
* 
GETPR NOP
      LDB PNT3
      ADB CNTR8
      STA B,I
      JSB BUFFR     BUFFER CHARACTER.
      ISZ CNTR8     INCREMENT 'BCC' COUNTER.
      LDB BCCLN     GET 'BCC'LENGTH.
      CPB CNTR8     ALL 'BCC' CHARS IN YET?
      JMP *+2       YES.
      JMP RTURN+1   NO, EXIT AND WAIT FOR NEXT CHAR.
* 
      LDA NOERR     GET 'NOERR' FLAG.
      SZA           PARITY CHECK REQUESTED BY USER?
      JMP GETPR,I   NO, RETURN.
* 
*     *** CALL SUBROUTINE TO CALCUALTE PARITY ON BLOCK. ***
* 
      CLA    DEACTIVATE 500 MS
      JSB TACTV     CHARACTER TIME OUT
      JSB .IO.      CLEAR CONTROL AND FLAG ON BOARD
      OCT 100011    CLEAR CONTROL ON BOARD
      STF 0         ENABLE INTERRUPT SYSTEM.
      LDA S.A.      GET MESSAGE STARTING ADDR.
      LDB TLOG      GET MESSAGE LENGTH
      CMB,INB       (LESS BCC CHARACTERS).
      ADB BCCLN
      JSB PCALI     GO CALCULATE PARITY.
      CPA BCBUF     1'ST CHARACTER COMPARE?
      JMP *+2       YES, CHECK SECOND.
      JMP NOTEQ     NO.
* 
      LDA CNTR8
      SLA           IS THERE A SECOND BCC CHAR?
      JMP GETPR,I   NO, RETURN WITH GOOD PARITY.
      CPB BCBUF+1   YES, IS IT OK?
      JMP GETPR,I   YES, RETURN WITH GOOD PARITY.
* 
NOTEQ CCA           PARITY ERRORS.
      STA NAKFG     TURN ON 'NAK' FLAG.
      JSB IERR      INCREMENT ERROR COUNT.
      JMP GETPR,I   RETURN.
      SPC 4
* 
*     *** SUBROUTINE TO CLEAR ALL CONTROL FLAGS. ***
* 
FLAGC NOP
      LDA =D-8      SET ERROR RETRY
      STA RETRI     VARIABLE TO -8.
* 
      JSB EBUSY     SET EQT ENTRY TO BUSY.
* 
      CLB
      STB NAKFG     SET OPTION AND
      STB RVIFG     CONTROL FLAGS
      STB CONVR     INITIALLY TO OFF.
      STB NOERR
      STB XPAR
      STB DLEFG
      STB OVERF
      STB BCCFG
      STB ETXFG
      STB WCALL
      STB WCFLG
      STB ITBFG
      JMP FLAGC,I
* 
      SPC 4
* 
*     *** SUBROUTINE TO GET BUFFER STARTING ADDRESS AND
*         LENGTH FROM CONVERSATIONAL WRITE'S DATA AREA. ***
* 
GETWR NOP
      LDA CONAD     GET USER'S BUFFER STARTING
      STA BUFSA     ADDRESS AND STORE.
      STA S.A.
      LDA CONLN     GET BUFFER LENGTH,
      SSA           CONVERT TO NEGATIVE CHARACTER
      JMP *+4       COUNT AND STORE.
      ALS
      CMA,INA
      STA WCFLG
      STA COUNT
      STA BFLN    ALSO FOR PARITY RETRY
      JMP GETWR,I   RETURN.
      SPC 4
* 
*     *** "CREAD" IS THE ENTRY POINT FOR THE CONVERSATIONAL
*         WRITE ROUTINE TO CALL THE READ PROCESSOR. ***
* 
CREAD NOP           ('NOP' USED ONLY FOR A TRACE. ).
      STA WORK      SAVE CHARACTER RECEIVED.
      STB TEMPR     SAVE TRANSPARENT TEXT INDICATOR.
      JSB FLAGC     GO CLEAR ALL CONTROL FLAGS.
      LDA TEMPR
      STA XPAR      SET TRANSPARENT TEXT FLAG.
* 
      CCA
      STA CONVR     SET CONVERSATIONAL FLAG ON.
      STA WCALL     SET LOGIC FOR WRITE-READ CALL.
* 
      JSB GETWR     GO GET BUFFER S.A. & LENGTH.
      LDA CONTP     CAUSE INTERRUPTS TO GO
      JSB PADRS     TO CONTINUATOR SECTION.
* 
      LDA WORK      RELOAD CHARACTER AND
      JMP STXCK     GO EDIT FOR 'STX' OR 'SOH'.
* 
*     *** SUBROUTINE TO CHECK VERTICAL PARITY.
*         I.E. BIT 9 OF STATUS WORD.  (ASCII CODE ONLY)
* 
BIT9  NOP
      JSB .IO.      GET I/O BOARD'S
      OCT 3         STATUS.
      AND =B1000    MASK PARITY BIT.
      SZA           SET?
      STA NAKFG     YES, SET 'NAK' FLAG ON.
      JMP BIT9,I    RETURN.
      SKP
* 
*     *** DATA SECTION.***
* 
BCBUF BSS 2
BCCFG BSS 1
BUFSA BSS 1
CCBUF BSS 4
CONVR BSS 1
DLEFG BSS 1
ETXFG BSS 1
FLOP  BSS 1
ITBFG BSS 1
NAKFG BSS 1
NOERR BSS 1
RETRI BSS 1
RSS   RSS
RVIFG BSS 1
S.A.  BSS 1
BFLN  BSS 1
TEMPR BSS 1
WCFLG BSS 1
WORK  BSS 1
WCALL BSS 1
XPAR  BSS 1
* 
CONTP DEF CONTN
PNT1  DEF CCBUF
PNT2  DEF TIMEO
PNT3  DEF BCBUF
* 
CNTR8 OCT 0
COUNT OCT 0
OVERF OCT 0
* 
      HED    MANUAL ANSWER PROCESSOR
* 
* 
*     *** MANUAL ANSWER PROCESSOR  ***
* 
* 
* EXECUTION STEPS*
*    1. WAIT FOR OPERATOR TO CONNECT MODEM
*    2. WAIT FOR "ENQ" TO BE SENT
*    3. ACTIVATE "WABT" MODULE
* 
* 
*********************
* INITIATOR SEGMENT ************************************************
*********************
* 
* 
* IF TERMINAL IS ALREADY "ON LINE" THEN REJECT THE REQUEST.
* 
ANSWR LDB =B2       PRIME B-REG WITH REJECT CODE.
      CLA           REQUEST IS GOOD,
      STA ASAVE     SET UP LINKAGE
      LDA D.50      IN "EXIT" SUBROUTINE
      STA I.50      TO SHOW SAME.
* 
      JSB EBUSY     SET EQT ENTRY TO BUSY.
* 
* SEPERATE TRANSMISSION CODE.
* 
      LDB FUNCT     GET FUNCTION/SUBFUNCTION CODE
      STB A1        AND SAVE.
      LDA =B2       PRIME A-REG FOR TRANSCODE.
      LDB A1        IS REQUEST
      CPB =B306     FOR EBCDIC?
      CLA           YES, SET UP FOR EBCDIC.
* 
      CPB =B307     REQUEST FOR ASCII?
      CLA,INA       YES, SET UP FOR ASCII.
* 
      JSB CCAR      SET UP CNTRL CHAR'S, MASK, I/O
* 
* SET UP I/O BOARD.
* 
      JSB .IO.       OUTPUT SYNC CODE
      OCT 12   CODE TO BOTH
       JSB .IO.
      OCT 100012   BOARDS
      CLB
C1    JSB .IO.      PRIME I/O BOARD
      OCT 6         TO BE A RECEIVER.
      CLA             ZERO
      STA TLOG        TRANSMISSION LOG
      JSB ISTAT       INITIALIZE STATUS
      LDB ADAN6     WAIT
      LDA =D25      250 MILISECONDS
      JSB TACTV     FOR I/O BOARD TO CALM DOWN.
      JMP EXIT      RETURN TO CALL.
* 
      SPC 3
************************
* ANSWER PHONE SEGMENT *********************************************
************************
* 
* 
*    WAIT FOR MODEM TO LINE CONNECTION
* 
ANSR6 JSB .IO.        GET STATUS
      OCT 100003   FROM I/O BOARD
* 
      ALF,SLA         DATA SET READY ?
      JMP C2        YES, CONTINUE PROCESSING.
      JMP EXIT      EXIT.
* 
*     SET TIMER FOR 250 MS INTERRUPT TO THE NEXT SEGMENT
* 
C2    LDA =D25
      LDB ADAN2     TIMER
      JSB TACTV     INTERRUPT.
* 
* DISABLE INTERRUPT.
* 
      JSB .IO.      CLEAR CONTROL & FLAG
      OCT 100011    CLEAR CONTROL ON BOARD
* 
      JMP EXIT      RETURN.
      SPC 3
**************************************************************
* THIS SEGMENT SETS UP TO RECEIVE THE "ENQ" FROM THE REMOTE. ********
**************************************************************
* 
ANSR2 LDA =D-300    SET COUNTER
      STA CONT2     FOR 10 MIN.
* 
RESYN  CCB          WAIT TILL SYNCHRO IS ACQUIRED
      JSB SYNRZ     IF IN SYNC MODE
      SZA           SYNC ACQUIRED?
      JMP ANSR4     NO.
* 
      LDA =D200     SET UP 2 SECOND
      LDB ADAN4     INTERRUPT
      JSB TACTV     TO TIMER SEGMENT.
* 
      LDA ADAN3    PRIME INTERRUPTS TO GO TO
      JSB PADRS     THE "ENQ" PROCESSOR.
C3    JSB .IO.    DISABLE
      OCT 100003      OF STRAY INTERRUPT
* 
      JSB .IO.      ENABLE
      OCT 100002    INTERRUPTS
* 
      JMP EXIT      EXIT.
      SPC 3
******************
* TIMER SEGMENT. ****************************************************
******************
* 
* THIS SEGMENT WAITS UP TO 30 CONSECUTIVE SECONDS FOR NO CHARACTERS
* 
ANSR4 ISZ CONT2     30 SECS UP?
      RSS           NO.
      JMP *+4       YES.
      JSB .IO.      PUT BOARD BACK
      OCT 6              IN HUNT FOR SYNC.
      JMP RESYN     GO WAIT FOR "SYNC,SYNC".
* 
      JSB .IO.      YES, TURN OFF BOARD.
      OCT 100000
* 
      LDA =D100     SET UP 1 SEC
      LDB ADAN5     DISCONNECT TIMEOUT.
      JSB TACTV
      JMP EXIT
* 
ANSR5 CLA           DISABLE TIMEOUT.
      JSB TACTV
      JMP C1        SET UP FOR NEXT CALL.
      SPC 3
****************************
* "ENQ" PROCESSING SEGMENT *****************************************
                                                                                                                                                                  24380-18032 1409                                                                                          