
* 
      LDB LINE      IF TERMINAL
      SZB           IS "ON LINE"
      IOR =B100     THEN TURN ON BIT 6 OF STATUS.
* 
      LDB RCSND     IF TERMINAL
      SZB           IS IN SEND STATE
      IOR =B20      THEN TURN ON BIT 4 OF STATUS.
* 
      LDB RQ2SD     IF REMOTE
      SZB           HAS "REQUESTED TO SEND"
      IOR =B4       THEN TURN ON BIT 2 OF STATUS.
* 
      LDB INERR     IF OPERATION
      SZB           WAS IN ERROR
      IOR =B40000   THEN TURN ON BIT 14 OF STATUS.
* 
      STA B         SAVE UPDATED STATUS.
      LDA EQT2A,I   GET EQT ENTRY #2,
      AND =B37400   AND
      IOR B         UPDATE
      STA EQT2A,I   ITS STATUS.
* 
* CLEAR DRIVER BUSY.
* 
      CLA           CLEAR
      STA BUSY      DRIVER BUSY.
      LDB INERR     IF STATUS
      SZB,RSS       IS OLD
      STA LERR      THEN RESET IT.
      STA EOF       CLEAR END OF FILE.
      STA RQ2SD     CLEAR REQUEST TO SEND.
      STA INERR     CLEAR "IN ERROR".
      STA TLOG      ZERO TRANSMISSION LOG.
      STA OVRFL     CLEAR BUFFER OVERFLOW BIT.
* 
* EXIT.
* 
      LDA FUNCT     REQUEST
      AND =B100     TO
      SZB           READ?
      JMP EXIT      YES, EXIT THIS SECTION.
* 
      LDA EQT2A     STORE
      ADA =B-1      EQT TABLE ENTRY ADDRESS
      STA CEXIT+2   IN CALL TO .BUFR.
      LDB WHICH     INTERRUPT
      SZB,RSS       FROM TIMER?
      JMP CONT5     NO.
      RBR,SLB       DOUBLE INTERRUPT?
      JMP CONT6     YES, BRING LEVEL DOWN.
      CLA           CLEAR
      STA WHICH     TIMER INTERRUPT.
      LDA T.50      GET TBG RETURN ADDRESS
      JMP CONT7     AND PREPARE TO EXIT.
* 
CONT6 STB WHICH     BRING INTERRUPT LEVEL DOWN.
CONT5 LDA I.50      GET INTERRUPTED ADDRESS.
CONT7 STA CEXIT+1   STORE RETURN ADRS IN .BUFR CALL.
* 
      LDA EOSVE     RESTORE
      ELA,ARS       E
      CLO           AND
      SLA           O
      STO           REGISTERS.
* 
      LDA ASAVE     RESTORE A-REGISTER.
      LDB BSAVE     RESTORE B-REGISTER.
      STF 0         ENABLE INTERRUPT SYSTEM.
CEXIT JSB .BUFR     DE-ALLOCATE BUFFER.
      BSS 1         ADDRESS OF INTERRUPT.
      BSS 1         EQUIPMENT ADDRESS.
      SPC 3
* 
*           *** DATA ***
* 
EOF   BSS 1         IF = 1, THEN LAST BLOCK WAS EOT.
INERR BSS 1         IF = 1, TEHN OPERATION IN ERROR.
OVRFL OCT 0         IF SET THEN BUFFER OVERFLOW.
RCSND OCT 0         IF EQUAL TO 1, THEN IN SEND STE.
RQ2SD OCT 0         IF = 1, THEN REMOTE REQ TO SEND.
TLOG  BSS 1         TRANSMISSION LOG (CHARACTERS).
      HED SEND PROCESSOR.
* 
* 
*           *** SEND PROCESSOR ***
* 
* 
* USER CALLING SEQUENCE:
* 
*     JSB .IOC.
*     OCT (FUNCTION - SUBFUNCTION - LOGICAL UNIT)
*     REJECT ADDRESS
*     STARTING ADDRESS OF BUFFER - IF IN CONVERSATIONAL MODE THEN
*                                  THIS WORD IS S.A. OF PARAMETER
*                                  LIST.
*     LENGTH OF BLOCK TO BE TRANSMITTED.
* 
* 
*     FUNCTION FIELD:  02
* 
*     SUBFUNCTION FIELD:
* 
*         BIT 9     PRIORITY REQUEST (FOR BUFFERED .IOC.)
*         BIT 8     IF SET, EXPECT "CONVERSATIONAL REPLY" FROM THE
*                   TERMINAL.
*         BIT 7     IF SET, DO NOT CALCULATE BLOCK CHECK CHARACTER.
* 
* 
*     PARAMETER LIST (CONVERSATIONAL MODE ONLY)
* 
*         WORD #1   STARTING ADDRESS OF TEST BLOCK.
*         WORD #2   STARTING ADDRESS OF REMOTE'S REPLY
*                   BUFFER (CONVERSATIONAL MODE ONLY).
*         WORD #3   MAXIMUM LENGTH OF REMOTE'S REPLY BUFFER.
* 
*     ALL BSC CONTROL CHARACTERS MUST BE EMBEDDED IN THE TEXT.
* 
*     EXCEPTIONS ARE: LEADING & TRAILING PAD CHAR'S AND BCC CHAR.
* 
*     TEXT MAY BE IN "TRANSPARENT TEXT" FORMAT, THE ADDITIONAL "DLE"
*     CHARACTERS ARE INSERTED BY THE USER PROGRAM.
* 
*     A REPLY OF "DLE EOT" CAUSES THE DRIVER TO DROP THE LINE.
* 
*     AFTER BLOCK IS SENT THE PROCESSOR WILL AUTOMATICALLY ACTIVATE
*     THE "TEMPORARY TEXT DELAY" MODULE.
* 
*     ERROR DETECTION AND CORRECTION PERFORMED BY THE DRIVER:
* 
*            A. IF NO REPLY IS RECEIVED FROM THE TERMINAL WITHIN
*               3 SECONDS AFTER BLOCK HAS BEEN TRANSMITTED, AN "ENQ"
*               CHARACTER WILL BE SENT AND THE LINE THEN MONITORED
*               FOR A REPLY.  IF THE REPLY IS STILL NOT RECEIVED,
*               THE PROCEDURE WILL BE REPEATED UP TO 8 TIMES.  AFTER
*               THE EIGTH TIME THE OPERATION IS SET IN ERROR AND
*              "DLE EOT" IS SENT WHICH DROPS THE LINE.
*            B. IF CARRIER DROPS OR DATA SET BECOMES NOT READY THEN
*               THE I/O BOARD WILL BE TURNED OFF AND THE DRIVER
*               FREED.
*            C. NON-CONVERSATIONAL MODE ONLY:
*               IF THE REPLY IS NOT THE PROPER ACKNOWLEDGEMENT CHAR-
*               ACTER OR NOT A REVERSE INTERRUPT CHARACTER, THE
*               BLOCK WILL BE RESENT.  IF NECESSARY THE PROCEDURE
*               WILL BE REPEATED UP TO 8 MORE TIMES.  AFTER THE
*               THE EIGTH TIME THE OPERATION IS SET IN ERROR AND
*              "DLE EOT" IS SENT WHICH DROPS THE LINE.
      SPC 3
*********************
* INITIATOR SEGMENT ************************************************
*********************
* 
* 
*           *** TEST FOR REJECT CONDITIONS. ***
* 
SEND  LDA EQT2A,I   GET WORD #2 OF DEVICE'S EQT TBLE
      CLB,INB       SET B-REG TO "OFFLINE" REJECT.
      ALF,ALF       IS
      RAL,RAL       TERMINAL
      SLA,RSS       "OFF LINE"?
      JMP REJEC     YES, REJECT THE REQUEST.
* 
      INB           SET B-REG TO "INCORRECT MODE".
      RAL           IN
      SSA,RSS       "RECEIVE" MODE?
      JMP REJEC     YES, REJECT THE REQUEST.
* 
      CLA           REQUEST
      STA ASAVE     WILL BE HONORED.
      SPC 3
* 
*           *** SET UP REQUESTED OPTIONS. ***
* 
      JSB EBUSY     SET EQT TABLE ENTRY TO BUSY.
      LDA USER2
      ADA =B2       POSSIBLE PARAMETER LIST
      LDB A,I       START ADDRESS
      STB F1        AND SAVE.
* 
      INA           GET
      LDB A,I       BUFFER LENGTH
      STB F2        AND SAVE.
* 
      LDB USER2     IS
      ADB =B2       REQUEST
      LDA FUNCT     FOR
      AND =B4       CONVERSATIONAL
      SZA           MODE?
      LDB F1        YES, GET PARAMETER S.A..
      STB F1        STORE ANSWER IN F1.
* 
* CALCULATE BLOCK CHECK CHARACTER.
* 
      LDA FUNCT     CALCULATE
      RAR,SLA       BLOCK CHECK CHARACTER?
      JMP NEBCC     NO, TAKE CALC OUT OF LOGIC.
      STA LNBCC     YES, PUT CALC LOGIC IN .
* 
EBPAR LDA F1,I      GET BUFFER START ADRS.
      LDB F2        GET BUFFER LENGTH.
      JSB PCALI     CALCULATE BUFFER'S PARITY.
* 
      STA BCCBF+1   SAVE FIRST PARITY CHARACTER.
      STB BCCBF+2   SAVE 2ND PARITY CHARACTER.
      STA BCBUF     SAVE FOR RETYR.
      STB BCBUF+1
* 
      JMP OPCC      CONTINUE PROCESSING.
* 
NEBCC CLA           SET BCC LENGTH
      STA LNBCC     AT ZERO CHARACTERS.
* 
* TEST FOR "CONVERSATIONAL MODE".
* 
OPCC  CLA
      JSB TACTV
      JSB .IO.
      OCT 11
      LDA D.50
      STA I.50
      CLB           PRIME B FOR NON-CONVRSATNL MODE.
      LDA FUNCT     USER REQUEST
      AND =B4       CONVERSATIONAL MODE
      SZA           (BIT 8 SET IN REQUEST CODE)?
      INB           YES, PRIME B FOR CONVR MODE.
      STB CONVS     SET "CONVERSATIONAL MODE" LOGIC.
* 
      SZA,RSS       IF NOT IN CONVERSATIONAL MODE
      JMP SINIT
* 
      LDA F1        FORM WORD +1 ADDRESS
      INA           OF PARAMETER LIST.
      LDB A,I       GET S.A. OF USER'S REPLY BUFFER
      STB CONAD     AND SAVE.
* 
      INA           GET LENGTH
      LDB A,I       OF REPLY BUFFER
      STB CONLN     AND SAVE.
* 
*           *** INITIALIZATION ***
* 
* INITIALIZE "RESEND" COUNTER
* 
* 
SINIT LDA =D-8
      STA SCONT
* 
* 
* 
* INITIALIZE BUFFER START ADRS & LENGTH.
* 
SEND4 LDA F1,I
      STA BUFAD     AND PUT IN BUFFER POINTER.
      STA S.A.
      LDA F2        GET BUFFER LENGTH,
      SSA,RSS       IF NECESSARY
      RAL           CONVERT TO CHARACTERS.
      SSA,RSS       IF NECESSARY
      CMA,INA       MAKE NEGATIVE.
      STA BLENG     SAVE IN COUNTER.
      STA BFLN      SAVE ALSO FOR PARITY RETRY
* 
PERTY JSB UPCAR     BRINS UP CARRIER
* 
* PUT SEND SEGMENT'S START ADRS IN INTERRUPT TRANSFER ADRS.
* 
      LDA ADSD1     GET SEG ADRS IN A-REG.
      JSB PADRS     SET INTERRUPT PROCESSOR FOR SEG.
* 
      CLA           SET "SEND SEGMENT" TO GET NEXT
      STA WSIDE     CHAR FROM LEFT-SIDE OF BFR WORD.
      STA TLOG      ZERO NO. OF WORDS SENT.
* 
      JSB LCHCK     CHECK LINE CONDITIONS.
* 
* SEND LEADING PAD CHARACTER TO THE TERMINAL.
* 
      LDB PAD       OUTPUT
      JSB .IO.      PAD CHARACTER
      OCT 7         TO THE I/O BOARD.
* 
      JSB .IO.      ENABLE
      OCT 2         INTERRUPTS.
* 
      JMP EXIT      EXIT.
      SPC 3
* 
* THIS SEGMENT SENDS THE BLOCK TO THE REMOTE.
* 
* 
* TEST FOR LINE CONDITIONS.
* 
SEND1 JSB LCHCK     CALL "LINE CHECK" MODULE.
* 
* CHECK IF LAST TEXT CHARACTER HAS BEEN SENT.
* 
      ISZ TLOG      INCREMENT NO. OF CHAR'S SENT.
      ISZ BLENG     SENT LAST CHARACTER?
      RSS           NO, GO SEND THE NEXT CHARACTER.
      JMP CHKBC     YES, SEND BLOCK CHECK CHARACTER.
* 
* SEND NEXT CHARACTER TO THE REMOTE.
* 
SCHAR LDA WSIDE     GET CHARACTER JUSTIFICATION.
      LDB BUFAD,I   GET WORD IN B-REG.
      SZA,RSS       IF CHARACTER LIES IN MSB,
      BLF,BLF       THEN ROTATE TO LSB OF A-REG.
      CMA,SZA,RSS   INDEX TO NEXT WORD?
      ISZ BUFAD     YES, INCREMENT POINTER.
      STA WSIDE     SET LOGIC FOR NEXT CHARACTER.
* 
      JSB .IO.      SEND THE CHARACTER
      OCT 7         TO THE REMOTE TERMINAL.
* 
      JSB .IO.      ENABLE
      OCT 2         INTERRUPT.
* 
      JMP EXIT      RETURN TO INTERRUPTED LOCATION.
* 
* 
* TEXT HAS BEEN SENT,  SEND OUT ETB (OR ETX) AND BLOCK CHECK CHAR.
* 
CHKBC CLA,INA
      STA SCASE
      LDA =D-2      SET UP COUNTER
      STA BADAK     FOR IMPROPER ACK,NAK.
      LDB WSIDE
      LDA BUFAD,I   GET ETB (ETX)
      SZB,RSS       CHARACTER
      ALF,ALF       AND
      STA BCCBF     STORE IN CNTRL BUFFER.
      LDA LNBCC     SEND
      LDB =B2       BLOCK
      SZA           CHECK CHARACTER?
      ADB BCCLN     YES, SET BUFFER LENGTH IN B-REG.
* 
SDBC  LDA ENQ       IF GARBLED REPLY, THEN SEND BACK
      STA RSEND+1   AN "ENQUIRY" CHARACTER.
      LDA PAD       PUT
      STA RSEND     LEADING PAD CHAR IN RE-SEND BFR.
      LDA =B2       RE-SEND STRING LENGTH
      STA RESLN     IS TWO.
      LDA BCCBA     PRIME A-RG TO S.A. OF CNTRL BFR.
      STB TMP       UPDATE
      ADB TLOG      TRANSMSSION
      STB TLOG      LOG.
      LDB TMP
TBCC  JSB CNTRL     SEND BCC, AND GET REMOTE'S REPLY
* 
* IF IN "CONVERSATIONAL MODE" THEN REQUEST RECEIVE PROCESSOR TO GET
* REMOTE'S REPLY.
* 
      STB WSI       SAVE DLE FLAG.
      CPA NAK       REPLY CHARACTER A "NAK"?
      JMP TMINE     YES, CHECK IF SHOULD RESEND.
* 
* ANALYZE REMOTE'S REPLY.
* 
      CPA ENQ       IS REMOTE CHANGING TO SEND STATE ?
      JMP SN2RE     YES, TURN LINE AROUND
      LDB BCONT     EXPECT
      SZB,RSS       AN "ACK0"?
      JMP CACK0     YES, SEE IF ACK0 WAS SENT.
      CPA ACK1      IS CHARACTER AN "ACK1"?
      JMP AOK       YES, END OPERATION.
      JMP CRVI      NO, SEE IF "RVI" CHAR WAS SENT.
CACK0 CPA ACK0      CHARACTER AN "ACK0"?
      JMP AOK       YES, END OPERATION.
* 
CRVI  CPA ACK0      CHECK FOR IMPROPER
      JMP MISSB     ACK0 OR ACK1
      CPA ACK1
      JMP MISSB
      CPA RVI       IS CHARACTER A "REVERSE INTRPT"?
      JMP SRRIS     YES, SET "REMOTE REQ TO SEND".
* 
* TEST IF IN CONVERSATIONAL MODE.
* 
      LDB CONVS     USER REQUEST
      SZB,RSS       "CONVERSATIONAL REPLY"?
      JMP RANAL     NO, REMOTE SENT BAD REPLY.
      CLA       SET SEND/RECEIVE FLAG
      STA RCSND     TO RECEIVE MODE.
      LDB WSI       RESTORE DLE FLAG.
      JSB CREAD     CALL CONVERSATIONAL READ.
* 
MISSB ISZ BADAK     GET RESPONCE AGAIN?
      JMP RANAL     YES.
      LDA BCBUF     RESET PARITY BITS.
      STA BCCBF+1   (OVERWRITTEN BY AN ENQ!)
      LDA BCBUF+1
      STA BCCBF+2
      JMP TMINE     TREATING ACK AS A NAK.
BADAK BSS 1
* 
* REMOTE SENT IMPROPER CONTROL CHARACTER.
* 
RANAL JSB UPCAR     BRING UP CARRIER.
      JSB IERR      INCREMENT # LINE ERRORS.
      ISZ SCONT     SENT RECORD 8 TIMES?
      JMP GAIN      NO, PREPARE TO SEND "ENQ".
      LDA =B2       SET
      STA LERR      "REMOTE SENT IMPROPER RESPONSE"
      JSB ENDAL     SEND "DLE EOT" AND DROP LINE.
* 
GAIN  LDA PAD       PUT
      STA BCCBF     "PAD ENQ"
      LDA ENQ       SEQUENCE
      STA BCCBF+1   IN CNTRL BUFFER.
      LDA BCCBA     GET S.A. IN A-REG.
      LDB =B2       GET STRING LENGTH IN B-REG.
      JMP TBCC      GO SEND CHARACTER.
* 
* 
* REMOTE NAKED THE MESSAGE.
* 
TMINE LDA S.A.      RESET STARTING ADDRESS
      STA BUFAD     AND BUFFER
      LDA BFLN      LENGTH TO THEIR
      STA BLENG     ORIGINAL VALUES.
      JSB IERR      INCREMENT # LINE ERRORS
      ISZ SCONT     SENT RECORD 8 TIMES ?
      JMP PERTY     NO, TRY AGAIN
* 
      CLA,INA       SET "MESSAGE SENT
      STA LERR      EIGHT TIMES" BIT,
      JSB UPCAR     BRING UP CARRIER.
      JSB ENDAL     SEND "DLE EOT" AND DROP LINE.
* 
* REMOTE'S REPLY WAS CORRECT, UPDATE STATUS AND ACTIVATE "TTD"
* MODULE.
* 
SRRIS CLA,INA,RSS   PRIME A TO "REMOTE REQ TO SEND".
AOK   CLA           SET A TO NOT "RMTE REQ TO SEND".
      STA RQ2SD     STORE ANSWER IN "REQ TO SEND".
* 
      LDB BCONT     SET "BCONT"
      CMB           FOR
      STB BCONT     ALTERNATIONG ACKNOWLEDGEMENT.
* 
      LDB TLOG      GET TRANSMISSION LOG.
      LDA F2        REQUEST
      SSA,RSS       IN WORDS?
      BRS           YES, CONVERT XLOG TO WORDS.
      STB TLOG      STORE ANSWER IN TLOG.
* 
      JSB DACTV     ACTIVATE "TEMP TEXT DELAY " MOD
* 
      JMP COMPT     END OPERATION.
      SPC 3
*     REMOTE IS EXECUTING A "RECEIVE TO SEND" FUNCTION
*     CHANGE LOGIC ON THIS END FOR RECEIVE MODE
* 
SN2RE JSB UPCAR     BRING UP CARRIER.
* 
      LDA RESH      ASK FOR RESPONCE
      LDB =B2       AGAIN TO INSURE REMOTE IS
      JSB CNTRL     INDEED TURING LINE AROUND.
* 
      CPA ENQ       "ENQ" AGAIN?
      RSS           YES, ASSUME RESPONCE IS CORRECT.
      JMP TBCC+1    NO, GO ANALYSE RESPONCE.
* 
      CLA           SET LINE STATE TO
      STA RCSND     RECEIVE
      STA BCONT     FORCE A RESPONCE OF "ACK0"
      LDB TLOG      GET TRANSMISSION LOG
      LDA F2        REQUEST IN
      SSA,RSS       WORDS ?
      BRS           YES, CONVERT XLOG TO WORDS
      STB TLOG      STB, IN TLOG
      JSB WACTV     ACTVATE  "WACT" MODULE
      JMP COMPT     COMPLETE OPERATION
      SPC 3
* 
*           *** DATA ***
* 
ADSD1 DEF SEND1
BCCBA DEF BCCBF
BCCBF BSS 3         BUFFER THAT IS SENT TO CNTRL.
      OCT 377       PAD CHARACTER.
BUFAD BSS 1         BUFFER ADDRESS.
BLENG BSS 1         CURRENT BUFFER NEG CHAR COUNT.
CONAD BSS 1         CNVSTNL REPLY'S BUFFER LENGTH.
CONLN BSS 1         CNVSTNL REPLY'S BUFFER START ADR
CONVS BSS 1         IF = 1, THEN IN "CONVRSTNL" MODE
F1    BSS 1         ADRS OF PARAMTER LIST.
F2    BSS 1         BUFFER LENGTH.
LNBCC BSS 1         IF = 0, THEN DO NOT CALC BCC.
SCONT BSS 1         COUNTS # TIMES A BLOCK IS SENT.
TMP   BSS 1         TEMPORARY STORAGE.
WSI   BSS 1         SAVES "DLE" FALG.
WSIDE BSS 1         CHARACTER JUSTIFICATION.
      HED  READ PROCESSOR.
* 
* 
*     *** RECEIVE PROCESSOR ***
* 
* 
* USER CALLING SEQUENCE:
* 
*     JSB .IOC.
*     OCT (FUNCTION - SUBFUNCTION - LOGICAL UNIT)
*     REJECT ADDRESS
*     BUFFER STARTING ADRESS.
*     LENGTH OF BLOCK TO BE RECEIVED.
* 
*     FUNCTION FIELD 01
* 
*         BIT 10: REQUEST TO SEND ('RVI')
* 
*         BIT 8:  CONVERSATIONAL READ
* 
*         BIT 7:  NO ERROR CORRECTION
* 
*         BIT 6:  REJECT PREVIOUS MESSAGE ('NAK')
* 
* 
*     A STATUS OF 'OFF LINE' OR IN 'SEND' MODE WILL CAUSE
*     THE DRIVER TO REJECT THE READ REQUEST.
* 
*     AN 'ENQ' CHARACTER RECEIVED WILL CAUSE THE DRIVER TO:
* 
*         1.  RESEND ITS INITIAL ACKNOWLEDGE CHARACTER
*             ('ACK0','ACK1','RVI', OR USER 'NAK') IF IT IS
*             THE FIRST CHARACTER RECEIVED.
* 
*         2.  SEND A 'NAK' IF AT ANY OTHER TIME.
* 
*     IF THE FIRST CONTROL CHARACTER SENT IS NOT A 'SOH',
*     'STX', OR 'ENQ' THE DRIVER WILL 'NAK' THE MESSAGE.
* 
*     AFTER THE MESSAGE IS CORRECTLY RECEIVED THE DRIVER WILL
*     AUTOMATICALLY ACTIVATE THE 'WACT' (WAIT BEFORE POSITIVE
*     ACKNOWLEDGEMENT) MODULE.
* 
*     A CONVERSATIONAL REPLY CANNOT BE EXECUTED UNTIL AN 'ETX'
*     TERMINATES A MESSAGE.  ('ETB' WILL NOT DO.)
* 
*     ERROR DETECTION AND CORRECTION PERFORMED BY THE DRIVER:
* 
*         1.  PARITY ERROR:  REREAD (MESSAGE 'NAKED') SEVEN TIMES.
*             ON THE EIGHTH TRY THE DRIVER WILL SET THE STATUS
*             TO LINE ERROR, SEND 'DLE' 'EOT' TO THE SENDER
*             AND DROP THE LINE.
* 
*         2.  DURING RECEIPT OF CHARACTERS, IF FIVE SECONDS
*             PASSES WITHOUT A CHARACTER BEING SENT, THE
*             DRIVER WILL SET THE STATUS TO INDICATE A TIMEOUT,
*             SEND 'DLE' 'EOT' TO THE SENDER AND DROP THE LINE.
* 
      SKP
*********************
*                   *
* INITIATOR SEGMENT ************************************************
*                   *
*********************
* 
* 
*     *** TEST FOR REJECT CONDITIONS. ***
* 
READ  CLB,INB       SET B-REG TO 'OFF-LINE' REJECT.
      LDA EQT2A,I   GET WORD #2 OF DEVICE EQT ENTRY.
      ALF,ALF
      RAL,RAL       IS TERMINAL
      SLA,RSS       OFF LINE?
      JMP REJEC     YES, REJECT THE REQUEST.
* 
      INB           SET B-REG TO 'INCORRECT MODE'.
      RAL           POSITION MODE BIT.
      SSA           IN 'SEND MODE'?
      JMP REJEC     YES, REJECT.
* 
      CLA           REQUEST IS LEGAL.
      STA ASAVE
      JSB .IO.
      OCT 11
      LDA D.50      SET UP RETURN LINKAGE.
      STA I.50
* 
*     *** SET UP REQUESTED OPTIONS. ***
* 
      JSB FLAGC     GO CLEAR ALL CONTROL FLAGS.
* 
      LDA FUNCT     GET USER FUNCTIONS.
      CCB           SET B-REG TO -1.
      SLA           'NAK' REQUESTED BY USER?
      STB NAKFG     YES, TURN OF 'NAK' FLAG.
      RAR,SLA       'NO ERROR CORRECT' REQUESTED?
      STB NOERR     YES, TURN ON 'NOERR' FLAG.
      RAR,SLA       'CONVERSATIONAL READ' REQUESTED?
      STB CONVR     YES, TURN ON 'CONVR' FLAG.
      RAR,RAR
      SLA,RSS       'REQUEST TO SEND' BY USER?
      JMP *+3       NO.
      STB RVIFG     YES, TURN ON 'RVI' FLAG.
      STB RQ2SD     ALSO RQ2SD FLAG.
                                                                                                                                                                 24380-18031 1409                                                                                           