
ASMB,R,B,L,C
      HED DOUBLE PRECISION ASCII TO BINARY ROUTINE.
      NAM AS2BI
*
*     DOUBLE PRECISION ASCII TO BIANRY ROUTINE.
*     CONVERTS ANY STRING OF ASCII DIGITS UP TO
*     2,147,583,647 TO DOUBLE PRECISION FORMAT AND
*     RETURNS THE BINARY VALUE IN THE A & B REGISTERS.
*     (A-REG CONTAINS LEAST SIG BITS, B-REG MOST.)
*
*
*     THE CALLING SEQUENCE IS:
*
*     LDA S.A.      "S.A." IS STRING STARTING ADDRESS.
*     LDB LNGTH     "LNGTH" IS THE STRING LENGTH IN CHARS.
*     JSB AS2BI     CALL ROUTINE.
*
*                   "LNGTH" DESCRIBES FIRST CHAR POSITION.
*                   POSITIVE VALUE IF LEFT JUSTIFIED.
*                   NEGATIVE IF RIGHT JUSTIFIED.
*
      SKP
      ENT AS2BI
*
*     *** INITIALIZE FOR PROCESS. ***
*
AS2BI NOP
      SZB,RSS       INPUT LENGTH =0?
      JMP ZEROC     YES.
*
      STA S.A.      SAVE STRING STARTING ADDR.
      CLA
      STA ANSR      INITIALIZE ANSWER.
      STA ANSR+1
      SSB           SET CHAR POSITION FLAG ACCORDING
      CMA           TO A NEG OR POSITIVE COUNT.
      STA FLIP
      SSB,RSS       CONVERT LENGTH TO NEGATIVE
      CMB,INB       VALUE IF NECESSARY.
      STB CCNTR     SET UP LOOP COUNTER.
      LDA POINT     SET ADDITION POINTER
      ADA 1         ACCORDING TO THE # OF
      ADA 1         INPUT CHARS.
      STA TEMP1
      INA
      STA TEMP2
*
*     *** GENERATE ANSWER. ***
*
LOOP1 LDA S.A.,I    GET A CHAR IN STRING.
      LDB FLIP      POSITION ACCORDING
      CMB,SZB       TO FLIP-FLOP FLAG.
      ALF,ALF
      AND =B17      CONVERT TO BINARY.
      CMA,INA       SET UP
      STA DCNTR     LOOP.
      STB FLIP      RESET FLIP-FLOP FLAG.
      SZB,RSS       INCREMENT CHARACTER POINTER
      ISZ S.A.      EVERY OTHER TIME.
      SZA,RSS       IS DIGIT A ZERO?
      JMP ZERO      YES.
*
      LDA ANSR      GET CURRENT BINARY
      LDB ANSR+1    VALUE IN A & B REG'S.
LOOP2 CLE
      ADA TEMP1,I   ADD REQUIRED VALUE TO A-REG.
      SEZ           OVERFLOW?
      INB           YES, INCREMENT B-REG.
      ADB TEMP2,I   ADD REQUIRED VALUE TO B-REG.
      ISZ DCNTR     INCREMENT DIGIT ADDITION COUNTER
      JMP LOOP2     LOOP UNTIL ZERO.
      STA ANSR      SAVE NEW
      STB ANSR+1    RESULTS.
*
ZERO  LDA ANSR      RELOAD ANSWER
      LDB ANSR+1    FOR POSSIBLE RETURN.
      ISZ CCNTR     END OF INPUT STRING?
      RSS
      JMP AS2BI,I   YES, RETURN WITH ANSWER.
*
      ISZ TEMP1     INCREMENT DIGIT
      ISZ TEMP1     VALUE POINTERS ...
      ISZ TEMP2
      ISZ TEMP2
      JMP LOOP1     LOOP.
*
*
ZEROC CLA           INPUT LENGTH =0.
      JMP AS2BI,I   RETURN WITH VALUE OF 0.
      SKP
*
*     *** DATA SECTION. ***
*
FLIP  BSS 1
S.A.  BSS 1
CCNTR BSS 1
DCNTR BSS 1
ANSR  BSS 2
TEMP1 BSS 1
TEMP2 BSS 1
POINT DEF EOT
*
*     *** THE FOLLOWING ARE THE OCTAL VALUES OF
*         THE FIRST 10 PLACE VALUES (BASE 10). ***
*
      OCT 145000    "1,000,000,000"
      OCT 35632
*
      OCT 160400    "100,000,000"
      OCT 2765
*
      OCT 113200    "10,000,000"
      OCT 230
*
      OCT 41100     "1,000,000"
      OCT 17
*
      OCT 103240    "100,000"
      OCT 1
*
      OCT 23420     "10,000"
      OCT 0
*
      OCT 1750      "1,000"
      OCT 0
*
      OCT 144       "100"
      OCT 0
*
      OCT 12        "10"
      OCT 0
*
      OCT 1         "1"
      OCT 0
*
EOT   NOP
      END
                                                                                                                                                                  24380-18022 1402                                                                                         