
ASMB,A,B,L,C
      HED 2100 SERIES MEMORY PARITY CHECK DIAGNOSTIC
      ORG 2B
* 
******************************************************************* 
* 
* 
* DIAGNOSTIC CHECKS PARITY OPERATION
* 
* DIAGNOSTIC ASSUMES THE FOLLOWING TESTS HAVE BEEN RUN
* 
*    MEMORY REFERENCE GROUP  DSN 101000 
*    ALTER-SKIP GROUP        DSN 101001 
*    SHIFT-ROTATE GROUP      DSN 101002 
*    MEMORY                  DSN 102000 
*    MEMORY PROTECT          DSN 102001 
* 
* RUNS IN 4K MEMORY 
* 
* TELETYPE NOT REQUIRED 
* 
* DIAGNOSTIC CONFIGURATOR IS REQUIRED 
* 
* DIAGNOSTIC SERIAL NO (DSN) 102002 
* 
* OPERATING INSTRUCTIONS: 
* 
*     1.  LOAD AND CONFIGURE DIAGNOSTIC CONFIGURATOR. 
* 
*     2.  LOAD MPC DIAGNOSTIC.
* 
*     3.  SET P REGISTER TO 100. PUT I/O CARD SELECT CODE IN
*         SWITCH REGISTER. PRESS PRESET(INT. & EXT. IF PRESENT) 
*         AND RUN.
* 
*     4.  SUCCESSFUL CONFIGURATION IS A HALT 102074. PRESS RUN. 
* 
*     5.  HALT 102002 OCCURS. POWER OFF AND SET COMPUTER TO FORCE 
*         BAD PARITY. 
* 
*     6.  SET SWITCH REGISTER TO 0. SET P REGISTER TO 130. PRESS
*         PRESET(INT. & EXT. IF PRESENT) AND RUN. 
* 
*     7.  HALT 102003 OCCURS. POWER OFF AND SET COMPUTER TO ALLOW 
*         GOOD PARITY.
* 
*     8.  PLACE THE INTERRUPT/HALT SWITCH IN THE HALT MODE. 
*         SET P REGISTER TO 131.
* 
*     9.  SET SWITCH REGISTER TO 0. PRESS 
*         PRESET(INT. AND EXT. IF PRESENT) AND RUN. 
* 
*     10. HALT OCCURS WITH B REGISTER = 1. PLACE THE INTERRUPT/ 
*         HALT SWITCH IN THE INTERRUPT POSITION. SELECT PROGRAM 
*         OPTIONS IN THE SWITCH REGISTER. PRESS PRESET(INT. & EXT.
*         IF PRESENT) AND RUN.
* 
      SKP 
*************** SWITCH REGISTER OPTIONS *************************** 
* 
*   BIT        MEANING
* 
*   0-7        RESERVED 
*    8         SUPPRESS OPERATOR INTERVENTION 
*   9-11       RESERVED 
*    12        LOOP ON DIAGNOSTIC. CLEAR TO HALT AT END OF PASS.
*  13-15       RESERVED 
* 
* 
*************** COMPUTER HALTS *************************************
* 
*   HALT       MEANING
* 
*  102002      SET UP HALT FOR FORCING BAD PARITY 
*  102003      SET UP HALT FOR FORCING GOOD PARITY
*  1020XX      PARITY ERRORS 04<XX<47 
*  10205X      ERROR HALT FOR L.G. X=0-4
*  102077      END OF PASS
*  1060XX      UNEXPECTED TRAP CELL HALT (XX=SC)
*  102073      SELECT CODE IN SW REG < 10 
*  102074      CONFIGURATION COMPLETE 
* 
* 
******************************************************************* 
* 
      SKP 
      ORG 100B
      JMP CONFI,I 
      ORG 105B
      DEF FWAM      FIRST WORD AVAILABLE MEMORY 
      BSS 1         LAST WORD AVAILABLE MEMORY
      ORG 126B
      OCT 102002    DIAGNOSTIC SERIAL NO
      SPC 3 
CTO   EQU 115B
SCD   EQU 116B
MSIZE EQU 117B
      SPC 3 
      ORG 130B
      SPC 1 
      JMP RSTR1,I   OPERATOR RESTART 1 LOCATION 
      JMP RSTR2,I   OPERATOR RESTART 2 LOCATION 
      JMP H77C+1    RESTART TO BYPASS SC ENTRY
* 
* TABLE OF SELECT CODES TO BE MODIFIED
* 
FIRST DEF *+1 
      DEF CH0 
      DEF CH1 
      DEF CH2 
      DEF CH3 
LAST  DEF *-1 
      SPC 2 
* 
* EQUATES 
* 
A     EQU 0 
B     EQU 1 
SWR   EQU 1 
CH    EQU 0 
      SPC 2 
* 
* CONSTANTS & STORAGE LOCATIONS 
* 
MSINC OCT 7777
MSMK  OCT 70000 
H1000 OCT 10000 
LGMG  OCT 100000
LGMK  OCT 170000
MPMK  OCT 40
DFAC1 DEF FAC1+1
DFAC2 DEF BADPA+1 
A2    OCT 2 
A77   OCT 77
A100  OCT 100 
A1000 OCT 1000
A2000 OCT 2000
H7777 OCT 77777 
MEMAX NOP 
A10   OCT 10
M10   OCT -10 
I/O   NOP           I/O SELECT CODE 
INSWR NOP           INTERNAL SWITCH REG 
THLT  OCT 106002    FIRST TRAP CELL HALT
CTBLA NOP 
P7700 OCT 177700
JE5I  JMP E5I,I 
HLT5  OCT 106005
JP10I JSB P10I,I
EXPAD NOP           EXPECTED ADDR OF PE 
HLTA  OCT 106000    A-REG TRAP CELL HALT
HLTB  OCT 106001    B-REG TRAP CELL HALT
NMPT  NOP           MEM PROTECT AVAIL 
MSK15 OCT 77777 
ACTAD NOP           ACTUAL INT ADDR 
JE10I JSB E10I,I
JE11I JSB E11I,I
JE27I JSB E27I,I
JE20I JSB E20I,I
KZERO OCT 0 
TEMP  NOP 
JE40I JSB E40I,I
JPRII JSB PRII,I
JIOI  JSB IOI,I 
JPE1I JSB PER1I,I 
JPE2I JSB PER2I,I 
JPE3I JSB PER3I,I 
BT6   OCT 100 
BT12  OCT 10000 
BIT8  OCT 400 
PER1  OCT 1 
PER2  OCT 123456
PER3  OCT 077777
PER4  OCT 125125
PER5  OCT 5 
PER6  OCT 6 
N200B OCT -200
CNTR  NOP 
* 
* ADDRESS DEFINITIONS 
* 
E5I   DEF E5
P10I  DEF PEB10 
APER1 DEF PER1      PARITY ERROR ADDRESS
APER5 DEF PER5
APER6 DEF PER6
PER1I DEF PERR1 
PER2I DEF PERR2 
PER3I DEF PERR3 
E10I  DEF E10R
E11I  DEF E11R
E27I  DEF E27R
E20I  DEF E20R
E40I  DEF E40R
PRII  DEF PRI 
IOI   DEF IOR 
RSTR1 DEF REST1 
RSTR2 DEF REST2 
CONFI DEF CONF
STRTI DEF START 
      SKP 
* 
* LGCK CHECKS COMPUTER TYPE FOR LG
*  IF SO M.P. IS CHEKED FOR ITS PRESENCE
*  AND IF PRESENT, EXITS TO P+2 
*  OTHERWISE TO P+1 
* 
LGCK  NOP 
      STA SAVA
      LDA CTO 
      AND LGMK      MASK FOR COMPUTER TYPE
      CPA LGMG      L.G.
      JMP NCK       YES 
      LDA SAVA
      ISZ LGCK      NO,EXIT P+2 
      JMP LGCK,I    EXIT P+2
NCK   LDA NMPT
      SZA           M.P. PRESENT
      ISZ LGCK      YES EXIT P+2
      LDA SAVA
      JMP LGCK,I    NO, EXIT P+1
SAVA  OCT 0 
      HED PARITY TEST -- CONF 
      ORG 600B
CONF  CLC 5 
      CLC 0,C 
* 
* DETERMINE AND STORE MEMORY SIZE 
* 
      LDA MSIZE 
      AND MSMK     FORM LWAM
      ADA MSINC 
      STA MEMAX 
* 
* INPUT & CHECK I/O SELECT CODE 
* 
SC    LIA SWR 
      AND A77       GET 
      STA SCD        SELECT CODE
      ADA M10 
      SSA,RSS       LESS THAN 7(OCTAL)? 
      JMP VALID     YES 
      HLT 73B       NO
      JMP SC        TRY AGAIN 
VALID EQU * 
      LDA SCD       STORE 
      STA I/O        SELECT CODE
      LDA CTO 
      AND MPMK
      STA NMPT
* 
* INPUT & STORE INTERNAL SW-REG 
* 
H77C HLT 74B
      JMP STRTI,I 
      HED PARITY TEST -- START
      ORG 2000B 
START CLC 5,C       TURN OFF PARITY INT 
      CLC 0,C       CLR ALL DEVICES, INT SYS OFF
* 
* STORE TRAP CELL HALTS IN LOC 2-77B
* 
      LDB A2
      LDA THLT
LP    STA B,I 
      INB 
      INA 
      CPB A100      TRAP CELL HALTS COMPLETE? 
      RSS           YES 
      JMP LP        NO, LOOP
* 
* MODIFY I/O INSTRUCTIONS 
* 
      LDB FIRST 
      STB CTBLA 
L     LDB CTBLA,I   GET INSTRUCTION ADDR FROM TABLE 
      LDA B,I       INSTRUCTION INTO A
      AND P7700     MASK OUT SELECT CODE
      IOR I/O       INCLUDE NEW SC
      STA B,I       STORE I/O INSTRUCTION 
      CPB LAST,I    MODIFICATION COMPLETE?
      JMP *+3       YES 
      ISZ CTBLA     NO
      JMP L 
      HED PARITY TEST -- INIT 
ODPTN EQU * 
      CLA 
      STA 5         NOP IN PE TRAP CELL 
* 
* 
H2    HLT 2B      * TURN OFF PWR, WIRE FOR EVEN 
      JMP H2        PARITY, SET SWITCH ON I/O TO INT
*                   TURN ON POWER 
*                   RESTART AT 130B 
* 
REST1 EQU * 
      CLC 5B,C      PARITY INT OFF
      LDA PER1
      STA PER1
      LDA PER5
      STA PER5
      LDA PER6
      STA PER6
      LDA BADPA 
      STA BADPA 
* 
* WRITES BAD PARITY PATTERNS INTO 
*  LOCATIONS 1000B THROUGH 1777B
* 
      LDA N200B     INITIALIZE COUNTER
      STA CNTR       TO -200B 
* 
      LDA PER1      PATTERN IN A
      LDB A1000     STARTING ADDR IN B
      JSB WRITE 
* 
      LDA PER2
      JSB WRITE 
* 
      LDA PER3
      JSB WRITE 
* 
      LDA PER4
      JSB WRITE 
* 
H3    HLT 3B      * TURN OFF PWR, WIRE FOR ODD
      JMP H3        PARITY,SET SWITCH ON I/O TO HALT
*                   TURN ON POWER 
*                   RESTART AT 131B 
      SPC 2 
* 
* WRITE ROUTINE. WRITES BAD PARITY INTO 200B
*  LOCATIONS STARTING AT ADDRESS IN B-REG 
* 
WRITE NOP 
      STA B,I       STORE BAD PARITY PATTERN
      RAL           SHIFT PATTERN 
      INB           STEP ADDR 
      ISZ CNTR      STEP COUNTER
      JMP WRITE+1   REPEAT
      LDA N200B     FINISHED. RESET COUNTER 
      STA CNTR
      JMP WRITE,I    AND RETURN *+1 
      HED PARITY TEST -- TESTA
* TESTS BIT 15 OF A-REGISTER AFTER LIA 5; PERFORMS
*  ORDERLY HALT ON PARITY ERROR 
      SPC 2 
PEA05 EQU * 
REST2 EQU * 
      CLC 5,C 
      LDA JE5I      SET TRAP CELL 
      STA 5 
* 
      JSB LGCK      L.G. ?
      JMP CH0 
      LIA 5         CHECK BIT 15 OF VIOLATION REG 
      SSA           ERROR IF =1 
E4    HLT 4B      * BIT 15 IS SET AFTER PWR TURN ON 
* 
* GENERATE PARITY HALT
* 
CH0   CLF CH        USE FLAG AS HALT INDICATOR
      STF 5         ENABLE PE INT 
      LDB PER1    * PARITY HALT SHOULD OCCUR HERE.
      NOP           PRESS PRESET (INT.), PARITY HALT
      NOP            SHOULD CLEAR. SET TO PARITY INT
*                                   MODE, PRESS PRESET (EXT) & RUN
* 
CH1   SFS CH        IF HLT OCCURRED, PRESET SET FLAG
E5    HLT 5B      * FAILED TO HALT ON PARITY ERROR
      CLC 5,C 
      LDA HLT5      RESTORE TRAP CELL HALT
      STA 5 
      HED PARITY TEST -- TESTB
* TESTS ABILITY TO INTERRUPT ON PARITY ERROR; CHECKS PE/MPT 
*  VIOLATION FF, PARITY INTERRUPT ADDRESS.
      SPC 2 
PEB05 EQU * 
      CLF 0         INT SYS OFF 
      CLF 5         DISABLE PE INT
      LDA JP10I     SET TRAP CELL 
      STA 5 
      LDA APER1 
      STA EXPAD     PE ADDR INTO EXPAD
      LDA HLTA
      STF 5         ENABLE PE INT 
      LDB PER1      SHOULD INTERRUPT
FAC1  INA 
      NOP 
      JSB LGCK      L.G. ?
      JMP PEC05 
      LDA EXPAD     EXPECTED INT ADDR INTO A
      CLB           0 INTO B
E6    HLT 6B      * PE INT NOT RECEIVED 
      JMP E.PEB 
* 
* PE INT SUBROUTINE 
* 
PEB10 NOP 
      CLC 5,C       DISABLE PE INT
      JSB LGCK      L.G. ?
      JMP E50 
      LDB HLTB      B = EXPECTED INSTR RESULT 
      CPA B         TEST FOR INSTR EXECUTION
      JMP *+2 
      HLT 0         EXECUTION ERROR 
      LDA PEB10     A = ACTUAL ADDRESS
      LDB DFAC1     B = EXPECTED ADDRESS
      CPA B         TEST FOR CORRECT ADDRESS
      JMP *+2 
      HLT 1         ADDRESS ERROR 
      LIA 5 
      SSA           PE/MPT VIOL. FF SET?
      RSS           YES 
      JMP E43       NO, REPORT ERROR
* 
      LDB NMPT      CHECK INT ADDR
      SZB,RSS       MEMORY PROTECT AVAILABLE
      JMP E.PEB     NO, EXIT
      AND MSK15     STRIP BIT 15
      STA ACTAD     INT ADDR INTO ACTAD 
      CPA EXPAD     ACTUAL ADDR = EXPECTED ADDR 
      JMP E.PEB     YES, EXIT 
      LDA EXPAD     NO, EXP ADDR INTO A 
      LDB ACTAD     ACTUAL ADDR INTO B
E7    HLT  7B     * PE INT ADDR INCORRECT 
      JMP PEC05 
E50   HLT 50B       L.G. AND NO M.P.; SHOULD NOT INT
E.PEB EQU * 
      HED PARITY TEST -- TESTC
* TESTS ABILITY OF CLF 5 TO INHIBIT PE INT
      SPC 2 
PEC05 EQU * 
      LDA JE10I 
      STA 5         SET TRAP CELL 
      STF 5 
      CLF 5 
      LDB PER1      SHOULD NOT
      NOP            INTERRRUPT HERE
      JMP E.PEC 
* 
* PE INT SUBROUTINE 
* 
E10R  NOP 
      CLC 5,C 
      LDA E10R
E10   HLT 10B     * CLF 5 DID NOT INHIBIT PE INT
E.PEC EQU * 
      HED PARITY TEST -- TESTD
* TESTS THAT PE INTS ARE INHIBITED WHEN PROTECTED 
*  LOADER AREA OR NON-EXISTENT MEMORY IS ACCCESSED. 
      SPC 2 
* 
* ACCESS LOADER AREA
* 
PED05 EQU * 
      LDA CTO 
      AND LGMK
      CPA LGMG      TEST FOR ODD G
      JMP PD05
      LDA JE11I 
      STA 5         SET TRAP CELL 
      STF 5         ENABLE PE INT 
      LDA MEMAX,I   ACCESS LOADER AREA
      NOP           SHOULD NOT INT HERE 
* 
* ACCESS NON-EXISTENT MEMORY (IF ANY) 
* 
PD05  LDA JE27I 
      STA 5         SET TRAP CELL 
      STF 5         ENABLE PE INT 
      LDA MEMAX 
PEA   CPA H7777     LAST MOD
      JMP E.PED     EXIT
      ADA H1000 
      LDB A,I       ACCESS NON-EXISTENT MEMORY
      NOP           SHOULD NOT INTERRUPT HERE 
      JMP PEA 
* 
* E11 INT ROUTINE 
* 
E11R  NOP 
      CLF 5 
      LDA E11R
E11   HLT 11B     * PE INT FROM LOADER AREA 
      JMP E11R,I    RETN *+1
* 
* E27 INT ROUTINE 
* 
E27R  NOP 
      CLF 5 
      LDA E27R
E27   HLT 27B     * PE INT FROM NON-EXISTENT MEMORY 
      JMP E27R,I
* 
E.PED EQU * 
      HED PARITY TEST -- TESTE
* TESTS THAT PE INTS ARE INHIBITED DURING 
*  A CLEAR/WRITE OPERATION
      SPC 2 
PEE05 EQU * 
      CLF 5 
      LDA JE20I 
      STA 5         SET TRAP CELL 
      LDA KZERO 
      STF 5         ENABLE PE INT 
      STA TEMP      PH3 OF STA USES CLR/WT OPERATION
      NOP           SHOULD NOT INT HERE 
      JMP E.PEE 
* 
* E20 INT ROUTINE 
* 
E20R  NOP 
      CLF 5 
      LDA E20R
E20   HLT 20B     * CLR/WT FAILED TO INHIBIT PE INT 
      JMP E20R,I    RETN *+1
* 
E.PEE EQU * 
      HED PARITY TEST -- TESTH
* TESTS PARITY ERROR PRIORITY CONTROL 
      SPC 2 
PEH05 EQU * 
      CLF 0 
      CLF 5 
      LDA JE40I 
      STA I/O,I     SET I/O TRAP CELL 
      LDA JPRII 
      STA 5         SET PE TRAP CELL
      LDA HLTA
      LDB HLTB
CH2   STC CH
CH3   STF CH
      STF 0         ENABLE I/O INT
      STF 5         ENABLE PE INT 
BADPA INA           EVEN PARITY HERE
      NOP           PE INT SHOULD OCCUR HERE
E41   HLT 41B     * NO PE OR I/O INT
      JMP E.PEH 
* 
*PE INT ROUTINE 
* 
PRI   NOP 
      CLF 0         DISABLE INT SYS 
      JSB LGCK      L.G. ?
      JMP E51 
      LDB HLTB      B = EXPECTED INSTR RESULT 
      CPA B         TEST FOR INSTR EXECUTION
      JMP *+2 
      HLT 0         EXECUTION ERROR 
      LDA PRI       A = ACTUAL ADDRESS
      LDB DFAC2     B = EXPECTED ADDRESS
      CPA B         TEST FOR CORRECT ADDRESS
      JMP *+2 
      HLT 1         ADDRESS ERROR 
      LDA JIOI
      STA I/O,I     SET I/O TRAP CELL 
      LDA HLTA
      STF 0         ENABLE INT SYS
      NOP           I/O SHOULD INTERRUPT
      CLF 0 
E42   HLT 42B     * NO I/O INT
      JMP E.PEH 
E51   HLT 51B       L.G. AND NO M.P.; SHOULD NOT INT
      JMP E.PEH     INTERRUPTED 
* 
* I/O INT ERROR ROUTINE 
* 
E40R  NOP 
      CLF 0 
      JSB LGCK      L.G. ?
      JMP E.PEH 
      LDA E40R
E40   HLT 40B     * I/O TOOK INT PRIORITY OVER PE 
      JMP E.PEH 
* 
* I/O INT ROUTINE 
* 
IOR   NOP 
      CLF 0 
      JMP E.PEH 
* 
E.PEH EQU * 
      HED PARITY TEST -- TESTI
* TESTS PARITY TREE LOGIC BY ACCESSING
*  A NUMBER OF DIFFERENT BAD PARITY LOCATIONS.
*  CHECKS PARITY ERROR ADDR. TESTS ABILITY TO 
*  LEAVE BAD PARITY AT AN ADDRESS WHEN ACCESSING
*  WITH A READ TYPE INSTRUCTION (LDB), & TO 
*  RESTORE GOOD PARITY WHEN ACCESSING WITH A
*  WRITE TYPE INSTRUCTION (STB).
      SPC 2 
PEI05 EQU * 
      CLF 0 
      CLC 5,C 
      LDA JPE1I 
      STA 5         SET PE TRAP CELL
      LDA A1000 
      STA EXPAD 
* 
* ACCESS PE LOCATIONS (1000B-1777B). SHOULD 
*  INTERRUPT TO PERR1 SUBROUTINE
* 
RDPER STF 5 
      LDB EXPAD,I   BAD PATTERN INTO B
      NOP           SHOULD INT HERE TO PERR1
      NOP 
      JSB LGCK      L.G. ?
      JMP STEP
      LDA EXPAD     EXPECTED INT ADDR INTO A
E44   HLT 44B     * PE INT NOT RECEIVED 
      JMP STEP
      SPC 2 
* 
* PERR1 INT ROUTINE 
* 
PERR1 NOP 
      CLC 5,C 
      JSB LGCK      L.G. ?
      JMP E52 
      LIA 5 
      SSA           CHECK BIT 15 OF A-REG 
      RSS 
E43   HLT 43B     * PE INDICATOR BIT 15 NOT SET 
      LDB NMPT
      SZB,RSS       MEMORY PROTECT AVAILABLE
      JMP STEP      NO
      AND MSK15     YES, STRIP BIT 15 
      STA ACTAD     STORE ACTUAL PE INT ADDR
      CPA EXPAD     IS ADDR CORRECT?
      JMP STEP      YES 
      LDA EXPAD     NO, EXPECTED ADDR INTO A
      LDB ACTAD     ACTUAL INT ADDR INTO B
E45   HLT 45B     * PE INT ADDR INCORRECT 
      JMP STEP
E52   HLT 52B       L.G. AND NO M.P.; SHOULD NOT INT
      SPC 1 
STEP  LDA EXPAD 
      INA           STEP ADDR 
      STA EXPAD 
      CPA A2000     FINISHED? 
      JMP PEI10     YES 
      JMP RDPER     NO, REPEAT
      SPC 2 
* 
* CHECKS ABILITY TO LEAVE BAD PARITY
* 
PEI10 EQU * 
      CLC 5,C 
      LDA JPE2I 
      STA 5         SET TRAP CELL 
* 
      STF 5         ENABLE PE INT 
      LDA APER6     PE ADDR INTO A
      LDB PER6      CONTENTS INTO B 
      NOP           SHOULD INT TO PERR2 
      NOP 
      JSB LGCK      L.G. ?
      JMP CHNGE 
E46   HLT 46B     * BAD PARITY CHANGED BY READ-TYPE 
*                                    INSTRUCTION
* 
* CHECKS ABILITY TO RESTORE GOOD PARITY 
* 
CHNGE CLC 5,C 
      LDA JPE3I 
      STA 5         SET PE TRAP CELL
* 
      LDA APER5     PE ADDR INTO A
      LDB PER5      CONTENTS INTO B 
      STB PER5      SHOULD RESTORE GOOD PARITY
      STF 5 
      LDB PER5      ACCESS SAME LOCATION AGAIN
      NOP           SHOULD NOT INT TO PERR3 
      CLC 5,C 
      JMP E.PEI 
      SPC 2 
* 
* PERR2 INT ROUTINE 
* 
PERR2 NOP 
      CLC 5,C 
      JSB LGCK      L.G. ?
E53   HLT 53B       L.G. AND NO M.P.; SHOULD NOT INT
      JMP CHNGE 
      SPC 2 
* 
* PERR3 INT ROUTINE 
* 
PERR3 NOP 
      CLC 5,C 
      JSB LGCK      L.G. ?
      JMP E54 
E47   HLT 47B     * GOOD PARITY NOT RESTORED BY 
*                                    WRITE TYPE INSTRUCTION 
      JMP PERR3,I   RETN *+1
E54   HLT 54B       L.G. AND NO M.P.; SHOULD NOT INT
      CLC 5,C 
      JMP E.PEI 
      SPC 2 
E.PEI EQU * 
      HED PARITY TEST -- END
END   EQU * 
      LIA 1         IS
      AND BIT8       BIT 8
      SZA             ON? 
      JMP NEXT1     YES 
      LDA JMP01     NO.PUT JMP
      STA JMP.1      2000B AFTER H77
      JSB CLRPE     RESTORE GOOD PARITY 
      JMP NEXT2 
NEXT1 EQU * 
      LDA JMP02     PUT JMP 
      STA JMP.1      PEB05 AFTER H77
NEXT2 EQU * 
      LIA 1         IS
      AND BT12       BIT 12 
      SZA,RSS         ON? 
      JMP H77       NO.GO HALT
      LIA 1         YES. IS 
      AND BIT8       BIT 8
      SZA             ON? 
JMP02 JMP PEB05     YES 
JMP01 JMP STRTI,I   NO
H77   EQU * 
      HLT 77B       END OF PASS 
JMP.1 BSS 1         DO ANOTHER PASS 
      SPC 2 
* 
* SUBROUTINE TO RESTORE GOOD PARITY TO LOCATIONS
*  CONTAINING PARITY ERRORS 
* 
      DEF *         LAST ADDR TO BE CLEARED 
CLRPE NOP 
      CLC 5,C       PARITY INT OFF
      LDA A2        A _ FIRST ADDR (LOC 2)
LOOP  LDB A,I       READ FROM, THEN WRITE BACK
      STB A,I        INTO LOCATION
      CPA CLRPE-1   FINISHED? 
      JMP FIN       YES 
      INA           NO, INCR ADDR 
      JMP LOOP      LOOP
FIN   STF 5         ENABLE PE INTPT 
      JMP CLRPE,I   RETN *+1
FWAM  EQU *         FIRST WORD AVAIL MEMORY 
      END 
                                                                                                                                                                                                                                                                                          24325-18001 1431  01 OF 01
                                                    