      HED ** COMPUTE (A MAX B) - <IMAX> **
* <IMAX> COMPUTES THE MAXIMUM OF TWO INTEGERS IN (A) AND (B)
* AND RETURNS THE LARGEST NUMBER (ARITHMETICALLY) IN (A).
      SPC 1
IMAX  NOP           ENTRY/EXIT
      STB SAVE      SAVE (B)
      CMB,INB       FORM -(B) 
      ADB A         FORM (A)-(B)
      SSB           IS (A) LARGER ? 
      LDA SAVE      NO: RETURN (B) IN (A) 
      JMP IMAX,I    YES: RETURN (A) IN (A)
      HED ** OUTPUT RESULT SIGN ROUTINE <OUTSN> **
* <OUTSN> POSTS THE SIGN OF THE RESULT IN THE RESULT STRING X$. 
* ENTER WITH SIGN IN (A) - -1=NEGATIVE, 0=POSITIVE. 
      SPC 1 
OUTSN NOP           ENTRY/EXIT
      LDB =B40      ASSUME PLUS SIGN (BLANK)
      SZA           POSITIVE ?
      LDB =B55      NO - LOAD MINUS (-) SIGN
      LDA XADDR     GET ADDRESS OF RESULT STRING
      JSB OUTCR      AND GO POST THE SIGN.
      JMP OUTSN,I   RETURN
      HED ** EXTRACT THE SIGN OF A STRING OPERAND <%SIGN> **
* <%SIGN> EXTRACTS THE SIGN OF A STRING WHOSE POINTER IS IN (A).
* THE SIGN , IF FOUND, IS RETURNED IN (A):  -1 FOR NEGATIVE,
* AND 0 FOR POSITIVE.  IF STRING IS UNSIGNED, POSITIVE IS 
* ASSUMED (A=0).  IF THE STRING IS NULL, THE MESSAGE "11 NS"
* IS PRINTED ON THE TTY, AND THE COMPUTER HALTS (102000). THIS
* IS AN IRRECOVERABLE CONDITION.  IF THE STRING IS SIGNED,
* (E)=1 ON RETURN, OTHERWISE (E)=0. 
      SPC 1 
%SIGN NOP           ENTRY/EXIT
      JSB GETCR     GO FETCH FIRST CHARACTER
      JMP ERRR1     ERROR - STRING IS NULL
      CPA =B53      PLUS SIGN (+) ? 
      JMP %SGNP     YES - POSITIVE
      CPA =B40      BLANK ? 
      JMP %SGNP     YES - ALTERNATE PLUS
      CPA =B55      MINUS (-) ? 
      JMP %SGNM     YES - NEGATIVE
      CLA,CLE       NONE OF ABOVE - UNSIGNED (+)
      JMP %SIGN,I   RETURN (A)=(E)=0
      SPC 1 
%SGNP CLA,CCE,RSS   POSITIVE: (A)=0, (E)=1
%SGNM CCA,CCE       NEGATIVE: (A)=-1, (E)=1 
      JMP %SIGN,I 
      SPC 1 
ERRR1 JSB .ERRR     STRING IS NULL - ERROR
      ASC 1,11      PRINT "11 NS" 
      ASC 1,NS
      HLT 0 
%NULL JMP *-1       IRRECOVERABLE ERROR HALT
      HED ** PLACE DECIMAL POINT ROUTINE - <PLACE> ** 
* <PLACE> CONVERTS THE INTERMEDIATE DECIMAL ARRAY TO ASCII AND
* PLACES THE DECIMAL POINT AT THE PROPER POSITION IN THE STRING.
* ENTER WITH THE LENGTH OF THE ARRAY IN (A), AND THE POINT
* DISPLACEMENT IN (B).  CALLING SEQUENCE: 
* 
*        LDA <LGTH> 
*        LDB <PDISP>
*        JSB PLACE
*        DEF DARRY      (THE ADDRESS OF THE DECIMAL ARRAY)
* 
PLACE NOP           ENTRY/EXIT
      STA SAVE1     SAVE THE LENGTH 
      CMA,INA       -L
      STA LENTH     POST -LGTH OF DEC. ARRAY
      LDA SUPON     TURN ON ZERO SUPPRESSION
      STA PLAC5+1    SWITCH (LEADING ZEROS ONLY). 
      LDA PLACE,I   GET ADR. OF DECIMAL ARRAY 
      ISZ PLACE      AND ADJUST RETURN ADDRESS. 
      STA ZPNT      SAVE LOCALLY
      STB PNT       SAVE POINT DISPLACEMNT
      CPB SAVE1     LGTH=POINT DISPLACEMENT ? 
      JMP PLAC2     YES 
      CMB,INB 
      ADB SAVE1     FORM L-P
      SSB,RSS       L>P ? 
      JMP PLAC4     YES 
      STB LOOP      LOOP COUNT = L-P (NEGATIVE) 
      LDA XADDR     GET ADDRESS OF DEST. STRING 
      LDB =B56
      JSB OUTCR     OUTPUT A DECIMAL POINT
      SPC 1 
PLAC1 LDA XADDR     OUTPUT P-L ASCII ZEROS, THUS
      LDB LOOP       PADDING ON THE LEFT. 
      JSB ZERO
      LDA LOOP
      CMA,INA 
      INA           COUNT=1+P-L 
      JMP PLAC3 
      SPC 1 
PLAC2 LDA XADDR     OUTPUT A POINT
      LDB =B56
      JSB OUTCR 
      CLA,INA       COUNT=1 
      SPC 1 
PLAC3 STA COUNT     POST THE COUNT (1 OR 1+P-L) 
      LDB ZPNT,I    GET A DECIMAL DIGIT 
      ADB =B60       AND CONVERT TO ASCII.
      LDA XADDR     GET ADDRESS OF DEST. STRING 
      JSB OUTCR      AND MOVE THE CHARACTER.
      ISZ ZPNT      BUMP SOURCE POINTER 
      ISZ COUNT     UPDATE CHARACTER COUNT
      ISZ LENTH     DECIMAL ARRAY EXHAUSTED ? 
      JMP PLAC3+1   NO
      LDA COUNT     YES - RETURN COUNT IN (A) 
      INA           ACCOUNT FOR THE SIGN
      JMP PLACE,I   RETURN
      SPC 1 
PLAC4 CMB,INB 
      STB LOOP      LOOP=L-P
      CLA 
      STA COUNT     COUNT=0 
      STA CHOUT     SET "NO CHARS OUT" SWITCH 
      SPC 1 
PLAC5 LDB ZPNT,I    GET A CHARACTER 
      SZB,RSS       ZERO ?
      JMP PLAC6     YES - SUPPRESS IT 
      ADB =B60      NO - CONVERT TO ASCII 
      LDA XADDR 
      JSB OUTCR     OUTPUT THE CHARACTER
      ISZ COUNT     ADJUST CHARACTER COUNT
      LDA SUPOF     TURN OFF ZERO SUPPRESSION AFTER 
      STA PLAC5+1    FINDING ONE NON-ZERO CHAR. 
      ISZ CHOUT     POST "AT LEAST ONE CHAR OUT"
      SPC 1 
PLAC6 ISZ ZPNT      ADJUST SOURCE POINTER 
      ISZ LOOP      FINISHED ?
      JMP PLAC5     NO - CONTINUE 
      LDA PSTAT     GET X/Y POINT STATUS WORD 
      RAL,CLE,ERA 
      SEZ,SLA,RSS   NO POINT IN EITHER STRING ? 
      JMP PLAC8     YES - EXIT IMMEDIATELU
      LDA XADDR     YES - OUTPUT A POINT
      LDB =B56
      JSB OUTCR 
      ISZ COUNT     UPDATE COUNT
      LDB PNT 
      CMB,INB,SZB,RSS POINT DISPLACEMENT=0 ?
      JMP PLAC8     YES - EXIT
      STB LOOP      LOOP=-PDISP 
      SPC 1 
PLAC7 LDB ZPNT,I    GET A DIGIT 
      ADB =B60      CONVERT TO ASCII
      LDA XADDR 
      JSB OUTCR     OUTPUT ASCII CHARACTER
      ISZ COUNT     UPDATE COUNT
      ISZ ZPNT      BUMP SOURCE POINTER 
      ISZ LOOP      FINISHED ?
      JMP PLAC7     NO - CONTINUE 
      JMP PLAC9     EXIT
      SPC 1 
PLAC8 EQU *         EXIT SEQUENCE 
      LDA CHOUT     ANY CHARACTERS OUT YET ?
      SZA 
      JMP PLAC9     YES - EXIT NORMALLY 
      LDA XADDR     NO - OUTPUT A ZERO
      LDB =B60
      JSB OUTCR 
      ISZ COUNT     UPDATE THE COUNT
      SPC 1 
PLAC9 LDA COUNT     RETURN THE COUNT IN (A) 
      INA           ACCOUNT FOR THE SIGN
      JMP PLACE,I 
      HED ** DETERMINE POINT DISPLACEMENT - <POINT> **
* <POINT> COMPUTES THE SIGNS AND POINT DISPLACEMENTS OF THE 
* ARGUMENT STRINGS X AND Y.  THE SIGNS ARE POSTED IN THE
* RESPECTIVE COMMON BLOCK FOR THE STRING, AS ARE THE DECIMAL
* POINT DISPLACEMENTS (I.E., THE NUMBER OF DECIMAL DIGITS 
* RIGHT OF THE DECIMAL POINT).  A LENGTH CORRECTION FACTOR
* IS COMPUTED FOR EACH STRING AND IS STORED IN THE COMMON 
* BLOCK 'LCOR'.  LCOR IS BUMPED FOR A STRING EACH TIME  
* EITHER A POINT OR A SIGN IS FOUND.
      SPC 1 
POINT NOP           ENTRY/EXIT
      DLD X+?LEN
      DST XPNT,I    SAVE BUFFER POINTER LOCALLY 
      DLD Y+?LEN
      DST YPNT,I
      LDA XPNT      PASS X-STRING POINTER AND GO
      JSB %SIGN      EXTRACT THE SIGN OF X. 
      STA X+?SGN    POST SIGN OF X-STRING 
      LDA YPNT
      JSB %SIGN     EXTRACT THE SIGN OF Y 
      STA Y+?SGN     AND POST IN COMMON.
      DLD X+?LEN    RESET LOCAL STRING POINTERS 
      DST XPNT,I
      DLD Y+?LEN
      DST YPNT,I
      LDA XPNT      PASS ADDRESS OF X-STRING
      JSB FIND       AND GO GET POINT DISPL.
      STA X+?PNT    POST IN COMMON
      STB LCOR+?X   POST X-STRING LGTH CORRECTION 
      CME 
      ERA           SAVE X-STRING POINT STATUS IN 
      STA PSTAT      IN PSTAT BIT 15. 
      LDA YPNT
      JSB FIND      FIND THE POINT IN Y=STRING
      STA Y+?PNT     AND POST IN COMMON.
      STB LCOR+?Y   POST Y-STRING LGTH CORRECTION 
      CME 
      ELA           SAVE Y-POINT STATUS IN 0
      IOR PSTAT      IN PSTAT BIT 0.
      STA PSTAT 
      JMP POINT,I   RETURN
      SKP 
* FIND THE DECIMAL POINT IN A STRING WHOSE POINTER IS IN (A): 
      SPC 1 
FIND  NOP           ENTRY/EXIT
      STA FSAVE     SAVE STRING ADDRESS 
      CCA 
      STA FLAG      FLAG=-1 
      STA PDISP     INITIAL DISPLACEMTN=-1
      CLA 
      STA INVCC     INVALID CHARACTER COUNT=0 
      LDA PFNDS     RESET 'POINT FOUND' SWITCH
      STA TRAP
      SPC 1 
FIND1 LDA FSAVE 
      JSB GETCR     FETCH NEXT CHARACTER
      JMP FIND2     END OF STRING 
TRAP  CPA =B56      DECIMAL POINT FOUND ? 
      ISZ FLAG      YES - BUMP FLAG TO 0
      JSB NUMCK     NO:  VERIFY THE DIGIT 
      JMP FIND4     INVALID DIGIT - COUNT IT
      CCA 
      CPA FLAG      FLAG STILL -1 ? 
      JMP FIND1     YES - CONTINUE
FINDC ISZ PDISP     NO - START COUNTING DIGITS
      NOP 
      JMP FIND1     CONTINUE UNTIL END OF STR.
      SPC 1 
FIND2 LDA PDISP     GET DISPLACEMENT
      LDB INVCC     RETURN INVALID CHAR. COUNT IN (B) 
      CLE,INA,SZA   POINT FOUND IN STRING ? 
      LDA PDISP     YES - RETURN DISPLACEMENT
      JMP FIND,I
      SPC 1 
FIND4 ISZ INVCC     BUMP INVALID CHAR. COUNT
      LDA FLAG      AT LEAST ONE POINT YET ?
      SZA 
      JMP FIND1     NO - IGNORE THE DIGIT 
      STA TRAP      YES - PREVENT COUNTING
      BSS 0          POINTS FROM NOW ON.
      JMP FINDC     GO BUMP POINT DISPL.
      HED ** PAD A STRING WITH ASCII ZERO <ZERO> ** 
* <ZERO> PADS A STRING WHOSE POINTER IS IN (A) WITH ASCII ZEROS,
* TO A LENGTH SPECIFIED BY A NUMBER IN (B) IN TWO'S COMPLEMENT. 
      SPC 1 
ZERO  NOP           ENTRY/EXIT
      STB LOOP1     SET LOOP COUNTER
      STA ADDR1      AND STRING ADDRESS.
      SPC 1 
ZERO1 LDA ADDR1     GET STRING ADDRESS AND
      LDB =B60       ASCII ZERO.
      JSB OUTCR     OUTPUT A CHARACTER
      ISZ LOOP1     FINFSHED ?
      JMP ZERO1     NO-CONTINUE 
      JMP ZERO,I    YES - RETURN
      HED ** ARGUMENT STRING ALIGNMENT ROUTINE <ALIGN> ** 
* <ALIGN> ALIGNS THE DECIMAL POINTS OF THE ARGUMENT STRINGS X 
* AND Y.  PADDING SWITCHES XPC AND YPC ARE SET SO AS TO CAUSE 
* ALIGNMENT OF THE STRINGS DURING ADDITION OR SUBTRACTION.
* IF ADJUSTED STRING LENGTH EXCEEDS 63 CHARACTERS, THE
* MESSAGE "11 OV" IS PRINTED ON THE TTY AND THE COMPUTER
* HALTS (HLT 1 - 102001 - IRRECOVERABLE). 
      SPC 1 
ALIGN NOP           ENTRY/EXIT POINT
      LDA X+.PNT.   GET PX
      CMA,INA       -PX 
      LDB LCOR+?X   GET PRESENT LENGTH CORRECTION 
      CMB,INB       -LCORX
      ADA B         FORM -PX-LCORX
      LDB X+.LEN.   GET -LX-1 
      CMB           LX
      ADA B         FORM LX-LCORX-PX
      STA DX        POST DIFFERENCE - DX
      SPC 1 
      LDA Y+.PNT.   GET PY
      CMA,INA       -PY 
      LDB LCOR+?Y   GET PRESENT Y LGTH CORRECTION 
      CMB,INB       -LCORY
      ADA B         -LCORY-PY 
      LDB Y+.LEN.   GET -LY-1 
      CMB           LY
      ADA B         FORM LY-LCORY-PY
      STA DY         AND POST Y DIFFERENCE - DY.
      SPC 1 
      LDA DX        GET X AND Y DIFFERENCES 
      LDB DY
      JSB IMAX      FORM (DX MAX DY)
      STA SAVE2     SAVE2=(DX MAX DY) 
      LDA X+.PNT.   GET PX AND PY 
      LDB Y+.PNT. 
      JSB IMAX      FORM (PX MAX PY)
      STA DISPL     P=(PX MAX PY) FOR ADD AND SUBTR.
      ADA SAVE2 
      STA LGTH      L=(DX MAX DY)+(PX MAX PY) 
      ADA MSIZE     TEST FOR STRING OVERFLOW
      SSA,RSS       LGTH > 63 ? 
      JMP ERRR2     YES - GO PRINT ERROR MSG. 
      LDB DX        GET DX
      CMB,INB       -DX 
      ADB SAVE2     (DX MAX DY)-DX
      CMB           FORM -(DX MAX DY)+DX-1
      STB PAD+?X    XPC=(-1-(DX MAX DY)+DX) 
      LDB DY        GET DY
      CMB,INB       -DY 
      ADB SAVE2 
      CMB 
      STB PAD+?Y    YPC=(-1-(DX MAX DY)+DY) 
      JMP ALIGN,I   RETURN
      SPC 1 
ERRR2 JSB .ERRR     PRINT STRING OVERFLOW 
      ASC 1,11
      ASC 1,OV       OVERFLOW ERROR MESSAGE.
      HLT 1 
%OVFL JMP *-1       FORCE IRRECOVERABLE HALT
      HED ** NUMERIC CHECK ROUTINE <NUMCK> ** 
* <NUMCK> ISOLATES A DECIMAL DIGIT FROM AN ASCII CHARACTER. 
* ENTER WITH THE CHARACTER IN (A), LEFT JUSTIFIED.
* IF NOT A VALID ASCII DIGIT (60-71 OCTAL) THE RETURN 
* IS P+1;  OTHERWISE P+2 WITH THE NUMERIC IN (A). 
      SPC 1 
NUMCK NOP           ENTRY/EXIT
      SZA,RSS       SPECIAL ENTRY FROM PADDING ?
      JMP NUMC1     YES - RETURN 0
      ADA =B-60     NO - DEMAND AN ASCII CHARACTER
      SSA           LESS THAN 60 OCTAL ?
      JMP NUMCK,I   YES - INVALID CHARACTER RETURN
      LDB =D-10 
      ADB A 
      SSB,RSS       GREATER THAN 10 ? 
      JMP NUMCK,I   YES - INVALID CHARACTER RETURN
      SPC 1 
NUMC1 ISZ NUMCK     YES - CHARACTER IS LEGAL
      JMP NUMCK,I   RETURN CHARACTER IN (A) 
      HED ** CHARACTER FETCH/STORE ROUTINES <GETCR,OUTCR> **
* <GETCR> FETCHES THE NEXT CHARACTER FROM A STRING WHOSE BUFFER 
* POINTER IS IN (A).  THE CHARACTER IS RETURNED IN (A), RIGHT 
* JUSTIFIED AND ISOLATED. 
      SPC 1 
GETCR NOP           ENTRY/EXIT POINT
      ISZ A,I       END OF STRING ? 
      RSS 
      JMP GETCR,I   YES - RETURN P+1
      INA 
      STA BADDR     POST BUFFER ADDRESS 
      LDB BADDR,I   GET CHARACTER ADDRESS 
      ISZ BADDR,I    AND BUMP FOR NEXT TIME.
      CLE,ERB       UPPER/LOWER FLAG TO (E) 
      LDA B,I       GET TWO CHARACTERS IN (A) 
      SEZ,RSS       UPPER CHARACTER ? 
      ALF,ALF       YES - POSITION IT 
      AND =B177     ISOLATE THE CHARACTER 
      ISZ GETCR     BUMP RETURN ADDRESS 
      JMP GETCR,I   RETURN P+2, CHAR. IN (A)
      SKP 
* <OUTCR> STORES A CHARACTER IN (B) IN A STRING WHOSE BUFFER
* POINTER IS IN (A).
      SPC 1 
OUTCR NOP           ENTRY/EXIT
      STB OUTCS     SAVE THE CHARACTER
      INA
      STA BADDR     POST CHARACTER ADDRESS
      LDB BADDR,I   GET WORD ADDRESS
      CLE,ERB       CHARACTER POSITION TO (E)
      ISZ BADDR,I   BUMP FOR NEXT TIME
      STB ADDR      POST ADDRESS OF CHARACTER PAIR
      SEZ           UPPER CHARACTER POSITION ?
      JMP OUTC1     NO - LOWER
      LDB OUTCS     YES - GET THE CHARACTER
      BLF,BLF       POSITION TO UPPER
      LDA ADDR,I    GET OLD PAIR
      AND =B177     MASK OUT OLD UPPER CHAR.
      IOR B          AND MERGE IN NEW ONE.
      STA ADDR,I    POST NEW PAIR
      JMP OUTCR,I   RETURN
      SPC 1
OUTC1 LDA ADDR,I    GET OLD PAIR
      AND =B77400   MASK OUT OLD LOWER CHAR.
      IOR OUTCS      AND MERGE IN NEW ONE.
      STA ADDR,I    POST NEW PAIR
      JMP OUTCR,I    AND RETURN 
      HED ** ADD/SUBTRACT/MULTIPLY INITIALIZATION <INIT> ** 
* <INIT> COMPUTES THE ARGUMENT STRING PSEUDO ADDRESSES AND LENGTHS
* FROM THE PARAMETERS IN THE CALLING SEQUENCE.  A POINTER TO THE
* THE PARAMETER ADDRESS SAVE AREA IS PASSED IN (B).  STRING 
* POINTER CONSIST OF A FOUR-WORD BLOCK OF COMMON STORAGE LAYED
* OUT AS FOLLOWS (EXAMPLE FOR X$ ONLY): 
      SPC 1 
* X+0     STRING LENGTH IN ONE'S COMPLEMENT 
* X+1     STRING ADDRESS TIMES 2
* X+2     POINT DISPLACEMENT OF X$ (NO. OF DIGITS RIGHT OF DEC.)
* X+3     SIGN OF X$ (0=PLUS, -1 =MINUS)
      SPC 1 
INIT  NOP           ENTRY/EXIT
      STB TEMP      SAVE PARAMETER LIST POINTER 
      LDA TEMP,I    GET X-STRING ADDRESS
      ALS           FORM PSEUDO ADDRESS 
      ISZ TEMP
      LDB TEMP,I
      ADA B,I       ADD IN OFFSET 
      STA X+?ADR    POST IN COMMON STORAGE
      ISZ TEMP
      LDB TEMP,I
      LDB B,I       GET X-STRING LENGTH 
      CMB 
      STB X+?LEN    POST -LEN(X)-1 IN COMMON
      ISZ TEMP
      SPC 1 
      LDA TEMP,I    GET Y-STRING ADDRESS
      ALS 
      ISZ TEMP
      LDB TEMP,I
      ADA B,I       ADD IN OFFSET 
      STA Y+?ADR    POST PSEUDO ADDRESS IN COMMON 
      ISZ TEMP
      LDB TEMP,I
      LDB B,I 
      CMB 
      STB Y+?LEN    POST Y-STRING LGTH. 
INITS JMP SETUP     GO INITIALIZE PRE AND POST- 
      BSS 0          PADDING SWITCHES.  THIS CODE 
      BSS 0           IS EXECUTED ONLY ONCE/LOAD. 
      JMP INIT,I    RETURN
      HED ** STRING ARITHMETIC ROUTINES - <SETUP> **
* <SETUP> SAVES THE ORIGINAL CONTENTS OF THE PRE- AND POST- 
* PADDING SWITCHES JMPI1-JMPI4 AND JSBI1-JSBI4.  THIS CODE
* IS EXECUTED ONLY ONCE PER LOADING.
      SPC 1 
SETUP CLA 
      STA INITS     PREVENT RE-EXECUTION IN THIS
      BSS 0          LOADING OF <STLIB>.
      LDA ADD3      SAVE PRE-PADDING SWITCHES 
      LDB ADD6       IN <IADD> ROUTINE. 
      DST JMPI1 
      LDA SUB2      ALSO IN <ISUB> ROUTINE
      LDB SUB5
      DST JMPI3 
      LDA ADD4+1    SAVE POST-PADDING SWITCHES
      LDB ADD7+1     IN <IADD> ROUTINE. 
      DST JSBI1 
      LDA SUB3+1    ALSO IN <ISUB>
      LDB SUB6+1
      DST JSBI3 
      LDA TRAP      SAVE 'POINT FOUND' FLAG 
      STA PFNDS 
      JMP INIT,I    RETURN THRU INIT ENTRY POINT
      HED ** CONSTANTS, STORAGE, EQUATES, LINKAGES, ETC. ** 
A     EQU 0         A/B REGISTER EQUATES
B     EQU 1 
.LEN. EQU 0         COMMON STORAGE LAYOUT EQUATES 
.PNT. EQU 2 
.SGN. EQU 3 
?LEN  EQU 0 
?ADR  EQU 1 
?PNT  EQU 2 
?SGN  EQU 3 
?X    EQU 0 
?Y    EQU 1 
SIZE  EQU 64        MAXIMUM RESULT STRING LENGTH
      SPC 1 
XLOC  DEF *+1       LOCAL STORAGE POINTER 
      BSS 2         X-STRING LGTH/ADDRESS 
YLOC  DEF *+1 
      BSS 2         Y-STRING LGTH/ADDRESS 
XPNT  DEF *+1       POINTERS FOR SUBROUTINES
      BSS 2 
YPNT  DEF *+1 
      BSS 2 
XADDR DEF X+?LEN    ADDRESS OF X COMMON BLOCK 
YADDR DEF Y+?LEN    ADDRESS OF Y COMMON BLOCK 
MSIZE ABS -SIZE     MAX. STRING LGTH - (NEGATIVE) 
CLAI  CLA           PRE-PADDING "ON" SWITCH 
JMPI1 JMP ADD4      PRE-PADDING "OFF" SWITCHES
JMPI2 JMP ADD7
JMPI3 JMP SUB3
JMPI4 JMP SUB6
JSBI1 JSB GETCR     POST-PADDING 'ON' SWITCHES
JSBI2 JSB GETCR 
JSBI3 JSB GETCR 
JSBI4 JSB GETCR 
SUPON SZB,RSS       ZERO SUPPRESSION "ON" SWITCH
SUPOF RSS           ZERO SUPPRESSION "OFF"
PFNDS CPA =B56      POINT FOUND SWITCH
ZARA  DEF Z         ADDRESS OF DECIMAL ARRAY
      SPC 1 
LOOP  BSS 1         TEMPORARY STORAGE LOCATIONS 
LOOP1 BSS 1 
SUM   BSS 1 
TEMP  BSS 1 
CARRY BSS 1 
DIFF  EQU SUM 
BORRO EQU CARRY 
XPAD  EQU PAD+?X
YPAD  EQU PAD+?Y
XVAL  BSS 1 
XLOOP BSS 1 
YLOOP BSS 1 
CHOUT EQU YLOOP 
INVCC EQU XLOOP 
OUTCS EQU GETCR
SAVE  BSS 1 
SAVE1 BSS 1 
SAVE2 BSS 1 
FSAVE BSS 1 
FLAG  BSS 1 
PDISP BSS 1 
LENTH BSS 1 
ZPNT  BSS 1 
PNT   BSS 1 
COUNT BSS 1 
BADDR BSS 1 
ADDR  BSS 1 
ADDR1 BSS 1 
DX    BSS 1 
DY    BSS 1 
PSTAT BSS 1 
      END 
