
ASMB,A,B,L,T,N
      IFN
      HED ***  MAGNETIC TAPE SYSTEM BOOTSTRAP, BOOT  ***     (JRW)
      XIF
      IFZ
      HED ***  "BOSS" SYSTEM BOOTSTRAP, BOOT  ***            (JRW)
      XIF
      ORG 00002B
      JMP SETUP     GO SET UP THE BOOTSTRAP.
      SPC 1
LIB.U EQU 010000B   LIBRARY UNIT NUMBER.
      SPC 1
      ORG 00077B
.77.  JSB .106.,I   STANDARD RETURN CALL TO IPL.
EXEC  JMP BEGIN     BEGIN MTS OPERATION.
BATCH BSS 1         BATCH INPUT DEVICE.
TYOUT BSS 1         SYSTEM TTY OUTPUT DEVICE.
      BSS 1         (SIO PUNCH DEVICE).
TYINP BSS 1         SYSTEM TTY INPUT DEVICE.
      DEF LWA       LAST WORD ADDRESS OF PROGRAM + 1.
.106. DEF IPL-1     ADDRESS OF RESIDENT IPL.
.107. BSS 1         MT DRIVER ENTRY POINT.
SSW   EQU 01B       SENSE SWITCH REGISTER.
BEGIN LIA SSW       LOAD THE :BATCH OPTION.
      STA A.OPT     SAVE THE SWITCH OPTIONS.
      AND .1B5      ISOLATE BIT 15.
      STA RES01,I   STORE THE :BATCH FLAG.
      JSB LINEF     GO ISSUE A LINE-FEED.
      JSB LINEF     GO ISSUE A LINE-FEED.
      LDA DEC38     LOAD THE MESSAGE LENGTH.
      LDB INITM     LOAD THE BUFFER ADDRESS.
      JSB TYOUT,I   TYPE THE INITIAL MESSAGE.
      JSB LINEF     GO ISSUE A LINE-FEED.
      JSB LINEF     GO ISSUE A LINE-FEED.
      LDA A.OPT     LOAD THE SWITCH OPTIONS.
      RAR,SLA,RAL   ARE THE OPTIONS TO BE LOGGED?
      IFN
      JMP RETRY     NO, CONTINUE.
      XIF
      IFZ
      JMP NOLOG     NO, CONTINUE.
      XIF
      SSA           YES; IS :BATCH OPTION ENABLED?
      JMP BAT.E     YES, CONTINUE.
      LDA DEC23     NO, LOAD: A=23.
      LDB D.BAT     LOAD THE OUTPUT BUFFER ADDRESS.
      JSB TYOUT,I   GO TO THE SYSTEM TTY DRIVER.
      IFN
      JMP LINF      GO ISSUE A LINE-FEED.
      XIF
      IFZ
      JMP AUX.S     GO TEST THE BUFFER OPTION.
      XIF
BAT.E LDA DEC22     LOAD: A=22.
      LDB E.BAT     LOAD THE OUTPUT BUFFER ADDRESS.
      JSB TYOUT,I   GO TO THE SYSTEM TTY DRIVER.
      IFZ
AUX.S LDA A.OPT     LOAD THE SWITCH OPTIONS.
      SLA           IS DISC TO HAVE TWO(2) BUFFERS?
      JMP BUF2      YES, CONTINUE.
      LDA DEC29     NO, LOAD: A=29.
      LDB BUF.1     LOAD THE OUTPUT BUFFER ADDRESS.
      JSB TYOUT,I   GO TO THE SYSTEM TTY DRIVER.
      JMP LINF      GO ISSUE A LINE-FEED.
BUF2  LDA DEC30     LOAD: A=30.
      LDB BUF.2     LOAD THE OUTPUT BUFFER ADDRESS.
      JSB TYOUT,I   GO TO THE SYSTEM TTY DRIVER.
      XIF
LINF  JSB LINEF     GO ISSUE A LINE-FEED.
      LIA SSW       LOAD THE SENSE SWITCH REGISTER.
      SZA,RSS       IS THE REGISTER ZERO(0)?
      IFN
      JMP LIN.F     YES, CONTINUE.
      XIF
      IFZ
      JMP PLOAD     YES, CONTINUE.
      XIF
      LDA DEC41     NO, LOAD: A=41.
      LDB SSW.M     LOAD THE OUTPUT BUFFER ADDRESS.
      JSB TYOUT,I   GO TO THE SYSTEM TTY DRIVER.
      IFZ
PLOAD LDA DEC31     LOAD: A=31.
      LDB INIT      LOAD THE OUTPUT BUFFER ADDRESS.
      JSB TYOUT,I   GO TO THE SYSTEM TTY DRIVER.
      XIF
LIN.F JSB LINEF     GO ISSUE A LINE-FEED.
      IFZ
NOLOG CLB           ENTER: B=0.
      LDA A.OPT     LOAD THE SWITCH OPTIONS.
      SLA           IS DISC TO HAVE TWO(2) BUFFERS?
      LDB AXDEF     YES, LOAD THE BUFFER ADDRESS.
      XIF
RETRY JSB .107.,I   GO TO THE MT DRIVER.
STATS EQU 000007B
      ABS 100000B+LIB.U+STATS STATUS REQUEST.
A     EQU 00000B    "A" REGISTER ADDRESS DEFINITION.
      IFN
      STB A         STORE THE STATUS WORD IN "A".
      AND .1401    ISOLATE THE LOCAL & BUSY BITS
      SZA           IS THE TAPE UNIT IN "LOCAL"?
      JMP LOCAL     YES, GO TYPE A MESSAGE.
      STB A         GET STATUS IN A
      AND BIT6      ISOLATE BOT BIT
      SZA,RSS       AT BOT?
      JMP LOCAL     NO. PRINT MESSAGE
      XIF
      IFZ
      CLA           ENTER: A=0.
      LDB A.OPT     LOAD THE SWITCH OPTIONS.
      SLB,RSS       IS DISC TO HAVE TWO(2) BUFFERS?
      JMP .77.      NO, GO BEGIN IPL PROCESSING.
      LDB S.RES     YES, LOAD PERMANENT LWA ADDRESS.
      STB X.RES,I   STORE THE RESIDENT REQUIREMENT.
      INB           CORRECT THE LWA PUNCH ADDRESS.
      STB X.ABS,I   STORE THE LWA FOR BCS PUNCHING.
      LDB .JMP.     LOAD THE RETURN JUMP.
      STB JMP,I     STORE THE RETURN JUMP.
      CLB           ENTER: B=0.
      STB BFLAG,I   INITIALIZE THE READ/WRITE FLAG.
      XIF
      JMP .77.      GO BEGIN IPL PROCESSING.
      SPC 1
LINEF NOP           ENTRY POINT.
      CLA           ENTER: A=0.
      JSB TYOUT,I   GO TO THE SYSTEM TTY DRIVER.
      JMP LINEF,I   RETURN.
      IFN
      SPC 2
LOCAL LDA DEC32     LOAD: A=32.
      LDB LCLM      LOAD THE MESSAGE BUFFER ADDRESS.
      JSB TYOUT,I   GO TO THE SYSTEM TTY DRIVER.
      JSB LINEF     GO ISSUE A LINE-FEED.
      JSB LINEF     GO ISSUE A LINE-FEED.
      HLT 44B       ALLOW OPERATOR TO FIX UNIT MODE.
      JMP RETRY     GO RECHECK THE TAPE UNIT STATUS.
      SPC 1
BIT6  OCT 100
.1401 OCT 1401
      XIF
      SPC 1
.1B5  OCT 100000    :BATCH FLAG MASK.
RES01 DEF .MTS.     ADDRESS DEFINITION:  :BATCH FLAG.
DEC41 DEC 41
SSW.M DEF *+1       OUTPUT BUFFER ADDRESS DEFINITION.
      ASC 19,*SET ALL SWITCH REGISTER BITS TO ZERO(
      ASC 2,0).
DEC22 DEC 22
E.BAT DEF *+1       OUTPUT BUFFER ADDRESS DEFINITION.
      ASC 11,*BATCH OPTION ENABLED.
DEC23 DEC 23
D.BAT DEF *+1       OUTPUT BUFFER ADDRESS DEFINITION.
      ASC 12,*BATCH OPTION DISABLED.
A.OPT NOP           SWITCH REGISTER OPTIONS.
INITM DEF *+1       INITIAL MESSAGE ADDRESS.
      IFN
      ASC 19,               HP MAGNETIC TAPE SYSTEM
DEC38 DEC 38        INITIAL MESSAGE LENGTH.
DEC32 DEC 32
LCLM  DEF *+1
      ASC 16,TAPE UNIT BUSY OR IN LOCAL MODE!
      XIF
      IFZ
      ASC 19,                  BOSS: BATCH OPERATED
      ASC 8, SOFTWARE SYSTEM
DEC38 DEC 54        INITIAL MESSAGE LENGTH.
DEC31 DEC 31
INIT  DEF *+1       OUTPUT BUFFER ADDRESS DEFINITION.
      ASC 16,*INITIALIZE WITH  :PROG,PRELOAD
DEC29 DEC 29
BUF.1 DEF *+1       OUTPUT BUFFER ADDRESS DEFINITION.
      ASC 15,*DISC ASSIGNED SINGLE BUFFER.
DEC30 DEC 30
BUF.2 DEF *+1       OUTPUT BUFFER ADDRESS DEFINITION.
      ASC 15,*DISC ASSIGNED TWO(2) BUFFERS.
S.RES DEF .IPL.-1   LAST WORD OF AVAILABLE MEMORY.
X.RES DEF .RES.     RESIDENT ADDRESS LOCATION.
X.ABS DEF .ABS.     LWA PUNCH LOCATION FOR BCS.
.JMP. NOP           JMP IPL
JMP   DEF J.IPL     ADDRESS OF JMP IPL
AXDEF DEF BUF       AUXILLARY BUFFER ADDRESS.
BFLAG DEF RD.WR     ADDRESS OF READ/WRITE FLAG.
      XIF
      SPC 1
LWA   EQU *
      SPC 1
SETUP LDA .107.     LOAD THE MT DRIVER ENTRY POINT.
      SZA,RSS       IS THE MT DRIVER PRESENT?
      JMP HLT07     NO, IRRECOVERABLE ERROR.
      STA MTSIO,I   YES, SAVE THE MT DRIVER ADDRESS.
      IFZ
      LDA JMP,I     LOAD JMP IPL
      STA .JMP.     STORE THE JMP IPL INSTRUCTION.
      XIF
      HLT 77B       END-OF-SETUP.
      JMP *-1       PROTECTED HALT!
      SPC 1
HLT07 HLT 07B       MISSING MT SIO DRIVER!
      JMP *-1       IRRECOVERABLE ERROR HALT.
      SPC 1
MTSIO DEF UNIT      INTERNAL MT SIO DRIVER ADDRESS.
      SKP
*     MTS INTER-PASS LOADER, NON-RESIDENT SEGMENT.
      SPC 1
KCORE EQU 30000B    16K MEMORY SIZE VERSION.
      SPC 1
      IFN
I.P.L EQU 00275B    NON-ESSENTIAL LOADER LENGTH.
      XIF
      IFZ
I.P.L EQU 01130B    IPL LENGTH.
      XIF
      ORG KCORE+06000B-I.P.L
      SPC 1
.IPL. EQU *
      SPC 1
      IFZ
J.IPL JMP IPL       GO TO RESIDENT IPL.
BUF   BSS 128       AUXILLARY DISC BUFFER.
RD.WR OCT 000000    READ/WRITE LAST OPERATION FLAG.
      XIF
      IFN
      LDA .B1,I     LOAD THE EXECUTION PHASE FLAG.
      XIF
      IFZ
      LDA B1        LOAD THE EXECUTION PHASE FLAG.
      XIF
      CLE,SZA       ENTER: E=0; CONTINUATION PHASE?
      JMP CONT.     YES, CONTINUE.
TERM. LDA ..MTS     LOAD THE S.SIO BUFFER ADDRESS.
      IFN
      STA .B1,I     SET UP "INDEX REGISTER" #1.
      JSB L.SIO,I   GO LOAD THE STANDARD DRIVERS.
      XIF
      IFZ
      STA B1        SET UP "INDEX REGISTER" #1.
      JSB LOAD0     GO LOAD THE STANDARD DRIVERS.
      XIF
      CLA           ENTER: A=0.
      STA 00002B    CLEAR THE "CS" FLAG WORD.
      STA 00003B    CLEAR THE "CL" FLAG WORD.
      IFN
      STA ENT,I     INITIALIZE PROGRAM ENTRY POINT.
      XIF
      IFZ
      STA ENTRY     INITIALIZE PROGRAM ENTRY POINT.
      XIF
EOT2  LDA .M2       YES; LOAD: A=-2.
      IFN
      STA .B4,I     INITIALIZE THE EOT COUNTER.
NEXTS LDA SIO,I     LOAD THE :BATCH FLAG.
      XIF
      IFZ
      STA B4        INITIALIZE THE EOT COUNTER.
NEXTS LDA .MTS.     LOAD THE :BATCH FLAG.
      XIF
      SLA,RSS       IS MTS IN THE :BATCH MODE?
      JMP TYPE      NO, INPUT FROM THE SYSTEM TTY.
      LDA DEC72     YES, LOAD: A=72.
      LDB STATE     LOAD THE CONTROL INPUT ADDRESS.
      JSB BATCH,I   GO TO THE SYSTEM :BATCH DRIVER.
      SZA,RSS       WAS A CONTROL INPUT READ?
      JMP EOT       NO, GO CHECK THE EOT COUNTER.
      IFN
      STA .LENG,I   YES, SAVE THE STATEMENT LENGTH.
      LDA STATE,I   LOAD THE FIRST STATEMENT WORD.
      XIF
      IFZ
      STA LENG.     YES, SAVE THE STATEMENT LENGTH.
      LDA IMAGE+1   LOAD THE FIRST STATEMENT WORD.
      XIF
      AND UP.8      ISOLATE THE FIRST CHARACTER.
      CPA COLON     WAS COLUMN 1 A COLON(:)?
      RSS           YES, SKIP.
      JMP NEXTS     NO, GO READ THE NEXT STATEMENT.
      IFN
      LDA .LENG,I   LOAD THE STATEMENT LENGTH.
      XIF
      IFZ
      LDA LENG.     LOAD THE STATEMENT LENGTH.
      XIF
      LDB STATE     LOAD THE INPUT BUFFER ADDRESS.
      JSB TYOUT,I   GO TO THE SYSTEM TTY DRIVER.
      IFN
      LDA .LENG,I   RESTORE THE STATEMENT LENGTH.
      XIF
      IFZ
      LDA LENG.     RESTORE THE STATEMENT LENGTH.
      XIF
      JMP CHECK     GO DETERMINE THE STATEMENT TYPE.
      SPC 2
CONT. CLB           ENTER: B=0.
      CPA .M1       PASS 2 OF FORTRAN, CONTINUATION?
      LDB FTN2      YES, LOAD THE REFERENCE TO FTN2.
      CPA .M2       ASSEMBLER CONTINUATION?
      LDB X.REF     YES, LOAD THE REFERENCE TO X-REF.
      CPA .M3       GENERAL PURPOSE SEGMENT LINK?
      IFN
      LDB IPL.1,I   YES, LOAD REFERENCE TO SEGMENT.
      XIF
      IFZ
      LDB B6        YES, LOAD REFERENCE TO SEGMENT.
      XIF
      CLE,SZB,RSS   WAS THE CONTINUATION CODE LEGAL?
      JMP TERM.     NO, GO TO THE TERMINATION PHASE.
      IFN
      STB .B1,I     YES, SAVE THE REFERENCE ADDRESS.
      LDA .BLAN     LOAD A LOWER WORD BLANK.
      STA .B6,I     INITIALIZE "INDEX REGISTER" 6.
      JMP CONT,I    GO LOAD THE CONTINUATION ROUTINE.
      XIF
      IFZ
      STB B1        YES, SAVE THE REFERENCE ADDRESS.
      LDA BLANK     LOAD A LOWER WORD BLANK.
      STA B6        INITIALIZE "INDEX REGISTER" 6.
      JMP .CONT     GO LOAD THE CONTINUATION ROUTINE.
      XIF
      SPC 2
TYPE  LDA DEC6      LOAD: A=6.
      LDB STAR      LOAD THE ASTERISK(*) ADDRESS.
      JSB TYOUT,I   GO TO THE SYSTEM TTY DRIVER.
      LDA DEC72     LOAD THE INPUT BUFFER LENGTH.
      LDB STATE     LOAD THE INPUT BUFFER ADDRESS.
      JSB TYINP,I   GO TO THE SYSTEM TTY DRIVER.
      SZA,RSS       WAS A CONTROL INPUT READ?
      JMP EOT       NO, GO CHECK THE EOT COUNTER.
      IFN
      STA .LENG,I   YES, SAVE THE STATEMENT LENGTH.
      XIF
      IFZ
      STA LENG.     YES, SAVE THE STATEMENT LENGTH.
      XIF
CHECK CMA,INA       LET A = -A.
      IFN
      STA .B4,I     STORE NEGATIVE STATEMENT LENGTH.
      XIF
      IFZ
      STA B4        STORE NEGATIVE STATEMENT LENGTH.
      XIF
      LDB STATE     LOAD THE INPUT BUFFER ADDRESS.
      IFN
      STB .B1,I     SET UP "INDEX REGISTER" #1.
      XIF
      IFZ
      STB B1        SET UP "INDEX REGISTER" #1.
      XIF
      LDA .M3       LOAD: A=-3.
      LDB PROG      LOAD: B= :PROG REFERENCE ADDRESS.
      IFN
      JSB IDENT,I   GO CHECK FOR A :PROG STATEMENT.
      XIF
      IFZ
      JSB MATCH     GO CHECK FOR A :PROG STATEMENT.
      XIF
      JMP .PROG     :PROG STATEMENT; GO BEGIN SCAN.
      SPC 1
      LDA .M3       LOAD: A=-3.
      LDB .PAUS     LOAD :PAUSE REFERENCE ADDRESS.
      IFN
      JSB IDENT,I   GO CHECK FOR A :PAUSE STATEMENT.
      XIF
      IFZ
      JSB MATCH     GO CHECK FOR A :PAUSE STATEMENT.
      XIF
      JSB SPACE     GO CHECK FOR A SPACE OR THE EOR.
      JMP .TYPE     NOT :PAUSE SO CHECK FOR :TYPE
      HLT 77B       PAUSE 77
      JMP EOT2      GO READ THE NEXT STATEMENT.
      SPC 2
      IFN
EOT   ISZ .B4,I     IS THIS A POSSIBLE EOT?
      XIF
      IFZ
EOT   ISZ B4        IS THIS A POSSIBLE EOT?
      XIF
      JMP NEXTS     NO, GO READ THE NEXT STATEMENT.
      HLT 02B       YES, WAIT FOR THE OPERATOR.
      JMP EOT2      GO READ THE NEXT STATEMENT.
      SPC 2
      IFN
.PROG LDA .B4,I     LOAD: -(STATEMENT LENGTH).
      XIF
      IFZ
.PROG LDA B4        LOAD: -(STATEMENT LENGTH).
      XIF
      ADA DEC6      REDUCE LENGTH BY SIX(6).
      CLE,SSA,RSS   IS THE STATEMENT > 6 CHARACTERS?
      IFN
      JMP ERR,I     NO, STATEMENT ERROR.
      STA .B4,I     STORE CORRECTED STATEMENT LENGTH.
      JMP LNEXT,I   GO SCAN THE STATEMENT.
      XIF
      IFZ
      JMP INERR     NO, STATEMENT ERROR.
      STA B4        STORE CORRECTED STATEMENT LENGTH.
      JMP NEXTL     GO SCAN THE STATEMENT.
      XIF
      SPC 2
.TYPE LDA .M3       LOAD: A=-3.
      LDB TY        LOAD: B= :TYPE REFERENCE ADDRESS.
      IFN
      JSB IDENT,I   GO CHECK FOR A :TYPE STATEMENT.
      XIF
      IFZ
      JSB MATCH     GO CHECK FOR A :TYPE STATEMENT.
      XIF
      RSS           :TYPE STATEMENT; SKIP.
      JMP .BA       NOT :TYPE SO GO CHECK FOR :BATCH
      IFN
      LDA SIO,I     LOAD THE :BATCH FLAG.
      XIF
      IFZ
      LDA .MTS.     LOAD THE :BATCH FLAG.
      XIF
      SLA,RSS       IS MTS IN THE :BATCH MODE?
      IFN
      JMP ERR,I     NO, STATEMENT ERROR.
      XIF
      IFZ
      JMP INERR     NO, STATEMENT ERROR.
      XIF
      CLA           YES, ENTER: A=0.
      JSB TYOUT,I   GO TO THE SYSTEM TTY DRIVER.
      IFN
      LDA SIO,I     LOAD THE :BATCH FLAG.
      XIF
      IFZ
      LDA .MTS.     LOAD THE :BATCH FLAG.
      XIF
      ERA,CLE,ELA   CHANGE TO :TYPE MODE.
      IFN
RESET STA SIO,I     STORE THE NEW :BATCH FLAG.
      XIF
      IFZ
RESET STA .MTS.     STORE THE NEW :BATCH FLAG.
      XIF
      JMP EOT2      GO READ THE NEXT STATEMENT.
      SPC 2
.BA   LDA .M3       LOAD: A=-3.
      LDB BA        LOAD :BATCH REFERENCE ADDRESS.
      IFN
      JSB IDENT,I   GO CHECK FOR A :BATCH STATEMENT.
      XIF
      IFZ
      JSB MATCH     GO CHECK FOR A :BATCH STATEMENT.
      XIF
      JSB SPACE     GO CHECK FOR A SPACE OR THE EOR.
      JMP .CO       NOT :BATCH SO CHECK FOR :COMMENT
      IFN
      LDA SIO,I     LOAD THE :BATCH FLAG.
      XIF
      IFZ
      LDA .MTS.     LOAD THE :BATCH FLAG.
      XIF
      SSA           IS :BATCH MODE ALLOWED?
      SLA,INA       YES; IF IN :TYPE MODE, SET FLAG!
      IFN
      JMP ERR,I     NO; :BATCH STATEMENT IS ILLEGAL!
      XIF
      IFZ
      JMP INERR     NO; :BATCH STATEMENT IS ILLEGAL!
      XIF
      JMP RESET     GO SET THE :BATCH FLAG.
      SPC 2
.CO   LDA .M4       LOAD: A=-4.
      LDB CO        LOAD :COMMENT REFERENCE ADDRESS.
      IFN
      JSB IDENT,I   GO CHECK FOR :COMMENT STATEMENT.
      XIF
      IFZ
      JSB MATCH     GO CHECK FOR :COMMENT STATEMENT.
      XIF
      RSS           :COMMENT STATEMENT; SKIP.
      IFN
      JMP ERR,I     UNKNOWN STATEMENT; ERROR.
      LDA END.C,I   LOAD THE ENDING COMMA(,) WORD.
      XIF
      IFZ
      JMP INERR     UNKNOWN STATEMENT; ERROR.
      LDA ENDCO     LOAD THE ENDING COMMA(,) WORD.
      XIF
      AND UP.8      MASK OFF THE UPPER CHARACTER.
      CPA COMMA     IS THE COMMA(,) THERE?
      JMP EOT2      YES, GO READ THE NEXT STATEMENT.
      IFN
      JMP ERR,I     NO, ILLEGAL STATEMENT; ERROR.
      XIF
      IFZ
      JMP INERR     NO, ILLEGAL STATEMENT; ERROR.
      XIF
      SPC 2
SPACE NOP           ENTRY POINT.
      ISZ SPACE     SKIP EXIT.
      IFN
      LDA .LENG,I   LOAD THE STATEMENT LENGTH.
      XIF
      IFZ
      LDA LENG.     LOAD THE STATEMENT LENGTH.
      XIF
      CPA DEC6      IS THE STATEMENT SCANNED?
      JMP SPACE,I   YES; LEGAL STATEMENT; RETURN.
      IFN
      LDA NAM,I     NO, LOAD THE LAST STATEMENT WORD.
      XIF
      IFZ
      LDA NAME      NO, LOAD THE LAST STATEMENT WORD.
      XIF
      AND UP.8      MASK OFF THE UPPER CHARACTER.
      CPA BLNK      IS THE CHARACTER A BLANK( )?
      JMP SPACE,I   YES; LEGAL STATEMENT; RETURN.
      IFN
      JMP ERR,I     NO; ILLEGAL STATEMENT; ERROR.
      XIF
      IFZ
      JMP INERR     NO; ILLEGAL STATEMENT; ERROR.
      XIF
      SPC 2
      IFN
ERR   DEF INERR     INPUT STATEMENT ERROR ROUTINE.
LNEXT DEF NEXTL     ADDRESS DEFINITION OF SCANNER.
CONT  DEF .CONT
L.SIO DEF LOAD0
IDENT DEF MATCH
ENT   DEF ENTRY
NAM   DEF NAME
END.C DEF ENDCO
.LENG DEF LENG.
SIO   DEF .MTS.
.B1   DEF B1        "INDEX REGISTER" #1, ADDRESS.
.B4   DEF B4        "INDEX REGISTER" #4, ADDRESS.
.B6   DEF B6        "INDEX REGISTER" #6, ADDRESS.
.BLAN CLE
IPL.1 DEF IPL-1     ADDRESS DEFINITION OF SEGMENT.
      SPC 1
      XIF
.PAUS DEF PAUSE+1
STATE DEF IMAGE+1
      SPC 1
.M1   DEC -1
.M2   DEC -2
.M3   DEC -3
.M4   DEC -4
DEC6 DEC 6
DEC72 DEC 72        CONTROL INPUT BUFFER LENGTH.
      SPC 1
BLNK  OCT 020000
COMMA OCT 026000    ,
COLON OCT 035000    :
UP.8  OCT 177400    UPPER CHARACTER MASK.
      SPC 2
TY    DEF *+1
      ASC 3,:TYPE
BA    DEF *+1
      ASC 3,:BATCH
CO    DEF *+1
      ASC 5,:COMMENT,
FTN2  DEF FTN2.
X.REF DEF XREF.
STAR  DEF STAR.
PROG  DEF PROG.
..MTS DEF *+1
      ASC 5,S.SIO
FTN2. ASC 5,FTN2
XREF. ASC 5,X-REF
STAR. ASC 3,*NEXT?
PROG. ASC 3,:PROG,
      SKP
*     S.A. OF THE IPL MUST BE: X6000B.
      SPC 1
      IFN
      ORG KCORE+06000B
      XIF
I.O   LDA B5        LOAD THE CURRENT SCAN ADDRESS.
      CLE,ERA       RESTORE "E"; UPPER/LOWER FLAG.
      STA B2        STORE THE CURRENT SCAN ADDRESS.
      CCA           ENTER: A=-1.
      STA B1        SET THE FLAG FOR A "BOOT" CALL.
      SPC 1
NEXTL LDA ASMBN     LOAD THE ASSEMBLY BUFFER ADDRESS.
      STA B5        SET UP "INDEX REGISTER" #5.
      LDA .M5       LOAD: A=-5.
      STA B3        SET UP "INDEX REGISTER" #3.
      LDA BLNKS     LOAD "A" WITH TWO(2) SPACES(  ).
ST.BL STA B5,I      STORE BLANKS IN ASSEMBLY BUFFER.
      ISZ B5        INCREMENT THE BUFFER ADDRESS.
      ISZ B3        IS THE BUFFER BLANKED OUT?
      JMP ST.BL     NO, GO BLANK THE NEXT WORD.
      LDA .M11      LOAD: A=-11.
      STA B3        STORE THE SCAN LIMIT.
      LDB ASMBN-1   LOAD THE ASSEMBLY BUFFER ADDRESS.
      RBL           SET BIT 0 TO ZERO(0).
SCAN  LDA B2,I      LOAD THE NEXT STATEMENT WORD.
      SEZ,CME,RSS   IS THE NEXT CHARACTER LOWER?
      ALF,ALF       NO, SHIFT UPPER TO BITS 7-0.
      AND .377      ISOLATE THE CHARACTER.
      SEZ,RSS       IS THE CURRENT WORD EXHAUSTED?
      ISZ B2        YES, INCREMENT STATEMENT ADDRESS.
      CPA COMM.     IS THE CHARACTER A COMMA(,)?
      LDA SEMIC     YES, LOAD A SEMI-COLON(;).
      CPA SEMIC     IS THE CHARACTER A SEMI-COLON?
      ISZ B4        YES; IS THE STATEMENT EXHAUSTED?
      CPA BLANK     NO; IS THE CHARACTER A BLANK( )?
      JMP ENDS.-1   YES, END-OF-STATEMENT.
      CPA SEMIC     NO; IS IT A SEMI-COLON(;)?
      JMP ENDS.     YES, END OF PROGRAM-NAME.
      CPA SLASH     NO; IS THE CHARACTER A SLASH(/)?
      JMP ENDS.     YES, END-OF-STATEMENT.
      SLB,INB,RSS   NO; DOES THIS FILL THE WORD?
      JMP UPPER     NO, GO SAVE THE CHARACTER.
      IOR B5        YES, INCLUDE THE UPPER CHARACTER.
      RBR           RESTORE THE ADDRESS FORMAT.
B     EQU 00001B    "B" REGISTER ADDRESS DEFINITION.
      STA B,I       STORE THE FULL-WORD.
      RBL           PREPARE FOR THE NEXT CHARACTER.
LIMIT ISZ B3        HAVE 11 CHARACTERS BEEN SCANNED?
      RSS           NO; SKIP.
      JMP INERR     YES; STATEMENT ERROR.
      ISZ B4        IS THE STATEMENT EXHAUSTED?
      JMP SCAN      NO, CONTINUE.
      LDA BLANK     YES, LOAD A BLANK( ) TERMINATOR.
ENDS. STA B6        STORE THE STATEMENT TERMINATOR.
      LDA B3        LOAD THE SCAN COUNT.
      CPA .M11      WAS A PROGRAM-NAME GIVEN?
      JMP INERR     NO; STATEMENT ERROR.
      SLB,INB,RSS   YES; IS THERE A HALF-WORD LEFT?
      JMP SAVE      NO, CONTINUE.
      LDA B5        YES, LOAD THE HALF-WORD.
      IOR BLANK     INCLUDE A LOWER BLANK( ).
      RBR           RESTORE THE ADDRESS FORMAT.
      STA B,I       STORE THE FULL-WORD.
SAVE  LDA B2        LOAD THE SCANNER POINTER.
      ELA           SAVE "E" IN BIT 0.
      STA B5        SAVE THE CHARACTER ADDRESS.
      LDA ASMBN     LOAD THE ASSEMBLY BUFFER ADDRESS.
      STA B1        SET UP "INDEX REGISTER" #1.
      JSB LOAD0     GO LOAD THE PROGRAM.
      LDA B6        LOAD THE STATEMENT TERMINATOR.
      CPA SEMIC     IS THERE ANOTHER PROGRAM-NAME?
      JMP I.O       YES; GO SCAN THE NEXT NAME.
      JSB UNIT,I    NO; GO TO THE MT SIO DRIVER.
REWND EQU 000003B
      ABS LIB.U+REWND REWIND REQUEST.
STARC LDA .RES.     LOAD THE IPL RETURN ADDRESS.
      STA .106.     RESTORE LOCATION 00106B.
      LDA UNIT      LOAD THE MT DRIVER ENTRY POINT.
      STA .107.     RESTORE LOCATION 00107B.
      CLC 00B,C     TURN OFF THE INTERRUPT SYSTEM.
      LDA B6        RELOAD THE STATEMENT TERMINATOR.
      CPA BLANK     IS A SET-UP PAUSE DESIRED?
      JMP START     NO, CONTINUE.
      LDA ENTRY     YES; LOAD THE EXECUTION S.A..
      CPA TWO2      IS THE PROGRAM BCS RELATED?
      JMP HLT00     YES, DO NOT PRINT :PAUSE
      LDA .DEC6     NO; LOAD: A=6.
      LDB PAUSE     LOAD :PAUSE REFERENCE ADDRESS.
      JSB TYOUT,I   GO TO THE SYSTEM TTY DRIVER.
HLT00 HLT 00B       PAUSE 00
START LDB JSB       LOAD THE RETURN JUMP.
      LDA ENTRY     LOAD THE PROGRAM S.A..
      AND B076      REMOVE BASE PAGE ADDRESS BITS.
      SZA           IS THE PROGRAM S.A. > 01777B?
      JMP BCS       YES, ASSUME NO :BATCH S.A..
      STB .77.      NO, STORE THE MTS ABORT ADDRESS.
      LDA TWO2      LOAD: A=00002B.
      CPA ENTRY     IS THE PROGRAM S.A. = 00002B?
      JMP BCS       YES, ASSUME BCS LOADR.
      LDA .MTS.     NO; LOAD THE :BATCH FLAG.
DEC8  SLA           IS MTS IN :BATCH MODE?
      JMP EXEC      YES, ASSUME PROGRAM S.A. = 100B.
BCS   CCA           NO; ENTER: A=-1.
      ADA ENTRY     CALCULATE: PROGRAM S.A.-1.
      STB A,I       STORE THE "JSB" RETURN CALL.
      LDA .ABS.     LOAD THE BCS LWA PUNCH ADDRESS.
      JMP ENTRY,I   BEGIN PROGRAM EXECUTION.
      SPC 2
UPPER ALF,ALF       SHIFT THE CHARACTER TO BITS 15-8.
      STA B5        SAVE THE HALF-WORD.
      JMP LIMIT     GO CHECK FOR END-OF-STATEMENT.
      SPC 2
LOAD0 NOP           ENTRY POINT.
NEXTR JSB LOAD1     GO LOAD AN ADDRESS RECORD.
      JMP ERROR     MT ERROR, RETRY LOADING.
      LDA .M5       LOAD: A=-5.
      LDB LOADR     LOAD ADDRESS RECORD ADDRESS.
      JSB MATCH     GO CHECK THE PROGRAM I.D. NAME.
      JMP LOADC     THE PROGRAM HAS BEEN FOUND.
      JSB LOAD1     SKIP TO THE NEXT ADDRESS RECORD.
      JMP NONAM     MT ERROR IN STRUCTURE OR PARITY.
      JMP NEXTR     GO LOAD THE NEXT ADDRESS RECORD.
      SPC 1
LOADC LDA S.A.      LOAD THE PROGRAM S.A..
      LDB ENTRY     LOAD THE EXECUTION S.A..
      SZB,RSS       IS AN S.A. IN HAND?
      STA ENTRY     NO, STORE THE PROGRAM S.A..
L2    JSB LOAD2     LOAD THE PROGRAM RECORD.
      JMP ERROR     MT ERROR, RETRY LOADING.
      JSB LOAD1     LOAD THE NEXT ADDRESS RECORD.
      JMP ERROR     MT ERROR, RETRY LOADING.
      LDA S.A.      LOAD THE PROGRAM S.A..
      SZA,RSS       IS THIS A CONTINUATION RECORD?
      JMP L2        YES, CONTINUE LOADING.
      CLA           NO; ENTER: A=0.
      CCB           ENTER: B=-1.
      JSB UNIT,I    GO TO THE MT DRIVER.
POS   EQU 000004B
      ABS LIB.U+POS POSITION REQUEST.
      JMP ERROR     MT ERROR, RETRY LOADING.
      JMP ERROR     MT ERROR, RETRY LOADING.
      JMP LOAD0,I   RETURN.
      SPC 2
MATCH NOP           ENTRY POINT.
      STB B3        STORE THE REFERENCE ADDRESS.
      LDB B1        LOAD UNKNOWN STATEMENT ADDRESS.
      STB B2        SET UP "INDEX REGISTER" #2.
NWORD LDB B2,I      LOAD THE UNKNOWN WORD.
      CPB B3,I      DOES IT MATCH THE REFERENCE WORD.
      JMP NEXTW     YES, GO PREPARE FOR NEXT WORD.
      ISZ MATCH     NO, SKIP EXIT.
      JMP MATCH,I   RETURN.
      SPC 1
NEXTW ISZ B2        INCREMENT "UNKNOWN" ADDRESS.
      INA,SZA,RSS   IS THE MATCH COMPLETED?
      JMP MATCH,I   YES, RETURN.
      ISZ B3        NO, INCREMENT REFERENCE ADDRESS.
      JMP NWORD     GO MATCH THE NEXT WORD.
      SPC 2
ERROR LDA ENTRY     LOAD THE EXECUTION S.A..
      CPA TWO2      WAS THE PROGRAM BCS RELATED?
      JMP HLT11     YES, DO NOT PRINT MESSAGE.
      CLA           NO; ENTER: A=0.
      JSB TYOUT,I   GO TO THE SYSTEM TTY DRIVER.
      LDA DEC8      LOAD: A=8.
      LDB L01       LOAD THE DIAGNOSTIC ADDRESS.
      JSB TYOUT,I   GO TO THE SYSTEM TTY DRIVER.
      CLA           ENTER: A=0.
      JSB TYOUT,I   GO TO THE SYSTEM TTY DRIVER.
HLT11 HLT 11B       STOP 11
      CLA           ENTER: A=0.
      JMP IPL       GO RELOAD THE SYSTEM.
      SPC 2
NONAM CCA           ENTER: A=-1.
      STA B1        SET THE FLAG FOR A "BOOT" CALL.
INERR LDB .MTS.     LOAD THE :BATCH FLAG.
      LDA ENTRY     LOAD THE EXECUTION S.A..
      CPA TWO2      WAS THE PROGRAM BCS RELATED?
      JMP NOTYP     YES, DO NOT PRINT.
      SLB,RSS       NO; IS MTS IN :BATCH MODE?
      JMP NO.LF     NO, DO NOT SINGLE SPACE.
      CLA           ENTER: A=0.
      JSB TYOUT,I   GO TO THE SYSTEM TTY DRIVER.
NO.LF LDA DEC8      LOAD THE MESSAGE LENGTH.
      LDB L02       LOAD THE DIAGNOSTIC ADDRESS.
      JSB TYOUT,I   GO PRINT THE DIAGNOSTIC.
      CLA           ENTER: A=0.
      JSB TYOUT,I   GO TO THE SYSTEM TTY DRIVER.
NOTYP LDA .MTS.     LOAD THE :BATCH FLAG.
SEMIC CLE,SLA,RAR   ;; IS MTS IN THE :BATCH MODE?
      HLT 01B       YES, LET THE OPERATOR FIX CARD.
      ISZ B1        WAS PROGRAM LOADING IN PROGRESS?
      IFN
      JMP SNEXT,I   NO, GO READ THE NEXT STATEMENT.
      XIF
      IFZ
      JMP EOT2      NO, GO READ THE NEXT STATEMENT.
      XIF
      JMP BOOT      YES, GO RELOAD THE SYSTEM.
      SPC 2
BLNKS ASC 1,
      SPC 1
BLANK CLE
COMM. OCT 000054    ,
SLASH OCT 000057    /
      SPC 1
TWO2  ABS 00002B    BCS, LOADR STARTING ADDRESS.
JSB   JSB .106.,I   PROGRAM STARTING ADDRESS - 1.
      IFN
.RES. DEF IPL-1     LOCATION 00106B.
.ABS. DEF I.O       BCS LWA PUNCH ADDRESS.
SNEXT DEF EOT2      NEXT STATEMENT ROUTINE.
      XIF
      SPC 1
.M5   DEC -5
.M11  DEC -11
.DEC6 DEC 6
.377  OCT 000377    LOWER CHARACTER MASK.
B076  OCT 076000    MASK TO REMOVE BASE PAGE ADDRESS.
      SPC 1
ENTRY OCT 000000    PROGRAM STARTING ADDRESS.
      SPC 1
L01   DEF *+1       MT PARITY OR EOF ERROR!
      IFN
      ASC 4,*TP ERR*
      XIF
      IFZ
      ASC 4,*DF ERR*
      XIF
L02   DEF *+1       CONTROL STATEMENT INPUT ERROR!
      ASC 4,*CS ERR*
PAUSE DEF *+1
      ASC 3,:PAUSE
      DEF ASMBN
ASMBN DEF *+1       I.D. NAME ASSEMBLY BUFFER.
.CONT JSB LOAD0     GO LOAD THE CONTINUATION ROUTINE.
      JMP STARC     GO BEGIN PROGRAM EXECUTION.
      SPC 1
      ASC 3,
      SPC 1
IMAGE DEF *+1       CONTROL INPUT BUFFER.
      BSS 3         CONTROL STATEMENT NAME.
NAME  BSS 1         BEGINNING OF I.D. NAME.
ENDCO BSS 32        END OF COMMENT COMMAND STATEMENT.
      SPC 1
LENG. BSS 1         INPUT CONTROL STATEMENT LENGTH.
      SPC 2
*     LOADER ADDRESS RECORD.
      SPC 1
ID    BSS 5         I.D. NAME.
S.A.  BSS 1         STARTING ADDRESS.
BUFFL BSS 1         RECORD LENGTH.
LOADA BSS 1         LOAD ADDRESS.
      SPC 2
B1    BSS 1         "INDEX REGISTER" NUMBER 1.
B2    BSS 1         "INDEX REGISTER" NUMBER 2.
B3    BSS 1         "INDEX REGISTER" NUMBER 3.
B4    BSS 1         "INDEX REGISTER" NUMBER 4.
B5    BSS 1         "INDEX REGISTER" NUMBER 5.
B6    BSS 1         "INDEX REGISTER" NUMBER 6.
      SKP
*     MTS INTER-PASS LOADER, RESIDENT SEGMENT.
      SPC 1
      IFN
RESID EQU 00037B    RESIDENT IPL LENGTH.
      ORG KCORE+06470B-RESID
      XIF
      SPC 1
IPL   EQU *
      CLC 00B,C     TURN OFF THE INTERRUPT SYSTEM.
      STA B1        SAVE THE SYSTEM REQUEST CODE.
BOOT  JSB UNIT,I    GO TO THE MT DRIVER.
      ABS LIB.U+REWND REWIND REQUEST.
      JSB LOAD1     LOAD THE ADDRESS RECORD.
      JMP BOOT      RETRY ON MT ERROR.
      JSB LOAD2     LOAD THE PROGRAM RECORD.
      JMP BOOT      RETRY ON MT ERROR.
      JMP LOADA,I   BEGIN THE IPL PHASE.
      SPC 2
LOAD1 NOP           ENTRY POINT.
      LDA MDEC8     LOAD: A=-8 (WORDS).
      LDB LOADR     LOAD THE BUFFER ADDRESS.
      JSB UNIT,I    GO TO THE MT DRIVER.
READ  EQU 000000B
      ABS LIB.U+READ READ REQUEST.
      JMP LOAD1,I   ERROR RETURN.
      JMP LOAD1,I   ERROR RETURN.
      ISZ LOAD1     SKIP EXIT.
      JMP LOAD1,I   RETURN.
      SPC 2
LOAD2 NOP           ENTRY POINT.
      LDA BUFFL     LOAD THE RECORD LENGTH.
      LDB LOADA     LOAD THE BUFFER ADDRESS.
      JSB UNIT,I    GO TO THE MT DRIVER.
      ABS LIB.U+READ READ REQUEST.
      JMP LOAD2,I   ERROR RETURN.
      JMP LOAD2,I   ERROR RETURN.
      ISZ LOAD2     SKIP EXIT.
      JMP LOAD2,I   RETURN.
      SPC 2
MDEC8 DEC -8        LOADER ADDRESS RECORD LENGTH.
LOADR DEF ID
      IFZ
.RES. DEF IPL-1     LOCATION 00106B.
.ABS. DEF I.O       BCS LWA PUNCH ADDRESS.
      XIF
.MTS. BSS 1         :BATCH AVAILABILITY FLAG.
UNIT  BSS 1         MT SIO DRIVER ENTRY POINT.
      SPC 1
*     L.W.A. OF THE IPL MUST BE: X6467.
      SPC 1
      END
                                                                                                                                                                  20595-80001 B                                                                                                                                                                                                                                                                                                                                                                                                                  