ASMB,R,L,B,T,C
      HED  A-05470-94058-1 REV.C  OPT70-73 DTAD0  ERS & LIST
      NAM DTAD0 
* 
*  REV C CORRECTS THE ERRORS SPECIFIED IN BUG 
*        REPORTS #7, #21, #50, #56
*  #7: FIXED SYSTEM RUN WITH LARGER CORESIZE ASSIGNS
*      DATA THROUGH IOC, I.E. IOC IS WIPED OUT. 
*  #21: OVERLAY OF EXACT SIZE OF PREVIOUS OVERLAY 
*       WOULD NOT CAUSE RECOMPUTATION OF CONSTANTS. 
*  #50: DTAD0 SYMBOL & LOAD ADDRESS DIFFERENT.
*  #56: SW-REG NOT CLEARED MAY CAUSE PUNCH OF MSG 
*       FROM DTAD0.  SW-WORD CLEARED ON 2100. 
* 
*  FEATURE ADDED TO DTAD0 IN REV C: 
*     Y-COMMAND TO MODIFY PROG STACK LENGTH IS
*         INCLUDED IN DTAD0.
      SKP 
* 
* PURPOSE:            GENERATES ADC BUFFER AREA, DATA QUALIFIER 
*                     STORAGE (SCALE FACTORS-MODE NUMBERS, BLOCK
*                     CALIBRATORS, & FREQUENCY FACTORS) AND 
*                     DATA BLOCK ASSOCIATED PARAMETERS FOR A
*                     12K-32K 5451/70 OPT70-OPT73 FOURIER SYSTEM. 
* 
* ENTRY POINTS: 
* 
*   1. DTAD           BSS STATEMENT ESTABLISHING ADC BUFFER.
*                     THIS ENTRY IS GENERATED BY DTAD0 AND EXISTS 
*                     AS AN UNDEFINED EXTERNAL UNTIL THEN.
* 
*   2. DTAD0          STARTING ADDRESS OF ADC BUFFER. 
* 
*   3. DRE.           STARTING ADDRESS OF BLOCK N1 WHICH IS SET 
*                     BY NAM LOCAT. 
* 
*   4. BSMAX          LARGEST BLOCKSIZE THAT FOURIER TRANSFORM
*                     CAN BE TAKEN ON.
* 
*   5. BSMIN          SMALLEST BLOCKSIZE THAT FOURIER TRANSFORM 
*                     CAN BE TAKEN ON.
* 
*   6. NMAX0          LARGEST NUMBER OF DATA BLOCKS.
*                     (NMAX0 X BSMIN = TOTAL DATA STORAGE IN 5470)
* 
*   7. NMAX           NUMBER OF DATA BLOCKS AVAILABLE FOR PRESENT 
*                     BLOCKSIZE.  SET UP BY NAM BLOK. 
* 
*   8. SIZE           PRESENT BLOCKSIZE SET UP BY NAM BLOK. 
* 
*   9. SIZM1          SIZE-1 SET UP BY NAM BLOK.
* 
*  10. MSZ            NEGATIVE SIZE (-SIZE) SET UP BY NAM BLOK. 
* 
*  11. MSZH           -(SIZE/2) SET UP BY NAM BLOK. 
* 
*  12. POW            LOG2(SIZE) SET UP BY NAM BLOK.
* 
* 
*      THE FOLLOWING THREE BSS STATEMENTS MUST ALWAYS BE
*     CONTIGUOUS (TOGETHER AND IN ORDER).  THEY ESTABLISH 
*     THE DATA QUALIFIER STORAGE.  EACH BSS STATEMENT 
*     IS BSS (NMAX0).  THESE THREE ENTRY POINTS ARE GENERATED 
*     IN NAM DTAD0 AND EXIST AS UNDEFINED EXTERNALS UNTIL THEN. 
* 
*  13. SCAL0          BSS STATEMENT ESTABLISHING SCALE FACTOR-
*                     MODE NUMBER STORAGE, AND ALSO CONTAINS
*                     SCALE FACTOR OF BLOCK 0.
*                     EACH SCALE FACTOR-MODE NUMBER WORD CONTAINS:
* 
*                     BITS 15-6 : SCALE FACTOR (9 BITS PLUS SIGN) 
*                     BITS  5-0 : MODE NUMBER 
*                           BIT 0 : 0 = RECTANGULAR, 1 = POLAR
*                           BIT 1 : 0 = LINEAR, 1 = LOG 
*                           BIT 2 : 0 = TIME DOMAIN,
*                                   1 = FREQUENCY DOMAIN
*                           BIT 3 : 0 = SINGLE PRECISION, 
*                                   1 = DOUBLE PRECISION
*                           BIT 4 : 0 = F(N) POSITIVE,
*                                   1 = F(N) NEGATIVE 
*                           BIT 5 : 0 = DC POSITIVE,
*                                   1 = DC NEGATIVE 
* 
*  14. CALB0          BSS STATEMENT ESTABLISHING BLOCK CALIBRATOR 
*                     STORAGE, AND ALSO CONTAINS CALIBRATOR OF
*                     BLOCK 0.
*                     THE BLOCK CALIBRATOR OF A DATA BLOCK
*                     IS .1<CALIBRATOR <1 FOR LINEAR BLOCKS AND 
*                     0 > CALIBRATOR > LOG(.1) FOR LOG DATA BLOCKS. 
*                     IF THE BLOCK CALIBRATOR =0, THEN THE DATA 
*                     OF THAT BLOCK ARE ASSUMED TO BE UNIFORMLY 
*                     EQUAL TO ZERO.
* 
*  15. FREQ0          BSS STATEMENT ESTABLISHING FREQUENCY FACTOR 
*                     STORAGE, AND ALSO CONTAINS FREQUENCY FACTOR 
*                     OF BLOCK 0. 
*                     EACH FREQUENCY FACTOR WORD CONTAINS:
* 
*                     BITS 15-14 : USED IN THE 5451-5471 AND
*                                  5451-5470 SYSTEMS TO INDICATE
*                                  THE MAGNITUDE OF THE LARGEST 
*                                  NUMBER IN THAT DATA BLOCK. 
*                                  OVS IS THE TERM USED TO SHOW 
*                                  THE STATUS OF BITS 15 & 14.
*                                  OVS = 00 : ABS(DMAX) < .25 
*                                  OVS = 01 : .25 = ABS(DMAX) < .5
*                                  OVS = 10 : ABS(DMAX) > .5
*                                        WHERE ABS(DMAX) IS THE 
*                                        LARGEST NUMBER IN THAT 
*                                        DATA BLOCK.
*                     BITS 13-0 : FREQUENCY FACTOR WHOSE VALUE
*                                 CAN RANGE FROM 0 TO +16383
* 
*  16. SCAL          STARTING ADDRESS OF DATA QUALIFIER STORAGE.
* 
*  17. ZIFFR          A COUNTER USED TO DETERMINE THE LOCATION
*                     OF BLOCK N1 DATA QUALIFIERS.  IT IS SET UP
*                     BY NAM BLOK.  INITIALLY IT IS SET EQUAL 
*                     TO (-BSMAX/BSMIN).
* 
* 
*  18. DTSUM        TOTAL DATA STORAGE IN 5470A.
* 
      SKP 
* FOURIER PROGRAM STACK ENTRIES:
* 
*                    FIRST 4 ENTRIES ARE GENERATED BY DTAD0.
* 
*  19. STOR0         POINTS TO BSS DEFINING PROG STACK LENGTH.
* 
*  20. STORL         POINTS TO LAST WORD +1 OF PROG STACK.
* 
*  21. POINT         PROG STACK POINTER (POINTS TO NEXT 
*                    COMMAND TO BE EXECUTED FROM PROG STACK). 
* 
*  22. RETV          SUBROUTINE JUMP RETURN ADDRESS.
* 
*  23. STACK         PROGRAM STACK LENGTH INCLUDING 36 WORD 
*                    SEARCH KEY FOR MT/DISC. LENGTH MAY BE
*                    SET BY Y-COMMAND AND PROGRAM STACK 
*                    REALLOCATED BY:
* 
*                    LDA =D336  (PROG STACK LENGTH + 36 WORDS)
*                    STA STACK
*                    CMA
*                    STA DTAD 
*                    JSB DTAD1
* 
* ENTRIES SPECIFIC TO 5470: 
* 
*  24. ZIFPW         LOG TO THE BASE 2 OF MAGNITUDE OF ZIFFR. 
* 
*  25. BFL70         ADC BUFFER SIZE IN THE COMPUTER. 
**********
* 
* OPERATION:          DTAD0 IS EXECUTED AT FIRST SYSTEM STARTUP 
*                     AND EACH TIME AN OVERLAY MODIFIES DATA
*                     STORAGE AVAILABILITY. 
* 
* PARAMETER DEFINITIONS &/OR INITIAL VALUES:
* 
*                     MAX   EQU (MAXIMUM BLOCKSIZE)/2 
*                     MIN   EQU MINIMUM BLOCKSIZE 
*                     L5470 EQU TOTAL DATA STORAGE IN 5470
*                     SUM   EQU ADC BUFFER STORAGE IN COMPUTER
*                     MXBL  EQU LARGEST NUMBER OF DATA BLOCKS 
*                               (L5470/MIN) 
*                     TMXBL EQU NUMBER OF BLOCKS FOR PRESENT SIZE 
*                               (L5470/BSMAX) 
*                     LOG   EQU LOG TO THE BASE 2 OF BLOCKSIZE
*                               (LOG2(MAX+MAX)) 
*                     SCTR  EQU MXBL/TMXBL
*                     LGZIF EQU LOG TO THE BASE 2 OF SCTR 
* 
      SKP 
*                     NAM DTAD0 
      ENT DTAD1 
      ENT DTAD0,DRE.,BSMAX,BSMIN,NMAX0,NMAX 
      ENT SIZE,SIZM1,MSZ,POW
      EXT SCAL0,CALB0,FREQ0 
      ENT SCAL
      ENT MSZH
      ENT ZIFFR 
      EXT DTAD
      ENT DTSUM 
      EXT .MEM.,BLOK,INS1,INSMX,WHAT
      EXT .IOC.,FLG1,WRBFA,WRBXA,WRBXN,PROPH
* 
      ENT STOR0,STORL,POINT,RETV
      ENT STACK,HCORE,Y0114,Y0115 
* 
      ENT BFL70,ZIFPW 
      EXT LIB7,OTB7 
* 
* 
* 
A     EQU 0 
B     EQU 1 
MAX   EQU 2048
MIN   EQU 64
L5470 EQU 4096
SUM   EQU 4096
MXBL  EQU 64
TMXBL EQU 1 
LOG   EQU 12
SCTR  EQU 64
LGZIF EQU 6 
* 
* 
DTAD0 DEF DTAD      (ACTUAL ADDRESS)
DTADA DEF DTAD
DRE.  DEF DTAD      (ACTUAL ADDRESS)
BSMAX ABS MAX+MAX LARGEST DATABLOCK 
BSMIN ABS MIN     SMALLEST DATABLOCK
NMAX0 ABS MXBL    LARGEST NUMBER OF DATABLOCKS
NMAX  ABS TMXBL   # OF DATABLOCKS FOR GIVEN SIZE
BFL70 ABS SUM     SIZE OF ADC BUFFER
* 
SIZE  ABS MAX+MAX 
SIZM1 ABS MAX+MAX-1 SIZE - 1
MSZ   ABS -MAX-MAX NEGATIVE SIZE
MSZH  ABS -MAX
POW   ABS LOG     BLOCKSIZE POWER 
* 
CALB  DEF CALB0 
FREQ  DEF FREQ0 
SCALE DEF SCAL0 
SCAL  DEF SCAL0     (ACTUAL ADDRESS)
ZIFFR ABS -SCTR 
ZIFPW ABS LGZIF 
DTSUM ABS L5470 
* 
STOR0 NOP           SET TO PROG STACK ADDRESS 
STORL NOP           PROG STACK END + 1
POINT NOP           PROG STACK POINTER
RETV  NOP           JUMP RETURN ADDRESS 
STACK DEC 336       PROG STACK LENGTH + 36
***** 
* 
DTAD1 NOP           ENTRY TO ALLOCATE DATA STORAGE
      LDA DTADA 
      ELA,CLE,ERA 
      LDA A,I 
      SSA,RSS 
      JMP DTAD1,I   NO CHANGE, EXIT 
DTAD2 CLA 
      OTA 1         CLEAR 2100 SW WORD
      LDA STACK 
      CMA,INA 
      STA LEN       PROG STACK LENGTH 
* 
      CLA,INA 
      STA NMAX      1 BLOCK MAX OF 4096 
      CLA           DETERMINE SIZE OF 5470
      JSB LIB7
      STB SAVE      SAVE CONTENTS OF LOC 0
      LDA =D4096
      JSB LIB7
      STB FWA       SAVE CONTENTS OF 4096 
      CPB SAVE
      INB 
      JSB OTB7      STORE IN 4096 (OR 0)
      CLA 
      JSB LIB7
      CPB SAVE      HAS 0 CHANGED ? 
      JMP SIZE8     NO, SO 8K 5470
      LDB SAVE
      JSB OTB7      RESTORE 0 
      LDA =D64
      STA NMAX0     LARGEST NUMBER OF DATA BLOCKS 
      LDB =D-192
      LDA =D4096
      JMP STR 
SIZE8 LDA =D4096
      LDB FWA 
      JSB OTB7      RESTORE 4096
      LDA =D128 
      STA NMAX0     LARGEST NUMBER OF DATA BLOCKS 
      ISZ NMAX      2 BLOCKS MAX OF 4096
      LDB =D-384
      LDA =D8192
STR   STB NPAR      -PARAMETERS REQUIRED
      STA DTSUM     TOTAL DATA SPACE IN 5470
* 
      LDB .MEM. 
      ADB =D3 
      LDA B,I       LAST WORD AVAIL HIGH CORE 
      LDB A 
      CMB,INB 
      ADB .MEM. 
      SSB,RSS 
      JMP END       ADC BUFFER BELOW IOC
      LDA HCORE 
      SZA 
      JMP END       FIXED LIMIT, HIGH CORE
      LDA =B27700   12K FIRST WORD PROTECTED CORE 
LOOP  LDB A,I 
      STB SAVE
      STA A,I 
      LDB A,I 
      SZB,RSS       ZERO IF CORE PROTECTED
      JMP END 
      LDB SAVE
      STB A,I 
      ADA =B10000   ADD 4K
      SSA,RSS       32K ? 
      JMP LOOP      TRY AGAIN 
END   AND =B70000 
      STA SAVE
      LDB .MEM. 
      ADB =D3 
      LDA B,I 
      AND =B7777
      IOR SAVE
      STA B,I       LAST WORD AVAIL MEMORY HIGH CORE
      STA LWA 
      ADB =D-1
      LDA B,I       FIRST WORD
      STA FWA 
      CMA,INA 
      ADA LWA 
      INA 
      STA CORE      TOTAL AVAIL HIGH CORE 
      ADA LEN       PROGRAM STACK LENGTH
      ADA NPAR      PARAMETER STORAGE 
      STA BFL70     ADC BUFFER SIZE IN COMPUTER 
* 
      LDA BSMIN 
      CMA,INA 
      STA SAVE
      CLB 
      LDA BSMAX 
      STA INS1      STORE FOR BLOK
      INB 
      ADA SAVE
      SZA 
      JMP *-3 
      CMB,INB 
      STB ZIFFR     - # OF MIN BLOCKS PER MAX BLOCK 
* 
      LDA FWA 
      STA DTAD0     START OF ADC BUFFER 
      STA DRE.
      LDB DTADA 
      ELB,CLE,ERB 
      STA B,I       ADC BUFFER ADDRESS
      ADA BFL70 
      LDB SCALE 
      ELB,CLE,ERB 
      STA B,I       SCALE FACTOR ADDRESS
      STA SCAL
      ADA NMAX0 
      LDB CALB
      ELB,CLE,ERB 
      STA B,I       CALIBRATION FACTOR ADDRESS
      ADA NMAX0 
      LDB FREQ
      ELB,CLE,ERB 
      STA B,I       FREQUENCY ADDRESS 
      LDA LWA       SET PROG STACK AT END OF CORE 
      ADA LEN 
      INA 
      STA STOR0     PROG STACK ADDRESS
      STA POINT 
      STA RETV
      LDB STACK 
      ADB =D-36 
      ADA B 
      STA STORL     PROG STACK END +1 
      CLB,INB 
      STB INSMX 
* 
      JSB BLOK      SET NMAX,SIZE,SIZM1,MSZ,POW,ZIFR
* 
      JSB .IOC.     PRINT SIZE INFO 
      OCT 20002 
      JMP *-2 
      DEF MSG 
      DEC -28 
      CLB 
      STB FLG1
      LDB =A
      JSB WRBFA 
      LDB NMAX
      JSB WRBXN 
      LDB =A /
      JSB WRBXA 
      LDB SIZE
      JSB WRBXN 
      LDB =A /
      JSB WRBXA 
      LDB BFL70 
      JSB WRBXN 
      JSB PROPH 
      JMP DTAD1,I   EXIT
* 
SAVE  BSS 1 
LEN   BSS 1 
NPAR  BSS 1 
LWA   BSS 1         LAST WORD AVAIL HIGH CORE 
FWA   NOP           FIRST WORD AVAIL HIGH CORE
CORE  BSS 1         TOTAL AVAILABLE HIGH CORE 
HCORE NOP           FORCES LAST WORD AVAIL CORE OR 0
MSG   ASC 14,DATA BLOCKS #/MAX SIZE/SPACE 
* 
Y0114 NOP 
      CLA,INA 
      CPA INSMX 
      RSS 
      JSB WHAT
      LDA INS1
      ADA =D36
      STA STACK 
      LDA Y0114,I 
      STA DTAD1 
      JMP DTAD2 
* 
Y0115 NOP 
      LDA Y0115,I 
      JMP A,I 
      END 
                                                                                                                                                                      