
{[l-,r+,b+]}
{
RT-11 Support library definitions
}

CONST

  maxfiles = 16;                {Maximum files available without special support library
                                 build}
  scrsiz = 150;                 {Size of scratch area in p$rts for temporary stack}

  {The following are the codes from the Device-indentifier Byte values
  from RT-11.  They map over the file variable at the byte labeled Hand.
  Additional devices are available from the DEC SSM manual, RT-11 V4,
  page 7-7}

  rk05 = 0;
  tc11 = 1;
  lp = 3;
  console = 4;
  rl = 5;
  rx02 = 6;
  tu10 = 11B;
  rx01 = 22B;
  nullhand = 25B;
  ls = 41B;
  mq = 42B;

TYPE

  word = 0..65535;              { Unsigned 16 bit quantity }
  byte = 0..255;                { Unsigned 8 bit quantity }
  signed_byte = -128..127;      { Signed 8 bit quantity }

  file_buffer = PACKED ARRAY [1..512] OF char;

  file_buffer_pointer = ^file_buffer;

  {
    File variable definitions.  The file variable is a structure created on
    the heap by RESET() or REWRITE().  It contains all the information
    necessary for I/O with record oriented devices. These definitions match
    those in OPCOM.MAC which are used by the support library modules.
  }

  {
    File status bits in STAT in the file variable
  }

  file_status = (modified,      {Buffer flag for a write}
                 span,          {Records span block boundries}
                 fseek,         {Random I/O OK}
                 readok,        {File is an input file}
                 writeok,       {File is an output file}
                 peof,          {end of file is pending}
                 temp,          {temporary file - deleted on a close}
                 txt,           { Text file }
                 nfs,           {Non file structured device}
                 go,            {Non fatal I/O errors}
                 dirt,          {Buffer was modified}
                 tty,           {This is open on an interactive device}
                 odt,           {Open for single charactor I/O}
                 def,           { Current character is defined }
                 feoln,         { End of line found }
                 feof);         { End of file found }

  {Type bits are the upper byte of the Device Status Word that RT-11 uses
  to identify a unique physical device and information about its access.
  These type bits map onto the Pascal file variable at the byte "Type"
  and should be self explainatory.  Further information is available in
  the RT-11 V4 SSM manual page 7-7.}

  type_bits = (blnk0,           {Reserved by Digital}
               blnk1,           {Reserved by Digital}
               spfun$,          {.SPFUN requests are valid}
               hndlr$,          {Enter handler at abort entry if abort job}
               specl$,          {Special directory structure (MT,CT, etc)}
               wonly$,          {Write only device}
               ronly$,          {Read only device}
               filst$);         {Random access device (disk)}

  file_variable =
    PACKED RECORD
    ptr: file_buffer_pointer;   { Pointer into file buffer }
    stat: SET OF file_status;   { Current file status }
    dev: word;                  {Logical device name}
    name1: word;                {First 3 chars of filename}
    name2: word;                {Second 3 chars of filename}
    ext: word;                  {file extension name}
    filesize: word;             {Size of the file in blocks}
    channel: byte;              {RT-11 channel number}
    func: byte;                 {Reserved}
    block: word;                {Current block in buffer}
    buf: word;                  { Address of record buffer }
    siz: word;                  { Size of record buffer }
    hand: byte;                 {RT-11 handler ID}
    dev_type: SET OF type_bits; {RT-11 Device ID}
    rec: word;                  {Record Size in bytes}
    data: word;                 {Pointer to end of valid data}
    perb: word;                 {Records per block}
    term: byte;                 {Multi terminal LUN number}
    ioerr: byte;                {I/O Error code of last transfer}
  END;

  {
    A file defined in the user's data area is simply a pointer to a
    file variable on the heap.
  }

  user_file_variable = ^file_variable;

  {
    The active file table contains the addresses of user file variables
  }

  user_file = ^user_file_variable;


  {
    Description of blocks on the free list.  The library routines NEW() and
    DISPOSE() manipulate dynamic memory.
  }
  free_pointer = ^free_block;

  free_block =
  RECORD
    next: free_pointer;         { Pointer to next free block }
    length: word;               { Size of this block in bytes }
  END;

  {
    The orphan list is a list of single word blocks which are too small to
    place on the free list.
  }

  orphan_pointer = ^orphan;

  orphan =
  RECORD
    next: orphan_pointer;       { Pointer to next orphan }
  END;

  active_file_table = ARRAY [1..maxfiles] OF user_file;

  {
    The Pascal library data area.  These fields are defined in the module
    opcom.mac
  }
  ptr = ^library_data;

  library_data =
  RECORD
    resr6: word;                {saved pointer to top of stack}
    resr5: word;                {saved pointer to global data}
    p_in: word;                 {Points to user file var for standard input}
    p_out: word;                {points to user file var for standard output}
    p_iblock: word;             {Saved pointer to standard input}
    p_oblock: word;             {Saved pointer to standard output}
    p_lastfile: user_file;      {Last file access was this one}
    p_chan0: active_file_table;
    p_ichan: user_file;              {pointer to standard input}
    p_ochan: user_File;              {pointer to standard output}
    p_pmalink: word;            {Dynamic link for PMA}
    p_pmpc: word;               {PMA program counter}
    p_userpc: word;             {Saved user program counter}
    p_savederr: word;           {Saved user error code}
    p_kore: word;               {Pointer to top of heap}
    p_free: free_pointer;       {Pointer to first element on free list}
    p_free2: orphan_pointer;    {first element on orphan list}
    p_free4: word;              {Zero flag}
    p_mtop: word;               {Top of memory available to program}
    p_errn: ARRAY [1..7] OF word;
    p_trap: ARRAY [1..8] OF word;{FPP trap area}
    p_area: ARRAY [1..scrsiz] OF word;{Temporary EMT arg area and stack}
    p_stack: word;              {Return link for high stack routine}
  END;
                                                                                                                                                                                                                                                                                                                                                                                                                                        