/*
 * FIO-DEC to ASCII
 * note: not all characters map to ascii (down arrow, implies, right arrow...)
 *
 * CONSISE  FIO-DEC  CHARACTER                 CONSISE  FIO-DEC  CHARACTER
 * CODE     CODE     LOWER  UPPER              CODE     CODE     LOWER  UPPER
 * 00        00      Tape Feed                 41       241      j      J
 * --       100      Delete                    42       242      k      K
 * 00       200      Space                     43        43      l      L
 * 01        01      1      "                  44       244      m      M
 * 02        02      2      '                  45        45      n      N
 * 03       203      3      ~ (not)            46       246      o      O
 * 04        04      4      (implies)          47       247      p      P
 * 05       205      5      (or)               50       250      q      Q
 * 06       206      6      ^ (and)            51        51      r      R
 * 07        07      7      < (less than)      54        54      -      +
 * 10        10      8      > (greater than)   55       255      )      ]
 * 11       211      9      <up arrow>         56       256      <non-spacing overstrike
 * --        --                                                   and vertical bar>
 * --        13      Stop Code                 
 * 20        20      0      <right arrrow>     57        57      (      [
 * 21       221      /      ?                  61        61      a      A
 * 22       222      s      S                  62        62      b      B
 * 23        23      t      T                  63       263      c      C
 * 24       224      u      U                  64        64      d      D
 * 25        25      v      V                  65       265      e      E
 * 26        26      w      W                  66       266      f      F
 * 27       227      x      X                  67        67      g      G
 * 30       230      y      Y                  70        70      h      H
 * 31        31      z      Z                  71       271      i      I
 * 33       233      ,      =                  72       272      Lower Case
 * 34        --      <black>                   73        73      .      X <multiply>
 * 35        --      <red>                     74       274      Upper Case
 * 36       236      tab                       75        75      Backspace
 * 40        40      <non-spacing middle dot
 *                    and underline>           77       277      Carriage Return
 *
 */

#include <stdio.h>

char cvt[] = { ' ', '"', 0x27, '~',  0 ,  0 , '^', '<',    /* 00 - 07 */
               '>', '^',  0 , '\n' ,  0 ,  0 ,  0 ,  0 ,     /* 10 - 17 */
               '.', '?', 'S', 'T', 'U', 'V', 'W', 'X',     /* 20 - 27 */
               'Y', 'Z',  0 , '=',  0 ,  0 , '\t',  0 ,    /* 30 - 37 */
               '.', 'J', 'K', 'L', 'M', 'N', 'O', 'P',     /* 40 - 47 */
               'Q', 'R',  0 ,  0 , '+', ']', '|', '[',     /* 50 - 57 */
               '.', 'A', 'B', 'C', 'D', 'E', 'F', 'G',     /* 60 - 67 */
               'H', 'I',  0 , 'x',  0 ,  0 ,  0 , '\n'     /* 70 - 77 */
        };

char cvtl[] ={ ' ', '1', '2', '3', '4', '5', '6', '7',     /* 00 - 07 */
               '8', '9',  0 , '\n',  0 ,  0 ,  0 ,  0 ,     /* 10 - 17 */
               '0', '/', 's', 't', 'u', 'v', 'w', 'x',     /* 20 - 27 */
               'y', 'z',  0 , ',',  0 ,  0 , '\t',  0 ,    /* 30 - 37 */
               '_', 'j', 'k', 'l', 'm', 'n', 'o', 'p',     /* 40 - 47 */
               'q', 'r',  0 ,  0 , '-', ')', '.', '(',     /* 50 - 57 */
                0 , 'a', 'b', 'c', 'd', 'e', 'f', 'g',     /* 60 - 67 */
               'h', 'i',  0 , '.',  0 ,  0 ,  0 , '\n'     /* 70 - 77 */
        };
main()
{
        char c;
        int state = 0;

        while(!feof(stdin)){
                c = getchar() & 0x3f;
		if (c == 034) continue;			/* RED */
		if (c == 035) continue;			/* BLACK */
		if (c == 013) {putchar('\f'); putchar('\n'); continue;}
                if (c == 072) {state = 0; continue;}    /* lower case */
                if (c == 074) {state = 1; continue;}    /* upper case */
                
                if(state){
                 if(cvt[c] == 0) { printf(">>%02o<<",c); continue;}
                 putchar(cvt[c]);
                }
                else{
                 if(cvtl[c] == 0) {printf(">>%02o<<",c); continue;}
                 putchar(cvtl[c]);
                }
        }
}
