{FILEID: spool.pas}

   PROCEDURE perror(enum: INTEGER);
   BEGIN
    WRITELN;
     writeln(beep, 'PIPE ERROR ',beep,beep,enum);
     CASE enum OF
       PEmpty: writeln('Tried to read an empty pipe.');
       PNotOpen: writeln('Pipe not open.');
       PFull: writeln('Pipe full.');
       POpErr: writeln('Tried to open a pipe which was already open.');
       PNotThere: writeln('Pipe does not exist.');
       PNoRoom: writeln('Not enough room to open a new pipe.');
       PsNotInitted: writeln('Pipes area has not been initialized.');
       END; {CASE}
   END;

    FUNCTION statit(VAR n, p : CBLOCK) : BOOLEAN;
      VAR
	val : INTEGER;
      BEGIN
	val := pipestatus(n.txt, p.txt);
	IF val < 0
	  THEN
	    BEGIN
	      perror(val);
	      statit := TRUE;
	    END
	  ELSE
	    statit := FALSE;
      END; {statit}


	PROCEDURE boolprnt(boolval : BOOLEAN);
	  BEGIN
	    IF boolval
	      THEN
		WRITELN('TRUE')
	      ELSE
		WRITELN('FALSE');
	  END;



PROCEDURE spoolit;
{ --------------------------------------------------------------------- }
{ spoolit - send a file (selected by the user) to a pipe which will be  }
{ read by the despooler and sent to the printer.  The pipe name can be  }
{ any string of 8 characters, but it must match the name being used by  }
{ the despooler.                                                        }
{ The spool program inserts a block before the text.  The information in}
{ this block is used by the despooler to aid in printing headers etc.   }
{ The format of a pipe generated by this procedure is as follows:       }
{       <preamble block><text><text>....<text>                          }
{ The format of the preamble block is:                                  }
{       block[0] - currently not used                                }
{       block[1] - length of filename (upto 80 characters)              }
{       block[2-81] - filename (string of ASCII characters)             }
{       block[82] - length of message (upto 80 characters)              } 
{       block[83-162] - message (yes! a string of ASCII characters)     }
{	block[163] - Text-Nontext flag	"0" = text			}
{					"1" = nontext			}
{       block[164-511] - not used                                       }
{ --------------------------------------------------------------------- }
    VAR
      IncldOn, FormFdOn, LnFdOn, xit: BOOLEAN;
      action, ch: CHAR;
      IOok, ln, i : INTEGER;
      k: INTEGER;
      fname, mess, pname: STRING;


    { ****************************************************************** }
    { putpipe writes the data to the pipe until end of file is reached.  }
    { This procedure could be used by any program which sends files to pipes..}
    { ****************************************************************** }
  FUNCTION putpipe(fname:STRING; strt, pno: INTEGER): BOOLEAN;
    VAR
      i, ior: INTEGER;
      xit: BOOLEAN;

				{ all writes to the pipes area are
				  done from this routine	   }
    PROCEDURE pwrt(**);
      VAR
	j : INTEGER;
      BEGIN
	j := pipewrite(pno, BLOCKLEN, nbuf.txt);
	IF j < 0
	  THEN
	    BEGIN
	      perror(j);
	      xit := TRUE;
	    END
	  ELSE
	    BEGIN
	      pblocks := pblocks + 1;
	      WRITE('.');
	      IF ((pblocks MOD 20) = 0)
		THEN
		  WRITELN;
	      nbcnt := 0;
	    END;
      END;



			{ fill out buffer on last pipe write with 0.
			  may not be necessary if pipes bug fixedd  }
      PROCEDURE fillnbuf(**);
	VAR
	  i : INTEGER;
	BEGIN
	  FOR i := nbcnt TO BlockMax DO
	    nbuf.txt[i] := CHR(0);
	END;

			{ Put Unformatted pipe - no text processing }
			{ done					    }
    PROCEDURE putunfp(fname : STRING);
	VAR
	  endf : BOOLEAN;
	  fb : BUFILE;
      BEGIN
	recnt := 0;
	IF rstbufile(fb, fname) = FILERR
	  THEN
	    BEGIN
	      WRITE(beep, '--- Unable to open file ');
	      Writestring(fname);
	      WRITELN;
	    END
	  ELSE
	    BEGIN
	      REPEAT
		xit := keypress(**);
		endf := bufrd(fb);
		IF NOT(endf)
		  THEN
		    BEGIN
		    IF nbcnt = BLOCKLEN
		      THEN
			pwrt(**);
		    MOVELEFT(fb^,nbuf.txt[nbcnt],BUFLEN);
		    nbcnt := nbcnt + BUFLEN;
		    END;
	      UNTIL ((endf) OR (xit));
	      IOok := closbufile(fb);
	    END;
      END; {putunfp}

			{ put text pipe - this procedure & those local
			  to it do all of the text formattinng	}
      PROCEDURE putxtp(fname : STRING);
	VAR
	  ln : INTEGER;
	  name, txtstrng : STRING;
	  f : TEXT;


			{ put nbuf char routine - checks to see if buf
			  is full. if it is then it calls a routine to
			  output buf before putting char into buf }
	PROCEDURE putnbufc( ch : CHAR );
	  BEGIN
	    IF nbcnt = BlockLen
	      THEN
		pwrt(**);
	    nbuf.txt[nbcnt] := ch;
	    nbcnt := nbcnt + 1;
	  END;

			{ put nbuf string - put a string of chars into
			  nbuf (pipe buf), followed by a <CR> & maybe
			  a <LF>(depending on option) }
	PROCEDURE putnbufstr(**);
	  VAR
	    i : INTEGER;

	  BEGIN
	    IF ln > 0
	      THEN
		IF ((nbcnt + ln) <= BLOCKLEN)
		  THEN
		    BEGIN
		    MOVELEFT(txtstrng[1],nbuf.txt[nbcnt],ln);
		    nbcnt := nbcnt + ln;
		    END
		  ELSE
		    FOR i := 1 TO ln DO
		      putnbufc(txtstrng[i]);
	    putnbufc(CHR(CR));
	    IF LnFdOn
	      THEN
		putnbufc(CHR(LF));
	  END;

			{ get a file name from txtstrng into name
			  string. }
	  PROCEDURE getname(**);
	    VAR
	      i, j, ln : INTEGER;
	    BEGIN
	      i := 4;
	      ln := LENGTH(txtstrng);
	      WHILE ((i <= ln) AND (txtstrng[i] = ' ')) DO
		i := i + 1;
	      j := 1;
	      WHILE ((i <= ln) AND
		     (NOT(txtstrng[i] IN [' ', ';', '}']))) DO
		BEGIN
		  name[j] := txtstrng[i];
		  i := i +1;
		  j := j+1;
		END;
	      name[0] := CHR(j-1);
	    END;


		{ call open file procedure and check for error return
		  if no error then check console input. If input then
		  set xit flag. Read next string. Check if string 
		  contains control sequences, then process; else
		  write out string. loop till eof
		}
	BEGIN {putxtpipe}
	  IF  rstxtfile(f, fname) = FILERR
	    THEN
	      BEGIN
		WRITE(beep, '--- Unable to open file ');
		Writestring(fname);
		WRITELN;
	      END
	    ELSE
	      BEGIN
		REPEAT
		  xit := keypress(**);
		  READLN(f, txtstrng);
		  ln := LENGTH(txtstrng);
		  IF ((ln > 2) AND (txtstrng[2] = '$'))
		    THEN
		      BEGIN
			IF (txtstrng[1] IN [ ';' , '{' ])
			  THEN
			    BEGIN
			      IF ((txtstrng[3] = 'P') AND (FormFdOn))
				THEN
			  	  txtstrng[3] := CHR(FF);
			      putnbufstr(**);
			      IF ((txtstrng[3] = 'I') AND (IncldOn))
				THEN
				  BEGIN
				    getname(**);
				    putxtp(name);
				  END;
			    END;
		      END
		    ELSE
		      putnbufstr(**);
		UNTIL ((xit) OR (EOF(f)));
		IOok := clostxtfile(f);
	      END;
	END;
  
		{
		  if text being output to the pipe is being formatted
		  then use putxtp procedure; else use putunfp.
		  On return, output remaining chars in buf.  It is
		  currently only possible to output 512 byte blocks
		  to a pipe; so it is necessary to fill out the last
		  buffer with 0s before sending it.
		}
    BEGIN {putpipe}
      xit := FALSE;
      nbcnt := BLOCKLEN;	{ count for preamble block }
      pwrt(**);
      IF NOT(xit)
	THEN
	  BEGIN
	    IF ftype <> FORMTD
	      THEN
		putunfp(fname)
	      ELSE
		putxtp(fname);
	    IF (NOT(xit) AND (nbcnt > 0))
	      THEN
		BEGIN
		  fillnbuf(**);
		  pwrt(**);
		END;
	  END;
      putpipe := xit;

    END; {putpipe}
  


    PROCEDURE splparams(**);

      BEGIN {splparams}
	WRITELN('SPOOL PARAMETERS: ');
	WRITE('P(ipe name: ');
	WriteString(pname);
	WRITELN;
	WRITE('F(ile name: ');
	WriteString(fname);
	WRITELN;
	WRITE('M(essage: ');
	WriteString(mess);
	WRITELN;
	WRITE('T(ype of File: ');
	CASE ftype OF
	  NONTXT: WRITELN('N(on Text');
	  UNFORMTD: WRITELN('U(nformatted Text');
	  FORMTD: WRITELN('F(ormatted Text');
	END; {CASE}
	WRITE('L(inefeeds: ');
	boolprnt(LnFdOn);
	WRITE('N(ew pages: ');
	boolprnt(FormFdOn);
	WRITE('I(nclude Files: ');
	boolprnt(IncldOn);
      END {splparams};


  BEGIN {spoolit}
    xit := FALSE;
    IncldOn := FALSE;
    LnFdOn := TRUE;
    FormFdOn := FALSE;
    ftype := FORMTD;
    fname := '';
    mess := '';
    pname := 'PRINTER';
    REPEAT
      REPEAT
	splparams(**);
	WRITE('    S(  P(  F(  M(  T(  L(  N(  I(  Q(  :');
	READ(action);
	WRITELN;
	IF action IN ['S', 'P', 'F', 'M', 'T', 'L', 'N', 'I', 'Q']
	  THEN
	    BEGIN
	      CASE action OF
		'S': {GO};

		'P': BEGIN
			WRITE('P(ipe name: ');
			Readstring(pname);
		     END;
		'F': BEGIN
			WRITE('F(ile name: ');
			Readstring(fname);
		     END;
		'M': BEGIN
			WRITE('M(essage: ');
			Readstring(mess);
		     END;
		'T': BEGIN
		      REPEAT
			WRITE('T(ype of File: U(nformatted Text ');
			WRITE('F(ormatted text N(on text : ');
			READ(ch);
			WRITELN;
			IF ch IN ['U', 'F', 'N']
			  THEN
			    CASE ch OF
			      'U': ftype := UNFORMTD;
			      'F': ftype := FORMTD;
			      'N': ftype := NONTXT;
			    END; {CASE}
		      UNTIL (ch IN ['U', 'F', 'N']);
		     END;

		'L': LnFdOn := NOT(LnFdOn);

		'N': FormFdOn := NOT(FormFdOn);

		'I': IncldOn := NOT(IncldOn);

		'Q': xit := TRUE;

	      END {CASE};
	      WRITELN;
	    END
	  ELSE
	    WRITELN(beep);
      UNTIL (action IN [ 'S', 'Q' ]);
      IF NOT(xit)
        THEN
          BEGIN
	  xit := statit(nbuf,pbuf);
	  IF NOT(xit)
	   THEN
	    BEGIN
            ln := LENGTH(fname);
	    nbuf.txt[0] := CHR(1);    { 1 for apple, just to be compat.  }
            nbuf.txt[1] := CHR(ln);
	    MOVELEFT(fname[1], nbuf.txt[2], ln);
	    ln := LENGTH(mess);
	    IF ln > MESSMAX
	      THEN
	        ln := MESSMAX;
	    nbuf.txt[82] := CHR(ln);
	    MOVELEFT(mess[1], nbuf.txt[83], ln);
	    IF ftype = NONTXT
	      THEN
		nbuf.txt[163] := '1'
	      ELSE
		nbuf.txt[163] := '0';
	    pnum := pipeowr (pname);
	    IF pnum < 0
	      THEN
		BEGIN
		  perror (pnum);
		  xit := TRUE;
		END
	      ELSE
		BEGIN
		  pblocks := 0;
		  WRITELN;
		  WRITE ('Spooling file to pipe ');
		  WriteString(pname);
		  WRITELN ('[',pnum:2,']');
		  xit := putpipe(fname,0,pnum);
		  k := pipecwr (pnum);
		  WRITELN;
		  WRITE (pblocks:3,' blocks written to pipe ');
		  WriteString(pname);
		  WRITELN ('[',pnum:2,']');
		END;
	    END;
          END;
    UNTIL xit;
  END; {spoolit}


PROCEDURE despoolit;
{ ------------------------------------------------------------------- }
{ despoolit - reads files from a pipe and sneds them to the printer.  }
{ The default pipe name used by the despooler is "PRINTER", though    }
{ this may be changed by the user.  The despooler will read and       }
{ print every pipe with that name.  When there are no more pipes with }
{ above name, wait approximately 1 minute and try again.  This process}
{ is repeated until a key is pressed on the console.                  }
{ ------------------------------------------------------------------- }
    VAR
      LnFdOn, txt, xit : BOOLEAN;
      action, ch : CHAR;
      device : INTEGER;
      i, IOok : INTEGER;
      k: INTEGER;
      lncnt : INTEGER;
      MaxLines: INTEGER;
      OsType: INTEGER;
      poscnt : INTEGER;
      tabsize: INTEGER;
      fb : BUFILE;
      ft : TEXT;
      fname, pname : STRING;
    

		{ putbuf -
		  Output pipe buffer to appropriate device.
		}
      PROCEDURE putbuf(buf: CBLOCK; cnt: INTEGER);
	VAR
	  i: INTEGER;
	  ior: INTEGER;
	  chval : INTEGER;

			{ lnchk -
			  Routine gets called everytime a <CR> is
			  found in txt file.  If max # of lines on
			  a page set to 0 then no lncnt is kept.
			  Otherwise, output a <FF> char after max
			  lines, and reset lncnt.
			}
	  PROCEDURE lnchk(**);
	    BEGIN
	      IF MaxLines > 0
		THEN
		  BEGIN
		    lncnt := lncnt + 1;
		    IF lncnt = MaxLines
		      THEN
			BEGIN
			  WRITE(ft, CHR(FF));
			  lncnt := 0;
			END;
		  END;
	    END;

	BEGIN {putbuf}
	  IF txt
	    THEN
	      BEGIN
		i := 0;
		WHILE ( i < cnt ) DO
		  BEGIN
		    chval := ORD(buf.txt[i]);
		    IF chval IN [ TAB, CR, LF, NULL, FF ]
		      THEN
			BEGIN
			  CASE chval OF
			    CR: BEGIN
				  poscnt := 0;
				  WRITE(ft, CHR(CR));
				  lnchk(**);
				END;
			    LF: BEGIN
				  IF LnFdOn
				    THEN
				      WRITE(ft, CHR(LF));
				END;

			   TAB: BEGIN
				  IF tabsize > 0
				    THEN
				      REPEAT
					  WRITE(ft, ' ');
					  poscnt := poscnt + 1;
				      UNTIL ((poscnt MOD tabsize) = 0)
				    ELSE
				      WRITE(ft, buf.txt[i]);
				END;

			    FF:	BEGIN
				  lncnt := 0;
				  WRITE(ft, buf.txt[i]);
				END;

			    NULL: { remove all nulls };
			  END; {CASE}
			END
		      ELSE
			BEGIN
			  WRITE(ft, buf.txt[i]);
			  poscnt := poscnt + 1;
			END;
		    i := i + 1;
		  END;
	      END
	    ELSE
	      BEGIN
			{ this loop works because all non-text 
			  files are multiples of BLOCKLEN and BUFLEN
			  is a multiple of BUFLEN
			}
		i := 0;
		WHILE (i < BLOCKLEN) DO
		  BEGIN
		    MOVELEFT(buf.txt[i], fb^, BUFLEN);
		    i := i + BUFLEN;
		    IF bufwrt(fb) = FILERR
		      THEN
			BEGIN
			WRITELN('WRITE FILE ERROR');
			xit := TRUE;
			END;
		  END;
	      END;
	END;

		{ preamble-
		  used to decipher the info embedded in preamble block
		}
    FUNCTION preamble (pn: INTEGER): BOOLEAN;
      VAR i,n: INTEGER;
      
			{ strprnt-
			  used to write the strings in the preamble
			  block to the printer.
			}
      PROCEDURE strprnt (ind: INTEGER);         { string print }
        VAR len, i: INTEGER;
        BEGIN
          len := ORD(nbuf.txt[ind]);
          IF len <> 0
            THEN
              BEGIN
                FOR i := 1 TO len DO 
  		  WRITE(ft, nbuf.txt[ind+i]);
                WRITELN (ft, CHR(LF), CHR(LF) );
              END;
        END; {strprnt}
        
      BEGIN {preamble}
        n := piperead (pn,nbuf.txt);
        IF n < 0
          THEN
	    BEGIN
              perror(n);
	      preamble := TRUE;
	    END
          ELSE
            BEGIN
	      CASE device OF
		LPR: MOVELEFT(lprname,fname,LENGTH(lprname)+1);
		CON: MOVELEFT(coname,fname,LENGTH(coname)+1);
		FIL: BEGIN
			MOVELEFT(nbuf.txt[1], fname[0], ORD(nbuf.txt[1])+1);
			WRITELN;
			WRITE('SPOOLED FILENAME: ');
			WriteString(fname);
			WRITELN;
			WRITE('FILENAME TO DESPOOL TO: ');
			ReadString(fname);
		     END;
	      END;
	      txt := (nbuf.txt[163] = '0');
	      IF txt
		THEN
		  i := rwrtxtfile(ft, fname)
		ELSE
		  i := rwrtbufile(fb, fname);
	      IF i = FILERR
		THEN
		  BEGIN
		    WRITELN('FILE OPEN ERROR: ',i);
		    preamble := TRUE;
		  END
		ELSE
		  BEGIN
		    preamble := FALSE;
		    IF device = LPR
		      THEN
			BEGIN
			  WRITE (ft, CHR(LF), CHR(LF), CHR(LF));
			  FOR i := 1 TO 4 DO
			     strprnt(1);

			  WRITELN (ft);
			  WRITELN (ft);
			  strprnt (82);
			  WRITELN (ft, CHR(FF));
			END;
		  END;
	    END;
      END; {preamble}


    PROCEDURE dsplwait(**);
      BEGIN
	pnum := -1;
        WHILE (NOT(xit) AND (pnum < 0)) DO
	  BEGIN
            pnum := pipeord (pname);
            IF pnum < 0
              THEN
                IF (pnum = PNotThere) OR (pnum = POpErr)
                  THEN
                    BEGIN
                      WRITELN;
                      WRITELN;
                      WRITE ('Waiting to Despool Pipe "');
		      WriteString(pname);
		      WRITELN('"');
                      WRITE('Depress any key to escape... ');
		      i := 0;
		      WHILE ((i < 1000) AND NOT(xit)) DO
			BEGIN
			  IF keypress
			    THEN
			      xit := TRUE;
                         CASE (i MOD 200) OF
			    0: WRITE(' ');
                          100: WRITE(CHR(8));
                         END; {CASE}
			 i := i+1;
			END;
                    END
                  ELSE
                    BEGIN
                      perror(pnum);
                      xit := TRUE; 
                    END;
	    WRITELN;
	END;
      END; {dsplwait}


      PROCEDURE dsplparams(**);
	BEGIN
	  WRITELN;
	  WRITELN('DESPOOL PARAMETERS: ');
	  WRITE('P(ipe name: ');
	  Writestring(pname);
	  WRITELN;
	  WRITE('W(here : ');
	  CASE device OF
	    LPR : WRITELN(' Line PRinter');
	    CON : WRITELN(' CONsole ');
	    FIL : WRITELN(' FILe');
	  END;
	  WRITELN('M(ax Lines/Page : ', MaxLines);
	  WRITELN('E(xpand Tabs: ', tabsize);
	  WRITE('L(inefeeds: ');
	  boolprnt(LnFdOn);
	  WRITELN;
	END;

    BEGIN  {desplit}
      xit := FALSE;
      pname := 'PRINTER';
      device := LPR;
      txt := TRUE;
      LnFdOn := TRUE;
      MaxLines := 0;
      tabsize := 8;
      REPEAT
	dsplparams(**);
	WRITELN;
	WRITE(' D(  P(  W(  M(  E(   L(  Q(  : ');
	READ(action);
	WRITELN;
	IF action IN [ 'D', 'P','W', 'M', 'E', 'L', 'Q' ]
	  THEN
	    BEGIN
	      CASE action OF
		'D' : {GO};
		'P' : BEGIN
			WRITE('P(ipe name: ');
			Readstring(pname);
		      END;
		'W' : REPEAT
			WRITE('W(here: L)pr, F)ile, C)onsole ');
			READ(ch);
			IF ch IN [ 'L', 'F', 'C' ]
			  THEN
			    CASE ch OF
				'L': device := LPR;
				'F': device := FIL;
				'C': device := CON;
			    END {case}
			  ELSE
			    WRITELN(beep);
		      UNTIL (ch IN [ 'L', 'F', 'C' ]);
		'M' : BEGIN
			WRITE('M(ax Lines/Page : ');
			READ(MaxLines);
		      END;
		'E' : BEGIN
			WRITE('E(xpand Tabs to: ');
			READ(tabsize);
		      END;
		'L' : LnFdOn := NOT(LnFdOn);
		'Q' : xit := TRUE;
	      END {CASE};
	    END
	  ELSE
	    WRITELN(beep);
	UNTIL action IN [ 'Q', 'D' ];
      WRITELN;
      WHILE NOT(xit) DO
        BEGIN
	  lncnt := 0;
	  poscnt := 0;
	  recnt := 0;
	  xit := statit(nbuf,pbuf);
	  dsplwait(**);
          IF NOT(xit)
            THEN
              BEGIN
                WRITE ('Despooling from pipe ');
		WriteString(pname);
		WRITELN('[',pnum,'].');
                xit := preamble(pnum);
		IF NOT(xit)
		  THEN
		    BEGIN
                      pblocks := 1;
                      REPEAT
			xit := keypress(**);
                	i := piperead(pnum, nbuf.txt);
                	IF (i < 0) AND (i<>PEmpty)
                	  THEN 
			    BEGIN
			      perror(i);
			      xit := TRUE;
			    END
                	  ELSE
                	    IF i > 0
                              THEN
                        	BEGIN
				  WRITE('.');
                        	  putbuf(nbuf, i);
                        	  pblocks := pblocks+1;
                        	END;
                      UNTIL ((i <= 0) OR (xit));
		      IF device = LPR
			THEN
                	  WRITELN (ft, CHR(FF),
                         'This page intentionally left blank.', CHR(FF));
                      WRITELN;
                      WRITELN;
                      WRITE ('Pipe ');
		      WriteString(pname);
                      WRITELN('[',pnum,'] contained ',
				pblocks, ' blocks');
		      IF txt
			THEN
			  IOok := clostxtfile(ft)
			ELSE
			  IOok := closbufile(fb);
		      k := pipecrd(pnum);
		    END;
              END; 
      END; {WHILE loop}
  END;

