;	FILE IS TOUCHTST.ASM

;	touch panel access demonstration and test
;	This program displays the X and Y Characters received from
;	the touch panel and also the numeric values for these coordinates

;	revised July 31, 1981 for release

;	ASCII display equates

cls	equ	1ah		;clear screen character
cr	equ	0dh
lf	equ	0ah
tab	equ	09h

	org	100h		;start of TPA
	jmp	ttest

signon:				;Signon message
	db	cls,'Control Data 110',cr,lf,lf,'Touch Panel Test',cr,lf
	db	cr,lf
	db	'Touch the CRT face and I will display the X and Y values'
	db	cr,lf,cr,lf
	db	'Type any character to exit the program',cr,lf
	db	cr,lf
	db	'X char',tab,'Y char',tab,'X val',tab,'Y val',cr,lf
	db	'$'

;	BDOS interface routines

bdos	equ	5		;define entry point to BDOS

conio:		;Reg E = 0FFh for input, or character for output.
;		 Return A = char or status, 0 = no char, other = input.
	mvi	c,06h
	jmp	bdos

getiob:		;Return A = I/O byte value
	mvi	c,07h
	jmp	bdos

setiob:		;set I/O byte to value in E
	mvi	c,08h
	jmp	bdos

prints:		;print string at (DE) stop on '$'
	mvi	c,09h
	jmp	bdos

rdrin:		;get Reader (touch panel) char to A
;		0 = no character
;		X value biased by 20h
;		Y value biased by 30h
	mvi	c,03h
	jmp	bdos

;	start of touch test

ttest:
	lxi	d,signon
	call	prints		;print signon message
	call	getiob		;get I/O byte
	ani	0f3h		;clear reader bits
	ori	4		;set reader bits to 01b
	mov	e,a
	call	setiob

;	test loop
tloop	call	rdrin		;get touch panel char
	ana	a		;set flags
	jnz	gotit		;if char present
	mvi	e,0ffh		;flag input
	call	conio
	ana	a		;set flags
	rnz			;exit test if key pressed
	jmp	tloop

gotit:		;have a touch panel character
	cpi	30h
	jm	gotx		;if x character
	sta	ych		;have y value
	lda	xch		;may have value '$'
	mov	e,a
	call	conio
	lda	xch		;convert to ascii
	sbi	20h		;remove bias
	sbi	10
	push	a
	jm	g1
	mvi	a,'1'
	jmp	g2
g1:	mvi	a,'0'
g2:	sta	xval
	pop	a
	jp	g3
	adi	10
g3:	adi	'0'
	sta	xval+1
	lda	ych		;convert to ascii
	sbi	30h		;remove bias
	sbi	10
	push	a
	jm	h1
	mvi	a,'1'
	jmp	h2
h1:	mvi	a,'0'
h2:	sta	yval
	pop	a
	jp	h3
	adi	10
h3:	adi	'0'
	sta	yval+1
	lxi	d,xydis		;display message
	call	prints
	jmp	tloop

gotx:		;save x character until y arives
	sta	xch
	jmp	tloop

;	output area to display X and Y

xch:	db	'^'
xydis:	db	tab
ych:	db	'^',tab
xval:	db	'  ',tab
yval:	db	'  ',cr,lf,'$'

	end
bits to 01b
	mov	e,a
	call	setiob

;	test loop
tloop	call	rdrin		;get touch panel char
	ana	a		;set flags
	jnz	