

	MACLIB	Z80

;
;
;COLD BOOT LOADER FOR CP/M 2.2
; FOR THE Z80 SBC
;LAST UPDATE 5/15/82
;

mini	equ	0			;set to 0ff for mini
;
RTYN	EQU	10			; disk io retries
SEEKRT	EQU	1			; rate 0=3ms, 1=6ms, 2=10ms, 3=20ms
CDISK 	EQU 	4			; last disk selected by the ccp
BELL	EQU	07			; ding
MAXDSK	EQU	1			; largest disk number
MONIT	EQU	0F033H			; monitor boot error entry point
if	mini
loader	equ	180h
else
loader	equ	100h
endif

cmdstatus equ	100h-4
sectors	equ	100h-2
;
CMD	EQU	0CH			; fdc command & fdc status register	
TK	EQU	CMD+1			; fdc track register
SECMD	EQU	CMD+2			; fdc sector register
DAL	EQU	CMD+3			; fdc data port
WAIT	EQU	014H	  		; hardware wait for fdc intrq + drq
					;  & drive select - restore latch
;
;
BUFF	EQU	80H			; default dma buffer

ORG	0
;
;

WBOOT:
	MVI	A,01101111B	
	OUT	16H	
	lda	nsects
	mov	d,a
	lxi	h,100h
if mini
	mvi	e,1			;start with sector 1 for mini
else
	mvi	e,2
endif
RBLK1:
if	mini
	lxi	b,dal
else
	LXI	B,8000H+DAL		; 
endif
	MOV	A,E			; get sector
	OUT	SECMD			; set sector
	MVI	A,088H			; get operation
	OUT	CMD
	NOP

READLOOP:
	IN	WAIT			; wait for drq or intrq
	ORA	A			; was it intrq ?
	JP	IODONE
	INI
	JR	READLOOP

IODONE:
	IN	CMD
	MOV	C,A
	SBCD	CMDSTATUS
	ORA	B			; 
	JRNZ	BOOTERROR	

	DCR	D			; one less blockr
if	mini
	JZ	goloader		; exit when zero
else
	jz	loader
endif
	INR	E
	mvi	a,26+1
	CMP	E
	JRNZ	RBLK1


BOOTERROR:
	SDED	SECTORS
	MVI	A,01001111B
	OUT	16H
	LDA	CMDSTATUS
	JMP	MONIT

if mini
goloader:
	lxi	H,loader
	lxi	D,100h			;move loader from 180h to 100h for mini
	lxi	B,1000h			;largest loader could be
	ldir
	jp	100h
endif

	ORG	07eH
nsects:	if	mini
	db	4
else
	db	24
endif

dens:	db	0e5h			;density flag patched by sysgen

	END

