;WRITTEN BY RUSSELL F. BUSHNELL JR.
;MARCH 30, 1987
;
;
;
;MACHINE LANGUAGE RUN-TIME SYSTEM FOR 5046 TEST
;
;
;
;
PPI0PA   EQU 0020H;PORT A(PPI0, IC10)
PPI0PB   EQU 0021H;PORT B(PPI0, 1C10)
PPI0PC   EQU 0022H;PORT C(PPI0, IC10)
PPI1PA   EQU 0024H;PORT A(PPI1, IC11)
PPI1PB   EQU 0025H;PORT B(PPI1, IC11)
PPI1PC   EQU 0026H;PORT C(PPI1, IC11)
PPI2PA   EQU 0028H;PORT A(PPI2, IC12)
PPI2PB   EQU 0029H;PORT B(PPI2, IC12)
PPI2PC   EQU 002AH;PORT C(PPI2, IC12)
PPI3PA   EQU 002CH;PORT A(PPI3, IC13)
PPI3PB   EQU 002DH;PORT B(PPI3, IC13)
PPI3PC   EQU 002EH;PORT C(PPI3, IC13)
PPI4PA   EQU 0030H;PORT A(PPI4, IC28)
PPI4PB   EQU 0031H;PORT B(PPI4, IC28)
PPI4PC   EQU 0032H;PORT C(PPI4, IC28)
PPI5PA   EQU 0040H;PORT A(PPI5, IC55)
PPI5PB   EQU 0041H;PORT B(PPI5, IC55)
PPI5PC   EQU 0042H;PORT C(PPI5, IC55)
PPI6PA   EQU 0044H;PORT A(PPI6, IC56)
PPI6PB   EQU 0045H;PORT B(PPI6, IC56)
PPI6PC   EQU 0046H;PORT C(PPI6, IC56)
PPI7PA   EQU 0048H;PORT A(PPI7, IC57)
PPI7PB   EQU 0049H;PORT B(PPI7, IC57)
PPI7PC   EQU 004AH;PORT C(PPI7, IC57)
PPI8PA   EQU 004CH;PORT A(PPI8, IC58)
PPI8PB   EQU 004DH;PORT B(PPI8, IC58)
PPI8PC   EQU 004EH;PORT C(PPI8, IC58)
PPICP0   EQU 0023H;CONTROL PORT 0(PPI0, IC10)
PPICP1   EQU 0027H;CONTROL PORT 1(PPI1, IC11)
PPICP2   EQU 002BH;CONTROL PORT 2(PPI2, IC12)
PPICP3   EQU 002FH;CONTROL PORT 3(PPI3, IC13)
PPICP4   EQU 0033H;CONTROL PORT 4(PPI4, IC28)
PPICP5   EQU 0043H;CONTROL PORT 5(PPI5, IC55)
PPICP6   EQU 0047H;CONTROL PORT 6(PPI6, IC56)
PPICP7   EQU 004BH;CONTROL PORT 7(PPI7, IC57)
PPICP8   EQU 004FH;CONTROL PORT 8(PPI8, IC58)
PIC0L    EQU 0034H;HEX 34 = PORT(PIC0, IC14)
PIC0H    EQU 0035H;HEX 35 = PORT(PIC0, IC14)
ICW1     EQU 0012H;HEX 12 = LWRADDR A7-A5, INTERVAL = 8, SINGLE
ICW2     EQU 0003H;HEX 03 = UPPADDR A15-A8(UPPER ROUTINE ADDRESS)
ICW3     EQU 0000H;HEX 00 = IR INPUT HAS NO SLAVE
OCW1     EQU 0000H;HEX 00 = MASK RESET
OCW2     EQU 0020H;HEX 20 =NON-SPEC. EOI(RESET HIGHEST PRI. BIT OF ISR)
OCW3     EQU 000FH;HEX 0F = POLLING ON NEXT READ (BCD OF HIGHEST INT.)
CTLWD1   EQU 0080H;HEX 80 = PORTS(A,B,C = OUTPUT)
CTLWD2   EQU 009BH;HEX 9B = PORTS(A,B,C = INPUT)
CTLWD3   EQU 00BEH;HEX BE = PORTS(A,B = INPUT, C = INTERRUPT)
CTLWD4   EQU 0009H;HEX 9 = PPI INTE A ENABLE (SET BIT VALUE - PC4)
CTLWD5   EQU 0005H;HEX 5 = PPI INTE B ENABLE (SET BIT VALUE - PC2)
CTLWD7   EQU 0092H;HEX 92 = PORTS(A,B = INPUT, C = OUTPUT)
CTLWD8   EQU 0089H;HEX 89 = PORTS(A,B = OUTPUT, C = INPUT)
CTLWD9   EQU 0081H;HEX 81 = PORTS(A,B,C4-C7 = OUTPUT, C0-C3 = INPUT)
EFTAG    EQU 10H;EXTERNAL FUNCTION CONTROL TAG
OATAG    EQU 20H;OUTPUT ACKNOWLEDGE CONTROL TAG
IATAG    EQU 40H;INPUT ACKNOWLEDGE CONTROL TAG
CLRTAG   EQU 80H;CLEAR SUBSYSTEM CONTROL TAG
ODRTAG   EQU 10H;OUTPUT DATA REQUEST CONTROL TAG (INPUT SIGNAL)
IDRTAG   EQU 20H;INPUT DATA REQUEST CONTROL TAG  (INPUT SIGNAL)
EITAG    EQU 40H;EXTERNAL INTERRUPT CONTROL TAG  (INPUT SIGNAL)
IPERR    EQU 80H;INPUT PARITY ERROR SIGNAL (INPUT SIGNAL)
ODRINT   EQU 81H;OUTPUT DATA REQUEST INTERRUPT VALUE (INPUT - PIC)
IDRINT   EQU 82H;INPUT DATA REQUEST INTERRUPT VALUE (INPUT - PIC)
EIINT    EQU 80H;EXTERNAL INTERRUPT INTERRUPT VALUE (INPUT - PIC)
IPERRINT EQU 83H;INPUT PARITY ERROR SIGNAL INTERRUPT VALUE(INPUT - PIC)
IHRDWAR0 EQU 00H;0 = INITILIZE HARDWARE COMMAND (MODE 0)
IHRDWAR1 EQU 01H;1 = INITILIZE HARDWARE COMMAND (MODE 1)
EXPAC    EQU 03H;3 = EXECUTE PACKET COMMAND
INSTRUC  EQU 04H;4 = INSTRUCTION COMMAND
DIR      EQU 05H;5 = DIRECTORY COMMAND
SPDAT    EQU 06H;6 = SAVE PACKET DATA (FILE)
DPDAT    EQU 07H;7 = DUMP PACKET DATA (FILE)
CPDATF   EQU 08H;8 = COMPARE PACKET DATA (FILES)
MAKPAC   EQU 09H;9 = MAKE PACKET (SAVE TO DISK)
PRNTC    EQU 0AH;A = TOGGLE PRINTER COMMAND
DELFIL   EQU 0BH;B = DELETE FILE COMMAND
DMPPKT   EQU 0CH;C = DUMP PACKET COMMAND
APOST    EQU 0DH;D = POST ANALYSIS
BADCMDS  EQU 0FFH;FF = BAD COMMAND STATUS
GOODST   EQU 00H;0 = GOOD STATUS (NORMAL COMMAND COMPLETION)
DATERR   EQU 01H;1 = DATA ERROR
FRMT1    EQU 01H;1 = STATUS FORMAT/TABLE 1
CONDT    EQU 01H;CONDITION TRUE
CONDF    EQU 00H;CONDITION FALSE
ZERO     EQU 00H;0=0
ONE      EQU 01H;1=1
RECSIZ   EQU 128;IBM 3740 RECORD SIZE
ABUFSIZ  EQU 0400H;0400 HEX = 1024 DEC
BBUFSIZ  EQU 0400H;0400 HEX = 1024 DEC
CBUFSIZ  EQU 0400H;0400 HEX = 1024 DEC
BOOT     EQU 0000H;CPM REBOOT (WARM START)
FDOS     EQU 0005H;CPM DOS ENTRY POINT
DCONF    EQU 6;DIRECT CONSOLE I/O FUNCTION 6
CONINF   EQU 1;CONSOLE INPUT FUNCTION 1
CONOUTF  EQU 2;CONSOLE OUTPUT FUNCTION 2
OPENF    EQU 15;OPEN FILE FUNCTION 15
CLOSEF   EQU 16;CLOSE FILE FUNCTION 16
DELETEF  EQU 19;DELETE FILE FUNCTION 19
READF    EQU 20;SEQUENTIAL READ FUNCTION 20
WRITEF   EQU 21;SEQUENTIAL WRITE FUNCTION 21
MAKEF    EQU 22;MAKE FILE FUNCTION 22
SDMADD   EQU 26;SET DMA ADDRESS FUNCTION 26
SCHFST   EQU 17;SEARCH FOR FIRST FUNCTION 17
SCHNXT   EQU 18;SEARCH FOR NEXT  FUNCTION 18
CONSTF   EQU 11;GET CONSOL STATUS FUNCTION 11
DWDLIN   EQU 0006H;DATA WORDS PER LINE
BIOSL1   EQU 0E833H;BIOS M259NCPC - AUTO CONSOLE PRINTER LOC.
BIOSL2   EQU 0FC33H;BIOS M264NCPC - AUTO CONSOLE PRINTER LOC.
BIOSL3   EQU 0E883H;BIOS B59MB3NC - AUTO CONSOLE PRINTER LOC.
LENGA    EQU 5BH;5BH = 91D
LENGB    EQU 04H;04H = 4D
LENGC    EQU 0BH;0BH = 11D
FALSE    EQU 0;VALUE OF FALSE
TRUE     EQU NOT FALSE;VALUE OF TRUE
TEST1    EQU TRUE;ASSEMBLE PROGRAM IN TEST MODE
MSGSA    EQU TRUE;MESSAGE SET A (STATUS WORD)
AHLPMSG  EQU FALSE;INCLUDE STATUS HELP MESSAGES
;
ORG 0A800H;WHERE THIS PROGRAM RUNS IN MEMORY
;
;NOTE - 1)ASM THIS PROGRAM.
;       2)LOAD HEX FILE AND MAKE A CPM COM FILE.
;       3)LOAD DDT,LOAD COM FILE.
;       4)PUT A JMP TO ORG LOCATION OF THIS PROGRAM AT 
;         MEMORY LOCATION 0100 (BEGINING OF TPA).
;       5)DO A CTRL C TO WARM BOOT CPM.
;       6)TYPE THIS - SAVE 164 M5046.COM (OR OTHER FILE NAME).
;       7)RUN NEW COM FILE "M5046" (5046 RUN-TIME SYSTEM).
;       8)THEN RUN PASCAL COUNTER PART.
;
LXI H,SMSG;DISPLAY SIGNON MESSAGE
CALL PMSG;DO IT!
JMP BOOT;JUMP TO CPM
;
JMP ISWM0;THIS LOCATION IS FORMAL ENTRY ADDRESS
;
;FORMAL PARAMETERS (USER LANGUAGE - INTERFACE)
;
LDKEY:   DB 0AAH;RUN TIME SYSTEM LOAD KEY (LOC./VALUE)
SADD:    DB 00H;LSB OF STARTING ADDRESS
         DB 00H;MSB OF STARTING ADDRESS
EADD:    DB 0FFH;LSB OF ENDING ADDRESS
         DB 3FH;MSB OF ENDING ADDRESS
SDATA:   DB 00H;LSB OF STARTING DATA (SEED WORD)
         DB 00H;
         DB 00H;
         DB 00H;
         DB 00H;
EDATA:   DB 00H;LSB OF ENDING DATA
         DB 00H;
         DB 00H;
         DB 00H;
         DB 00H;
XADD:    DB 00H;LSB - SCRATCH ADDRESS (RUN-TIME)
         DB 00H;
         DB 00H;
         DB 00H;
         DB 00H;
XDATA:   DB 00H;LSB - SCRATCH DATA (RUN-TIME)
         DB 00H;
         DB 00H;
         DB 00H;
         DB 00H;
PRGCMD:  DB 03H;PROGRAM COMMAND
PRGMOD:  DB 00H;MISC. PROGRAM MODIFIERS
CMDMOD:  DB 00H;MISC. COMMAND MODIFIERS
DATMOD:  DB 00H;MISC. DATA MODIFIERS
PRGCNT:  DB 00H;LSB - MISC. COUNTER
         DB 00H;MSB - MISC. COUNTER
XPRGCNT: DB 00H;LSB - MISC. SCRATCH COUNTER
         DB 00H;MSB - MISC. SCRATCH COUNTER
CBIAS:   DB 00H;LSB - COUNTER BIAS
         DB 00H;MSB - COUNTER BIAS
HSTATS:  DB 00H;HARDWARE STATUS
         DB 00H;FORMAT/TABLE
PSTATS:  DB 00H;PROGRAM STATUS
         DB 00H;FORMAT/TABLE
ERRCNT:  DB 00H;ERROR COUNTER (LSB)
         DB 00H;ERROR COUNTER (MSB)
RETRYC:  DB 00H;RETRY COUNTER (LSB)
         DB 00H;RETRY COUNTER (MSB)
RETRYX:  DB 00H;CURRENT RETRY COUNT (LSB)
         DB 00H;CURRENT RETRY COUNT (MSB)
FCBA:
DRA:     DB 00H;START OF FILE CONTROL BLOCK A (SEE CPM INTERFACE GUIDE)
FILENA:
F1A:     DB 'F';NEXT ELEVEN BYTES FOR FILENAME A
         DB 'I';
         DB 'L';
         DB 'E';
         DB ' ';
         DB 'A';
         DB ' ';
F8A:     DB ' ';
T1A:     DB ' ';
T2A:     DB ' ';
T3A:     DB ' ';
EXA:     DB 00H;
S1A:     DB 00H;
S2A:     DB 00H;
RCA:     DB 00H;
D0A:     DS 16;
CRA:     DB 00H;
R0A:     DB 00H;
R1A:     DB 00H;
R2A:     DB 00H;
FCBB:
DRB:     DB 00H;START OF FILE CONTROL BLOCK B
FILENB:
F1B:     DB 'F';NEXT ELEVEN BYTES FOR FILENAME B
         DB 'I';
         DB 'L';
         DB 'E';
         DB ' ';
         DB 'B';
         DB ' ';
F8B:     DB ' ';
T1B:     DB ' ';
T2B:     DB ' ';
T3B:     DB ' ';
EXB:     DB 00H;
S1B:     DB 00H;
S2B:     DB 00H;
RCB:     DB 00H;
D0B:     DS 16;
CRB:     DB 00H;
R0B:     DB 00H;
R1B:     DB 00H;
R2B:     DB 00H;
FCBC:
DRC:     DB 00H;START OF FILE CONTROL BLOCK C
FILENC:
F1C:     DB 'F';NEXT ELEVEN BYTES FOR FILENAME C
         DB 'I';
         DB 'L';
         DB 'E';
         DB ' ';
         DB 'C';
         DB ' ';
F8C:     DB ' ';
T1C:     DB ' ';
T2C:     DB ' ';
T3C:     DB ' ';
EXC:     DB 00H;
S1C:     DB 00H;
S2C:     DB 00H;
RCC:     DB 00H;
D0C:     DS 16;
CRC:     DB 00H;
R0C:     DB 00H;
R1C:     DB 00H;
R2C:     DB 00H;
ABUFF:   DS RECSIZ;SPACE FOR RECORD A
BBUFF:   DS RECSIZ;SPACE FOR RECORD B
PBUFF:   DS RECSIZ;SPACE FOR RECORD C
ABPTR:   DB 00H;BUFFER POINTER A (LSB)
         DB 00H;BUFFER POINTER A (MSB)
BBPTR:   DB 00H;BUFFER POINTER B (LSB)
         DB 00H;BUFFER POINTER B (MSB)
PBPTR:   DB 00H;BUFFER POINTER C (LSB)
         DB 00H;BUFFER POINTER C (MSB)
XCNTR:   DB 00H;SCRATCH COUNTER (LSB)
         DB 00H;SCRATCH COUNTER (MSB)
XCNTRB:  DB 00H;SCRATCH COUNTER (LSB)
         DB 00H;SCRATCH COUNTER (MSB)
STKPTR:  DB 00H;
         DB 00H;
         DS 80H;128 BYTES FOR NEW STACK AREA
NEWSTK:  DB 00H;THIS LOCATION IS TOP OF STACK
PRNSTS:  DB 00H;BIOS VER. AVAILABLE - 00=NOT YET,FF=NO,C9=YES
         DB 00H;BIOS IDENTIFIER 1,2 OR 3
         DB 0C9H;PRINTER ON / OFF STATUS BYTE 0=ON, C9=OFF
         DB 00H;
         DB 00H;
WMEMIO:  DB 03H;HEX 03 = NO WAIT-STATES FOR MEMORY OR I/O
EFW:     DB 00H;BITS 0  -  7 OF THE EXTERNAL FUNCTION WORD (LSB)
         DB 00H;BITS 8  - 15 OF THE EFW
         DB 00H;BITS 16 - 23 OF THE EFW
         DB 00H;BITS 24 - 31 OF THE EFW
         DB 00H;BITS 32 - 39 OF THE EFW (MSB)
AFW:     DB 00H;BITS 0  -  7 OF THE ADDRESS FUNCTION WORD (LSB)
         DB 00H;BITS 8  - 15 OF THE AFW
         DB 00H;BITS 16 - 23 OF THE AFW
         DB 00H;BITS 24 - 31 OF THE AFW
         DB 00H;BITS 32 - 39 OF THE AFW (MSB)
ODW:     DB 00H;BITS 0  -  7 OF THE OUTPUT DATA WORD (LSB)
         DB 00H;BITS 8  - 15 OF THE ODW
         DB 00H;BITS 16 - 23 OF THE ODW
         DB 00H;BITS 24 - 31 OF THE ODW
         DB 00H;BITS 32 - 39 OF THE ODW (MSB)
IDW:     DB 00H;BITS 0  -  7 OF THE INPUT DATA WORD (LSB)
         DB 00H;BITS 8  - 15 OF THE IDW
         DB 00H;BITS 16 - 23 OF THE IDW
         DB 00H;BITS 24 - 31 OF THE IDW
         DB 00H;BITS 32 - 39 OF THE IDW (MSB)
STW:     DB 00H;BITS 0  -  7 OF THE STATUS WORD (LSB)
         DB 00H;BITS 8  - 15 OF THE STW
         DB 00H;BITS 16 - 23 OF THE STW
         DB 00H;BITS 24 - 31 OF THE STW
         DB 00H;BITS 32 - 39 OF THE STW (MSB)
XFCNT:   DB 00H;TRANSFER COUNT (LSB)
         DB 00H;(MSB)
LOWSP:     DB 00H;LOW SPEED MODIFIER
HIGHSP    DB 00H;HIGH SPEED MODIFIER
CMPMOD:  DB 00H;COMPARE MOD.
CLRMOD:  DB 00H;CLEAR MOD.
EFWMOD:  DB 00H;EF MOD. (PACKET HAS EF TO SEND)
AFWMOD:  DB 00H;AF MOD.
IDWMOD:  DB 00H;ID MOD.
ODWMOD:  DB 00H;OD MOD.
EIWMOD:  DB 00H;EI MOD.
PARMOD:  DB 00H;PARITY MOD.
MSTOP:   DB 00H;MENU STOP MOD.
ONERR:   DB 00H;ON ERROR MOD.
INVEF:   DB 00H;CAUSE INVALID EF MOD.
INVTAG:  DB 00H;CAUSE INVALID TAG MOD.
INVPAR:  DB 00H;CAUSE PARITY ERROR MOD.
INVTIM:  DB 00H;CAUSE TIME-OUT MOD.
TIMCNT:  DB 00H;TIME-OUT COUNT VALUE (LSB)
         DB 00H;(MSB)
RECSB:   DB 00H;RECOVER SENSE BYTES MOD.
RECUL:   DB 00H;RECOVER USAGE LOG MOD.
DRECA:   DB 00H;DO RECOVERY ACTION ON ERROR MOD.
SAVIBF:  DB 00H;SAVE INPUT BUFFER TO DISK MOD.
CMPSTW:  DB 01H;COMPARE STATUS WORD MODIFIER
DISPSTW: DB 01H;DISPLAY STATUS WORD MODIFIER
DSPSHLP: DB 00H;DISPLAY STW HELP MODIFIER
SVSTSN:  DB 01H;SAVE STW & SENSE BYTES TO DISK (PACKET)
STWREC:  DB 01H;STW RECOVERY ENABLE MODIFIER
ANASTW:  DB 01H;ANALYZE STW FOR FANCY DISPLAY AND RECOVERY
XSTW:    DB 00H;INPUT STW STORAGE
         DB 00H;
         DB 00H;
         DB 00H;
         DB 00H;MSB OF STW
BUFRPT:  DB 01H;REPEATING BUFFER MODIFIER
WRDRPT:  DB 01H;REPEATING WORD MODIFIER (BUFRPT MUST ALSO BE SET)
LSTPAC:  DB 01H;LAST PACKET MODIFIER (IN FILE)
PRPCNT:  DB 00H;PACKET REPEAT COUNT (LSB)
         DB 00H;(MSB)
;EXTRA:   DS 03H;FUTURE
SENSEBYT DS 24H;BUFFER FOR 24 SENSE BYTES
XA:      DB 00H;SCRATCH STORAGE 0-4
         DB 00H;
         DB 00H;
         DB 00H;
         DB 00H;
XB:      DB 00H;SCRATCH STORAGE 0-4
         DB 00H;
         DB 00H;
         DB 00H;
         DB 00H;
STATET:  DB 00H;STATE OF CHANNEL TAG (LSB)
         DB 00H;(MSB)
WTAG:    DB 00H;CURRENT TAG (DURING WAIT)
TWCNT:   DB 00H;CURRENT COUNT FOR TIME-OUT (LSB)
         DB 00H;(MSB)
TMCNT:   DB 00H;MAX COUNT FOR TIME-OUT (LSB)
         DB 00H;(MSB)
EFCNT:   DB 00H;TOTAL EF COUNT (LSB)
         DB 00H;(MSB)
AFCNT:   DB 00H;TOTAL AF COUNT (LSB)
         DB 00H;(MSB)
ODCNT:   DB 00H;TOTAL OD COUNT (LSB)
         DB 00H;(MSB)
IDCNT:   DB 00H;TOTAL ID COUNT (LSB)
         DB 00H;(MSB)
STCNT:   DB 00H;TOTAL EI COUNT (LSB)
         DB 00H;(MSB)
PASS:    DB 00H;FOR LOOP CONTROL
XXFCNT:  DB 00H;TEMP - SAVE XFER CNT (LSB)
         DB 00H;(MSB)
;
;
;
;
ISWM0:;INITILIZE SOFTWARE MODE 0
         PUSH PSW;
         PUSH B;
         PUSH D;
         PUSH H;
         LXI H,0000H;
         DAD SP;
         SHLD STKPTR;
         LXI SP,NEWSTK;ASSIGN NEW STACK
         MVI A,00H;CLEAR A REG
         STA HSTATS;CLEAR HARDWARE STATUS (LAST)
         STA PSTATS;CLEAR PROGRAM STATUS (LAST)
         STA ERRCNT;CLEAR ERROR COUNTER (LSB)
         STA ERRCNT + 1;CLEAR ERROR COUNTER (MSB)
         LDA SADD;INIT STARTING ADDRESS (LSB)
         STA XADD;
         LDA SADD + 1;INIT STARTING ADDRESS (MSB)
         STA XADD + 1;
         LDA SDATA;INIT STARTING DATA (LSB)
         STA XDATA;
         LDA SDATA + 1
         STA XDATA + 1
         LDA SDATA + 2
         STA XDATA + 2
         LDA SDATA + 3
         STA XDATA + 3
         LDA SDATA + 4
         STA XDATA + 4
         LDA PRGCNT;INIT MISC. COUNTER (LSB)
         STA XPRGCNT;
         LDA PRGCNT + 1;INIT MISC. COUNTER (MSB)
         STA XPRGCNT + 1;
         JMP GETCMD
;
IHRDWM0:;INITILIZE HARDWARE MODE 0
         MVI A,CTLWD1;
         OUT PPICP1;
         OUT PPICP2;
         MVI A,CTLWD2;
         OUT PPICP6;
         OUT PPICP7;
         MVI A,CTLWD3;
         OUT PPICP8;
         MVI A,CTLWD4;
         OUT PPICP8;
         OUT PPICP5;
         MVI A,CTLWD5;
         OUT PPICP8;
         OUT PPICP5;
         IN PPI8PA;
         IN PPI8PB;
         IN PPI5PA;
         IN PPI5PB;
         MVI A,CTLWD1;
         OUT PPICP0;
         LDA WMEMIO;
         OUT PPI0PC;
         MVI A,ICW1;
         OUT PIC0L;
         MVI A,ICW2;
         OUT PIC0H;
         MVI A,ICW3;
         PIC35;
         JMP HLEVLG
;
IHRDWM1:;INITILIZE HARDWARE MODE 1
         JMP HLEVLG;BACK TO HIGH LEVEL LANGUAGE
;
GETCMD:
         LDA PRGCMD;GET COMMAND
         CPI IHRDWAR0;INITILIZE HARDWARE(MODE 0) COMMAND
         JZ IHRDWM0;IF PRGCMD - THEN INITILIZE HARDWARE
         CPI IHRDWAR1;INITILIZE HARDWARE(MODE 1) COMMAND
         JZ IHRDWM1;IF PRGCMD - THEN INITILIZE HARDWARE
         CPI EXPAC;EXECUTE PACKET
         JZ RUNPAC;IF PRGCMD - THEN EXECUTE PACKETS
         CPI INSTRUC;INSTRUCTIONS
         JZ DTXTF;IF PRGCMD - THEN DUMP ASCII TEXT FILE
         CPI DIR;DISPLAY DIRECTORY
         JZ DDIR;IF PRGCMD - THEN DISPLAY DIRECTORY
         CPI DELFIL;DELETE FILE
         JZ FILDEL;IF PRGCMD - THEN DELETE FILE
         CPI DMPPKT;DUMP PACKET
         JZ PKTDMP;IF PRGCMD - THEN DUMP PACKET
         CPI APOST;POST ANALYSIS
         JZ POSTANA;IF PRGCMD - THEN POST PACKET ANALYSIS
         CPI SPDAT;SAVE PACKET DATA
         JZ SAVDAT;IF PRGCMD - THEN SAVE PACKET DATA
         CPI DPDAT;DUMP PACKET DATA
         JZ DFILES;IF PRGCMD - THEN DUMP PACKET DATA
         CPI CPDATF;COMPARE PACKET DATA FILES
         JZ CFILES;IF PRGCMD - THEN COMPARE PACKET DATA FILES
         CPI MAKPAC;MAKE PACKET (SAVE TO DISK)
         JZ SAVPAC;THEN SAVE PACKET (ACTUAL TEST)
         CPI PRNTC;TOGGLE PRINTER COMMAND
         JZ PRNT;IF PRGCMD - THEN TOGGLE PRINTER ON OR OFF
         MVI A,BADCMDS;BAD COMMAND
         STA PSTATS
         JMP HLEVLG;BACK TO HIGH LEVEL LANGUAGE ON BAD COMMAND

HLEVLG:
         LHLD STKPTR
         SPHL
         POP H
         POP D
         POP B
         POP PSW
         RET;BACK TO HIGH LEVEL LANGUAGE
;
;PRINT THE MESSAGE AT H AND L UNTIL A ZERO
;
PMSG:
         MOV A,M;GET A CHAR. ADDRESSED BY THE H AND L REG.
         ORA A;IF ITS'S STILL ZERO,
         RZ;RETURN
         MOV E,A;
         MVI A,CONOUTF;
         MOV C,A;
         PUSH H;
         CALL FDOS;
         POP H;
         INX H;INCREMENT REG PAIR H AND L
         JMP PMSG;AND GET ANOTHER CHARACTER
;
;PUT ALL MESSAGES HERE
;
SMSG:;SIGNON MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB '5046 RUN TIME SYSTEM IS NOW LOADED',0
;
MSG1:;FILE EXISTS MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'FILE ALREADY EXISTS',0
;
MSG2:;FILE CREATED MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'FILE CREATED',0
;
MSG3:;NO DIRECTORY SPACE MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'THE DIRECTORY IS FULL AND/OR DISK IS WRITE PROTECTED',0
;
MSG4:;FILE OPEN MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'FILE OPENED SUCCESSFULLY',0
;
MSG5:;FILE NO DID CLOSE MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'UNABLE TO CLOSE FILE',0
;
MSG6:;WRITE ERROR MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'WRITE ERROR - DISK IS FULL AND/OR DISK IS WRITE PROTECTED',0
;
MSG7:;FILE CLOSE MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'FILE CLOSED SUCCESSFULLY',0
;
MSG8:;UNABLE TO OPEN MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'UNABLE TO OPEN FILE',0
;
MSG9:;OUT OF DATA MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'READ ERROR - OUT OF DATA (EOF)',0
;
MSG10:;SHOULD BE MESSAGE
         DB 'SHOULD BE = ',0
;
MSG11:;WAS MESSAGE
         DB '  WAS = ',0
;
MSG12:;DATA COMPARE ERROR MESSAGE
         DB 'DATA COMPARE ERROR - ',0
;
MSG13:;TOTAL ERROR MESSAGE
         DB 'TOTAL ERRORS = ',0
;
MSG14:;FILE NO DID DELETE MESSAGE
         DB 0DH,0AH;CR&LF
         DB 'UNABLE TO DELETE FILE',0
;
MSG15:;DELETE FILE MESSAGE
         DB 0DH,0AH;CR&LF
         DB 'FILE DELETED',0
;
MSG16:;MISC.
         DB ' : ',0;
;
MSG17:;MISC.
         DB 0DH,0AH,0;
;
MSG18:;MISC.
         DB ' ',0;
;
MSG21:;HEX MESSAGE
         DB ' (HEX) ',0
;
MSG22:;WRONG BIOS MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'SORRY - WRONG BIOS VERSION!!! ',0
;
MSG23:;PRINTER ON MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'PRINTER IS NOW ON! ',0
;
MSG24:;PRINTER OFF MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'PRINTER IS NOW OFF! ',0
;
MSG30:;STATUS HEADER MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 0AH;LINE FEED
         DB '           * * *   MAID-III - 5046 CHANNEL STATUS WORD '
         DB '(BITS 35 - 0)   * * * '
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 0AH;LINE FEED
         DB 00H;END OF MESSAGE ID.
;
IF MSGSA;ASSEMBLE IF MESSAGE SET A
MSG31:;CT MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB ' - CHANNEL TRUNCATION BIT IS SET (CT - STATUS BIT 31) ',0
;
ENDIF;
IF AHLPMSG
MSG32:;CT HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'THE CHANNEL TRUNCATION BIT, IN BIT POSITION 31; IS SET TO'
         DB 0DH,0AH;
         DB 'INDICATE TRUNCATION OF DATA TRANSFER WHEN THE CHANNEL '
         DB 0DH;0AH;
         DB 'FAILS TO RESPOND TO AN INPUT OR OUTPUT DATA WORD REQUEST'
         DB 0DH,0AH;
         DB 'WITHIN 2 MILLISECONDS.CHANNEL TRUNCATION MAY REPRESENT AN'
         DB 0DH,0AH;
         DB 'ABNORMAL CONDITION AS A RESULT OF A PROGRAMMING ERROR OR '
         DB 0DH,0AH;
         DB 'A HARDWARE MALFUNCTION. HOWEVER, CHANNEL TRUNCATION CAN '
         DB 0DH,0AH;
         DB 'BE AN EXPECTED CONDITION FOR CERTAIN COMMAND USAGES OR '
         DB 0DH,0AH;
         DB 'WHEN A FORCED EF IS USED TO TERMINATE DATA TRANSFER. '
         DB 0DH,0AH;
         DB 'CHANNEL TRUNCATION MAY ALSO BE SPECIFIED BY THE STATUS '
         DB 0DH,0AH;
         DB 'ACTION VALUE. ',0
;
ENDIF;
IF MSGSA;
MSG33:;STATUS ACTION MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB ' - STATUS ACTION   = ',0
;
ENDIF;
IF AHLPMSG;
MSG34:;STATUS ACTION HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB ' ',0
;
ENDIF;
IF MSGSA;
MSG35:;STATUS ACTION VALUE MESSAGE
        DB 'START A READ LABEL COMMAND FOR THE CURRENT DEVICE (01H).',0
;
ENDIF;
IF AHLPMSG;
MSG36:;STATUS VALUE HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
        DB 'THIS STATUS ACTION IS PRESENTED ONLY WITH ATTENTION STATUS'
         DB 0DH,0AH;
         DB 'ALONE AND INDICATES A DISK PACK CHANGE CONDITION AT THE'
         DB 0DH,0AH;
         DB 'CURRENT DISK UNIT. THIS ACTION WILL BE PRESENTED IN AN'
         DB 0DH,0AH;
         DB 'UNSOLICITED STATUS WORD. ',0
;
ENDIF;
IF MSGSA;
MSG37:;STATUS ACTION VALUE MESSAGE
        DB 'START A READ LABEL COMMAND FOR THE CURRENT DEVICE (02H).',0
;
ENDIF;
IF AHLPMSG;
MSG38:;STATUS VALUE HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'THIS STATUS ACTION IS PRESENTED ONLY WITH ATTENTION AND'
         DB 0DH,0AH;
        DB 'BUSY STATUS. THIS INDICATES THAT THE CU HAS TERMINATED THE'
         DB 0DH,0AH;
         DB 'CURRENT COMMAND PRIOR TO EXECUTION BECAUSE OF A DISK PACK'
         DB 0DH,0AH;
         DB 'CHANGE CONDITION AT THE SAME DISK UNIT AS SPECIFIED IN'
         DB 0DH,0AH;
         DB 'THIS COMMAND. ',0
;
ENDIF;
IF MSGSA;
MSG39:;STATUS ACTION VALUE MESSAGE
         DB 'RESTART THE CURRENT COMMAND FOR THE CURRENT DEVICE (03H).'
;
ENDIF;
IF AHLPMSG;
MSG40:;STATUS VALUE HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
        DB 'THIS STATUS ACTION IS PRESENTED ONLY WITH STATUS MODIFIER,'
         DB 0DH,0AH;
         DB 'CONTROL UNIT END, AND BUSY STATUS. THIS ACTION INDICATES'
         DB 0DH,0AH;
         DB 'THAT THE OPERATION INITIATED BY THE CURRENT COMMAND IS '
         DB 0DH,0AH;
         DB 'BEING PROCESSED AT THE DISK UNIT, INDEPENDENT OF THE CU,'
         DB 0DH,0AH;
         DB 'AND THAT A SECONDARY STATUS WORD WILL BE PRESENTED LATER'
         DB 0DH,0AH;
         DB 'FOR THE SAME DISK UNIT. ',0
;
ENDIF;
IF MSGSA;
MSG41:;STATUS ACTION VALUE MESSAGE
         DB 'START NEXT COMMAND FOR ANY OTHER AVAILABLE DEVICE(04H).',0
;
ENDIF;
IF AHLPMSG;
MSG42:;STATUS VALUE HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'THIS STATUS ACTION IS PRESENTED ONLY FOR CONTROL COMMANDS'
         DB 0DH,0AH;
         DB 'WITH CHANNEL END STATUS ALONE. THIS ACTION INDICATES THAT'
         DB 0DH,0AH;
         DB 'THE CU HAS TERMINATED THE CURRENT COMMAND PRIOR TO EXE- '
         DB 0DH,0AH;
         DB 'CUTION BECAUSE AN EF-EI COLLISION HAS OCCURRED ON THIS'
         DB 0DH,0AH;
         DB 'COMMAND. ',0
;
ENDIF;
IF MSGSA;
MSG43:;STATUS ACTION VALUE MESSAGE
         DB 'START THE NEXT COMMAND FOR THE CURRENT DEVICE (05H).',0
;
ENDIF;
IF AHLPMSG;
MSG44:;STATUS VALUE HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'THIS STATUS ACTION IS PRESENTED ONLY FOR CONTROL COMMANDS'
         DB 0DH,0AH;
       DB 'WITH DEVICE END STATUS ALONE OR WITH CHANNEL END AND DEVICE'
         DB 0DH,0AH;
         DB 'END STATUS TOGETHER. THIS ACTION INDICATES THAT DISK UNIT'
         DB 0DH,0AH;
         DB 'POSITIONING HAS BEEN COMPLETED. ',0
;
ENDIF;
IF MSGSA;
MSG45:;STATUS ACTION VALUE MESSAGE
         DB 'START THE NEXT COMMAND FOR ANY AVAILABLE DEVICE (06H).',0
;
ENDIF;
IF AHLPMSG;
MSG46:;STATUS VALUE HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'THIS STATUS ACTION IS PRESENTED ONLY FOR WRITE OR READ'
         DB 0DH,0AH;
         DB 'COMMANDS WITH CHANNEL END AND DEVICE END STATUS. THIS'
         DB 0DH,0AH;
         DB 'ACTION INDICATES NORMAL COMMAND COMPLETION WITHOUT'
         DB 0DH,0AH;
         DB 'CHANNEL TRUNCATION. ',0
;
ENDIF;
IF MSGSA;
MSG47:;STATUS ACTION VALUE MESSAGE
         DB 'START THE NEXT COMMAND FOR ANY AVAILABLE DEVICE (07H).',0
;
ENDIF;
IF AHLPMSG;
MSG48:;STATUS VALUE HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'THIS STATUS ACTION IS PRESENTED ONLY FOR SENSE COMMANDS,'
         DB 0DH,0AH;
        DB 'EXCEPT THE SENSE I/O COMMANDS, WITH CHANNEL END AND DEVICE'
         DB 0DH,0AH;
       DB 'END STATUS. THIS ACTION INDICATES NORMAL COMMAND COMPLETION'
         DB 0DH,0AH;
         DB 'WITHOUT CHANNEL TRUNCATION. ',0
;
ENDIF;
IF MSGSA;
MSG49:;STATUS ACTION VALUE MESSAGE
         DB 'PERFORM ERROR RECOVERY WITH SENSE DATA (08H). ',0
;
ENDIF;
IF AHLPMSG;
MSG50:;STATUS VALUE HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'THIS STATUS ACTION IS PRESENTED ONLY FOR THE SENSE I/O'
         DB 0DH,0AH;
         DB 'COMMAND WITH CHANNEL END AND DEVICE END STATUS. THIS '
         DB 0DH,0AH;
         DB 'ACTION INDICATES NORMAL COMMAND COMPLETION WITHOUT'
         DB 0DH,0AH;
         DB 'CHANNEL TRUNCATION. ',0
;
ENDIF;
IF MSGSA;
MSG51:;STATUS ACTION VALUE MESSAGE
       DB 'PERFORM ERROR RECOVERY WITHOUT COMPLETE SENSE DATA (09H).',0
;
ENDIF;
IF AHLPMSG;
MSG52:;STATUS VALUE HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'THIS STATUS ACTION IS PRESENTED ONLY FOR THE SENSE I/O'
         DB 0DH,0AH;
         DB 'COMMAND WITH CHANNEL END AND DEVICE END STATUS. THIS'
         DB 0DH,0AH;
         DB 'ACTION INDICATES THAT COMPLETE SENSE DATA WAS NOT TRANS-'
         DB 0DH,0AH;
         DB 'FERRED. THIS STATUS ACTION MAY BE PRESENTED BECAUSE VALID'
         DB 0DH,0AH;
         DB 'SENSE INFORMATION WAS NOT AVAILABLE OR BECAUSE CHANNEL'
         DB 0DH,0AH;
         DB 'TRUNCATION OCCURRED DURING THE SENSE DATA TRANSFER. ',0
;
ENDIF;
IF MSGSA;
MSG53:;STATUS ACTION VALUE MESSAGE
         DB 'PERFORM RECOVERY IF NECESSARY BECAUSE OF CHANNEL '
         DB 0DH,0AH;
         DB '                     TRUNCATION (0AH). ',0
;
ENDIF;
IF AHLPMSG;
MSG54:;STATUS VALUE HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'THIS STATUS ACTION IS PRESENTED FOR ALL COMMANDS, EXCEPT'
         DB 0DH,0AH;
         DB 'THE SENSE I/O COMMAND, WITH CHANNEL END AND DEVICE END'
         DB 0DH,0AH;
         DB 'STATUS. THIS ACTION INDICATES NORMAL COMMAND COMPLETION'
         DB 0DH,0AH;
         DB 'EXCEPT THAT CHANNEL TRUNCATION OF DATA TRANSFER WAS'
         DB 0DH,0AH;
         DB 'DETECTED. THE CHANNEL TRUNCATION BIT(31) IS SET IN THE'
         DB 0DH,0AH;
         DB 'STATUS WORD. ',0
;
ENDIF;
IF MSGSA;
MSG55:;STATUS ACTION VALUE MESSAGE
         DB 'ACQUIRE SENSE DATA (0BH). ',0
;
ENDIF;
IF AHLPMSG;
MSG56:;STATUS VALUE HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'THIS STATUS ACTION IS PRESENTED FOR ALL COMMANDS, EXCEPT'
         DB 0DH,0AH;
         DB 'THE SENSE I/O COMMAND, WITH UNIT CHECK STATUS ALONE AND'
         DB 0DH,0AH;
         DB 'MAY APPEAR WITH OR WITHOUT THE CHANNEL TRUNCATION BIT(31)'
         DB 0DH,0AH;
         DB 'SET IN THE STATUS WORD. THIS STATUS ACTION IS PRESENTED'
         DB 0DH,0AH;
        DB 'FOR ALL UNIT CHECK CONDITIONS NOT COVERED BY STATUS ACTION'
         DB 0DH,0AH;
         DB 'CODES 0CH, 0DH, AND 0EH. ',0
;
ENDIF;
IF MSGSA;
MSG57:;STATUS ACTION VALUE MESSAGE
         DB 'ACQUIRE SENSE DATA (0DH). ',0
;
ENDIF;
IF AHLPMSG;
MSG58:;STATUS VALUE HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'THIS STATUS ACTION IS PRESENTED FOR ANY COMMAND WITH UNIT'
         DB 0DH,0AH;
     DB 'CHECK STATUS ALONE ONLY WHEN THE ASSOCIATED SENSE INFORMATION'
         DB 0DH,0AH;
         DB 'DESCRIBES A BUS OUT PARITY ERROR THAT HAS OCCURRED ON A'
         DB 0DH,0AH;
         DB 'FUNCTION WORD TRANSFER. A BUS OUT CHECK ON A FUNCTION'
         DB 0DH,0AH;
         DB 'WORD THAT CONTAINS A COMMAND THAT IS DECODED AS A SENSE'
         DB 0DH,0AH;
         DB 'I/O (04H) COMMAND IS NOT REPORTED. ',0
;
ENDIF;
IF MSGSA;
MSG59:;STATUS ACTION VALUE MESSAGE
         DB 'REPEAT THE OPERATION WITH A READ DATA COMMAND (0EH). ',0
;
ENDIF;
IF AHLPMSG;
MSG60:;STATUS VALUE HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'THIS STATUS ACTION IS PRESENTED ONLY FOR THE READ DATA'
         DB 0DH,0AH;
         DB 'SPECIAL COMMAND WITH UNIT CHECK STATUS ALONE AND MAY'
         DB 0DH,0AH;
         DB 'APPEAR WITH OR WITHOUT THE CHANNEL TRUNCATION BIT(31)'
         DB 0DH,0AH;
         DB 'SET IN THE STATUS WORD. THIS STATUS ACTION IS PRESENTED'
         DB 0DH,0AH;
         DB 'ONLY WHEN THE ASSOCIATED SENSE INFORMATION DESCRIBES THE'
         DB 0DH,0AH;
         DB 'OCCURRENCE OF A CORRECTABLE DATA CHECK IN A DATA FIELD.',0
;
ENDIF;
IF MSGSA;
MSG61:;STATUS ACTION VALUE MESSAGE
         DB 'PERFORM RECOVERY IF NECESSARY BECAUSE OF FORCED EF'
         DB 0DH,0AH;
         DB '                     COMMAND TERMINATION (0FH). ',0
;
ENDIF;
IF AHLPMSG;
MSG62:;STATUS VALUE HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
     DB 'THIS STATUS ACTION IS PRESENTED WITH ANY STATUS AND INDICATES'
         DB 0DH,0AH;
         DB 'TERMINATION OF A COMMAND BY A FORCED EF. ',0
;
ENDIF;
IF MSGSA;
MSG63:;RECOVERY ACTION MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB ' - RECOVERY ACTION = ',0
;
ENDIF;
IF AHLPMSG;
MSG64:;RECOVERY ACTION HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB ' ',0
;
ENDIF;
IF MSGSA;
MSG65:;RECOVERY ACTION VALUE MESSAGE
         DB 'WRITE INHIBITED (01H).',0
;
MSG66:;RECOVERY ACTION VALUE MESSAGE
         DB 'SEEK IN PROGRESS FOR ANOTHER CHANNEL, OR CORRECTABLE DATA'
         DB 0DH,0AH;
DB '                     CHECK,OR DATA CHECK (NOT PERMANENT) (02H).',0
;
MSG67:;RECOVERY ACTION VALUE MESSAGE
         DB 'IMPROPER ALTERNATE TRACK POINTER (03H).',0
;
MSG68:;RECOVERY ACTION VALUE MESSAGE
    DB 'COMMAND REJECT(EXCEPT SPECIAL CASES),OR END OF PACK(04H).',0
;
MSG69:;RECOVERY ACTION VALUE MESSAGE
         DB 'READ LABEL COMMAND REQUIRED (05H).',0
;
MSG70:;RECOVERY ACTION VALUE MESSAGE
         DB 'INTERVENTION REQUIRED (06H).',0
;
MSG71:;RECOVERY ACTION VALUE MESSAGE
         DB 'BUS OUT PARITY ERROR (07H).',0
;
MSG72:;RECOVERY ACTION VALUE MESSAGE
         DB 'EQUIPMENT CHECK (NOT PERMANENT) (08H).',0
;
MSG73:;RECOVERY ACTION VALUE MESSAGE
         DB 'PERMANENT DATA CHECK (09H).',0
;
MSG74:;RECOVERY ACTION VALUE MESSAGE
         DB 'INVALID TRACK FORMAT OR NO RECORD FOUND (0AH).',0
;
MSG75:;RECOVERY ACTION VALUE MESSAGE
         DB 'ENVIRONMENTAL DATA PRESENT (0BH).',0
;
MSG76:;RECOVERY ACTION VALUE MESSAGE
         DB 'ONLY VALID COPY LATCH SET FOR FIRST RECORD PARTIALLY'
         DB 0DH,0AH;
         DB '                     '
         DB 'UPDATED ON WRITE DATA OR WRITE DATA PAD ZEROS (0CH).',0
;
MSG77:;RECOVERY ACTION VALUE MESSAGE
         DB 'ONLY VALID COPY LATCH SET FOR LAST RECORD PARTIALLY'
         DB 0D,0AH;
         DB '                     '
         DB 'UPDATED ON WRITE DATA OR WRITE DATA PAD ZEROS (0DH).',0
;
MSG78:;RECOVERY ACTION VALUE MESSAGE
         DB 'PERMANENT EQUIPMENT CHECK (0EH).',0
;
MSG79:;DEVICE STATUS MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB  ' - DEVICE STATUS   = '
         DB 0DH,0AH,0;CR LF
;
ENDIF;
IF AHLPMSG;
MSG80:;DEVICE STATUS HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB ' ',0
;
ENDIF;
IF MSGSA;
MSG81:;DEVICE STATUS MESSAGE
         DB '                     ATTENTION (BIT 15).',0DH,0AH,0
;
ENDIF;
IF AHLPMSG;
MSG82:;DEVICE STATUS HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
        DB 'ATTENTION STATUS INDICATES A DISK PACK CHANGE CONDITION AT'
         DB 0DH,0AH;
         DB 'THE SELECTED DISK UNIT. ATTENTION STATUS IS USUALLY'
         DB 0DH,0AH;
         DB 'PRESENTED ALONE.'
         DB 0DH,0AH;
         DB 'ATTENTION STATUS MAYBE PRESENTED IN AN UNSOLICITED STATUS'
         DB 0DH,0AH;
         DB 'WORD OR WITH BUSY STATUS TO INDICATE THAT THE CU HAS'
         DB 0DH,0AH;
         DB 'TERMINATED THE CURRENT COMMAND PRIOR TO EXECUTION BECAUSE'
         DB 0DH,0AH;
         DB 'OF A DISK PACK CHANGE CONDITION AT THE SAME DISK UNIT AS'
         DB 0DH,0AH;
         DB 'SPECIFIED IN THIS COMMAND.',0
;
ENDIF;
IF MSGSA;
MSG83:;DEVICE STATUS MESSAGE
         DB '                     STATUS MODIFIER (BIT 14).',0DH,0AH,0
;
ENDIF;
IF AHLPMSG;
MSG84:;DEVICE STATUS HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
       DB 'STATUS MODIFIER STATUS INDICATES THAT THE CU HAS TERMINATED'
         DB 0DH,0AH;
         DB 'THE CURRENT COMMAND PRIOR TO EXECUTION BECAUSE AN EF - EI'
         DB 0DH,0AH;
         DB 'COLLISION HAS OCCURRED ON THIS COMMAND.'
         DB 0DH,0AH;
         DB 'STATUS MODIFIER STATUS IS PRESENTED ONLY WITH BUSY AND'
         DB 0DH,0AH;
         DB 'CONTROL UNIT END STATUS.',0
;
ENDIF;
IF MSGSA;
MSG85:;DEVICE STATUS MESSAGE
         DB '                     CONTROL UNIT END (BIT 13).',0DH,0AH,0
;
ENDIF;
IF AHLPMSG;
MSG86:;DEVICE STATUS HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'CONTROL UNIT END STATUS INDICATES THAT THE CU HAS'
         DB 0DH,0AH;
         DB 'TERMINATED THE CURRENT COMMAND PRIOR TO EXECUTION BECAUSE'
         DB 0DH,0AH;
         DB 'AN EF - EI COLLISION HAS OCCURRED ON THIS COMMAND.'
         DB 0DH,0AH;
         DB 'CONTROL UNIT END STATUS IS PRESENTED ONLY WITH BUSY AND'
         DB 0DH,0AH;
         DB 'STATUS MODIFIER STATUS.',0
;
ENDIF;
IF MSGSA;
MSG87:;DEVICE STATUS MESSAGE
         DB '                     BUSY (BIT 12), ',0DH,0AH,0
;
ENDIF;
IF AHLPMSG;
MSG88:;DEVICE STATUS HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
        DB 'BUSY STATUS IS PRESENTED WITH ATTENTION STATUS TO INDICATE'
         DB 0DH,0AH;
         DB 'THAT THE CU HAS TERMINATED THE CURRENT COMMAND PRIOR TO'
         DB 0DH,0AH;
         DB 'EXECUTION BECAUSE OF A DISK PACK CHANGE CONDITION AT THE'
         DB 0DH,0AH;
         DB 'DISK UNIT SPECIFIED IN THIS COMMAND.'
         DB 0DH,0AH;
        DB 'BUSY STATUS MAY ALSO BE PRESENTED WITH STATUS MODIFIER AND'
         DB 0DH,0AH;
         DB 'CONTROL UNIT END STATUS TO INDICATE THAT THE CU HAS TERM-'
         DB 0DH,0AH;
         DB 'INATED THE CURRENT COMMAND PRIOR TO EXECUTION BECAUSE AN'
         DB 0DH,0AH;
         DB 'EF - EI COLLISION HAS OCCURRED ON THIS COMMAND.',0
;
ENDIF;
IF MSGSA;
MSG89:;DEVICE STATUS MESSAGE
         DB '                     CHANNEL END (BIT 11), ',0DH,0AH,0
;
ENDIF;
IF AHLPMSG;
MSG90:;DEVICE STATUS HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'CHANNEL END STATUS IS PRESENTED ALONE TO INDICATE THAT'
         DB 0DH,0AH;
         DB 'THE OPERATION INITIATED BY THE CURRENT COMMAND IS BEING'
         DB 0DH,0AH;
         DB 'PROCESSED AT THE DISK UNIT, INDEPENDENT OF THE CU, AND'
         DB 0DH,0AH;
         DB 'THAT A SECONDARY STATUS WORD WILL BE PRESENTED LATER FOR'
         DB 0DH,0AH;
         DB 'THE SAME DISK UNIT.'
         DB 0DH,0AH;
         DB 'CHANNEL END STATUS MAY ALSO BE PRESENTED WITH DEVICE END'
         DB 0DH,0AH;
       DB 'STATUS TO INDICATE NORMAL COMPLETION OF A COMMAND FOR WHICH'
         DB 0DH,0AH;
         DB 'CHANNEL END HAS NOT BEEN PREVIOUSLY PRESENTED ALONE.',0
;
ENDIF;
IF MSGSA;
MSG91;DEVICE STATUS MESSAGE
         DB '                     DEVICE END (BIT 10), ',0DH,0AH,0
;
ENDIF;
IF AHLPMSG;
MSG92;DEVICE STATUS HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
        DB 'DEVICE END STATUS IS PRESENTED ALONE IN A SECONDARY STATUS'
         DB 0DH,0AH;
      DB 'WORD TO INDICATE NORMAL COMPLETION OF AN OPERATION FOR WHICH'
         DB 0DH,0AH;
         DB 'CHANNEL END STATUS HAS BEEN PREVIOUSLY PRESENTED ALONE.'
         DB 0DH,0AH;
         DB 'DEVICE END STATUS MAY ALSO BE PRESENTED WITH CHANNEL END'
         DB 0DH,0AH;
       DB 'STATUS TO INDICATE NORMAL COMPLETION OF A COMMAND FOR WHICH'
         DB 0DH,0AH;
     DB 'CHANNEL END STATUS HAD NOT BEEN PREVIOUSLY PRESENTED ALONE.',0
;
ENDIF;
IF MSGSA;
;
MSG93:;DEVICE STATUS MESSAGE
         DB '                     UNIT CHECK (BIT 9), ',0DH,0AH,0
;
ENDIF;
IF AHLPMSG;
MSG94:;DEVICE STATUS HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
        DB 'UNIT CHECK STATUS IS USUALLY PRESENTED ALONE AND INDICATES'
         DB 0DH,0AH;
         DB 'THAT AN ERROR OR UNUSUAL CONDITION HAS OCCURRED ON EITHER'
         DB 0DH,0AH;
         DB 'THE CURRENT COMMAND OR THE PRIOR COMMAND. THE SENSE I/O'
         DB 0DH,0AH;
         DB 'COMMAND(04H) MUST BE ISSUED WITHIN TWO SECONDS OF UNIT'
         DB 0DH,0AH;
         DB 'CHECK FOR THE SENSE DATA TO BE VALID. A NONZERO RECOVERY'
         DB 0DH,0AH;
         DB 'ACTION FIELD IS ALWAYS SET WITH UNIT CHECK STATUS.',0
;
ENDIF;
IF MSGSA;
MSG95:;DEVICE STATUS MESSAGE
         DB '                     UNIT EXCEPTION (BIT 8), ',0DH,0AH,0
;
ENDIF;
IF AHLPMSG;
MSG96:;DEVICE STATUS HELP MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'THIS BIT(08) IS NOT USED AND IS ALWAYS ZERO.',0
;
ENDIF;
IF MSGSA;
MSG97:;STATUS ACTION MESSAGE
         DB 'NO STATUS ACTION (00H). ',0
;
ENDIF;
IF AHLPMSG;
MSG98:;STATUS VALUE HELP MESSAGE
         DB 00H;
;
ENDIF;
IF MSGSA;
MSG99:;RECOVERY ACTION VALUE
         DB 'NO RECOVERY ACTION (00H). ',0
;
MSG100:;DEVICE STATUS MESSAGE
         DB '                     NO DEVICE STATUS (00H). ',0
;
ENDIF;
IF AHLPMSG;
MSG101:;DEVICE STATUS HELP MESSAGE
         DB 00H;
;
ENDIF;
IF MSGSA;
MSG102:;DEVICE ADDRESS MESSAGE
         DB 0DH,0AH;CARRIAGE RETURN LINE FEED
         DB ' - DEVICE ADDRESS  = ',0
;
ENDIF;
IF AHLPMSG;
MSG103:;DEVICE ADDRESS HELP MESSAGE
         DB 00H;
;
ENDIF;
IF MSGSA;
MSG104:;STATUS ACTION MESSAGE
         DB 'DOES NOT EXIST (0CH). ',0
;
ENDIF;
IF AHLPMSG;
MSG105:;STAUS VALUE HELP MESSAGE
         DB 00H;
;
ENDIF;
IF MSGSA;
MSG106:;RECOVERY ACTION VALUE MESSAGE
         DB 'DOES NOT EXIST (0FH). ',0
;
ENDIF;
MSG107:;STATUS WORD COMPARE ERROR MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'THE DATA COMPARE ERROR IS THE STATUS WORD. ',0
;
MSG108:;STATUS WORD MESSAGE
         DB ' - STATUS WORD = ',0
;
MSG109:;STW DISPLAY ANALYSIS MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB ' - stw analysis',0
         DB 0DH,0AH;CARRIAGE RETURN LINE FEED
;
MSG110:;CARRIAGE RETURN AND LINE FEED MSG
         DB 0DH,0AH,0;MISC. CR LF
;
MSG200:;TIME-OUT MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB '**************************************************** '
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'ERROR - CHANNEL TIME-OUT (PROTOCOL) ',0
;
MSG201;NEED TAG MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB '      - CONTROL UNIT DOES NOT RESPOND ',0
;
MSG202:;CHANNEL TAG SEQ. MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB '**************************************************** ';
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'ERROR - CHANNEL TAG OUT OF SEQUENCE (PROTCOL) ',0;
;
MSG203:;ODR MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB '      - RECEIVED AN OUTPUT DATA REQUEST (ODR) ',0
;
MSG205:;IDR MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB '      - RECEIVED AN INPUT  DATA REQUEST (IDR) ',0
;
MSG207:;EI MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB '      - RECEIVED AN EXTERNAL INTERRUPT  (EI) ',0
;
MSG208:;PARITY MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB '**************************************************** '
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB 'ERROR - WORD CHANNEL PARITY ERROR ',0
;
MSG209:;PARITY MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB '      - PARITY ERROR WHILE INPUTING FROM THE C.U. ',0
;
MSG210:;ERROR MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB '      - WAS NOT EXPECTING ANY CHANNEL TAGS '
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB '**************************************************** ',0
;
MSG211:;ERROR MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB '      - WAS EXPECTING AN OUTPUT DATA REQUEST (ODR) '
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB '**************************************************** ',0
;
MSG213:;ERROR MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB '      - WAS EXPECTING AN INPUT  DATA REQUEST (IDR) '
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB '**************************************************** ',0
;
MSG214:;ERROR MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB '      - WAS EXPECTING AN EXTERNAL INTERRUPT (EI) '
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB '**************************************************** ',0
;
MSG215:;ERROR MESSAGE
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB '      - CHANNEL TAGS ARE ACTIVE (C.U. DID NOT RESET) '
         DB 0DH;CARRIAGE RETURN
         DB 0AH;LINE FEED
         DB '**************************************************** ',0
;
CLOSE:;CLOSE FILE
         ;LXI D,FCBX - LOAD ADDRESS TO FILE CONTROL
         ;BLOCK IN REG. PAIR D,E BEFORE ENTRY
         PUSH D;SAVE FCBX FOR FCB CLR
         MVI C,CLOSEF;CPM CLOSE FUNCTION
         CALL FDOS;TELL CPM YOU COMMAND IT
         CPI 0FFH;DID IT OBEY? FF MEANS NO!
         PUSH PSW;SAVE ZERO FLAG
         LXI H,MSG5;UNSUCCESSFUL CLOSE MESSAGE
         CZ PMSG;DO IT!
         POP PSW;RESTORE ZERO FLAG
         JZ BOOT;REBOOT IF DISOBEYED
         POP D;RESTORE FCBX
         CALL CLRFCB;CLEAR FCB LOWER BYTES
         LXI H,MSG7;SUCCESSFUL CLOSE MESSAGE
         CALL PMSG;DO IT!
         RET;
;
OPEN:;OPEN FILE
         ;LXI D,FCBX - LOAD ADDRESS OF FILE CONTROL BLOCK
         ;IN REG. PAIR D,E BEFORE ENTRY
         CALL CLRFCB;CLEAR FCB LOWER BYTES
         MVI C,OPENF;OPEN FILE COMMAND
         CALL FDOS;GIVE PROBLEM TO CPM
         CPI 0FFH;FF IF FILE IS NOT FOUND
         PUSH PSW;SAVE ZERO FLAG FOR LATER
         LXI H,MSG8;UNABLE TO OPEN MESSAGE
         CZ PMSG;DO IT!
         POP PSW;RESTORE ZERO FLAG
         JZ BOOT;REBOOT IF FILE IS NOT FOUND
         LXI H,MSG4;SUCCESSFUL OPEN MESSAGE
         CALL PMSG;DO IT!
         RET;
;
MAKE:;CREATE FILE
         ;LXI D,FCBX - LOAD ADDRESS OF FILE CONTROL BLOCK
         ;IN REG. PAIR D,E BEFORE ENTRY
         CALL CLRFCB;CLEAR FCB LOWER BYTES
         MVI C,MAKEF;MAKE FILE COMMAND
         CALL FDOS;GIVE PROBLEM TO CPM
         CPI 0FFH;FF IF DIRECTORY IS FULL
         PUSH PSW;SAVE ZERO FLAG FOR LATER
         LXI H,MSG3;DIRECTORY IS FULL MESSAGE
         CZ PMSG;DO IT!
         POP PSW;RESTORE ZERO FLAG
         JZ BOOT;REBOOT IF NO DIRECTORY SPACE
         LXI H,MSG2;FILE CREATED MESSAGE
         CALL PMSG;DO IT!
         RET;
;
WRITE:;WRITE TO FILE
         ;LXI D,FCBX - LOAD ADDRESS OF FILE CONTROL BLOCK
         ;IN REG. PAIR D,E BEFORE ENTRY
         PUSH PSW;
         PUSH B;
         PUSH D;
         PUSH H;
         MVI C,WRITEF;CPM SEQ. WRITE FUNCTION 21
         CALL FDOS;GIVE PROBLEM TO CPM
         CPI 00H;00 IF DISK IS NOT FULL
         PUSH PSW;SAVE ZERO FLAG
         LXI H,MSG6;DISK FULL MESSAGE
         CNZ PMSG;DO IT!
         POP PSW;RESTORE ZERO FLAG
         JNZ BOOT;REBOOT IF DISK IS FULL
         POP H;
         POP D;
         POP B;
         POP PSW;
         RET;
;
READ:;READ FROM FILE
         ;LXI D,FCBX - LOAD ADDRESS OF FILE CONTROL BLOCK
         ;IN REG. PAIR D,E BEFORE ENTRY
         PUSH PSW;
         PUSH B;
         PUSH D;
         PUSH H;
         MVI C,READF;CPM SEQ. READ FUNCTION 20
         CALL FDOS;GIVE PROBLEM TO CPM
         CPI 00H;00 = SUCCESSFUL READ
         PUSH PSW;SAVE ZERO FLAG FOR LATER
         LXI H,MSG9;OUT OF DATA MESSAGE (EOF)
         CNZ PMSG;DO IT!
         POP PSW;RESTORE ZERO FLAG
         JNZ RFCBR;CLEAR FCB AND CLOSE FILE (OUT OF DATA - EOF)
         POP H;
         POP D;
         POP B;
         POP PSW;
         RET;
;
RFCBR:;CLOSE FILE AND CLEAR FCB
         POP H;DEC STACK
         POP D;RESTORE FCB ADDRESS
         CALL CLOSE;
         JMP HLEVLG;BACK TO HIGH LEVEL LANGUAGE
;
FDELETE:;FILE DELETE
         ;LXI D,FCBX - LOAD ADDRESS TO FILE CONTROL
         ;BLOCK IN REG. PAIR D,E BEFORE ENTRY
         MVI C,DELETEF;CPM DELETE FUNCTION
         CALL FDOS;TELL CPM TO DELETE
         CPI 0FFH;DID IT OBEY? FF MEANS NO
         PUSH PSW;SAVE ZERO FLAG
         LXI H,MSG14;UNSUCCESSFUL DELETE MESSAGE
         CZ PMSG;DISPLAY IT
         POP PSW;RESTORE ZERO FLAG
         JZ BOOT;REBOOT IF DISOBEYED
         LXI H,MSG15;SUCCESSFUL DELETE MESSAGE
         CALL PMSG;DISPLAY IT
         RET;
;
FILA:;INIT. FILE (TEXT)
         MVI C,SDMADD;
         CALL FDOS;
         LXI D,FCBA;
         CALL OPEN;
         LXI D,FCBA;
         CALL READ;
         LXI H,ABUFF;
         SHLD ABPTR;
         LXI H,RECSIZ;
         SHLD XCNTR;
         RET;
;
ASCIID:;DISPLAY ASCII TEXT AND LOOK FOR (RET) FOR STOP
         MOV E,A;A CHAR HERE <> FF MEANS OUTPUT CMD ALSO
         CPI 1AH;ASCII EOF
         JZ CF;DONE IF AT END OF FILE
         MVI C,DCONF;DIRECT CONSOLE I/O
         CALL FDOS;TELL CPM
CONST:   MVI C,DCONF;DIRECT CON. I/O
         MVI E,0FFH;FF = INPUT COMMAND
         CALL FDOS;GIVE TO CPM
         CPI ZERO;IS CHAR READY
         RZ;RETURN IF NO (ZERO)
         CPI 13H;IS IT CTRL-S (XOFF)
         JZ CWT;LOOP FOR NEXT CHAR (STOP SCROLL)
         CPI 0DH;CARRIAGE RETURN
         RNZ;START SCROLL IF NOT CR
CF:      LXI D,FCBA;
         CALL CLOSE;
         JMP HLEVLG;BACK TO HIGH LEVEL LANGUAGE
CWT:;CONSOL - WAIT FOR CHAR
         MVI C,CONINF;
         CALL FDOS;
         RET;
;
ASCHEX:
         MVI A,00H;
         CMP B;
         MVI A,30H;ASCII 0
         RZ;
         MVI A,01H;
         CMP B;
         MVI A,31H;ASCII 1
         RZ;
         MVI A,02H;
         CMP B;
         MVI A,32H;ASCII 2
         RZ;
         MVI A,03H;
         CMP B;
         MVI A,33H;ASCII 3
         RZ;
         MVI A,04H;
         CMP B;
         MVI A,34H;ASCII 4
         RZ;
         MVI A,05H;
         CMP B;
         MVI A,35H;ASCII 5
         RZ;
         MVI A,06H;
         CMP B;
         MVI A,36H;ASCII 6
         RZ;
         MVI A,07H;
         CMP B;
         MVI A,37H;ASCII 7
         RZ;
         MVI A,08H;
         CMP B;
         MVI A,38H;ASCII 8
         RZ;
         MVI A,09H;
         CMP B;
         MVI A,39H;ASCII 9
         RZ;
         MVI A,0AH;
         CMP B;
         MVI A,41H;ASCII A
         RZ;
         MVI A,0BH;
         CMP B;
         MVI A,42H;ASCII B
         RZ;
         MVI A,0CH;
         CMP B;
         MVI A,43H;ASCII C
         RZ;
         MVI A,0DH;
         CMP B;
         MVI A,44H;ASCII D
         RZ;
         MVI A,0EH;
         CMP B;
         MVI A,45H;ASCII E
         RZ;
         MVI A,0FH;
         CMP B;
         MVI A,46H;ASCII F
         RZ;
         RET;
;
NEWLIN:
         PUSH PSW;
         PUSH D;
         PUSH H;
         MVI C,CONOUTF;CPM CONSOLE OUT (FUNCTION 2)
         MVI E,0DH;ASCII CARRIAGE RETURN
         CALL FDOS;
         MVI C,CONOUTF;
         MVI E,0AH;ASCII LINE FEED
         CALL FDOS;
         LDA XADD + 1;
         CALL CONDMP;
         LDA XADD;
         CALL CONDMP;
         MVI C,CONOUTF;
         MVI E,20H;ASCII SPACE
         CALL FDOS;
         MVI C,CONOUTF;
         MVI E,20H;
         CALL FDOS;
         MVI C,CONOUTF;
         MVI E,20H;
         CALL FDOS;
         MVI B,DWDLIN;
         MVI C,00H;
         POP H;
         POP D;
         POP PSW;
         RET;
;
CONDMP:
         PUSH PSW;
         PUSH B;
         PUSH D;
         PUSH H;
         MOV D,A;
         ANI 0F0H;
         RRC;
         RRC;
         RRC;
         RRC;
         MOV B,A;
         CALL ASCHEX;
         MOV E,A;
         MVI C,CONOUTF;
         CALL FDOS;
         MOV A,D;
         ANI 0FH;
         MOV B,A;
         CALL ASCHEX;
         MOV E,A;
         MVI C,CONOUTF;
         CALL FDOS;
         POP H;
         POP D;
         POP B;
         POP PSW;
         RET;
;
COMPWD:
         PUSH PSW;
         PUSH B;
         PUSH D;
         PUSH H;
         LDA XDATA + 4;
         STA EDATA + 4;
         LDA XDATA + 3;
         STA EDATA + 3;
         LDA XDATA + 2;
         STA EDATA + 2;
         LDA XDATA + 1;
         STA EDATA + 1;
         LDA XDATA + 0;
         STA EDATA + 0;
         LDA SDATA + 4;
         MOV B,A;
         LDA XDATA + 4;
         CMP B;COMPARE SDATA WITH XDATA/EDATA
         JNZ DCMPER;
         LDA SDATA + 3;
         MOV B,A;
         LDA XDATA + 3;
         CMP B;
         JNZ DCMPER;
         LDA SDATA + 2;
         MOV B,A;
         LDA XDATA + 2;
         CMP B;
         JNZ DCMPER;
         LDA SDATA + 1;
         MOV B,A;
         LDA XDATA + 1;
         CMP B;
         JNZ DCMPER;
         LDA SDATA + 0;
         MOV B,A;
         LDA XDATA + 0;
         CMP B;
         JNZ DCMPER;
         POP H;
         POP D;
         POP B;
         POP PSW;
         RET;
;
DCMPER:
         MVI A,DATERR;DATA ERROR
         STA PSTATS;PROGRAM STATUS
         MVI A,FRMT1;FORMAT/TABLE
         STA PSTATS + 1;
         LHLD ERRCNT;GET CURRENT ERROR COUNT
         INX H;ADD ONE TO IT
         SHLD ERRCNT;UPDATE VARIABLE PARAMETER
         LHLD XADD;
         DCX H;SUBTRACT ONE
         SHLD XADD;
         CALL NEWLIN;
         LHLD XADD;
         INX H;ADD ONE
         SHLD XADD;
         LXI H,MSG12;DATA COMPARE ERROR MESSAGE
         CALL PMSG;DISPLAY IT!
         LXI H,MSG10;SHOULD BE MESSAGE
         CALL PMSG;DISPLAY IT!
         LDA SDATA + 4;
         CALL CONDMP;
         LDA SDATA + 3;
         CALL CONDMP;
         LDA SDATA + 2;
         CALL CONDMP;
         LDA SDATA + 1;
         CALL CONDMP;
         LDA SDATA + 0;
         CALL CONDMP;
         LXI H,MSG11;WAS MESSAGE
         CALL PMSG;DISPLAY IT
         LDA EDATA + 4;
         CALL CONDMP;
         LDA EDATA + 3;
         CALL CONDMP;
         LDA EDATA + 2;
         CALL CONDMP;
         LDA EDATA + 1;
         CALL CONDMP;
         LDA EDATA + 0;
         CALL CONDMP;
         POP H;
         POP D;
         POP B;
         POP PSW;
         RET;
;
UPDREC:
         LHLD XCNTR;
         XCHG;
         LHLD ABPTR;
         INX H;BUFFER POINTER
         DCX D;XCNTR
         SHLD ABPTR;
         XCHG;
         SHLD XCNTR;
         MVI A,00H;
         CMP H;XCNTR
         JNZ $ + 7;
         CMP L;
         JZ RESET;
         RET;
;
RESET:
         LXI D,ABUFF;
         MVI C,SDMADD;
         CALL FDOS;
         LXI D,FCBA;
         CALL READ;
         LXI D,RECSIZ;
         LXI H,ABUFF;
         SHLD ABPTR;
         XCHG;
         SHLD XCNTR;
         RET;
;
NEXTWD:
         PUSH PSW;
         PUSH B;
         PUSH D;
         PUSH H;
         LHLD ABPTR;
         MOV A,M;
         STA XDATA;
         CALL UPDREC;
         LHLD ABPTR;
         MOV A,M;
         STA XDATA + 1;
         CALL UPDREC;
         LHLD ABPTR;
         MOV A,M;
         STA XDATA + 2;
         CALL UPDREC;
         LHLD ABPTR;
         MOV A,M;
         STA XDATA + 3;
         CALL UPDREC;
         LHLD ABPTR;
         MOV A,M;
         STA XDATA + 4;
         CALL UPDREC;
         LHLD XADD;
         INX H;
         SHLD XADD;
         POP H;
         POP D;
         POP B;
         POP PSW;
         RET;
;
INITC:
         LXI D,ABUFF;LOAD DMA ADDRESS
         MVI C,SDMADD;SET DMA ADDRESS COMMAND
         CALL FDOS;GIVE PROBLEM TO CPM
         LXI D,FCBA;LOAD ADDRESS TO FILE CONTROL BLOCK A
         CALL OPEN;
         LXI D,FCBA;LOAD ADDRESS TO FILE CONTROL BLOCK A
         CALL READ;
         LXI H,ABUFF;
         MOV A,M;SADD
         STA XADD;
         INX H;
         MOV A,M;SADD + 1
         STA XADD + 1;
         LXI D,FCBA;LOAD ADDRESS TO FCB A
         CALL READ;
         LXI H,ABUFF;
         SHLD ABPTR;
         LXI H,RECSIZ;
         SHLD XCNTR;
         ;MVI A,00H;DATA FOR START ADDRESS OF FILE (ASSUME 0)
         ;STA XADD + 1;OVERRIDE INITA: (MSB)
         ;STA XADD;OVERRIDE INITA: (LSB)
         RET;
;
SEARCH:
         JMP $ + 6;
LOOPF:   CALL NEXTWD;
         LHLD SADD;
         XCHG;
         LHLD XADD;
         MOV A,H;
         CMP D;SADD + 1 (MSB)
         JNZ LOOPF;
         MOV A,L;
         CMP E;SADD (LSB)
         JNZ LOOPF;
         RET;
;
;THE NEXT FIVE SUBROUTINES ARE REPEATS OF THE ABOVE
;BUT FOR BUFFER B (BOTH USED AS OUTPUTS)
UPRECB:
         LHLD XCNTRB;
         XCHG;
         LHLD BBPTR;
         INX H;
         DCX D;
         SHLD BBPTR;
         XCHG;
         SHLD XCNTRB;
         MVI A,00H;
         CMP H;
         JNZ $ + 7;
         CMP L;
         JZ RSTB;
         RET;
;
RSTB:
         LXI D,BBUFF;
         MVI C,SDMADD;
         CALL FDOS;
         LXI D,FCBB;
         CALL READ;
         LXI D,RECSIZ;
         LXI H,BBUFF;
         SHLD BBPTR;
         XCHG;
         SHLD XCNTRB;
         RET;
;
NXTWDB:
         PUSH PSW;
         PUSH B;
         PUSH D;
         PUSH H;
         LHLD BBPTR;
         MOV A,M;
         STA XDATA + 0;
         CALL UPRECB;
         LHLD BBPTR;
         MOV A,M;
         STA XDATA + 1;
         CALL UPRECB;
         LHLD BBPTR;
         MOV A,M;
         STA XDATA + 2;
         CALL UPRECB;
         LHLD BBPTR;
         MOV A,M;
         STA XDATA + 3;
         CALL UPRECB;
         LHLD BBPTR;
         MOV A,M;
         STA XDATA + 4;
         CALL UPRECB;
         LHLD XADD;
         INX H;
         SHLD XADD;
         POP H;
         POP D;
         POP B;
         POP PSW;
         RET;
;
INITCB:
         LXI D,BBUFF;
         MVI C,SDMADD;
         CALL FDOS;
         LXI D,FCBB;
         CALL OPEN;
         LXI D,FCBB;
         CALL READ;
         LXI H,BBUFF;
         MOV A,M;
         STA XADD;
         INX H;
         MOV A,M;
         STA XADD + 1;
         LXI D,FCBB;
         CALL READ;
         LXI H,BBUFF;
         SHLD BBPTR;
         LXI H,RECSIZ;
         SHLD XCNTRB;
         RET;
;
SRCHB:
         JMP $ + 6;
LOOPFB:  CALL NXTWDB;
         LHLD SADD;
         XCHG;
         LHLD XADD;
         MOV A,H;
         CMP D;
         JNZ LOOPFB;
         MOV A,L;
         CMP E;
         JNZ LOOPFB;
         RET;
;
GPLOOP:;
         MOV A,M;
         STAX D;
         INX H;
         INX D;
         DCR C;
         MOV A,C;
         CPI ZERO;
         RZ;
         JMP GPLOOP;
;
PPLOOP:;
         LDAX D;
         MOV M,A;
         INX H;
         INX D;
         DCR C;
         MOV A,C;
         CPI ZERO;
         RZ;
         JMP PPLOOP;
;
GETPAC:
         LXI D,FCBC;LOAD ADDRESS TO FILE CONTROL BLOCK C
         CALL READ;GET RECORD FROM DISK
         LXI H,PBUFF;PACKET BUFFER
         LXI D,EFW;
         MVI C,LENGA;
         CALL GPLOOP;
         LXI D,SADD;
         MVI C,LENGB;
         CALL GPLOOP;
         LXI D,F1A;
         MVI C,LENGC;
         CALL GPLOOP;
         LXI D,F1B;
         MVI C,LENGC;
         CALL GPLOOP;
         RET;
;
;SAME AS ABOVE ROUTINE BUT PUTS INSTEAD OF GETS
PUTPAC:
         LXI H,PBUFF;
         LXI D,EFW;
         MVI C,LENGA;
         CALL PPLOOP;
         LXI D,SADD;
         MVI C,LENGB;
         CALL PPLOOP;
         LXI D,F1A;
         MVI C,LENGC;
         CALL PPLOOP;
         LXI D,F1B;
         MVI C,LENGC;
         CALL PPLOOP;
         LXI D,FCBC;
         CALL WRITE;
         RET;
;
IF TEST1;ASSEMBLE IF THIS IS TEST MODE
SEFWXF:
         CALL IEFCNT;
         RET;
;
SAFWXF:
         CALL IAFCNT;
         RET;
;
SODWXF:
         CALL IODCNT;
         RET;
;
SIDWXF:
         CALL IIDCNT;
         RET;
;
SEIWXF:
         CALL ISTCNT;
         RET;
;
SCLRXF:
         RET;
;
SPARXF:
         RET;
;
ENDIF;
;
RBPTR:;RESET BUFFER FOR NEXT ROUTINE
        LXI H,ABUFSIZ;A BUFFER SIZE
        XCHG;SWAP DE WITH HL
        LHLD ABPTR;A BUFFER PTR.
        RET;
;
;ODW - REPEATING BUFFER DRIVER (SOFT)
SODRB:
         MVI A,ZERO;
         STA TWCNT + 0;RESET TIME-OUT COUNTER (LSB)
         STA TWCNT + 1;(MSB)
         LHLD XFCNT;GET DATA TRANSFERE COUNT
         MOV C,L;
         MOV B,H;MOVE HL TO BC REG.
         CALL RBPTR;RESET BUFFER POINTERS
LODARB:;
        ;IN PPI7PB;CHECK FOR INPUT TAGS
        ;CPI ODRTAG;PROPER TAG
        ;JZ CYBUFF;CYCLE BUFFER IF OK
        ;MVI A,02D;
        ;STA STATET;SAVE CURRENT STATE IN CASE OF ERROR
        ;CALL WAITT;WAIT LOOP AND PROPER TAG CHECK
        ;JMP LODARB;LOOK AGAIN FOR TAG
CYBUFF:;
        MOV A,M;MOVE BUFFER TO A REG.
        ;OUT PPI1PA;OUT TO DATA PORT (BITS 0 - 7)
        STA XDATA;FOR COMPARE PURPOSE
        INX H;INC. BUFFER POINTER
        DCX D;DEC. REMAINING BUFFER SIZE
        MOV A,D;MOV MSB TO A REG.
        ORA A;SET FLAGS
        JNZ $ + 8;IF NOT ZERO SKIP NEXT CHECK
        MOV A,E;MOV LSB TO A REG.
        ORA A;SET FLAGS
        CZ RBPTR;IF SENT ALL OF BUFFER RESET BUFFER (REPEAT)
        MOV A,M;COMMENTS - SAME AS ABOVE FOR BYTE XFERS.
        ;OUT PPI1PB;(BITS 8 - 15)
        STA XDATA;
        INX H;
        DCX D;
        MOV A,D;
        ORA A;
        JNZ $ + 8;
        MOV A,E;
        ORA A;
        CZ RBPTR;
        MOV A,M;
        ;OUT PPI1PC;(BITS 16 - 23)
        STA XDATA;
        INX H;
        DCX D;
        MOV A,D;
        ORA A;
        JNZ $ + 8;
        MOV A,E;
        ORA A;
        CZ RBPTR;
        MOV A,M;
        ;OUT PPI2PA;(BITS 24 - 31)
        STA XDATA;
        INX H;
        DCX D;
        MOV A,D;
        ORA A;
        JNZ $ + 8;
        MOV A,E;
        ORA A;
        CZ RBPTR;
        MOV A,M;
        ORI OATAG;MERGE TAG
        ;OUT PPI2PB;(BITS 32 - 35 + TAG)
        STA XDATA;
        MVI A,ZERO;
        ;OUT PPI2PB;RESET TAG
        DCX D;
        MOV A,D;
        ORA A;
        JNZ $ + 8;
        MOV A,E;
        ORA A;
        CZ RBPTR;
        PUSH H;SAVE BUFFER POINTER
        CALL IODCNT;COUNT OUT-PUT DATA WORDS
        POP H;GET BUFFER POINTER
        DCX B;DEC. XFCNT
        LDA WRDRPT;WORD REPEAT MODIFIER
        CPI CONDT;IS IT SET
        JZ SODRW;THEN REPEAT WORD ONLY (SAVE TIME)
        MVI A,ZERO;
        CMP B;XFCNT (MSB)
        JNZ LODARB;REPEAT DRIVER THROUGH XFCNT
        CMP C;XFCNT (LSB)
        JNZ LODARB;REPEAT TILL DONE
        JMP OFIN;ALL DONE
;
;ODW - REPEATING BUFFER WORD DRIVER (SOFT)
SODRW:;
       MVI A,ZERO;
       CMP B;XFCNT (MSB)
       JNZ LODARW;REPEAT WORD THROUGH XFCNT
       CMP C;XFCNT (LSB)
       JNZ LODARW;REPEAT TILL DONE
       JMP OFIN;ALL DONE
LODARW:
       ;IN PPI7PB;CHECK FOR INPUT TAG
       CPI ODRTAG;PROPER TAG
       ;JZ CYWRD;CYCLE WORD IF OK
       MVI A,02D;
       STA STATET;SAVE CURRENT STATE IN CASE OF ERROR
       ;CALL WAITT;WAIT LOOP AND PROPER TAG CHECK
       ;JMP LODARW;LOOK AGAIN FOR TAG
CYWRD:
       MOV A,M;GET WORDS LAST BYTE (MSB)
       ORI OATAG;MERGE TAG
       ;OUT PPI2PB;(BITS 32 - 35 + TAG)
       MVI A,ZERO;
       ;OUT PPI2PB;RESET TAG
       PUSH H;SAVE BUFFER WORD POINTER
       CALL IODCNT;COUNT OUT-PUT DATA WORDS
       POP H;RESTORE BUFFER POINTER
       DCX B;DEC. XFCNT
       JMP SODRW;GO CHECK XFCNT FOR REPEAT
;
;NEXT DRIVERS COMMENTS ARE SAME AS ABOVE BUT FOR INPUT DATA.
;SENDS OUT REPEATING BUFFER WITH INPUT TAGS FOR FAST
;DATA INPUT AND COMPARE USING HARD-WARE COMPARE
;IDW - REPEATING BUFFER DRIVER (SOFT)
SIDRB:
       MVI A,ZERO;
       STA TWCNT + 0;
       STA TWCNT + 1;
       LHLD XFCNT;
       MOV C,L;
       MOV B,H;
       CALL RBPTR;
LIDARB:;
       ;IN PPI7PB;
       ;CPI IDRTAG;
       ;JZ CYBUFI;CYCLE OUT BUFFER FOR INPUTS COMPARE
       ;MVI A,03D;
       ;STA STATET;
       ;CALL WAITT;
       ;JMP LIDARB;
CYBUFI:;
       MOV A,M;
       ;OUT PPI1PA;
       STA SDATA;
       INX H;
       DCX D;
       MOV A,D;
       ORA A;
       JNZ $ + 8;
       MOV A,E;
       ORA A;
       CZ RBPTR;
       MOV A,M;
       ;OUT PPI1PB;
       STA SDATA;
       INX H;
       DCX D;
       MOV A,D;
       ORA A;
       JNZ $ + 8;
       MOV A,E;
       ORA A;
       CZ RBPTR;
       MOV A,M;
       ;OUT PPI1PC;
       STA SDATA;
       INX H;
       DCX D;
       MOV A,D;
       ORA A;
       JNZ $ + 8;
       MOV A,E;
       ORA A;
       CZ RBPTR;
       MOV A,M;
       ;OUT PPI2PA;
       STA SDATA;
       INX H;
       DCX D;
       MOV A,D;
       ORA A;
       JNZ $ + 8;
       MOV A,E;
       ORA A;
       CZ RBPTR;
       MOV A,M;
       ORI IATAG;
       ;OUT PPI2PB;
       ;CHECK FOR COMPARE ERROR (HARD)
       STA SDATA;
       MVI A,ZERO;
       ;OUT PPI2PB;
       DCX D;
       MOV A,D;
       ORA A;
       JNZ $ + 8;
       MOV A,E;
       ORA A;
       CZ RBPTR;
       PUSH H;
       CALL IIDCNT;
       POP H;
       DCX B;
       LDA WRDRPT;
       CPI CONDT;
       JZ SIDRW;
       MVI A,ZERO;
       CMP B;
       JNZ LIDARB;
       CMP C;
       JNZ LIDARB;
       JMP IFIN;
;
;IDW - REPEATING BUFFER WORD DRIVER (SOFT)
SIDRW:;
       MVI A,ZERO;
       CMP B;
       JNZ LIDARW;
       CMP C;
       JNZ LIDARW;
       JMP IFIN;
LIDARW:;
       ;IN PPI7PB;
       CPI IDRTAG;
       ;JZ CYWRDI;
       MVI A,03D;
       STA STATET;
       ;CALL WAITT;
       ;JMP LIDARW;
CYWRDI:;
       MOV A,M;
       ORI IATAG;
       ;OUT PPI2PB;
       ;CHECK FOR COMPARE ERROR (HARD)
       MVI A,ZERO;
       ;OUT PPI2PB;
       PUSH H;
       CALL IIDCNT;
       POP H;
       DCX B;
       JMP SIDRW;
;
IF NOT TEST1;ASSEMBLE IF THIS IS NOT TEST MODE
;EFW - WORD/TAG DRIVER (SOFT)
SEFWXF:  MVI A,ZERO;
         STA TWCNT + 0;RESET TIME-OUT COUNTER (LSB)
         STA TWCNT + 1;(MSB)
LEFA:    IN  PPI7PB;CHECK FOR INPUT TAGS
         ORI ZERO;SHOULD BE NONE
         JZ  EFSEND;SEND EF IF CHANNEL IS CLEAR
         MVI A,ZERO;
         STA STATET;SAVE CURRENT STATE IN CASE OF ERROR
         CALL WAITT;WAIT LOOP AND TAG SEQUENCE CHECK
         JMP LEFA;CHECK AGAIN FOR TAG
EFSEND:  LDA EFW + 0;BITS 0-7
         OUT PPI1PA;DATA PORT
         LDA EFW + 1;BITS 8-15
         OUT PPI1PB;DATA PORT
         LDA EFW + 2;BITS 16-23
         OUT PPI1PC;DATA PORT
         LDA EFW + 3;BITS 24-31
         OUT PPI2PA;DATA PORT
         LDA EFW + 4;BITS 32-39
         ORI EFTAG;MERGE TAG
         OUT PPI2PB;SEND BITS 32-35 + TAG
         MVI A,ZERO;
         OUT PPI2PB;RESET TAG
         CALL IEFCNT;COUNT EF WORDS
         RET;
;
;AFW - WORD/TAG DRIVER (SOFT)
SAFWXF:  MVI A,ZERO;
         STA TWCNT + 0;RESET TIME-OUT COUNTER (LSB)
         STA TWCNT + 1;(MSB)
LAFA:    IN PPI7PB;DATA PORT
         CPI ODRTAG;CHECK FOR PROPER TAG
         JZ AFSEND;SEND IF OK
         MVI A,01D;
         STA STATET;SAVE STATE VALUE IN CASE OF ERROR
         CALL WAITT;WAIT LOOP AND PROPER TAG CHECK
         JMP LAFA;LOOK AGAIN FOR TAG
AFSEND:  LDA AFW + 0;BITS 0-7
         OUT PPI1PA;DATA PORT
         LDA AFW + 1;BITS 8-15
         OUT PPI1PB;DATA PORT
         LDA AFW + 2;BITS 16-23
         OUT PPI1PC;DATA PORT
         LDA AFW + 3;BITS 24-31
         OUT PPI2PA;DATA PORT
         LDA AFW + 4;BITS 32-39
         ORI EFTAG;MERGE TAG
         OUT PPI2PB;SEND BITS 32-35 + TAG
         MVI A,ZERO;
         OUT PPI2PB;RESET TAG
         CALL IAFCNT;COUNT AF WORDS
         RET;
;
;ODW - WORD/TAG DRIVER (SOFT)
SODWXF:  MVI A,ZERO;
         STA TWCNT + 0;RESET TIME-OUT COUNTER (LSB)
         STA TWCNT + 1;(MSB)
LODA:    IN PPI7PB;CHECK FOR INPUT TAGS
         CPI ODRTAG;PROPER TAG
         JZ  ODSEND;SEND IF OK
         MVI A,02D;
         STA STATET;SAVE CURRENT STATE IN CASE OF ERROR
         CALL WAITT;WAIT LOOP AND PROPER TAG CHECK
         JMP LODA;LOOK AGAIN FOR TAG
ODSEND:  LDA XDATA + 0;BITS 0 - 7
         OUT PPI1PA;DATA PORT
         LDA XDATA + 1;BITS 8-15
         OUT PPI1PB;DATA PORT
         LDA XDATA + 2;BITS 16-23
         OUT PPI1PC;DATA PORT
         LDA XDATA + 3;BITS 24-31
         OUT PPI2PA;DATA PORT
         LDA XDATA + 4;BITS 32-39
         ORI OATAG;MERGE TAG
         OUT PPI2PB;SEND BITS 32-35 + TAG
         ;CHECK FOR COMPARE ERROR (HARD)
         MVI A,ZERO;
         OUT PPI2PB;RESET TAG
         CALL IODCNT;COUNT OUTPUT DATA WORDS
         RET;
;
;IDW - WORD/TAG DRIVER (SOFT)
SIDWXF:  MVI A,ZERO;
         STA TWCNT + 0;RESET TIME-OUT COUNTER (LSB)
         STA TWCNT + 1;(MSB)
LIDA:    IN  PPI7PB;CHECK FOR INPUT TAGS
         CPI IDRTAG;CHECK FOR PROPER TAG
         JZ  IDGET;GET IF OK
         MVI A,03D;
         STA STATET;SAVE STATE VALUE IN CASE OF ERROR
         CALL WAITT;WAIT LOOP AND PROPER TAG CHECK
         JMP LIDA;LOOK AGAIN FOR TAG
IDGET:   IN  PPI6PA;DATA PORT
         STA XDATA + 0;BITS 0-7
         IN  PPI6PB;DATA PORT
         STA XDATA + 1;BITS 8-15
         IN  PPI6PC;DATA PORT
         STA XDATA + 2;BITS 16-23
         IN  PPI7PA;DATA PORT
         STA XDATA + 3;BITS 24-31
         IN PPI7PB;DATA PORT
         STA XDATA + 4;BITS 32-35 + TAG
         MVI A,IATAG;ACK. TAG
         OUT PPI2PB;DATA PORT
         MVI A,ZERO;
         OUT PPI2PB;RESET TAG
         CALL IIDCNT;COUNT INPUT DATA WORDS
         RET;
;
;EIW - WORD/TAG DRIVER (SOFT)
SEIWXF:  MVI A,ZERO;
         STA TWCNT + 0;RESET TIME-OUT COUNTER (LSB)
         STA TWCNT + 1;(MSB)
LISA:    IN PPI7PB;CHECK FOR INPUT TAGS
         CPI EITAG;CHECK FOR PROPER TAG
         JZ ISGET;GET IF OK
         MVI A,04D;
         STA STATET;SAVE STATE VALUE IN CASE OF ERROR
         CALL WAITT;WAIT LOOP AND PROPER TAG CHECK
         JMP LISA;LOOK AGAIN FOR TAG
ISGET:   IN  PPI6PA;DATA PORT
         STA XSTW + 0;BITS 0-7
         IN  PPI6PB;DATA PORT
         STA XSTW + 1;BITS 8-15
         IN  PPI6PC;DATA PORT
         STA XSTW + 2;BITS 16-23
         IN  PPI7PA;DATA PORT
         STA XSTW + 3;BITS 24-31
         IN PPI7PB;DATA PORT
         STA XSTW + 4;BITS 32-35 + TAG
         MVI A,IATAG;ACK. TAG
         OUT PPI2PB;DATA PORT
         MVI A,ZERO;
         OUT PPI2PB;RESET TAG
         CALL ISTCNT;COUNT INPUT STATUS WORDS
         RET;
;
;CLR - TAG (SOFT)
SCLRXF:  MVI A,CLRTAG;CHANNEL CLEAR TAG
         OUT PPI2PB;RESET CHANNEL
         MVI A,ZERO;
         OUT PPI2PB;RESET CLEAR TAG
LCLA:    IN  PPI7PB;DATA PORT
         CPI ZERO;SEE IF CHANNEL DID RESET
         RZ;YES
         MVI A,05D;
         STA STATET;SAVE CURRENT STATE IN CASE OF ERROR
         CALL WAITT;WAIT LOOP AND TAG SEQUENCE CHECK
         JMP LCLA;CHECK AGAIN FOR CLEAR
;
;INPUT PARITY ERROR (SOFT)
SPARXF:  IN  PPI7PB;DATA PORT
         CPI IPERR;CHECK FOR PARITY ERROR
         RZ  ;RETURN IF NO PARITY ERROR
         MVI A,06D;
         STA STATET;SAVE CURRENT STATE IN CASE OF ERROR
         CALL TRANA;TAG RECOVERY AND ANALYSIS
         RET;
;
ENDIF;
;CHANNEL DATA COUNTERS (SOFT)
IEFCNT:  LHLD EFCNT;
         INX  H;
         SHLD EFCNT;
         RET;
;
IAFCNT:  LHLD AFCNT;
         INX H;
         SHLD AFCNT;
         RET;
;
IODCNT:  LHLD ODCNT;
         INX H;
         SHLD ODCNT;
         RET;
;
IIDCNT:  LHLD IDCNT;
         INX H;
         SHLD IDCNT;
         RET;
;
ISTCNT:  LHLD STCNT;
         INX H;
         SHLD STCNT;
         RET;
;
;TAG TIME-OUT & WRONG TAG ROUTINE
WAITT:   IN  PPI7PB;GET CHANNEL TAG(S)
         STA WTAG;SAVE CHANNEL TAG(S)
         CPI ZERO;
         JNZ TRANA;TAG RECOVERY AND ANALYSIS
         LHLD TWCNT;TIME-OUT COUNTER
         INX H;INCREMENT
         SHLD TWCNT;SAVE NEW COUNT
         LDA TMCNT + 1;TIME-OUT MAX COUNT
         CMP H;CHECK IF MAX COUNT (LOW BYTE)
         RNZ;
         LDA TMCNT + 0;TIME-OUT MAX COUNT
         CMP L;CHECK HIGH BYTE
         RNZ;
         JMP TRANA;TAG RECOVERY AND ANALYSIS
                  ;ERROR IS TIME-OUT
;
;TAG RECOVERY AND ANALYSIS
TRANA:
         MVI A,ZERO;
         STA PASS;RESET LOOP CONTROL
         LXI H,WTAG;
         CMP M;SAVED CHANNEL TAG
         CZ  TMOREC;TAG TIME-OUT HANDLER
         LDA WTAG;SAVED CHANNEL TAG
         ANI ODRTAG;MASK FOR ODR
         CPI ODRTAG;IS IT AN ODR
         CZ  ODTREC;ODR RECOVERY
         LDA WTAG;SAVED CHANNEL TAG
         ANI IDRTAG;MASK FOR IDR
         CPI IDRTAG;IS IT AN IDR
         CZ  IDTREC;IDR RECOVERY
         LDA WTAG;SAVED TAG
         ANI EITAG;MASK FOR EI
         CPI EITAG;IS IT AN EI
         CZ  EITREC;EI RECOVERY
         LDA WTAG;SAVED TAG
         ANI IPERR;MASK FOR PARITY ERROR
         CPI IPERR;IS IT A PARITY ERROR
         CZ  PARREC;PARITY RECOVERY
         MVI A,00D;STATE 0
         LXI H,STATET;
         CMP M;ARE WE IN STATE 0
         LHLD MSG210;ERR MSG
         CZ  PMSG;DISPLAY IT
         MVI A,01D;STATE 1
         LXI H,STATET;
         CMP M;ARE WE IN STATE 1
         LHLD MSG211;ERR MSG
         CZ  PMSG;DISPLAY IT
         MVI A,02D;STATE 2
         LXI H,STATET;
         CMP M;ARE WE IN STATE 2
         LHLD MSG211;ERR MSG
         CZ  PMSG;DISPLAY IT
         MVI A,03D;STATE 3
         LXI H,STATET;
         CMP M;ARE WE IN STATE 3
         LHLD MSG213;ERR MSG
         CZ  PMSG;DISPLAY IT
         MVI A,04D;STATE 4
         LXI H,STATET;
         CMP M;ARE WE IN STATE 4
         LHLD MSG214;ERR MSG
         CZ PMSG;DISPLAY IT
         MVI A,05D;STATE 5
         LXI H,STATET;
         CMP M;ARE WE IN STATE 5
         LHLD MSG215;ERR MSG
         CZ  PMSG;DISPLAY IT
         MVI A,ZERO;
         STA PASS;RESET LOOP CONTROL
         HLT;
;
;RECOVERY ROUTINES (WHAT TO DO GOES HERE)
TMOREC:
         LXI H,MSG200;ERR MSG
         CALL PMSG;DISPLAY IT
         LXI H,MSG201;ERR MSG
         CALL PMSG;DISPLAY IT
         ;PUT RECOVERY ROUTINES HERE
         RET;
;
ODTREC:
         MVI A,ZERO;
         LXI H,PASS;
         CMP M;
         JNZ $ + 12;PRINT NEXT MSG ONCE PER PASS
         LXI H,MSG202;ERR MSG
         CALL PMSG;DISPLAY IT
         MVI A,ONE;
         STA PASS;SET PASS REGISTER
         LXI H,MSG203;ERR MSG
         CALL PMSG;DISPLAY IT
         ;PUT RECOVERY ROUTINES HERE
         RET;
;
IDTREC:
         MVI A,ZERO;
         LXI H,PASS;
         CMP M;
         JNZ $ + 12;PRINT NEXT MSG ONCE PER PASS
         LXI H,MSG202;ERR MSG
         CALL PMSG;DISPLAY IT
         MVI A,ONE;
         STA PASS;SET PASS REGISTER
         LXI H,MSG205;ERR MSG
         CALL PMSG;DISPLAY IT
         ;PUT RECOVERY ROUTINES HERE
         RET;
;
EITREC:
         MVI A,ZERO;
         LXI H,PASS;
         CMP M;
         JNZ $ + 12;PRINT NEXT MSG ONCE PER PASS
         LXI H,MSG202;ERR MSG
         CALL PMSG;DISPLAY IT
         MVI A,ONE;
         STA PASS;SET PASS REGISTER
         LXI H,MSG207;ERR MSG
         CALL PMSG;DISPLAY IT
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
PARREC:
         LXI H,MSG208;ERR MSG
         CALL PMSG;DISPLAY IT
         LXI H,MSG209;ERR MSG
         CALL PMSG;DISPLAY IT
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
OPENIF:;OPEN A FILE IF NOT ONE CREATE IT
         LXI D,FCBB;LOAD ADDRESS OF FILE CONTROL BLOCK B
         CALL CLRFCB;CLEAR FCB LOWER BYTES
         MVI C,OPENF;OPEN FILE COMMAND
         CALL FDOS;GIVE TO CPM
         CPI 0FFH;FF IF FILE IS NOT FOUND
         PUSH PSW;SAVE ZERO FLAG FOR LATER
         LXI H,MSG1;DISPLAY ALREADY EXIST MESSAGE
         CNZ PMSG;DO IT
         POP PSW;RESTORE ZERO FLAG
         JNZ EXISTS;FILE EXISTS THEN JUMP CREATE
         LXI D,FCBB;LOAD ADDRESS OF FCB B
         CALL MAKE;CREATE FILE
EXISTS:  LXI D,BBUFF;LOAD DMA ADDRESS
         MVI C,SDMADD;SET DMA ADDRESS COMMAND
         CALL FDOS;GIVE TO CPM
         LXI H,TMPFCB;TEMP. FCB
         XCHG;HL TO DE
         LXI H,FCBB + 12D;INPUT FCB
         CALL SFCBL;SAVE FCBB INTO TMPFCB (FOR REWRITE)
         CALL RESB;RESET BUFFER COUNTER CONTROLS
         LDA XADD + 0;
         STA EADD + 0;
         LDA XADD + 1;
         STA EADD + 1;
         LDA SADD + 0;
         MOV M,A;
         INX H;
         LDA SADD + 1;
         MOV M,A;
         INX H;
         LDA EADD + 0;
         MOV M,A;
         INX H;
         LDA EADD + 1;
         MOV M,A;
         LXI D,FCBB;LOAD ADDRESS OF FCB B
         CALL WRITE;SAVE FILE INFO IN THE FIRST RECORD
         CALL RESB;RESET BUFFER COUNTER CONTROLS
;        LXI D,FCBB;LOAD ADDRESS OF FCB B
;        CALL WRITE;SAVE FAKE FILE INFO IN FIRST DATA RECORD
;        CALL RESB;RESET BUFFER COUNTER CONTROLS
         RET;
;
OPENPIF:;;CREATE A FILE BUT NOT IF IT EXISTS
         LXI D,FCBC;LOAD ADDRESS OF FILE CONTROL BLOCK C
         CALL CLRFCB;CLEAR FCB LOWER BYTES
         MVI C,OPENF;OPEN FILE COMMAND
         CALL FDOS;GIVE PROBLEM TO CPM
         CPI 0FFH;FF IF FILE IS NOT FOUND
         PUSH PSW;SAVE ZERO FLAG FOR LATER
         LXI H,MSG1;DISPLAY ALREADY EXIST MESSAGE
         CNZ PMSG;DO IT
         POP PSW;RESTORE ZERO FLAG
         JNZ BOOT;REBOOT IF FILE EXISTS
         LXI D,FCBC;LOAD ADDRESS OF FILE CONTROL BLOCK C
         CALL MAKE;CREATE FILE
         LXI D,PBUFF;LOAD DMA ADDRESS
         MVI C,SDMADD;SET DMA ADDRESS COMMAND
         CALL FDOS;GIVE PROBLEM TO CPM
         ;CALL RESB;RESET BUFFER COUNTER CONTROLS
         RET;
;
SAVINP;SAVE CHANNEL INPUT DATA TO DISK IF MOD. SAVIBF SET
         PUSH PSW;SAVE REGISTERS
         PUSH B;
         PUSH D;
         PUSH H;
         LHLD XCNTRB;CURRENT RECORD LENGTH COUNTER
         MOV B,H;
         MOV C,L;
         LXI D,RECSIZ;LOAD SET RECORD LENGTH
         LHLD BBPTR;LOAD CURRENT BUFFER POINTER
         LDA XDATA;GET LSB OF DATA WORD
         MOV M,A;MOVE DATA TO SECTOR BUFFER
         INX B;INCREMENT CURRENT SECTOR LENGTH COUNTER
         INX H;INCREMENT SECTOR BUFFER POINTER
         MOV A,D;
         CMP B;
         JNZ $ + 8;
         MOV A,E;
         CMP C;
         CZ WRITEBR;
         LDA XDATA + 1;
         MOV M,A;MOVE THE NEXT BYTE
         INX B;
         INX H;
         MOV A,D;
         CMP B;
         JNZ $ + 8;
         MOV A,E;
         CMP C;
         CZ WRITEBR;
         LDA XDATA + 2;
         MOV M,A;MOVE THE NEXT BYTE
         INX B;
         INX H;
         MOV A,D;
         CMP B;
         JNZ $ + 8;
         MOV A,E;
         CMP C;
         CZ WRITEBR;
         LDA XDATA + 3;
         MOV M,A;AND THE NEXT
         INX B;
         INX H;
         MOV A,D;
         CMP B;
         JNZ $ + 8;
         MOV A,E;
         CMP C;
         CZ WRITEBR;
         LDA XDATA + 4;
         MOV M,A;MOVE THE LAST 8 BITS OF THE 40 BIT WORD
         INX B;
         INX H;
         MOV A,D;
         CMP B;
         JNZ $ + 8;
         MOV A,E;
         CMP C;
         CZ WRITEBR;
         SHLD BBPTR;SAVE CURRENT BUFFER POINTER
         MOV H,B;
         MOV L,C;
         SHLD XCNTRB;SAVE CURRENT RECORD LENGTH COUNTER
         POP H;RESTORE REGISTERS
         POP D;
         POP B;
         POP PSW;
         RET;
;
WRITEBR:;WRITE THE RECORD FOR B BUFF
         LXI D,BBUFF;LOAD DMA ADDRESS
         MVI C,SDMADD;SET DMA ADDRESS COMMAND
         CALL FDOS;GIVE TO CPM
         LXI D,FCBB;LOAD ADDRESS TO FCB B
         CALL  WRITE;WRITE RECORD
         CALL RESB;
         RET;
;
RESB:;
         LXI H,0000H;ZERO
         SHLD XCNTRB;ZERO CURRENT RECORD LENGTH COUNTER
         LXI B,0000H;ZERO CURRENT RECORD LENGTH COUNTER
         LXI D,RECSIZ;LOAD SET RECORD LENGTH
         LXI H,BBUFF;LOAD POINTER TO BUFFER B
         SHLD BBPTR;RESET BUFFER POINTER
         RET;
;
FINB:;
         LXI D,FCBB;LOAD ADDRESS TO FCB B
         CALL WRITE;WRITE TWO MORE RECORD (AVOID AN EOF)
         LXI D,FCBB;LOAD ADDRESS TO FCB B
         CALL WRITE;JUST IN CASE
         LXI D,FCBB;LOAD ADDRESS TO FCB B
         CALL CLOSE;CLOSE FILE
         MVI A,ZERO;ZERO STUFF IN FCBB
         STA DRB;
         STA EXB;
         STA S1B;
         STA S2B;
         STA RCB;
         STA D0B;
         STA CRB;
         STA R0B;
         STA R1B;
         STA R2B;
         RET;
;
REWRIT:;RE-WRITE FIRST CONTROL RECORD
         CALL WRITEBR;MAKE SURE ALL IS OUT TO DISK
         LXI D,BBUFF;LOAD DMA ADDRESS
         MVI C,SDMADD;SET DMA ADDRESS COMMAND
         CALL FDOS;GIVE TO CPM
         LXI H,TMPFCBB;SAVE FCBB
         XCHG;
         LXI H,FCBB + 12D;
         CALL SFCBL;CALL LOOP
         LXI H,FCBB + 12D;LAST SAVE FCB
         XCHG;MOVE HL TO DE
         LXI H,TMPFCB;FCBB BEFORE FIRST WRITE
         CALL SFCBL;RESTORE OPENED FCB FOR REWRITE
;        LXI D,FCBB;LOAD ADDRESS TO FCB B
;        MVI C,CLOSEF;CPM CLOSE FUNCTION
;        CALL FDOS;TELL CPM
;        CPI 0FFH;DID IT? FF MEANS NO
;        PUSH PSW;SAVE ZERO FLAG
;        LXI H,MSG5;UNSUCCESSFUL CLOSE MESSAGE
;        CZ PMSG;DO IT
;        POP PSW;RESTORE ZERO FLAG
;        JZ BOOT;REBOOT IF NO CLOSE
;        LXI D,FCBB;LOAD ADDRESS TO FCB B
;        MVI C,OPENF;OPEN FILE COMMAND
;        CALL FDOS;TELL CPM
;        CPI 0FFH;FF IF FILE IS NOT FOUND
;        PUSH PSW;SAVE ZERO FLAG
;        LXI H,MSG8;UNABLE TO OPEN MESSAGE
;        CZ PMSG;DO IT
;        POP PSW;RESTORE ZERO FLAG
;        JZ BOOT;REBOOT IF FILE NOT FOUND
         CALL RESB;RESET BUFFER COUNTER CONTROLS
         LDA XADD + 0;
         STA EADD + 0;
         LDA XADD + 1;
         STA EADD + 1;
         LDA SADD + 0;
         MOV M,A;
         INX H;
         LDA SADD + 1;
         MOV M,A;
         INX H;
         LDA EADD + 0;
         MOV M,A;
         INX H;
         LDA EADD + 1;
         MOV M,A;
         LXI D,FCBB;LOAD ADDRESS OF FCB B
         CALL WRITE;SAVE FILE INFO IN THE FIRST RECORD (RE-WRITE)
         LXI H,FCBB + 12D;RESTORE ORG. FCBB
         XCHG;
         LXI H,TMPFCBB;
         CALL SFCBL;RESTORE LOOP
         CALL RESB;RESET BUFFER COUNTER CONTROLS
         CALL FINB;CLOSE FILE
         RET;
;
SFCBL:;LOOP TO MOVE FILE CONTROL BLOCK
         MVI B,18H;24 BYTES TO MOVE
         MOV C,M;
         INX H;INC. PTR.
         XCHG;SWAP POINTERS
         MOV M,C;
         INX H;INC. OTHER POINTER
         XCHG;SWAP AGAIN
         DCR B;
         JNZ SFCBL + 2;DO ALL
         RET;
TMPFCB:  DS 24D;SCRATCH AREA
TMPFCBB: DS 24D;SCRATCH AREA
;
CLRFCB:;CLEAR FCB IN THE DE ON ENTRY
         MOV H,D;COPY DE TO HL
         MOV L,E;LSB
         MVI A,0CH;AJUST FCB PTR TO PASS FILE NAME
         INX H;INC. AJUST
         DCR A;DEC. TIMES TO AJUST (SKIP FIRST 12 BYTES)
         JNZ $ - 2D;MOVE PTR. TILL DONE
         MVI B,18H;24 BYTES TO CLEAR
         MVI A,ZERO;CLEAR BYTE
         MOV M,A;CLEAR FCB
         INX H;INC. PTR. TO FCB
         DCR B;DEC. REMAINING COUNT
         JNZ $ - 3;LOOP TILL DONE
         RET;
;
;THE NEXT ROUTINES ARE USED TO MAKE DATA FILE
RGCOPY:;COPYS ODW TO XDATA (40 BITS)
         LDA ODW + 0;LSB
         STA XDATA + 0;LSB
         LDA ODW + 1;
         STA XDATA + 1;
         LDA ODW + 2;
         STA XDATA + 2;
         LDA ODW + 3;
         STA XDATA + 3;
         LDA ODW + 4;MSB
         STA XDATA + 4;MSB
         RET;
;
RGLOAD:;LOADS XDATA INTO INTERNAL REGISTERS (40 BITS)
         LDA XDATA + 0;BYTE 0
         MOV C,A;
         LHLD XDATA + 1;BYTES 1 & 2
         XCHG;MOVE HL TO DE
         LHLD XDATA + 3;BYTES 3 & 4
         RET;
;
RGUNLD:;UNLOAD REGISTERS TO XDATA (40 BITS)
         MOV A,C;
         STA XDATA + 0;BYTE 0
         SHLD XDATA + 3;BYTES 3 & 4
         XCHG;MOVE DE TO HL
         SHLD XDATA + 1;BYTES 1 & 2
         RET;
;
MAKDAT:;MAKE DATA ROUTINE
         CALL RGCOPY;COPY ODW TO XDATA..OK
         MVI A,ZERO;
         STA XADD + 0;ZERO START ADDRESS (LSB)
         STA SADD + 0;
         STA XADD + 1;(MSB)
         STA SADD + 1;
         LDA DATMOD;GET MODIFIER
         CPI 0FEH;DO WE OPEN/CREATE FILE
         JNZ $ + 7;IF NOT COMMAND THEN SKIP OPEN/CREATE
         CALL OPENIF;OPEN FILE FOR INPUT DATA IF NOT ONE CREATE IT
         RET;OPEN/CREATE ONLY
         CPI 0FFH;IS IT A REWITE/CLOSE COMMAND
         JNZ $ + 7;SKIP CLOSE IF NOT
         CALL REWRIT;REWRITE FIRST DATA CONTROL RECORD
         RET;CLOSE/REWRITE ONLY
         CALL SAVINP;DONT MODIFY DATA FIRST TIME
         LHLD XPRGCNT;GET MODIFIER REPEAT COUNT (IS IT ZERO)
         MVI A,ZERO;
         CMP H;IS MSB ZERO
         JNZ COUNTL;ENTER LOOP IF REPEAT > ZERO
         CMP L;IS LSB ZERO
         JNZ COUNTL;ENTER LOOP IF REPEAT > ZERO
         RET;ALL DONE IF NO REPEAT
COUNTL:
         CALL CHKDMOD;CHECK DATA MODIFERS
         CALL SAVINP;SAVE DATA TO BUFFER OR DISK IF BUFFER IS FULL
         LHLD XPRGCNT;GET MODIFIER REPEAT COUNT
         DCX H;DEC. COUNT
         SHLD XPRGCNT;UPDATE NEW COUNT
         MVI A,ZERO;
         CMP H;IS MSB ZERO
         JNZ COUNTL;LOOP UNTIL REPEAT = 0
         CMP L;IS LSB ZERO
         JNZ COUNTL;LOOP UNTIL ALL IS ZERO
         RET;
;
CHKDMOD:;CHECK FOR DATA MODIFIERS THEN MODIFY
         LDA DATMOD;GET DATA MODIFIER
         CPI 01H;NO OPERATION
         JZ NOOP;DO MOD.
         CPI 02H;INCREMENT OPERATION
         JZ INCOP;DO MOD.
         CPI 03H;DECREMENT OPERATION
         JZ DECOP;DO MOD.
         CPI 04H;SHIFT RIGHT OPERATION
         JZ RSFOP;DO MOD.
         CPI 05H;SHIFT LEFT OPERATION
         JZ LSFOP;DO MOD.
         CPI 06H;RANDOM OPERATION
         JZ RANDOP;DO MOD.
         CPI 07H;COMPLIMENT OPERATION
         JZ COMPOP;DO MOD.
         RET;
;
NOOP:;NO OPERATION ROUTINE (40 BITS)
         CALL RGLOAD;LOAD INTERNAL REGS (ODW)
         CALL RGUNLD;UNLOAD INTERNAL REGISTERS TO XDATA
         RET;
;
INCOP:;INCREMENT OPERATION ROUTINE (40 BITS)
         CALL RGLOAD;LOAD INTERNAL REGS (ODW)
         MOV A,C;MOVE LSB TO A REG
         CPI 0FFH;DO WE HAVE CARRY (FROM LAST TIME)
         JZ DOINC;INC. REST OF 40 BIT WORD
         INR C;INC. UNTILL FF (CARRY)
         JMP RGUNLD;UNLOAD REGISTERS
DOINC:
         INR C;INC. BYTE 0
         INX D;INC. BYTES 2 & 1
         MVI A,ZERO;
         CMP D;IS BYTE 2 ZERO
         JNZ RGUNLD;REPEAT UNTILL 0
         CMP E;IS BYTE 1 ZERO
         JNZ RGUNLD;REPEAT UNTILL ZERO
         INX H;INC. BYTES 4 & 3
         JMP RGUNLD;UNLOAD REGS
;
DECOP:;DECREMENT OPERATION (40 BITS)
         CALL RGLOAD;
         MOV A,C;
         CPI 00H;
         JZ DODEC;
         DCR C;
         JMP RGUNLD;
DODEC:
         DCR C;
         DCX D;
         MVI A,0FFH;
         CMP D;
         JNZ RGUNLD;
         CMP E;
         JNZ RGUNLD;
         DCX H;
         JMP RGUNLD;
;
RSFOP:;SHIFT RIGHT OPERATION (36 BITS)
         CALL RGLOAD;
         MOV A,C;BYTE 0
         RRC;
         MVI A,7FH;
         STA XDATA + 0;
         JNC $ + 8;
         MVI A,0FFH;
         STA XDATA + 0;
;
         MOV A,E;BYTE 1
         RRC;
         MVI A,7FH;
         STA XDATA + 1;
         JNC $ + 8;
         MVI A,0FFH;
         STA XDATA + 1;
;
         MOV A,D;BYTE 2
         RRC;
         MVI A,7FH;
         STA XDATA + 2;
         JNC $ + 8;
         MVI A,0FFH;
         STA XDATA + 2;
;
         MOV A,L;BYTE 3
         RRC;
         MVI A,7FH;
         STA XDATA + 3;
         JNC $ + 8;
         MVI A,0FFH;
         STA XDATA + 3;
;
         MOV A,H;BYTE 4
         RRC;
         MVI A,7FH;
         STA XDATA + 4;
         JNC $ + 8;
         MVI A,0FFH;
         STA XDATA + 4;
;
;
;
         MOV A,H;BYTE 4
         RLC;
         RLC;
         RLC;
         ORI 80H;
         MOV H,A;
         LDA XDATA + 0;DID BYTE ZERO HAVE CARRY OUT
         ANA H;
         RRC;
         RRC;
         RRC;
         RRC;
         MOV H,A;
;
         MOV A,L;BYTE 3
         RRC;
         ORI 80H;
         MOV L,A;
         LDA XDATA + 4;DID BYTE 4 HAVE CARRY OUT
         ANA L;
         MOV L,A;
;
         MOV A,D;BYTE 2
         RRC;
         ORI 80H;
         MOV D,A;
         LDA XDATA + 3;DID BYTE 3 HAVE CARRY OUT
         ANA D;
         MOV D,A;
;
         MOV A,E;BYTE 1
         RRC;
         ORI 80H;
         MOV E,A;
         LDA XDATA + 2;DID BYTE 2 HAVE CARRY OUT
         ANA E;
         MOV E,A;
;
         MOV A,C;BYTE 0
         RRC;
         ORI 80H;
         MOV C,A;
         LDA XDATA + 1;DID BYTE 1 HAVE CARRY OUT
         ANA C;
         MOV C,A;
;
         JMP RGUNLD;
;
LSFOP:;SHIFT LEFT OPERATION (36 BITS)
         CALL RGLOAD;
         JMP RGUNLD;
;
RANDOP:;RANDOM OPERATION (40 BITS)
         CALL RGLOAD;
         MOV H,E;
         MOV L,C;
         MOV A,M;
         STA XDATA + 0;
         INX H;
         MOV A,M;
         STA XDATA + 1;
         INX H;
         MOV A,M;
         STA XDATA + 2;
         INX H;
         MOV A,M;
         STA XDATA + 3;
         INX H;
         MOV A,M;
         STA XDATA + 4;
         RET;
;
COMPOP:;COMPLIMENT OPERATION (40 BITS)
         CALL RGLOAD;
         MOV A,H;
         CMA;
         MOV H,A;
;
         MOV A,L;
         CMA;
         MOV L,A;
;
         MOV A,D;
         CMA;
         MOV D,A;
;
         MOV A,E;
         CMA;
         MOV E,A;
;
         MOV A,C;
         CMA;
         MOV C,A;
         JMP RGUNLD;
;
UPDAFW:;UPDATES AFW FOR REPEAT PACKET (ADD XFCNT TO LAST AFW)
         LHLD XXFCNT + 0;LSB/MSB
         XCHG;HL TO DE
         LHLD AFW + 0;BYTES 0 & 1
         DAD D;DE TO HL ADD
         SHLD AFW + 0;0 & 1
         RNC;DONE IF NO CARRY OUT
         LHLD AFW + 2;BYTES 2 & 3
         INR L;INC. BYTE 2
         JNC $ + 4;IF NO CARRY DONT INC. BYTE 3
         INR H;INC. BYTE 3 (HAD CARRY OUT OF BYTE 2)
         MOV A,H;MOVE MSB TO A REG.
         ANI 07H;STRIP OFF UNWANTED BITS (ONLY 26 - 0)
         MOV H,A;PUT BACK INTO H REG.
         SHLD AFW + 2;PUT BACK BYTES 2 & 3
         RET;
;
RDPAC:;
         MVI A,CONDT;
         LXI H,CMPMOD;
         CMP M;
         JZ  INCMP;DO INPUT AND COMPARE
         CALL SIDWXF;DO INPUT AND NO COMPARE
         JMP INSAV;GO SEE IF INPUT IS TO BE SAVED (FILE)
INCMP:
         LDA BUFRPT;GET BUFFER REPEAT MODIFIER
         CPI CONDT;IS IT SET
         JZ SIDRB;THEN GOTO REPEATING INPUT ROUTINE
         CALL NEXTWD;GET THE SOURCE COMPARE WORD
         LDA  XDATA + 4;(MSB)
         STA  SDATA + 4;(MSB) START DATA
         LDA  XDATA + 3;
         STA  SDATA + 3;
         LDA  XDATA + 2;
         STA  SDATA + 2;
         LDA  XDATA + 1;
         STA  SDATA + 1;
         LDA  XDATA + 0;
         STA  SDATA + 0;
         CALL SIDWXF;GET INPUT WORD
         CALL COMPWD;COMPARE WORDS (DISK AND CHANNEL)
INSAV:   MVI A,CONDT;
         LXI H,SAVIBF;SAVE INPUT BUFFER MODIFIER
         CMP M;
         CZ  SAVINP;SAVE THIS WORD
         LHLD XFCNT;TRANSFER LENGTH
         DCX  H;
         SHLD XFCNT;
         MVI  A,ZERO;
         CMP  H;
         JNZ  RDPAC;LOOP
         CMP  L;
         JNZ  RDPAC;LOOP
IFIN:
         MVI A,CONDT;
         LXI H,SAVIBF;
         CMP M;
         CZ REWRIT;
         MVI A,CONDT;
         LXI H,CMPMOD;
         CMP M;
         RNZ;
         LXI D,FCBA;
         CALL CLOSE;
         RET;
;
WRPAC:   CALL INITC;OPEN OUT FILE AND GET FIRST RECORD (CNTRL)
         CALL SEARCH;FIND START ADDRESS IN FILE
         LDA BUFRPT;REPEAT BUFFER MODIFIER
         CPI CONDT;
         JZ  SODRB;SEND DATA VIA REPEATING BUFFER
WRPACL:  CALL NEXTWD;GET NEXT BYTE (IN AND OUT OF BUFFER)
         CALL SODWXF;SEND OUTPUT DATA
         LHLD XFCNT;TRANSFER LENGTH
         DCX  H;
         SHLD XFCNT;
         MVI  A,ZERO;
         CMP  H;
         JNZ  WRPACL;LOOP
         CMP  L;
         JNZ  WRPACL;LOOP
OFIN:
         LXI D,FCBA;
         CALL CLOSE;
         RET;
;
;ANALYZE CT BIT IN STATUS WORD
CKCT:
         LDA XSTW + 3;GET CT PORTION OF STATUS WORD
         ANI 80H;CT MASK
         CPI 80H;IS IT SET (CT)
         CZ  CTS;CALL IF SET
         RET;
;
;STATUS RECOVERY ROUTINE (WHAT TO DO GOES HERE)
CTS:
         LDA DISPSTW;GET DISPMOD
         CPI CONDT;DO WE DISP STATUS
         JNZ $ + 7;SKIP MESSAGE IF NO
         LXI H,MSG31;GET MSG.
         CALL PMSG;DISPLAY IT
         ;PUT RECOVERY ROUTINES HERE
         RET;
;
;ANALYZE STATUS ACTION IN STATUS WORD
CKSA:
         LDA DISPSTW;GET DISPLAY MODIFIER
         CPI CONDT;DO WE DISPLAY STATUS
         JNZ $ + 7;SKIP MESSAGE IF NO
         LXI H,MSG33;GET MESSAGE
         CALL PMSG;DISPLAY IT
         LDA XSTW + 3;GET STATUS ACTION
         RRC;AJUST
         RRC;AJUST
         ANI 0FH;STATUS ACTION MASK
         CPI 00H;IS STATUS ACTION 0
         CZ  ACOD0;IF ZERO CALL ACTION CODE 0 HANDLER
         CPI 01H;
         CZ  ACOD1;
         CPI 02H;
         CZ  ACOD2;
         CPI 03H;
         CZ  ACOD3;
         CPI 04H;
         CZ  ACOD4;
         CPI 05H;
         CZ  ACOD5;
         CPI 06H;
         CZ  ACOD6;
         CPI 07H;
         CZ  ACOD7;
         CPI 08H;
         CZ  ACOD8;
         CPI 09H;
         CZ  ACOD9;
         CPI 0AH;
         CZ  ACODA;
         CPI 0BH;
         CZ  ACODB;
         CPI 0CH;
         CZ  ACODC;
         CPI 0DH;
         CZ  ACODD;
         CPI 0EH;
         CZ  ACODE;
         CPI 0FH;
         CZ  ACODF;
         RET;
;
;STATUS ACTION RECOVERY ROUTINES (WHAT TO DO GOES HERE)
ACOD0:
         LDA DISPSTW;GET DISP MODIFIER
         CPI CONDT;DO WE DISP STATUS
         JNZ $ + 7;SKIP MESSAGE IF NO
         LXI H,MSG97;GET MSG
         CALL PMSG;DISPLAY IT
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
ACOD1:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG35;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
ACOD2:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG37;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
ACOD3:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG39;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
ACOD4:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG41;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
ACOD5:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG43;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
ACOD6:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG45;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
ACOD7:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG47;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
ACOD8:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG49;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
ACOD9:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG51;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
ACODA:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG53;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
ACODB:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG55;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
ACODC:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG104;WAS NOT IN BOOK!
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
ACODD:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG57;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
ACODE:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG59;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
ACODF:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG61;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
;ANALYZE RECOVERY ACTION IN STATUS WORD
CKREC:
         LDA DISPSTW;GET DISPLAY MODIFIER
         CPI CONDT;DO WE DISPLAY STATUS
         JNZ $ + 7;SKIP MESSAGE IF NO
         LXI H,MSG63;GET MESSAGE
         CALL PMSG;DISPLAY IT
         LDA XSTW + 2;GET RECOVERY ACTION
         RRC;AJUST
         RRC;AJUST
         ANI 0FH;RECOVERY ACTION MASK
         CPI 00H;IS IT REC. 0
         CZ RCOD0;CALL REC. CODE HANDLER 0
         CPI 01H;
         CZ RCOD1;
         CPI 02H;
         CZ RCOD2;
         CPI 03H;
         CZ RCOD3;
         CPI 04H;
         CZ RCOD4;
         CPI 05H;
         CZ RCOD5;
         CPI 06H;
         CZ RCOD6;
         CPI 07H;
         CZ RCOD7;
         CPI 08H;
         CZ RCOD8;
         CPI 09H;
         CZ RCOD9;
         CPI 0AH;
         CZ RCODA;
         CPI 0BH;
         CZ RCODB;
         CPI 0CH;
         CZ RCODC;
         CPI 0DH;
         CZ RCODD;
         CPI 0EH;
         CZ RCODE;
         CPI 0FH;
         CZ RCODF;
         RET;
;
;RECOVERY ACTION RECOVERY ROUTINES (WHAT TO DO GOES HERE)
RCOD0:
         LDA DISPSTW;GET DISPLAY MODIFIER
         CPI CONDT;DO WE DISPLAY STATUS
         JNZ $ + 7;SKIP MSG IF NO
         LXI H,MSG99;GET MESSAGE
         CALL PMSG;DISPLAY IT
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
RCOD1:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG65;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
RCOD2:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG66;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
RCOD3:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG67;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
RCOD4:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG68;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
RCOD5:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG69;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
RCOD6:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG70;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
RCOD7:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG71;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
RCOD8:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG72;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
RCOD9:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG73;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
RCODA:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG74;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
RCODB:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG75;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
RCODC:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG76;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
RCODD:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG77;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
RCODE:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG78;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
RCODF:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG106;NO MESSAGE IN BOOK
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
;ANALYZE DEVICE STATUS IN STATUS WORD
CKDEVS:
         LDA DISPSTW;GET DISPLAY MODIFIER
         CPI CONDT;DO WE DISPLAY STATUS
         JNZ $ + 7;SKIP MESSAGE IF NO
         LXI H,MSG79;GET MESSAGE
         CALL PMSG;DISPLAY IT
         LDA XSTW + 1;GET DEVICE STATUS
         ANI 80H;MASK OUT OTHERS
         CPI 80H;ATTENTION BIT
         CZ  DVCOD8;
         LDA XSTW + 1;GET DEVICE STATUS
         ANI 40H;MASK OUT OTHERS
         CPI 40H;STATUS MODIFIER BIT
         CZ  DVCOD7;
         LDA XSTW + 1;GET DEVICE STATUS
         ANI 20H;MASK OUT OTHERS
         CPI 20H;CONTROL UNIT END
         CZ  DVCOD6;
         LDA XSTW + 1;GET DEVICE STATUS
         ANI 10H;MASK OUT OTHERS
         CPI 10H;BUSY BIT
         CZ  DVCOD5;
         LDA XSTW + 1;GET DEVICE STATUS
         ANI 08H;MASK OUT OTHERS
         CPI 08H;CHANNEL END BIT
         CZ  DVCOD4;
         LDA XSTW + 1;GET DEVICE STATUS
         ANI 04H;MASK OUT OTHERS
         CPI 04H;DEVICE END BIT
         CZ  DVCOD3;
         LDA XSTW + 1;GET DEVICE STATUS
         ANI 02H;MASK OUT OTHERS
         CPI 02H;UNIT CHECK BIT
         CZ  DVCOD2;
         LDA XSTW + 1;GET DEVICE STATUS
         ANI 01H;MASK OUT OTHERS
         CPI 01H;UNIT EXCEPTION
         CZ  DVCOD1;
         LDA XSTW + 1;GET DEVICE STATUS
         CPI 00H;NONE
         CZ  DVCOD0;
         RET;
;
;DEVISE STATUS RECOVERY ROUTINES (WHAT TO DO GOES HERE)
DVCOD8:
         LDA DISPSTW;GET DISPLAY MODIFIER
         CPI CONDT;IS IT SET
         JNZ $ + 7;SKIP MESSAGE IF NOT
         LXI H,MSG81;GET MSG
         CALL PMSG;DISPLAY IT
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
DVCOD7:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG83;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
DVCOD6:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG85;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
DVCOD5:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG87;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
DVCOD4:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG89;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
DVCOD3:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG91;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
DVCOD2:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG93;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
DVCOD1:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG95;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
DVCOD0:
         LDA DISPSTW;
         CPI CONDT;
         JNZ $ + 7;
         LXI H,MSG100;
         CALL PMSG;
         ;PUT RECOVERY ROUTINE HERE
         RET;
;
;STATUS WORD ANALYSIS
STWANA:
         LDA DISPSTW;GET STW DISPLAY MODIFIER
         CPI CONDT;DO WE DISPLAY
         JNZ $ + 7;SKIP MESSAGE IF NO
         LXI H,MSG109;GET MESSAGE IF YES
         CALL PMSG;DISPLAY IT
         CALL CKCT;CHECK CT BIT
         CALL CKSA;CHECK STATUS ACTION
         CALL CKREC;CHECK RECOVERY ACTION
         CALL CKDEVS;CHECK DEVICE STATUS
         LDA  DISPSTW;GET DISPLAY MOD.
         CPI  CONDT;DO WE DISPLAY
         RNZ; RETURN IF NO DISPLAY
         LXI H,MSG102;GET MESSAGE
         CALL PMSG;DISPLAY IT
         LDA  XSTW + 0;GET STW - DEVICE ADDRESS
         CALL CONDMP;DISPLAY IT
         LXI H,MSG110;GET CR & LF
         CALL PMSG;DISPLAY IT
         RET;
;
;DISPLAY STW HEADER AND STW
STWDSP:
         LXI H,MSG30;GET HEADER MSG
         CALL PMSG;DISPLAY IT
         LXI H,MSG108;GET STW = MSG
         CALL PMSG;DISPLAY IT
         LDA XSTW + 4;NEXT DISPLAY INPUT STW
         CALL CONDMP;
         LDA XSTW + 3;
         CALL CONDMP;
         LDA XSTW + 2;
         CALL CONDMP;
         LDA XSTW + 1;
         CALL CONDMP;
         LDA XSTW + 0;
         CALL CONDMP;
         RET;
;
;COMPARE EXPECTED (STW) WITH INPUT (XSTW)
COMPST:
         LDA SDATA + 0;SAVE SDATA
         STA XA + 0;TEMP.
         LDA SDATA + 1;
         STA XA + 1;
         LDA SDATA + 2;
         STA XA + 2;
         LDA SDATA + 3;
         STA XA + 3;
         LDA SDATA + 4;
         STA XA + 4;
         LDA EDATA + 0;SAVE EDATA
         STA XB + 0;
         LDA EDATA + 1;
         STA XB + 1;
         LDA EDATA + 2;
         STA XB + 2;
         LDA EDATA + 3;
         STA XB + 3;
         LDA EDATA + 4;
         STA XB + 4;
         LDA STW + 0;NOW MOVE EXPECTED STW FOR COMPARE
         STA SDATA + 0;
         LDA STW + 1;
         STA SDATA + 1;
         LDA STW + 2;
         STA SDATA + 2;
         LDA STW + 3;
         STA SDATA + 3;
         LDA STW + 4;
         STA SDATA + 4;
         LDA XSTW + 0;NOW MOVE INPUT STATUS WORD TO COMPARE
         STA XDATA + 0;
         LDA XSTW + 1;
         STA XDATA + 1;
         LDA XSTW + 2;
         STA XDATA + 2;
         LDA XSTW + 3;
         STA XDATA + 3;
         LDA XSTW + 4;
         STA XDATA + 4;
         CALL COMPWD;COMPARE THEM LIKE DATA WORDS
         LDA XA + 0;RESTORE SDATA
         STA SDATA + 0;
         LDA XA + 1;
         STA SDATA + 1;
         LDA XA + 2;
         STA SDATA + 2;
         LDA XA + 3;
         STA SDATA + 3;
         LDA XA + 4;
         STA SDATA + 4;
         LDA XB + 0;RESTORE EDATA
         STA EDATA + 0;
         LDA XB + 1;
         STA EDATA + 1;
         LDA XB + 2;
         STA EDATA + 2;
         LDA XB + 3;
         STA EDATA + 3;
         LDA XB + 4;
         STA EDATA + 4;
         LDA PSTATS;DID WE GET A COMPARE ERROR
         CPI DATERR;YES OR NO
         RNZ;RETURN IF NO ERROR
         LXI H,MSG107;GET ERR MSG
         CALL PMSG;DISPLAY IT
         RET;
;
;        * * *   MAIN ROUTINES   * * *
;
RUNPAC:;
         MVI A,GOODST;
         STA PSTATS;
         STA HSTATS;
         LXI D,PBUFF;LOAD DMA ADDRESS
         MVI C,SDMADD;SET DMA ADDRESS COMMAND
         CALL FDOS;GIVE PROBLEM TO CPM
         LXI  D,FCBC;LOAD ADDRES TO FILE CONTROL BLOCK C
         CALL OPEN;
         CALL GETPAC;GET PACKET AND INITILIZE IT
         LHLD XFCNT;GET TRANSFER COUNT
         SHLD XXFCNT;SAVE XFER CNT FOR REPEAT PACKET
PAKLOP:
         LHLD XXFCNT;GET SAVED XFER COUNT
         SHLD XFCNT;RESET XFER CNT VARIABLE
         MVI A,CONDT;
         LXI H,SAVIBF;SAVE INPUT MODIFIER
         CMP M;
         CZ  OPENIF;THEN OPEN FILE FOR INPUT
         MVI A,CONDT;
         LXI H,CMPMOD;COMPARE MODIFIER
         CMP M;
         JNZ PLOOPA;SKIP OPEN AND INIT. IF NO COMPARE
         CALL INITC;OPEN AND INIT COMPARE FILE
         CALL SEARCH;FIND START ADDRESS IN SEQ. FILE
PLOOPA:;
         MVI A,CONDT;
         LXI H,CLRMOD;
         CMP M;
         CZ SCLRXF;DO A CLEAR
         MVI A,CONDT;
         LXI H,EFWMOD;
         CMP M;
         CZ SEFWXF;SEND EF
         MVI A,CONDT;
         LXI H,AFWMOD;
         CMP M;
         CZ SAFWXF;SEND AF
         MVI A,CONDT;
         LXI H,IDWMOD;
         CMP M;
         CZ RDPAC;INPUT DATA
         MVI A,CONDT;
         LXI H,ODWMOD;
         CMP M;
         CZ WRPAC;OUTPUT DATA
         MVI A,CONDT;
         LXI H,EIWMOD;
         CMP M;
         CZ SEIWXF;GET STATUS
         LDA CMPSTW;
         CPI CONDT;
         CZ COMPST;COMPARE INPUT STW WITH EXPECTED STW
         LDA DISPSTW;
         CPI CONDT;
         CZ STWDSP;DISPLAY STATUS WD AND HEADER
         LDA ANASTW;
         CPI CONDT;
         CZ STWANA;ANALYZE STW AND RECOVER
         MVI A,CONDT;
         LXI H,MSTOP;
         CMP M;
         ;CZ MENUA;DISPLAY MENU
         CALL UPDAFW;UPDATE AFW FOR PACKET REPEAT (CONT ADDRESS)
         LHLD PRPCNT;GET PACKET REPEAT COUNT
         DCX H;-1 FROM COUNT
         SHLD PRPCNT;UPDATE VARIABLE
         MVI A,0FFH;
         CMP H;IS MSB ZERO YET
         JNZ PAKLOP;NO - DO AGAIN
         CMP L;IS LSB ZERO YET
         JNZ PAKLOP;NO - THEN KEEP GOING
         LXI D,PBUFF;LOAD DMA ADDRESS
         MVI C,SDMADD;SET DMA ADDRESS COMMAND
         CALL FDOS;TELL CPM
         LDA LSTPAC;LAST PACKET MODIFIER
         CPI CONDT;IS IT SET
         PUSH PSW;SAVE FLAGS
         CNZ GETPAC;IF NOT LAST PACKET THEN GET NEXT PAC. IN FILE
         LHLD XFCNT;GET PACKET XFER COUNT
         SHLD XXFCNT;SAVE IT FROM CHANGE
         POP PSW;RESTORE FLAGS
         JNZ PAKLOP;START EXEC. NEXT PACKET IN FILE
         LXI D,FCBC;
         CALL CLOSE;
         JMP HLEVLG;BACK TO HIGH LEVEL LANGUAGE
;
SAVDAT:
         MVI A,GOODST;
         STA PSTATS;
         STA HSTATS;
         CALL MAKDAT;MAKE DATA BUFFER/FILE
         JMP HLEVLG;BACK TO HIGH LEVEL LANGUAGE
;
DFILES:
         CALL INITC;
         CALL SEARCH;
         CALL NEWLIN;
         LHLD EADD;GET ENDING ADDRESS TO REG. PAIR H,L
         XCHG;LOAD ENDING ADDRESS INTO REG. D,E
LOOPD:
         MOV A,C;
         CMP B;
         CZ NEWLIN;
         INR C;
         LHLD XADD;LOAD NEXT PROM ADDRESS INTO REG. PAIR H,L
         CALL NEXTWD;
         LDA XDATA + 4;LOAD THE A REG. WITH THE MSB OF THE DATA WRD.
         CALL CONDMP;DUMP ON CONSOLE
         LDA XDATA + 3;
         CALL CONDMP;
         LDA XDATA + 2;
         CALL CONDMP;
         LDA XDATA + 1;
         CALL CONDMP;
         LDA XDATA;
         CALL CONDMP;
         PUSH B;
         PUSH D;
         PUSH H;
         MVI C,CONOUTF;CPM CONSOLE OUT (FUNCTION 2)
         MVI E,20H;ASCII SPACE
         CALL FDOS;
         MVI C,CONOUTF;
         MVI E,20H;
         CALL FDOS;
         POP H;
         POP D;
         POP B;
         MOV A,H;
         CMP D;
         JNZ LOOPD;
         MOV A,L;
         CMP E;
         JNZ LOOPD;
         MVI A,GOODST;
         STA PSTATS;
         STA HSTATS;
         JMP HLEVLG;BACK TO HIGH LEVEL LANGUAGE
;
CFILES:
         MVI A,GOODST;
         STA PSTATS;
         STA HSTATS;
         CALL INITC;
         CALL SEARCH;
         CALL INITCB;
         CALL SRCHB;
         LHLD EADD;GET ENDING ADDRESS TO REG. PAIR H,L
         XCHG;LOAD ENDING ADDRESS INTO REG. PAIR D,E
LOOPE:
         CALL NEXTWD;LOAD FILES - CURRENT DATA WORD
         LDA XDATA + 4;MSB OF WORD
         STA SDATA + 4;MSB OF WORD
         LDA XDATA + 3;
         STA SDATA + 3;
         LDA XDATA + 2;
         STA SDATA + 2;
         LDA XDATA + 1;
         STA SDATA + 1;
         LDA XDATA + 0;LSB OF WORD
         STA SDATA + 0;LSB OF WORD
         LHLD XADD;
         DCX H;
         SHLD XADD;
         CALL NXTWDB;
         CALL COMPWD;
         LHLD XADD;
         DCX H;
         MOV A,H;
         CMP D;
         JNZ LOOPE;
         MOV A,L;
         CMP E;
         JNZ LOOPE;
         JMP HLEVLG;BACK TO HIGH LEVEL LANGUAGE
;
SAVPAC:
         MVI A,GOODST;
         STA PSTATS;
         STA HSTATS;
       LDA PRGMOD;SEE IF WE NEED TO OPEN FILE
         CPI CONDT;IS OPEN CMD TRUE
         JNZ $ + 6;IF NOT SKIP OPEN (ALREADY OPEN)
         CALL OPENPIF;CREATE FILE
         CALL PUTPAC;PUT PACKET OUT TO DISK
         LDA LSTPAC;GET LAST PACKET MODIFIER
         CPI CONDT;IS IT SET
         JNZ $ + 9;IF NOT THEN SKIP CLOSE PACKET
         LXI D,FCBC;LOAD ADDRESS TO FCB B
         CALL CLOSE;CLOSE FILE
         JMP HLEVLG;BACK TO HIGH LEVEL LANGUAGE
;
;DELETES FILE FROM DISK
FILDEL:;
         MVI A,GOODST;
         STA PSTATS;
         STA HSTATS;
         LXI D,FCBA;
         CALL FDELETE;
         JMP HLEVLG;BACK TO HIGH LEVEL LANGUAGE
;
;DUMP ASCII TEXT FILES (INSTRUCTIONS)
DTXTF:
         MVI A,GOODST;
         STA PSTATS;
         STA HSTATS;
         LXI D,ABUFF;
         CALL FILA;INIT.
LOPTXT:
         CALL NEXTWD;
         LDA XDATA + 0;
         CALL ASCIID;
         LDA XDATA + 1;
         CALL ASCIID;
         LDA XDATA + 2;
         CALL ASCIID;
         LDA XDATA + 3;
         CALL ASCIID;
         LDA XDATA + 4;
         CALL ASCIID;
         JMP LOPTXT;LOOP UNTIL (EOF)
;
;DISPLAY DIRECTORY
DIRADD:;AJUST PTR. IN BUFFER TO FILENAME POSITION
         ADD A;A * 32
         ADD A;
         ADD A;
         ADD A;
         ADD A;
         LXI H,ABUFF;
         ADC L;
         MOV L,A;
         JNC $ + 4;
         INR H;
         SHLD ABPTR;
         RET;
;
DDDIR:;DISPLAY DISK DIRECTORY (FILENAME)
         MVI B,0CH;FILE NAME LENGTH
         LHLD ABPTR;
         MOV A,M;
         INX H;
         SHLD ABPTR;
         PUSH B;
         CALL ASCIID;PRINT THE CHAR
         POP B;
         DCR B;
         PUSH PSW;
         PUSH B;
         MOV A,B;
         CPI 03H;INSERT SPACE BETWEEN UFN & AFN (FILENAME PAS)
         JNZ $ + 9;
         LXI H,MSG18;'_'
         CALL PMSG;DISPLAY A SPACE
         POP B;
         POP PSW;
         JNZ DDDIR + 2;
         LDA XCNTR + 0;
         DCR A;
         STA XCNTR + 0;
         JNZ $ + 15;
         LXI H,MSG17;CR&LF
         CALL PMSG;
         MVI A,05H;FILENAMES TO DISP. BEFORE CR&LF
         STA XCNTR + 0;
         RET;
         LXI H,MSG16;_:_
         CALL PMSG;DISPLAY IT
         RET;
;
DDIR:;
         MVI A,05H;COUNT BEFORE CR&LF
         STA XCNTR + 0;TEMP REG.
         LXI D,ABUFF;SET DMA
         MVI C,SDMADD;
         CALL FDOS;
         LXI D,FCBA;
         MVI C,SCHFST;SEARCH FIRST
         CALL FDOS;
         CPI 0FFH;= FILE NOT FOUND
         JZ HLEVLG;BACK TO HIGH LEVEL LANGUAGE
         CALL DIRADD;AJUST BUFFER PTR.
         CALL DDDIR;DISPLAY FILENAME
LDIR:    LXI D,FCBA;
         MVI C,SCHNXT;SEARCH NEXT
         CALL FDOS;
         CPI 0FFH;= FILE NOT FOUND
         JZ HLEVLG;BACK TO HIGH LEVEL LANGUAGE
         CALL DIRADD;AJUST BUFFER PTR.
         CALL DDDIR;DISPLAY FILENAME
         JMP LDIR;LOOP TILL DONE
;
;PACKET DUMP (FILE)
PKTDMP:;
         JMP HLEVLG;BACK TO HIGH LEVEL LANGUAGE
;
;POST PACKET FILE ANALYSIS
POSTANA:;
         JMP HLEVLG;BACK TO HIGH LEVEL LANGUAGE
;
RESPRNT:
         MVI A,0C9H;AVAILABLE BYTE
         STA PRNSTS;UPDATE STATUS BYTE
         RET;
;
CHKL:
         MVI A,0FFH;NOT AVAILABLE BYTE
         STA PRNSTS;UPDATE STATUS BYTE
         STA PRNSTS + 1;UPDATE VER. STATUS BYTE
         LDA BIOSL1;M259NCPC - BIOS AUTO CONSOLE PRINTER
         CPI 0C9H;LOCATION TO CHANGE IF C9 (RET INST)
         MVI A,01H;M259NCPC = VER. 1
         STA PRNSTS + 1;UPDATE VER. FOUND STATUS BYTE
         CZ RESPRNT;CALL - IF FOUND
         LDA BIOSL2;M264NCPC - BIOS AUTO CONSOLE PRINTER
         CPI 0C9H;LOCATION TO CHANGE IF C9 (RET INST)
         MVI A,02H;M264NCPC = VER. 2
         STA PRNSTS + 1;UPDATE VER. FOUND STATUS BYTE
         CZ RESPRNT;CALL - IF FOUND
         LDA BIOSL3;B59MB3NC - BIOS AUTO CONSOLE PRINTER
         CPI 0C9H;LOCATION TO CHANGE C9 (RET INST)
         MVI A,03H;B59MB3NC = VER. 3
         STA PRNSTS + 1;UPDATE VER. FOUND STATUS BYTE
         CZ RESPRNT;CALL - IF FOUND
         RET;
;
PRNT:
         MVI A,GOODST;GET GOOD STATUS BYTE
         STA PSTATS;UPDATE PROGRAM STATUS
         STA HSTATS;UPDATE HARDWARE STATUS
         LDA PRNSTS;GET BIOS AVAILABLE STATUS BYTE
         CPI 00H;NOT YET CHECKED
         CZ CHKL;CHECK FOR POSSIBLE BIOS'S
         LDA PRNSTS;GET BIOS AVAILABLE STATUS BYTE
         CPI 0FFH;NOT AVAILABLE BYTE
         PUSH PSW;SAVE ZERO FLAG FOR LATER
         LXI H,MSG22;WRONG BIOS MESSAGE
         CZ PMSG;DISPLAY IT
         POP PSW;
         MVI A,BADCMDS;BAD STATUS
         STA PSTATS;UPDATE PROGRAM STATUS VARIABLE
         JZ HLEVLG;BACK TO HIGH LEVEL LANGUAGE
         LDA PRNSTS + 1;GET VER. STATUS BYTE
         CPI 01H;IS IT BIOS VER. 1
         JZ PRNB1;JUMP IF YES
         CPI 02H;IS IT BIOS VER. 2
         JZ PRNB2;JUMP IF YES
         JMP PRNB3;THEN IT MUST BE VER. 3
;
PRNB1:
         LDA PRNSTS + 2;ON OR OFF STATUS
         CPI 0C9H;C9 = PRINTER OFF
         JZ TOGG1ON;THEN TURN IT ON
         JNZ TOG1OFF;THEN TURN IT OFF
TOGG1ON:
         MVI A,00H;ON BYTE
         STA BIOSL1;CHANGE BIOS
         STA PRNSTS + 2;ON STATUS
         LXI H,MSG23;PRINTER ON MESSAGE
         CALL PMSG;DISPLAY IT
         JMP HLEVLG;
TOG1OFF:
         MVI A,0C9H;OFF BYTE
         STA BIOSL1;CHANGE BIOS
         STA PRNSTS + 2;OFF STATUS
         LXI H,MSG24;PRINTER OFF MESSAGE
         CALL PMSG;DISPLAY IT
         JMP HLEVLG;
PRNB2:
         LDA PRNSTS + 2;ON OR OFF STATUS
         CPI 0C9H;C9 = PRINTER OFF
         JZ TOGG2ON;THEN TURN IT ON
         JNZ TOG2OFF;THEN TURN IT OFF
TOGG2ON:
         MVI A,00H;ON BYTE
         STA BIOSL2;CHANGE BIOS
         STA PRNSTS + 2;ON STATUS
         LXI H,MSG23;PRINTER ON MESSAGE
         CALL PMSG;DISPLAY IT
         JMP HLEVLG;
TOG2OFF:
         MVI A,0C9H;OFF BYTE
         STA BIOSL2;CHANGE BIOS
         STA PRNSTS + 2;OFF STATUS
         LXI H,MSG24;PRINTER OFF MESSAGE
         CALL PMSG;DISPLAY IT
         JMP HLEVLG;
PRNB3:
         LDA PRNSTS + 2;ON OR OFF STATUS
         CPI 0C9H;C9 = PRINTER OFF
         JZ TOGG3ON;THEN TURN IT ON
         JNZ TOG3OFF;THEN TURN IT OFF
TOGG3ON:
         MVI A,00H;ON BYTE
         STA BIOSL3;CHANGE BIOS
         STA PRNSTS + 2;ON STATUS
         LXI H,MSG23;PRINTER ON MESSAGE
         CALL PMSG;DISPLAY IT
         JMP HLEVLG;
TOG3OFF:
         MVI A,0C9H;OFF BYTE
         STA BIOSL3;CHANGE BIOS
         STA PRNSTS + 2;OFF STATUS
         LXI H,MSG24;PRINTER OFF MESSAGE
         CALL PMSG;DISPLAY IT
         JMP HLEVLG;BACK TO HIGH LEVEL LANGUAGE
;
END.
