program SPLIT

! Split the file of "cards" from Dick Weaver.  Each separate "deck" has
! a line with all # on it, followed by a line with 10 # and a description.

! If a file has a line beginning with a comma, assume it is a 1401 object
! "deck."  The EBCDIC -> ASCII conversion turned lozenge into <, record
! mark into \, +0 into {, -0 into } and group mark into !.  Translate these
! into what Supnik's simulator expects: ) for lozenge, ' for record mark,
! ? for +0, ! for -0, and " for group mark.

  logical :: DO_TRANS = .false.    ! "Do translation"
  character(7) :: FILE             ! Name of a generated file, FILE###
  integer :: FILENUM = 0           ! Number of a generated file
  integer :: I, J                  ! Subscript and loop inductor
  character(80) :: LINE            ! Input and output line.
  integer :: LineNo = 0
  character(80) :: TEST            ! Line with all #.
  character(5) :: TRANS_IN = '<\{}!'    ! loz, rm, +0, -0, gm
  character(5) :: TRANS_OUT = ')''?!"'  ! loz, rm, +0, -0, gm

  do i = 1, 80
    test(i:i) = '#'
  end do

  do
    read ( *, '(a)', end=999 ) line
    lineNo = lineNo + 1
    if ( line == test ) then
      if ( filenum /= 0 ) close ( 10 )
      filenum = filenum + 1
      write ( file, "('FILE',i3.3)" ) filenum
      open ( unit=10, file=file, form='formatted', access='sequential' )
      do_trans = .false.
      cycle
    end if
    if ( line(1:11) == test(1:10) ) &
      & print '(i4,":",1x,3a)', lineNo, file, ': ', trim(line(12:))
    if ( line(1:1) == ',' ) do_trans = .true.
    if ( do_trans ) then
      do i = 1, 80
        j = index(trans_in, line(i:i))
        if ( j /= 0 ) line(i:i) = trans_out(j:j)
      end do
    end if
    write ( 10, '(a)') line
  end do
999 continue
end program SPLIT
