/* Read "tapes" in Pierce's (prp@teleport.com) format, and write them in
   the format Supnik's simh 1401 simulator (simh.trailing-edge.com)
   expects.

   In Pierce's format, each 8-bit byte contains a BCD character in the
   low-order six bits (0-5).  Bit 6 is parity -- even for BCD "tapes" and
   odd for "Binary" tapes.  Bit 7 is set in the first character of a
   record.  An end-of-file mark is 0017 (0x0F).  It is possible for the
   last character of a file to be 0200 (0x80).

   simh wants records on "tapes" to be represented by a 32-bit little-
   endian count before and after the record.  The characters are
   represented in the low-order six bits of each byte, in BCD, with no
   parity.  Word marks are represented by word mark characters, just like
   on 1401 tapes.
*/

#include <stdio.h>

main(int argc, char* argv[])
{ unsigned char buf[16001];  /* largest possible record, given that 1401 had
                       16k max memory. */
  int c;
  FILE *fi, *fo;    /* file handles */
  int i;            /* general-purpose index/subscript */
  long recnum;
  long recsiz;      /* actual record size */

  /* Open the input and output files */
  if ( argc != 3 ) {
    printf ("Exactly two arguments required\n");
    printf ("First is input file, second is output file\n");
    exit(1);
  }
  
  if ((fi = fopen(argv[1], "rb")) == NULL) {
          printf ("Unable to open input file %s\n", argv[1]);
          perror(argv[0]);
          exit(1);
  }
  if ((fo = fopen(argv[2], "wb")) == NULL) {
          printf ("Unable to open output file %s\n", argv[2]);
          perror(argv[2]);
          exit(1);
  }

  /* Copy the files */
  recnum = 0;
  recsiz = 0;
  while ( (c = fgetc(fi)) != EOF ) {
    if ( c == 0x80 ) break;
    if ( c & 0x80 ) { /* beginning of a record */
      if ( recsiz != 0 ) { /* There's a record to output */
        recnum++;
/*      printf ( "Writing record %d with %d bytes\n", recnum, recsiz); */
        fwrite ( &recsiz, sizeof(recsiz), 1, fo );
        fwrite ( buf, 1, recsiz, fo );
        if ( recsiz & 1 ) fwrite ( "\0", 1, 1, fo ); /* pad to even length */
        fwrite ( &recsiz, sizeof(recsiz), 1, fo );
        recsiz = 0;
      }
    }
    buf[recsiz++] = (char)(c & 077);
    if ( c == 0x8F ) break;
  }
/*printf ( "Writing record %d with %d bytes\n", recnum++, recsiz); */
  fwrite ( &recsiz, sizeof(recsiz), 1, fo );
  fwrite ( buf, 1, recsiz, fo );
  fwrite ( &recsiz, sizeof(recsiz), 1, fo );
  printf ( "Wrote %d records\n", ++recnum );
  fclose ( fo );
  return(0);
}
