               job  Write chain tape                                       write
               ctl  6611
     *
     * Read program headers, programs and detail cards, and write them
     * on tape 6.  Everything is written with word marks, so programs
     * need to read detail records with word marks, and not expect
     * word marks they set to be preserved.  There's a word mark in 1
     * for detail records.
     *
     * Program headers have  A  in column 80, ID in 73-76,  C in 79 for
     * the chain loader, H in 79 for the page heading printing program, T
     * in 79 for test programs, E in 79 for the end-of-file program, an
     * optional title in 49-71, and the following in 1-27 if it's not an
     * end-of-file program:
     *
     * ....5...10...15...20...25..
     * ,008015,022026N0000001001
     * 1      1      1      1   1
     *
     * On the tape, 1-27 are replaced by
     *
     * ....5...10...15...20...25..
     * L%U1201RB018LB###U%U1B.001
     * 1       1    1   1    1   1
     *
     * The ### is filled from the entry address on the END card of the
     * program's object deck.
     *
     * If it is an end-of-file program, the following is expected in 1-36:
     *
     * ....5...10...15...20...25...30...35.
     * ,008015,022027,031032U%U1RN099.B001
     *
     * The source code for this is at the end of this deck.
     *
     * The program is written on the tape from 201 up to its GMWM, and
     * is read back into 201.  This is to preserve the parameter block
     * at 181-199.  Thus, the program shouldn't bother to load anything
     * below that.  In particular, it shouldn't depend upon initializing
     * the index registers.
     *
     * Program decks are in Autocoder format.
     * The program cannot have a GMWM within it.  If it has none at the
     * end, the one just before "HEADER" will serve.
     *
     * The entry point for every program is taken from the /xxx080 card
     * at the end of its deck.
     *
     * Halts identified by A/B-Star contents:
     * 111 => Tape write error, start writes blank tape and retries
     * 666 => First card is not a header, start reads another
     * 999 => Done, start loops on the halt
     *
     systp     equ  %U6
     *
     start     r
               bce  header,80,a   Is it a header
               nop  666
               h
               b    start
     *
     * This GMWM is for writing detail records.
     *
               org  81
               dcw  @"@
     *
     * This GMWM is for writing headers.
     *
               org  181
               dcw  @"@
     *
     * Some constants
     *
               org  3692
     gmwm      dcw  @"@
               org  *&x00
               org  *-100
     bclear    equ  *
               org  gmwm&1
     kclear    dsa  bclear
     * Tape loader to put in the header that's written on tape
               rtw  1,201
               ber  21
     entry     cs   345,80
               bsp  1
               h    1
     tapldr    dcw  #1
     *
     * Save the header in 101-180
     *
     header    sw   1,201        Set up for Autocoder format, clear
               lca  80,180
               bce  whead,79,E   End-file record?
     *
     * Load an Autocoder-format program into low memory.  All load
     * cards have "1040" in 68-71.
     *
               mcw  kclear,clear&3
               cs   gmwm-1
     clear     cs   0-0
               sw   clear&1
               a    @I0@,clear&2  Subtract 100 from clear address
               cw   clear&1
               bw   clear,201    Clear more if not all done
     skip      r                 Skip clear core cards
               bce  load,68,1    Bootstrap card?
               b    skip
     load      mcw  rback,71     Setup to come back to LOADR
               b    1            Run bootstrap card to set word marks
     loadl     mcw  rback,71     Setup to come back to LOADR
               b    40           Load the card
     rback     dsa  loadr
     loadr     bce  loadz,40,/
               bce  loadl,68,1   Load the card
     *
     * The whole program has been read.  Write the header.
     *
     loadz     mcw  43,entry&3
               cs   80           Clear Autocoder loader's word marks
               lca  tapldr,130   Overlay the header's card loader
               chain5
               b    whead
     wheade    bsp  systp
               nop  111
               h
               skp  systp        Write blank tape
     whead     wtw  systp,101    Write the header
               ber  wheade       Error
               bce  done,179,E   End file program?
               b    loadw
     *
     * Error handler for writing the program
     *
     loade     bsp  systp        Error handler
               nop  111
               h
               skp  systp
     *
     * Write the program
     *
     loadw     wtw  systp,201    Write the program
               ber  loade
               sw   1            So programs can assume it
     *
     * Write detail cards with word marks.
     *
     detail    r
               bce  header,80,a  Is it a header?
     detlw     wtw  systp,1
               ber  detle
               b    detail
     detle     bsp  systp
               nop  111
               h
               skp  systp
               b    detlw
     *
     * Write an end-of-file program
     *
     done      wtm  systp
     donel     nop  999
               h
               b    donel
     *
               end  start
