program DisAsm

! Disassembles object decks in Autocoder, SPS, one-field-per-card and
! seven-field-per-card formats.

  use CommandLine_m, only: CommandLine
  use DisAsmAutocoder_m, only: DisAsmAutocoder
  use DisAsmDump_m, only: DisAsmDump
  use DisAsmOnePerCard_m, only: DisAsmOnePerCard
  use DisAsmSevenPerCard_m, only: DisAsmSevenPerCard
  use DisAsmSPS_m, only: DisAsmSPS

  implicit NONE

  character :: Format    ! A = Autocoder, 1 = one per card,
                         ! 7 = seven per card, S = SPS
  character(100) :: Line ! First card of input
  logical :: ShowAddr    ! Show addresses in 6:10; set by -a option
  logical :: ShowMem     ! Show memory contents; set by -m option
  character(55) :: Title ! To put on JOB card

  ! Analyze command line
  call commandLine ( showAddr, showMem, format, title )

  if ( format == '' ) then ! decide the format from the first card
    read ( *, '(a)', end=9 ) line
    if ( line(38:40) == '057' ) then
      format = 'A'  ! Autocoder, <= 4k
    else if ( line(29:29) == '9' ) then
      format = 'A'  ! Autocoder, > 4k
    else if ( index(line(1:9),':') /= 0 ) then
      format = 'D'  ! simh Dump
    else if ( line(29:29) == ' ' .and. line(8:11) == '1001' ) then
      format = '1'  ! One-field-per-card
    else if ( line(29:29) == '1' ) then
      format = '7'  ! Seven-field-per-card
    else if ( line(29:29) == '5' ) then
       format = 'S' ! SPS
    else
      print '(a,a)', 'Cannot determine format; specify it using a ', &
                   & 'command-line option.'
      stop
    end if
  else
    line = ''
  end if

  select case ( format )
  case ( 'A' )
    call DisAsmAutocoder ( showAddr, showMem, line, title )
  case ( 'D' )
    call DisAsmDump ( showAddr, showMem, line, title )
  case ( '1' )
    call DisAsmOnePerCard ( showAddr, showMem, line, title )
  case ( '7' )
    call DisAsmSevenPerCard ( showAddr, showMem, line, title )
  case ( 'S' )
    call DisAsmSPS ( showAddr, showMem, line, title )
  end select

9 continue
end program DisAsm
