               job  WORDMARK AND BUFFER TEST                               1010C
               ctl  6611
     *
     * Initial stuff in print area
     *
               org  201
               dcw  @1234567890))ABCDEFGHIJKLMNOPQRSTUVWXYZ***)))@
               dc   @1234567890))ABCDEFGHIJKLMNOPQRSTUVWXYZ***)))@
               dc   @1234567890))ABCDEFGHIJKLMNOPQRSTUVWXYZ***)))@
     *
     * Sense switches:
     * B on to repeat inner test -- for scoping
     * C on to print correct results
     * D on to repeat test without reading new detail
     * E on to halt on errors
     *
     * Halts:
     * 99 in A-star and B-star if no more detail records and no header.
     *    Pushing start tries again.  If reading detail from tape it
     *    is nonetheless possible to read more detail from cards here.
     * 86 in A-star and B-star if tape error.  Pushing start tries again.
     *    It is possible to read more detail from cards here.
     * 513 in I-star and 497 in A-star if SW fails to set a WM.  Pushing
     *    start continues.
     * 886 in I-star and 741 in A-star if printer becomes unbusy too
     *    soon.
     * 912 in I-star and 741 in A-star if printer stays busy too long.
     * 984 in I-star and 808 in A-star if carriage becomes unbusy too
     *    soon.
     * 1010 in I-star and 808 in A-star if carriage stays busy too long.
     *
     * Set a word mark in 1.  Read detail records from cards if there
     * are any. Otherwise halt if 81 is not GM (program is not loaded
     * from tape). Otherwise read a record from tape into 1. If 80 is 
     * A, branch to 1.
     * 
     * Print the first two if headpr is not blank.  Otherwise skip them.
     * (This is changed at the end to print one header).
     *
     start     equ  detail
               org  336            At 336 to allow chaining CS to W
     headpr    equ  190            Print first two detail if not blank.
     headct    dcw  0              How many detail read?  Print first 2.
     taperr    bsp  1              Backspace
               nop  86             86 if tape error
               h                   Halt with 86 in A-star and B-star
     detail    sw   1,81           1 for header, 81 under GM if tape
               blc  nocard         No cards left?
               r    testhd         Read a detail or header card
     nocard    bce  tapehd,81,"    Tape load puts GM in 81
               b    finis
     tapeof    bsp  1
     finis     nop  99             99 if no tape or EOF
               h                   Halt with 99 in A-star and B-star
               b    detail         Try again
     tapehd    rtw  1,1            Read a detail or header tape record
               ber  taperr         Error?
               bef  tapeof         Eof?
     testhd    bce  1,80,a         Execute if a header
               bce  cont,headct,2  Headers printed yet?
               bce  skiphd,headpr,  Skip header printing?
               lca  77,277         Print the first two headers
               w
               cs
               cs
               w
     skiphd    a    *-6,headct
               b    detail
     *
     * Continue here after reading detail (which is irrelevant to
     * this test)
     *
     cont      lca  k200,count    Initialize counter to 200
               mcw  kp1,332       Junk for the print line
               mcw  kp1           Spread it out
               mcw  kp1             etc.
               w
     *
     * Print 132 lines of WMs with 1, 2, ..., 132 WMs
     *
     a         a    *-6,count     Bump the counter
               mcw  count,b&3     Move counter to SW
               mcw  count,bb&6    Move counter to BW
     b         sw   5777&x1       5777&x1 is XXX, meaning *filled in*
     bb        bw   c,5777&x1     5777&x1 is XXX, meaning *filled in*
               h    b             Why wasn't the word mark set?
     c         wm                 Write word marks
               bw   d,332         Done if 332 has a WM
               b    a             Set another WM
     d         cc   T
               w
               cs
               cs
               bss  cont,D        Repeat if D is on
     e         lca  k000-1,kll    Initialize KLL to zero
               mcw  k200,fsw&3    Initialize SW to 200
     *
     * Fill a line with junk and word marks
     *
               lca  kp2,244       Junk for the print line
               mcw  244,288       Spread it out
               mcw  244,332         etc.
     f         sw   fsw&1
               a    *-6,fsw&3     Bump where WM is set
               cw   fsw&1
     fsw       sw   200           Set a WM in 201-332
               bw   scope,332     Done setting WMs if 332 has one
               b    f
     scope     wm
               w
               wm
               w
               bss  scope,B
     *
     * Have we done this ten times?
     *
               a    *-6,kll       Bump KLL
               bce  g,kll-1,1     Done if KLL is 10
               b    scope
     g         cc   L
               bss  e,D           Repeat if D is on
     *
     * Print and carriage timing tests
     *
     h         lca  k000-1,kll
               cs   332
               cs
               lca  buffm,286
     *
     * Print timing test
     *
     j         a    *-6,kll
     scope2    lca  k000,count
     waitp1    bpb  waitp1        Wait for printer and carriage
     waitc1    bpcb waitc1
               w
     m         bpb  n             Printer should stay busy for 163
               b    plat1         Print latch error 1
     n         a    *-6,count
               c    count,k163
               bu   m
     o         a    *-6,count
               c    count,k191    Printer should not be busy after 191
               bu   o
               bpb  plat2         Print latch error 2
               bss  scope2,B
     scope3    nop  k000&x1,count  Huh?
               lca
               cc   J
     *
     * Carriage timing test
     *
     q         bpcb r
               b    clat1         Carriage latch error 1
     r         a    *-6,count
               c    count,k41     Carriage should stay busy for 41
               bu   q
     s         a    *-6,count
               c    count,k44     Carriage should not be busy after 44
               bu   s
               bpcb clat2         Carriage latch error 2
               bss  scope3,B
     t         bce  u,kll-1,2     Done after ten times
               b    j
     u         bss  h,D           Repeat if D is on
               b    detail        Load next program?
     *
     * Error message routines
     *
     plat1m    dcw  @PRINT LATCH ERROR 1@
     plat1     bss  scope2,B
               bss  plat1e,E
               mcw  plat1m,229
               w
     waitp2    bpb  waitp2
     waitc2    bpcb waitc2
               cs   scope3,235
     plat1e    h    scope3
     plat2m    dcw  @PRINT LATCH ERROR 2@
     plat2     bss  scope2,B
               bss  plat2e,E
               mcw  plat2m,229
               w    waitp2
     plat2e    h    scope3
     clat1m    dcw  @CARRIAGE LATCH ERROR 1@
     clat1     bss  scope3,B
               bss  clat1e,E
               mcw  clat1m,232
               w
     z         cs   t,235
     clat1e    h    t
     clat2m    dcw  @CARRIAGE LATCH ERROR 2@
     clat2     bss  scope3,B
               bss  clat2e,E
               mcw  clat2m,232
               w    z
     clat2e    h    t
     *
     * Constants
     *
     kll       dcw  @LL@
     k000      dcw  @000@
     k200      dsa  200
     count     dsa  200
     k163      dsa  163
     k191      dsa  191
     k41       dsa  041
     k44       dsa  044
     buffm     dcw  @BUFFERED MACHINES PRINT AND CARRIAGE BUSY TEST.@
     kp1       dcw  @1234567890))ABCDEFGHIJKLMNOPQRSTUVWXYZ***)))@
     kp2       dcw  @ALTERNATE PRINT WORDMARKS & PRINT LINE TEST.@
               dcw  @"@
     *
     * Modify header print routine so it only prints the first
     * card of detail as a header.
     *
               org  headct
               dcw  1
               end  start
