               JOB  Test reading and writing short records on tape         5040C
               ctl  6611
     *
     * Sense switches:
     *  B: Don't check for errors if on
     *  C: Print stuff if on
     *  D: Repeat same record if on
     *  E: Halt on error if on
     *  F: Not used
     *  G: Repeat entire test if on
     *
     * Stuff in the preamble -- not in one-field-per-card format
     *
               org  333
     *
     * Set up for one-field-per-card format and start loading
     *
               sw   8,12
     reload    sw   1
               r    1
     *
     * Look for next program -- A in column 80
     *
     nxprog    r
     tptest    bce  *&5,80,a
               b    421    What's going to be at 421?
               cs   reload,80
               dcw  #1
     *
     * Title print routine  Notice that in the original format,
     * the title and ID are in CC 49-77 of the last card -- the one
     * that transfers control to the program.
     *
     titlsw    equ  1252   1 to use title print routine
     hdrs      equ  1120   All programs put headers in 1120-1199
     titlex    equ  413    All routines must return here after title
     *
               org  1200
     titlpr    w               Print (space).
               sw   49         Set WM for Title and Block No.
               lca  77,277     Load Title and Block No. in Print Area.
               w               Print Title and Block No.
               cs   277        Clear Print Area
               w               Print (space).
               cw   hdrs&20,hdrs&40  Clear Word Marks in second
               cw   hdrs&60   line stored information.
               lca  hdrs&79   Load second line.
               w               Print second line.
               cs   280        Clear Print Area.
               w    titlex     Print (space) and branch to main program.
               dcw  #1
     *
     tapes1    equ  1268   blank indicates the tape loader
     taperd    equ  1288   tape read routine?
     tapes2    equ  1398   GM indicates the tape loader
     *
     * Stuff that is in one-field-per-card format
     *
               ORG  377
     bop       BCE  taperd,tapes1,  USE WHEN TESTS ARE RUN FROM TAPE
               BIN  start,           ,,
               ORG  400
     start     CS   332            START TEST
               CS
     bop2      BCE  titlpr,titlsw,1  BR TO TITLE PRINT ROUTINE?
     loop      MCW  k001,passct   SET PASS COUNTER TO 001
                  N00             NOP
               SW   199           SET WM IN 199
               BIN  init,         BR TO SET MOD INSTR TO INITIAL COND.
               ORG  437
     write     WT   4,208         WRITE 15 CHARACTER RECORD
               BSS  testef,B      B ON TO SCOPE
               BER  error         BRANCH IF WRITE ERROR
     testef    BEF  eor           BRANCH IF END OF REEL
               BSP  4             BACKSPACE
               RT   4,245         READ BACK SAME 15 CHARACTER RECORD
               BSS  write,B       B ON TO SCOPE
               BER  seter         BRANCH IF READ ERROR
               B    wmtest        BRANCH TO TEST FOR ERROR BY COMPARING
     mvpass    MCS  passct,203    MOVE PASS NUMBER
     nopsw     NOP  erprnt        NOP IF NO ERRORS - BRANCH IF ANY ERRORS
               DC   @ @         
               BSS  print,C       C ON TO CORRECT ROUTINE
     dtest     BSS  swdone,D      D ON TO REPEAT SAME RECORD
               C    move&3,tapca  TEST IF LAST RECORD HAS BEEN WRITTEN
               BU   bump          BRANCH IF NOT LAST RECORD
               BCE  loopt,passct-1,1 BRANCH IF END OF 10TH PASS
               A    k001-4,passct   ADD 1 TO PASS COUNTER
               BIN  init,         BRANCH TO START NEXT PASS
               ORG  601
     loopt     BSS  loop,G        G ON TO REPEAT TEST
               CS   nxprog,299    BRANCH TO READ NEXT PROGRAM
     bump      SW   move&1        ADD 1 TO MOVE INSTR TO SET UP NEXT
               A    k001-4,move&3  RECORD TO BE WRITTEN
               B    swdone        BRANCH TO SET UP NEXT RECORD
     eor       RWD  4             REWIND
               B    swdone        BRANCH TO SET UP SAME RECORD
     error     LCA  bop2,nopsw    CHANGE NOP TO BRANCH
               MCW  tapwrd,230    MOVE TAPE WRITE ERROR COMMENT
               BSS  wrhalt,E      E ON TO ERROR STOP
               B    testef        BRANCH TO TEST FOR END OF REEL
     wrhalt    H    testef        ERROR STOP IF TAPE WRITE ERROR
     seter     LCA  bop2,nopsw    CHANGE NOP TO BRANCH
               MCW  tapwrd,267    MOVE TAPE READ ERROR COMMENT
               BSS  rehalt,E      E ON TO ERROR STOP
               B    745           BRANCH TO TEST FOR ERROR BY COMPARING
     rehalt    H    745           ERROR STOP IF TAPE READ ERROR
     uneq      SW   246,258       SET WM IN TAPE READ AREA
     uneq2     LCA  bop2,nopsw    CHANGE NOP TO BRANCH
               MCW  cmpmsg,278    MOVE COMPARE ERROR COMMENT
               BSS  unhalt,E      E ON TO ERROR STOP
               B    mvpass        BRANCH TO MOVE PASS NUMBER
     unhalt    H    mvpass        ERROR STOP IF ERROR DETECTED BY COMPARE
     erprnt    MCW  errmsg,285    MOVE WORD ERROR TO PRINT
               BSS  dtest,E       E OFF TO ERROR PRINT
     print     W                  PRINT
               WM                 PRINT WORD MARKS
               BIN  dtest,        BRANCH TO SENSE D
     wmtest    BW   *&5,246       TEST FOR WORD MARKS
               B    uneq2           ,,
               BW   *&5,258         ,,
               B    uneq2           ,,
               CW   246,258         ,,
               CW   260,223         ,,
               C    260,223       TEST FOR ERRORS BY COMPARING
               BU   uneq            ,,
               C    258,221         ,,
               BU   uneq            ,,
               C    252,215         ,,
               BU   uneq            ,,
               BW   uneq,259     TEST FOR WORD MARKS
               BW   uneq,253        ,,
               BW   uneq,245        ,,
               SW   246,258         ,,
               BIN  mvpass,         ,,
               ORG  886
     init      MCW  tapca&4,mod1&3  SET MODIFIED INSTR TO INITIAL COND
               MCW  tapca&8,move&3   ,,
     init2     CW   mod1&1,tapcon  SET WORD MARKS THROUGHOUT TABLE
     mod1      SW   tapcon-12,mod1&1  ,,
               BW   swdone,tapcon   ,,
               A    k001-4,mod1&3   ,,
               B    init2           ,,
     swdone    CS   299           CLEAR PRINT AREA
               CW   move&1        SET UP 15 CHARACTER RECORD TO BE
     move      MCW  tapcon-11,209  WRITTEN ON TAPE
               LCA                  ,,
               MCW  209,211         ,,
               MCW  211,215         ,,
               LCA  214,222         ,,
               SW   222             ,,
               LCA  gmwm,223        ,,
               MCW  hdrs&20,nopsw  CHANGE ERROR BRANCH TO NOP
               SW   246,258       SET WORD MARK IN TAPE READ AREA
               BIN  write,        BRANCH TO WRITE TAPE
     k001      dcw  10001         CONSTANT
     passct    dcw  @xxx@         PASS COUNTER FOR NO. OF TEST PASSES
     tapca     dsa  tapcon
               sw   tapcon-12
               mcw  tapcon-11
               ORG  1085
     tapwrd    DCW  @TAPE@        CONSTANTS FOR PRINTOUTS
     cmpmsg    dcw  @compare@       ,,
     errmsg    dcw  @error@         ,,
     tapcon    DCW  @AAKT4EOX8I-,@@  CONSTANTS FOR TAPE RECORDS
               org  hdrs
               DCW  @PASS   RECORD WRITTE@   CONSTANTS FOR HEADINGS
               DCW  @N     TYPE OF ERRORS@     ,,
               DCW  @    RECORD READ BACK@     ,,
               DCW  @   TYPE OF ERRORS   @     ,,
               ORG  1250
     gmwm      DCW  @"@                        ,,
     *
     * Stuff at the end.  Not in one-field-per-card format
     * Looks like it's for automatically figuring out whether the
     * program is loaded from tape.
     *
               org  19
     begin     bce  ontape,tapes2,"  GM at tapes2?
               b    start
     ontape    lca  btape&4,tptest&3
               b    1604             What's going to be at 1604?
     btape     b    taperd
               END  begin
