               job  PRINT-PUNCH                                            1050A
               ctl  6611
     *
     * Sense switches:
     * B on to repeat inner test -- for scoping
     * C on to print correct results
     * D on to repeat test without reading new detail
     * E on to halt on errors
     *
     * Halts:
     * 99 in A-star and B-star if no more detail records and no header.
     *    Pushing start tries again.  If reading detail from tape it
     *    is nonetheless possible to read more detail from cards here.
     * 86 in A-star and B-star if tape error.  Pushing start tries again.
     *    It is possible to read more detail from cards here.
     * 458 in A-star and 490 in I-star if test error and SS E on.  Pushing
     *    start continues, depending on SS D.
     * 578 in I-star: WP and branch failed to branch.
     *
     * Set a word mark in 1.  Read detail records from cards if there
     * are any. Otherwise halt if 81 is not GM (program is not loaded
     * from tape). Otherwise read a record from tape into 1. If 80 is 
     * A, branch to 1.
     * 
     * Print the first two if headpr is not blank.  Otherwise skip them.
     *
     start     equ  detail
               org  336            At 336 to allow chaining CS to W
     headpr    equ  190            Print first two detail if not blank.
     headct    dcw  0              How many detail read?  Print first 2.
     taperr    bsp  1              Backspace
               nop  86             86 if tape error
               h                   Halt with 86 in A-star and B-star
     detail    sw   1,81           1 for header, 81 under GM if tape
               blc  nocard         No cards left?
               r    testhd         Read a detail or header card
     nocard    bce  tapehd,81,"    Tape load puts GM in 81
               b    finis
     tapeof    bsp  1
     finis     nop  99             99 if no tape or EOF
               h                   Halt with 99 in A-star and B-star
               b    detail         Try again
     tapehd    rtw  1,1            Read a detail or header tape record
               ber  taperr         Error?
               bef  tapeof         Eof?
     testhd    bce  1,80,a         Execute if a header
               bce  cont,headct,2  Headers printed yet?
               bce  skiphd,headpr,  Skip header printing?
               lca  77,277         Print the first two headers
               w
               cs
               cs
               w
     skiphd    a    *-6,headct
               b    detail
     *
     * Results
     *
     worked    bss  corrpr,c       C ON TO CORRECT PRINT ROUTINE
     loop      bss  repeat,d       D ON TO REPEAT
               cs   start,80       BRANCH TO READ NEXT RECORD
     failed    lca  error,285      BEGIN ERROR PRINT ROUTINE
               bss  errhlt,e       E ON TO ERROR STOP
     corrpr    w    loop           ERROR OR CORRECT PRINT
     errhlt    h    loop           ERROR STOP
     error     dcw  @error@        CONSTANTS
     *
     * Start or continue the test
     *
     cont      cw   d1&1,d2&1      EXPAND TABLE FROM 701-760 TO 701-820
               lca  d3,d6            ,,
               cw   d3&1,d3&1        ,,
               cs   180            CLEAR PUNCH
               sw   101,201        SET WM IN PUNCH AND PRINT AREAS
     repeat    lca  first,count    LOAD 780 INTO CARD COUNTER
     next      mcw  count,move&3   MOVE CARD COUNTER INTO LOCATION 474-476
     move      mcw  0-0,280        MOVE TABLE INTO PRINT AREA
               mcw  280,180        MOVE TABLE INTO PUNCH AREA
               bwz  wpbr,101,2     BR TO PRINT-PUNCH & BR IF NO ZONE IN 101
     scope     wp                  PRINT-PUNCH
               bss  scope,B        B ON TO SCOPE
               b    test           BRANCH TO TEST FOR LAST CARD
     wpbr      wp   btest          PRINT-PUNCH & BRANCH
               h                   ERROR STOP IF NO BRANCH
     btest     bss  wpbr,B         B ON TO SCOPE
     test      c    last,count     COMPARE CARD COUNTER WITH 799
               bu   bump           BRANCH TO ADD 1 IF NOT 799
               bss  repeat,D       D ON TO REPEAT TEST
               cs   280
               cs   180
               b    detail         BRANCH TO READ NEXT RECORD
     bump      a    k1,count       ADD 1 TO CARD COUNTER
               b    next           BRANCH TO PRINT-PUNCH NEXT CARD
     first     dsa  d4             CONSTANT TO START CARD COUNTER
     k1        dcw  1              CONSTANT TO INCREMENT CARD COUNTER
     last      dsa  d5             CONSTANT TO STOP CARD COUNTER
     count     dcw  @XXX@          CARD COUNTER
     d1        dcw  @AKT4 BLU5"CMV6 DNW7_@   TABLE TO BE PRINT-PUNCHED
     d2        dcw  @EOX8 FPY9+GQZ0 HR'#(@     ,,
     d3        dcw  @I-,@ &$%1?.*/2 )JS3!@     ,,
     d4        ds   20
     d5        ds   19
     d6        ds   21
               dcw  @"@
               org  headct
               dcw  1              Modify to print only one header
               end  start
