               job  RIPPLE PUNCH                                           1030A
               ctl  6611
     *
     * Sense switches:
     * B on to repeat inner test -- for scoping
     * D on to repeat test without reading new detail
     *
     * Halts:
     * 99 in A-star and B-star if no more detail records and no header.
     *    Pushing start tries again.  If reading detail from tape it
     *    is nonetheless possible to read more detail from cards here.
     * 86 in A-star and B-star if tape error.  Pushing start tries again.
     *    It is possible to read more detail from cards here.
     * 504 (505 in I-STAR) if punch-and-branch fails to branch
     *
     * Set a word mark in 1.  Read detail records from cards if there
     * are any. Otherwise halt if 81 is not GM (program is not loaded
     * from tape). Otherwise read a record from tape into 1. If 80 is 
     * A, branch to 1.
     * 
     * Print the first two if headpr is not blank.  Otherwise skip them.
     *
     start     equ  detail
               org  336            At 336 to allow chaining CS to W
     headpr    equ  190            Print first two detail if not blank.
     headct    dcw  0              How many detail read?  Print first 2.
     taperr    bsp  1              Backspace
               nop  86             86 if tape error
               h                   Halt with 86 in A-star and B-star
     detail    sw   1,81           1 for header, 81 under GM if tape
               blc  nocard         No cards left?
               r    testhd         Read a detail or header card
     nocard    bce  tapehd,81,"    Tape load puts GM in 81
               b    finis
     tapeof    bsp  1
     finis     nop  99             99 if no tape or EOF
               h                   Halt with 99 in A-star and B-star
               b    detail         Try again
     tapehd    rtw  1,1            Read a detail or header tape record
               ber  taperr         Error?
               bef  tapeof         Eof?
     testhd    bce  1,80,a         Execute if a header
               bce  cont,headct,2  Headers printed yet?
               bce  skiphd,headpr,  Skip header printing?
               lca  77,277         Print the first two headers
               w
               cs
               cs
               w
     skiphd    a    *-6,headct
               b    detail
     *
     * Test starts here
     *
     cont      cs   180            CLEAR PUNCH AREA
               sw   101            SET WM IN PUNCH AREA
     inner     lca  kstart,count   LOAD CARD COUNTER
     next      mcw  count,*&4      MOVE CARD COUNTER INTO NEXT INSTRUCTION
               mcw  0-0,180        MOVE TABLE INTO PUNCH AREA
               bwz  scope2,101,2   BR TO PUNCH AND BRANCH IF NO ZONE IN 101
     scope1    p                   PUNCH
               bss  scope1,B       B ON TO SCOPE
               b    test           BRANCH TO TEST FOR LAST CARD
     scope2    p    branch         PUNCH & BRANCH
               h                   ERROR STOP IF NO BRANCH
     branch    bss  scope2,B       B ON TO SCOPE
     test      c    done,count     COMPARE CARD COUNTER WITH  DONE
               bu   more           BRANCH TO ADD 1 IF NOT  DONE
               bss  inner,d        D ON TO REPEAT TEST
               b    detail         BRANCH TO READ NEXT RECORD
     more      a    *-6,count      ADD 1 TO CARD COUNTER
               b    next           BRANCH TO PUNCH NEXT CARD
     *
     * Data
     *
     kstart    dsa  data1          CONSTANT TO START CARD COUNTER
     done      dsa  data2          CONSTANT TO STOP CARD COUNTER
     count     dcw  #3             CARD COUNTER
               dcw  @AKT4 BLU5"CMV6 DNW7_@   TABLE TO BE RIPPLE PUNCHED
               dc   @EOX8 FPY9&GQZ0 HR'#(@     ,,
               dc   @I-,@ +$%1?.*/2 )JS3!@     ,,
     data1     dc   @AKT4 BLU5"CMV6 DNW7_@     ,,
     data2     dc   @EOX8 FPY9&GQZ0 HR'#@      ,,
               dcw  @"@            GMWM
     *
     * Modify header printer to print only one header
     *
               org  headct
               dcw  1
               end  start
