               job  NUMERICAL RIPPLE PRINT                                 1022B
               ctl  6611
     *
     * Sense switches:
     * B on to repeat inner test -- for scoping
     * D on to repeat test without reading new detail
     *
     * Halts:
     * 99 in A-star and B-star if no more detail records and no header.
     *    Pushing start tries again.  If reading detail from tape it
     *    is nonetheless possible to read more detail from cards here.
     * 86 in A-star and B-star if tape error.  Pushing start tries again.
     *    It is possible to read more detail from cards here.
     *
     * Set a word mark in 1.  Read detail records from cards if there
     * are any. Otherwise halt if 81 is not GM (program is not loaded
     * from tape). Otherwise read a record from tape into 1. If 80 is 
     * A, branch to 1.
     * 
     * Print the first two if headpr is not blank.  Otherwise skip them.
     *
     start     equ  detail
               org  336            At 336 to allow chaining CS to W
     headpr    equ  190            Print first two detail if not blank.
     headct    dcw  0              How many detail read?  Print first 2.
     taperr    bsp  1              Backspace
               nop  86             86 if tape error
               h                   Halt with 86 in A-star and B-star
     detail    sw   1,81           1 for header, 81 under GM if tape
               blc  nocard         No cards left?
               r    testhd         Read a detail or header card
     nocard    bce  tapehd,81,"    Tape load puts GM in 81
               b    finis
     tapeof    bsp  1
     finis     nop  99             99 if no tape or EOF
               h                   Halt with 99 in A-star and B-star
               b    detail         Try again
     tapehd    rtw  1,1            Read a detail or header tape record
               ber  taperr         Error?
               bef  tapeof         Eof?
     testhd    bce  1,80,a         Execute if a header
               bce  cont,headct,2  Headers printed yet?
               bce  skiphd,headpr,  Skip header printing?
               lca  77,277         Print the first two headers
               w
               cs
               cs
               w
     skiphd    a    *-6,headct
               b    detail
     *
     * Continue here after reading detail
     *
     cont      cw   tab1&1,tab2&1  Expand
               lca  tab3,dat1        the
               cw   tab3&1             data
               lca  dat1,dat4      ,,
               cw   dat1&1         ,,
               sw   201
     repeat    lca  kbeg,count     Initialize data counter
     line      mcw  count,*&4      Plug data counter into NSI  
               mcw  dat2,332       Move data to print area
     scope     w
               bss  scope,B        B on for scoping
               c    kend,count     Done?
               bu   more           No
               bss  repeat,D       Repeat the test
               b    detail         Load the next program
     more      a    k1,count       Bump the counter
               b    line
     *
     * Constants and data areas
     *
     kbeg      dsa  dat2
     k1        dcw  1
     kend      dsa  dat3
     count     dcw  @XXX@
     tab1      dcw  @1234 5678 90-, .$*) @
     tab2      dcw  @)*$. ,-09 8765 4321 @
     tab3      dcw  @2468 0,$) 1357 9-.* @
     dat1      ds   60
     dat2      ds   12
     dat3      ds   59
     dat4      ds   49
               dcw  @"@
     *
     * Modify header printer to print only the title
     *
               org  headct
               dcw  1
               end  start
