               job  WORDMARK AND BUFFER TEST                               1010C
               ctl  6611
     *
     * Sense switches:
     * B on to repeat inner test -- for scoping
     * D on to repeat test without reading new detail
     * E on to halt on errors
     *
     * Halts:
     * 492 in I-star and 476 in A-star if SW failed to set a WM
     * 930 in I-star and 719 in A-star if printer becomes unbusy too
     *    soon.
     * 999 in I-star and 719 in A-star if printer stays busy too long.
     * 1030 in I-star and 786 in A-star if carriage becomes unbusy too
     *    soon.
     * 1080 in I-star and 786 in A-star if carriage stays busy too long.
     *
     * Initial stuff in print area
     *
               org  201
  201          dcw  @1234567890))ABCDEFGHIJKLMNOPQRSTUVWXYZ***)))@
  245          dc   @1234567890))ABCDEFGHIJKLMNOPQRSTUVWXYZ***)))@
  299          dc   @1234567890))ABCDEFGHIJKLMNOPQRSTUVWXYZ***)))@
     *
     * Stuff in the preamble
     *
               org  333
     *
     * Set up for one-field-per-card format and begin loading
     *
  333start     sw   8,12
  340reload    sw   1
  344          r    1
     *
     * Look for next program -- A in column 80
     *
  348detail    r
  349tptest    bce  *&5,80,a
  357bcont     b    cont
  361          cs   reload,80
  368          dcw  #1
     *
     tapes1    equ  1268   blank indicates the tape loader
     taperd    equ  1288   tape read routine?
     tapes2    equ  1398   GM indicates the tape loader
               org  377
  377          bce  begin,1261,1
  385          b    taperd
               org  400
  400begin     cs   332
  404          cs
  405          bce  titlpr,titlsw,1  Print the header
  413          cs   80
  417          b    cont
  421cont      lca  k200,count    Initialize counter to 200
  428          cs   332
  432          cs
  433          lca  kp1,244       Junk for the print line
  440          mcw  244,288       Spread it out
  447          mcw  244,332         etc.
  454          w
     *
     * Print 132 lines of WMs with 1, 2, ..., 132 WMs
     *
  455a         a    *-6,count     Bump the counter
  462          mcw  count,b&3     Move counter to SW
  469          mcw  count,bb&6    Move counter to BW
  476b         sw   5777&x1       5777&x1 is XXX, meaning *filled in*
  480bb        bw   c,5777&x1     5777&x1 is XXX, meaning *filled in*
  488          h    b             Why wasn't the word mark set?
  492c         wm                 Write word marks
  494          bw   d,332         Done if 332 has a WM
  502          b    a             Set another WM
  506d         cc   T
  508          w
  509          bss  cont,D        Repeat if D is on
  514e         lca  k000-1,kll    Initialize KLL to zero
  521          mcw  k200,fsw&3    Initialize SW to 200
  528          cs   332
  532          cs
     *
     * Fill a line with junk and word marks
     *
  533          lca  kp2,244       Junk for the print line
  540          mcw  244,288       Spread it out
  547          mcw  244,332         etc.
  554f         sw   fsw&1
  558          a    *-6,fsw&3     Bump where WM is set
  565          cw   fsw&1
  569fsw       sw   200           Set a WM in 201-332
  573          bw   scope,332     Done setting WMs if 332 has one
  581          b    f
  585scope     wm
  587          w
  588          wm
  590          w
  591          bss  scope,B
     *
     * Have we done this ten times?
     *
  596          a    *-6,kll       Bump KLL
  603          bce  g,kll-1,1     Done if KLL is 10
  611          b    scope
  615g         cc   L
  617          bss  e,D           Repeat if D is on
     *
     * Print and carriage timing tests
     *
  622h         nop
               dc   #1
  624          lca  k000-1,kll
  631          cs   332
  635          cs
  636          lca  buffm,289
     *
     * Print timing test
     *
  643j         a    *-6,kll
  650scope2    lca  k000,count
  657          b    waitp1        Wait for printer and carriage
  661l         w
  662m         bpb  n             Printer should stay busy for 163
  667          b    plat1         Print latch error 1
  671n         a    *-6,count
  678          c    count,k163
  685          bu   m
  690o         a    *-6,count
  697          c    count,k191    Printer should not be busy after 191
  704          bu   o
  709          bpb  plat2         Print latch error 2
  714          bss  scope2,B
     *
     * Carriage timing test
     *
  719scope3    nop  k000&x1,count  Huh?
  726          lca
  727          cc   J
  729q         bpcb r
  734          b    clat1         Carriage latch error 1
  738r         a    *-6,count
  745          c    count,k41     Carriage should stay busy for 41
  752          bu   q
  757s         a    *-6,count
  764          c    count,k44     Carriage should not be busy after 44
  771          bu   s
  776          bpcb clat2         Carriage latch error 2
  781          bss  scope3,B
  786t         bce  u,kll-1,2     Done after ten times
  794          b    j
  798u         bss  h,D           Repeat if D is on
  803          b    detail        Load next program?
     *
     * Constants
     *
  807kll       dcw  @LL@
  809k000      dcw  @000@
  812k200      dsa  200
  815count     dsa  200
  818k163      dsa  163
  821k191      dsa  191
  824k41       dsa  041
  827k44       dsa  044
  830buffm     dcw  @BUFFERED MACHINES PRINT AND CARRIAGE BUSY TEST.   @
     plat1m    dcw  @PRINT LATCH ERROR 1@
               dc   #1
     *
     * Error message routines
     *
  900plat1     bss  scope2,B
  905          bss  plat1e,E
  910          mcw  plat1m,229
  917          w
  918w         cs   235     Is it save to clear before waiting?
  922          b    waitp2  Why wait after clearing?
  926plat1e    h    scope3
  930plat2m    dcw  @PRINT LATCH ERROR 2@
               dc   @    @
  953plat2     bss  scope2,B
  958          bss  plat2e,E
  963          mcw  plat2m,229
  970          w    w
  974plat2e    h    scope3
  978clat1m    dcw  @CARRIAGE LATCH ERROR 1@
 1000clat1     bss  scope3,B
 1005          bss  clat1e,E
 1010          mcw  clat1m,232
 1017          w
 1018z         cs   235
 1022          b    t
 1026clat1e    h    t
 1030clat2m    dcw  @CARRIAGE LATCH ERROR 2@
               dc   @   @
 1055clat2     bss  scope3,B
 1060          bss  clat2e,E
 1065          mcw  clat2m,232
 1072          w    z
 1076clat2e    h    t
     *
     * Routines to wait for printer and carriage
     *
 1080waitp1    bpb  waitp1
 1085waitc1    bpcb waitc1
 1090          b    l
 1094waitp2    bpb  waitp2
 1099waitc2    bpcb waitc2
 1104          b    scope3
 1108          dc   #2
     *
     * More constants
     *
 1110kp1       dcw  @1234567890))ABCDEFGHIJKLMNOPQRSTUVWXYZ***)))@
               dc   #1
 1155kp2       dcw  @ALTERNATE PRINT WORDMARKS & PRINT LINE TEST.@
               dc   #1
     *
     * Title print routine.  Notice that in the original format,
     * the title and ID are in CC 49-77 of the last card -- the one
     * that transfers control to the program.
     *
     titlsw    equ  1252   1 to use title print routine
     hdrs      equ  1120   All programs put headers in 1120-1199
     titlex    equ  413    All routines must return here after title
     *
               org  1200
 1200titlpr    w                 Print (space).
 1201          sw   49           Set WM for Title and Block No.
 1205          lca  77,277       Load Title and Block No. in Print Area.
 1212          w                 Print Title and Block No.
 1213          cs   277          Clear Print Area
 1217          W    cont
 1221          DCW  @         @
 1230          DCW  @002@
               end  start
