               JOB  TEST FOR ZONE OR WM & BRANCH                           0060B
               ctl  6611
     *
     * Sense switches:
     * B on to repeat inner test -- for scoping
     * C on to print correct results
     * D on to repeat test without reading new detail
     * E on to halt on errors
     *
     * Halts:
     * 99 in A-star and B-star if no more detail records and no header.
     *    Pushing start tries again.  If reading detail from tape it
     *    is nonetheless possible to read more detail from cards here.
     * 86 in A-star and B-star if tape error.  Pushing start tries again.
     *    It is possible to read more detail from cards here.
     * 458 in A-star and 490 in I-star if test error and SS E on.  Pushing
     *    start continues, depending on SS D.
     *
     * Set a word mark in 1.  Read detail records from cards if there
     * are any. Otherwise halt if 81 is not GM (program is not loaded
     * from tape). Otherwise read a record from tape into 1. If 80 is 
     * A, branch to 1.
     * 
     * Print the first two if headpr is not blank.  Otherwise skip them.
     *
     start     equ  detail
               org  336            At 336 to allow chaining CS to W
     headpr    equ  190            Print first two detail if not blank.
     headct    dcw  0              How many detail read?  Print first 2.
     taperr    bsp  1              Backspace
               nop  86             86 if tape error
               h                   Halt with 86 in A-star and B-star
     detail    sw   1,81           1 for header, 81 under GM if tape
               blc  nocard         No cards left?
               r    testhd         Read a detail or header card
     nocard    bce  tapehd,81,"    Tape load puts GM in 81
               b    finis
     tapeof    bsp  1
     finis     nop  99             99 if no tape or EOF
               h                   Halt with 99 in A-star and B-star
               b    detail         Try again
     tapehd    rtw  1,1            Read a detail or header tape record
               ber  taperr         Error?
               bef  tapeof         Eof?
     testhd    bce  1,80,a         Execute if a header
               bce  cont,headct,2  Headers printed yet?
               bce  skiphd,headpr,  Skip header printing?
               lca  77,277         Print the first two headers
               w
               cs
               cs
               w
     skiphd    a    *-6,headct
               b    detail
     *
     * Results
     *
     worked    bss  corrpr,c       C ON TO CORRECT PRINT ROUTINE
     loop      bss  repeat,d       D ON TO REPEAT
               cs   start,80       BRANCH TO READ NEXT RECORD
     failed    lca  error,285      BEGIN ERROR PRINT ROUTINE
               bss  errhlt,e       E ON TO ERROR STOP
     corrpr    w    loop           ERROR OR CORRECT PRINT
     errhlt    h    loop           ERROR STOP
     error     dcw  @error@        CONSTANTS
     *
     * Start or continue the test
     *
     cont      equ  *&1
     repeat    sw   1,78           LOAD PRINT AREA
               cs   332              ,,
               lca  80               ,,
               cs                    ,,
               lca  72,272           ,,
               bce  setwm,224,*    BR TO SET WM IN ALL * AND % CHARAC
               bce  setwm,224,%      ,,
     dotest    bce  ztest,41,      BR TO TEST EQUAL ZONES IF BLANK IN 041
               mcw  201,*&8        MOVE D MODIFIER TO TEST ZONE OP
     scope     bwz  uneq,224,X     TEST UNEQUAL ZONES OR WM
               bwz                   ,,
               bwz                   ,,
               bwz                   ,,
               bss  scope,B        B ON TO SCOPE
               b    result         BRANCH TO LOAD RESULT COMMENT
     ztest     mcw  201,*&8        MOVE D MODIFIER TO TEST ZONE OP
     scope2    bwz  eqzone,224,X   TEST EQUAL ZONES OR WM
               bss  scope2,B       B ON TO SCOPE
               b    failed         BRANCH TO ERROR PRINT ROUTINE IF UNEQ
     eqzone    bss  scope2,B       B ON TO SCOPE
     result    sw   241            LOAD RESULT COMMENT
               lca  247,267          ,,
               b    worked
     setwm     sw   224            SET WM IN 224 IF * OR %
               b    dotest           ,,
     uneq      bss  scope,B        B ON TO SCOPE
               b    failed
     gmwm      dcw  @"@
               end  start
