               job  Test infrastructure
               ctl  6611
     *
     * Sense switches:
     * B on for tightest loop -- for scoping
     * C on to print correct results
     * D on to loop over test plus printing
     * E on to halt on error instead of printing
     *
     * Detail format:
     * 1-5   Lengths of up to five instructions in test
     * 6-40  Instructions to implement test
     * 41-45 A field
     * 46-50 B field
     * 51-55 Correct result
     * 56-75 Description
     * 76-80 Test ID
     *
     * Halts:
     * 086 in A-star and B-star if tape read error
     * 099 in A-star and B-star if test failure
     *
               org  333
     *
     * Page heading
     *
     start     cs   332
               cs
               mcw  @A/D@,203
               mcw  @B@,211
               mcw  @Should Be@,229
               mcw  @Actual@,238
               mcw  @Status@,247
               mcw  @Description@,261
               mcw  @ID@,276
               w
               cs
               cs
     *
     * Read a test and execute it
     *
     readit    bce  tapein,81,"  Tape load puts GM in 81
               cs   80           Start fresh
               r    gotit
     taperr    bsp  1
               nop  86           Halt 86 for tape error
               h
     tapein    rt   1,1
               ber  taperr
     *
     * Got a detail record.  Print it if 1 is *
     *
     gotit     bce  prntdr,1,*
     hook      b    setup
     prntdr    sw   1        Print the detail record
               mcw  80,280
               w
               cs   readit,280
     *
     * set word marks for up to six instructions
     *
     setup     mcw  @06@,sw&3    Refresh changed instructions
               mcw  @1@,add&3
               sw   5
               chain4
     sw        sw   0-0          Set word mark under instruction
               sw   sw&1
     add       a    0-0,sw&3     Bump where to set word mark
               cw   sw&1
               bce  donesw,add&3,6  Done setting word marks?
               a    *-6,add&3    Bump instruction width counter
               b    sw           Go set another word mark
     sw6       sw   6            Set WM under first instruction
     add1      a    1            Add count in column 1
     *
     * Done setting word marks under instructions
     * Set word marks for A, B, Correct, Description and ID fields
     * Move fields to print area
     *
     donesw    sw   41,46
               sw   51,56
               sw   76
               mcw  45,205
               mcw  50,215
               mcw  55,225
               mcw  75,270
               mcw  80,279
     *
     * Run the test
     *
               b    6
     *
     * Return  here for success
     *
     worked    bss  6,b          Tight loop for scoping
               bss  prntok,c     Print correct result
               b    testd
     prntok    mcw  @OK   @,246
     prntit    mcw  50,237       Actual result
               w
     testd     bss  6,d          Loose loop -- test & print
               b    readit       Go do another test
     *
     * Return here for failure
     *
     failed    bss  6,b          Tight loop for scoping
               bss  errhlt,e     Error halt?
               mcw  @ERROR@,246
               b    prntit
     errhlt    nop  99           Halt 99 for test failure
               h
               b    testd
               end  start
