Unit B1401CNV;
//******************************************************************************
//  Conversion Functions
//------------------------------------------------------------------------------

Interface

Uses SysUtils,
     IBMTrace,
     IBMChars;

Type Str3=String[3];

Type TConvertMode=(
     CMAddr,
     CMNorm
     );

Function  BCDOfAsc(AC: Char): Byte;
Procedure SetConvertMode(CM: TConvertMode);
Function  W2S(WW: Word): String;
Function  BCD2Bin(BS: Str3): Word;
Function  Bin2BCD(BW: Word): Str3;
Procedure Asc2NZ(AC: Char; Var N,Z: Byte);
function  NZ2Asc(N,Z: Byte): Char;
Function  CollSeq(A: Byte): Byte;

Implementation

Uses B1401IEX;

//Type TCodeTable=Array[0..63] of Char;
(*
Const CodeTable: TCodeTable=(
//00   01   02   03   04   05   06   07   08   09   0A   0B   0C   0D   0E   0F
' ' ,'1' ,'2' ,'3' ,'4' ,'5' ,'6' ,'7' ,'8' ,'9' ,'0' ,'#' ,'@' ,#$8D,#$8E,#$8F,
'+' ,'/' ,'S' ,'T' ,'U' ,'V' ,'W' ,'X' ,'Y' ,'Z' ,'!' ,',' ,'%' ,']' ,#$9E,#$9F,
'-' ,'J' ,'K' ,'L' ,'M' ,'N' ,'O' ,'P' ,'Q' ,'R' ,#$AA,'$' ,'*' ,#$AD,#$AE,#$AF,
'&' ,'A' ,'B' ,'C' ,'D' ,'E' ,'F' ,'G' ,'H' ,'I' ,#$BA,'.' ,')' ,#$BD,#$BE,#$BF
);
*)

// .a&$*-/,%=#@?ABCDEFGHI!JKLMNOPQRaSTUVZXYZ0123456789//

// Prolly not needed, or least just use multiple tables
Procedure SetConvertMode(CM: TConvertMode);
Begin
{ Case CM of
    CMNorm: Begin
              CodeTable[$00]:=' ';     // Make ' ' return 0
            End;
    CMAddr: Begin
              CodeTable[$00]:='0';     // Make '0' return 0
              CodeTable[$10]:='?';     // Make '?' return $10
              CodeTable[$1E]:=#$27;    // Make ''' return $1E
              CodeTable[$2A]:='!';     // Make '!' return $2A
            End;
  End;}
End;

Function W2S(WW: Word): String;
Begin
  Result:=Format('%.5u',[WW]);
End;

Function BCDOfAsc(AC: Char): Byte;
Begin
  Result:=Pos(AC,MapChrs); //CodeTable);
End;

Procedure Asc2NZ(AC: Char; Var N,Z: Byte);
Begin
  N:=Pos(AC,MapChrs); //CodeTable);
  If N>0 then Dec(N);
  Z:=(N And $30) Shr 4;
  N:=(N And $0F);
  // Make "0" return zero
//If (N=10) And (Z=0) then N:=0;
  If (N=10) then N:=0;
End;

function NZ2Asc(N,Z: Byte): Char;
Begin
//Result:=CodeTable[(Z Shl 4) Or N];
  Result:=MapChrs[((Z Shl 4) Or N)+1];
  // Make " " return "0"
  If Result=' ' then Result:='0';
End;

function BCD2Bin(BS: Str3): Word;
Var N1,N2,N3,
    Z1,Z2,Z3,
    ZV: Byte;
Begin
// (BS[2]='2') and (BS[3]='6') then
//raceput;
  Asc2NZ(BS[1],N1,Z1);
  Asc2NZ(BS[2],N2,Z2);
  Asc2NZ(BS[3],N3,Z3);
  ZV:=(Z3 Shl 2) Or Z1;
  Result:=ZV*1000+N1*100+N2*10+N3;
  If Z2<>0 then begin
    TraceAdd(' Index Reg');
//  RunEnabled:=False;
    Runstate:=RSEror;
    TracePut;
  End;
end;

function Bin2BCD(BW: Word): Str3;
Var NW,ZW: Word;
    RS: Str3;
Begin
  NW:=BW Mod 1000;
  ZW:=BW Div 1000;
  RS:=Format('%.3u',[NW]);
  RS[1]:=NZ2Asc(Ord(RS[1])-$30,ZW And $3);
  RS[3]:=NZ2Asc(Ord(RS[3])-$30,ZW Shr 2);
  Result:=RS;
end;

Function CollSeq(A: Byte): Byte;
Begin
  Result:=Pos(Chr(A),' .''&$*-/,%=#@?ABCDEFGHI!JKLMNOPQRaSTUVZXYZ0123456789');
End;

(*
The first four columns are for simulators. The Bob S. column is for Bob Supnik's
1401 simulator, easily available on the web. The next two columns are for another
Bob working on a 1401 simulator and the old version of my simulator.
Finally the Newcomer column is for the 1401 simulator here.

The A and F columns are for the "business" and "Fortran" chains for
the 1403 printer, from Bob Supnik.

The last column is for my programs here. Where there are two characters,
txt2bcd will accept either and bcd2txt will produce the first (business)
unless -f (Fortran) is specified. At the far right some of the strange
original BCD characters are described in parentheses.
The code octal 20 is special, it is used on tape to represent 00 in core and
so normally would not be printable. With bcd2txt the default is to convert it
to "^" so it doesn't disappear when converting both ways, but with -b it will
convert to a blank which is the normal case and should work with most editing
tasks. This table is in the file asciibcd.h.

octal  Bob S.  Bob A.  P. Old  Newcomer       A    F      Pierce
 00                                                             (Blank)
 01     1       1       1         1           1    1        1
 02     2       2       2         2           2    2        2
 03     3       3       3         3           3    3        3
 04     4       4       4         4           4    4        4
 05     5       5       5         5           5    5        5
 06     6       6       6         6           6    6        6
 07     7       7       7         7           7    7        7
 10     8       8       8         8           8    8        8
 11     9       9       9         9           9    9        9
 12     0       0       0         0           0    0        0
 13     #       #       =         = #         #    =        # =
 14     @       @       '         ' @         @    '        @ '
 15     :       :       :         :                         :
 16     >       >       >         >                         >
 17     (       t              Radical 0xFB        {        {   (Tape Mark)
 20     ^       c                 b                ^        ^   (Cents or b with a stroke)
 21     /       /       /         /           /    /        /
 22     S       S       S         S           S    S        S
 23     T       T       T         T           T    T        T
 24     U       U       U         U           U    U        U
 25     V       V       V         V           V    V        V
 26     W       W       W         W           W    W        W
 27     X       X       X         X           X    X        X
 30     Y       Y       Y         Y           Y    Y        Y
 31     Z       Z       Z         Z           Z    Z        Z
 32     '       r                 |                |        |   (Record Mark)
 33     ,       ,       ,         ,           ,    ,        ,
 34     %       %       (         % (         %    (        % (
 35     =       =                 ^                         ~
 36     \       '       \         \                         \
 40     -       -       -         -           -    -        -
 41     J       J       J         J           J    J        J
 42     K       K       K         K           K    K        K
 43     L       L       L         L           L    L        L
 44     M       M       M         M           M    M        M
 45     N       N       N         N           N    N        N
 46     O       O       O         O           O    O        O
 47     P       P       P         P           P    P        P
 50     Q       Q       Q         Q           Q    Q        Q
 51     R       R       R         R           R    R        R
 52     !       !       !         !           -    -        !
 53     $       $       $         $           $    $        $
 54     *       *       *         *           *    *        *
 55     ]       )       ]         ]                         ]
 56     ;       ;       ;         ;                         ;
 57     _       d               Delta 0x7F                  _   (Delta)
 60     &       &       +         + &         &    &        & +
 61     A       A       A         A           A    A        A
 62     B       B       B         B           B    B        B
 63     C       C       C         C           C    C        C
 64     D       D       D         D           D    D        D
 65     E       E       E         E           E    E        E
 66     F       F       F         F           F    F        F
 67     G       G       G         G           G    G        G
 70     H       H       H         H           H    H        H
 71     I       I       I         I           I    I        I
 72     ?       ?       ?         ?           &    &        ?
 73     .       .       .         .           .    .        .
 74     )       o       )         )           )    )        )   (Lozenge)
 75     [       (       [         [                         [
 76     <       <       <         <                         <
 77 *   "       g            Group Mark 0xCE       }        }   (Group Mark)

octal  Bob S.  Bob A.  P. Old  Newcomer       A    F      Pierce
 13     #       #       =         = #         #    =        # =
 14     @       @       '         ' @         @    '        @ '
 15     :       :       :         :                         :
 16     >       >       >         >                         >
 17     (       t              Radical 0xFB        {        {   (Tape Mark)
 20     ^       c                 b                ^        ^   (Cents or b with a stroke)
 32     '       r                 |                |        |   (Record Mark)
 34     %       %       (         % (         %    (        % (
 35     =       =                 ^                         ~
 36     \       '       \         \                         \
 52     !       !       !         !           -    -        !
 55     ]       )       ]         ]                         ]
 56     ;       ;       ;         ;                         ;
 57     _       d               Delta 0x7F                  _   (Delta)
 60     &       &       +         + &         &    &        & +
 72     ?       ?       ?         ?           &    &        ?
 74     )       o       )         )           )    )        )   (Lozenge)
 75     [       (       [         [                         [
 76     <       <       <         <                         <
 77 *   "       g            Group Mark 0xCE       }        }   (Group Mark)

 *)

Initialization
  SetConvertMode(CMAddr);
end.

