/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 15-Dec-85 | [1.209] Created change log
* 15-Dec-85 | [1.209] Moved location of diagnostic button to top right corner
*           | Added symbolic names for alert display
* 30-Dec-85 | [1.283] Added I/O check stop switch definitions
* 30-Dec-85 | [1.283] Repositioned manual address switch to make room for
*           | I/O check stop switch
* 29-Jul-86 | [1.395] Added lamp test switch position
* 30-Jul-86 | [1.398] Modified lamp test switch descriptions
* 30-Jul-86 | [1.400] Changed off switch to be a bit higher, lamp test a bit 
*           | lower
*****************************************************************************/

/* The A-reg button display */

#define A_X  ((coord)0)
#define A_Y  ((coord)16)

/* The B-reg button display */

#define B_X  ((coord)9)
#define B_Y  ((coord)16)

/* The I-reg button display */

#define I_X  ((coord)18)
#define I_Y  ((coord)16)

/* The POWER OFF button display */

#define power_X ((coord)71)
#define power_Y ((coord)3)

/* The SENSE SWITCH display */

#define ss_width ((coord)5)
#define ss_space ((coord)2)
#define ss_height ((coord)4)

#define ss_X ((coord)31)
#define ss_Y ((coord)21)

#define ss_delta (ss_width+ss_space)

/* The ADDRESS display */  

#define address_X ((coord)0)
#define address_Y ((coord)10)

/* The OP-register data display */

#define O_display_X ((coord)36)
#define O_display_Y ((coord)4)

/* The B-register data display */

#define B_display_X ((coord)13)
#define B_display_Y ((coord)4)

/* The A-register data display */

#define A_display_X ((coord)18)
#define A_display_Y ((coord)4)

/* The LOGIC display */

#define logic_X ((coord)23)
#define logic_Y ((coord)4)

/* The LOAD KEY display */

#define load_X ((coord)37)
#define load_Y ((coord)18)

/* The START KEY display */

#define start_X ((coord)47)
#define start_Y ((coord)18)

/* The STOP KEY display */

#define stop_X ((coord)57)
#define stop_Y ((coord)18)

/* The RESET KEY display */

#define reset_X ((coord)71)
#define reset_Y ((coord)18)

#define manual_X ((coord)9)
#define manual_Y ((coord)21)
#define manual_width ((coord)4)
#define manual_height ((coord)3)
#define manual_spacing ((coord)1)

/* The PROCESSOR MODE display */

#define mode_X ((coord)36)
#define mode_Y ((coord)13)
#define mode_width ((coord)10)
#define mode_height ((coord)3)

/* The ENTER KEY display */

#define enter_X ((coord)65)
#define enter_Y ((coord)3)

/* The STORAGE DATA FOR ENTRY display */ 

#define pattern_X ((coord)40)
#define pattern_Y ((coord)3)

#define character_X ((coord)65)
#define character_Y ((coord)4)

/* The INSTRUCTION LENGTH display */ 

#define ilength_X ((coord)23)
#define ilength_Y ((coord)12 )

/* The DIAGNOSTICS ENABLE button */

#define diag_key_X ((coord)76)
#define diag_key_Y ((coord)0)

#define diag_key_width ((coord)3)
#define diag_key_height ((coord)3)

/* The diagnostics scrolling window location */

#define diag_X ((coord)0)
#define diag_Y ((coord)0)

/* The PERIPHERALS button */

#define peripherals_X ((coord)65)
#define peripherals_Y ((coord)10)

#define peripherals_width ((coord)12)
#define peripherals_height ((coord)3)

/* The alert lights */

#define alert_Y ((coord)0)
#define alert_X ((coord)0)

#define alert_width ((coord)12)


/* The I/O check stop switch */

#define IOcheck_X ((coord)0)
#define IOcheck_Y ((coord)21)

#define IOcheck_width ((coord)5)
#define IOcheck_height ((coord)4)

#define lamp_X ((coord)73)
#define lamp_Y ((coord)6)
#define lamp_width ((coord)5)
#define lamp_height ((coord)4)

