/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 30-Dec-85 | [1.283] Created
* 24-Jan-86 | [1.308] Use width-1 to avoid activating switch when adjacent
*           | to it
* 23-Feb-86 | [1.364] include <> => include ""
* 23-Feb-86 | [1.364] printf -> scdspmsg to support color
* 23-Feb-86 | [1.365] make switch light blue
* 25-Feb-86 | [1.378] Use color.h, make legend in separate color
* 31-Jul-86 | [1.406] Log I/O check console event
* 18-Aug-86 | [1.414] screen.h -> bscreen.h
* 10-Nov-91 | [1.428] <jmn> converted to Microsoft C 6.0
*****************************************************************************/
#include "stdio.h"
/* #include "graph.h" */

#include "btypes.h"
#include "scdspmsg.h"

#include "boolean.h"
#include "panel.h"
#include "hercules.h"
#include "disp.h"
#include "color.h"
#include "diag.h"
#include "kb.h"
#include "scan.h"
#include "display.h"
#include "1401.h"

boolean IOcheck = true;

/****************************************************************************
*                                   draw_iocheck
* Effect: 
*       Draws the I/O Check Stop switch
****************************************************************************/

void draw_iocheck()
    {
     unsigned char fore;
     unsigned char back;
     unsigned char h_fore;
     unsigned char h_back;

     if(ismono())
        { /* mono */
	 h_fore = fore = H_NORMAL;
	 h_back = back = 0;
	} /* mono */
     else
        { /* color */
	 fore = control_fore;
	 back = control_back;
	 h_fore = legend_fore;
	 h_back = legend_back;
	} /* color */

     hide_mouse_cursor();
     scdspmsg(IOcheck_Y,IOcheck_X,fore,back,  "   ");
     scdspmsg(IOcheck_Y+1,IOcheck_X,fore,back,"   ");
     mark_screen(IOcheck_X+1,IOcheck_Y+1," on",IOcheck);
     scdspmsg(IOcheck_Y+2,IOcheck_X,fore,back,"   ");
     mark_screen(IOcheck_X+1,IOcheck_Y+2,"off",(boolean)!IOcheck);
     scdspmsg(IOcheck_Y+3,IOcheck_X,fore,back,"ͼ");
     scdspmsg(IOcheck_Y,IOcheck_X+1,h_fore,h_back,"I/O");
     show_mouse_cursor();
    }

/****************************************************************************
*                                   ioflip
* Effect: 
*       toggles I/O check stop switch
****************************************************************************/

void ioflip()
    {
     IOcheck = !IOcheck;
     if(diagnostics_on)
        { /* log it */
	 char msg[80];
	 sprintf(msg,"I/O Check Switch %s",(IOcheck ? "ON" : "OFF"));
	 log_console_event(msg);
	} /* log it */
     draw_iocheck();
    }


/****************************************************************************
*				  in_IOcheck
* Inputs:
*       coord X: screen X of mouse hit
*	coord Y: screen Y of mouse hit
* Result: boolean
*       true if in I/O Check Stop switch
*	false if not
****************************************************************************/

boolean in_IOcheck(coord X,coord Y)
    {
     return bounded(X,Y,IOcheck_X,IOcheck_Y,IOcheck_X+IOcheck_width-1,
     			IOcheck_Y+IOcheck_height);
    }

/****************************************************************************
*                                check_IOcheck
* Inputs:
*       coord X: screen X of mouse hit
*	coord Y: screen Y of mouse hit
* Effect: 
*       Handles I/O check stop switch toggling
****************************************************************************/

void check_IOcheck(coord X, coord Y)
    {
     if(in_IOcheck(X,Y))
        { /* hit it */
	 ioflip();
	 wait_for_mouse_up();
	} /* hit it */
    }
