/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 13-Dec-85 | [1.183] Created
* 25-Feb-86 | [1.379] include <> => include ""
* 31-Jul-86 | [1.405] Made all chars unsigned
*****************************************************************************/
#include "boolean.h"
#include "stdio.h"
#include "mach.h"
#include "cvbytes.h"

/****************************************************************************
*                                   cvbytes
* Inputs:
*       unsigned char * dest: Place to put converted bytes
*	int val: Value to convert
* Effect: 
*       3 bcd characters representing the value are placed in dest[0..2]
****************************************************************************/

void cvbytes(unsigned char * dest,short val)
    {
     dest[2] = (unsigned char) (val % 10);	/* low order bcd char is units */
     if(dest[2] == '\0') dest[2] = 10;	/* 8-2 for 0 */

     dest[1] = (unsigned char) ((val / 10) % 10);
     if(dest[1] == '\0') dest[1] = 10;	/* 8-2 for 0 */

     dest[0] = (unsigned char) ((val / 100) % 10);
     if(dest[0] == '\0') dest[0] = 10;	/* 8-2 for 0 */

     /* That takes care of the easy stuff!  000..999 now stored */

     /* Now do decoding for 1000..3999	(A,B,AB = 1,2,3 on tens)
        and for 4000-15000		(A,B,AB = 1,2,3 * 4000 on units )
        and index registers

	range		hundreds	units
	 000-  999	-		-
	1000- 1999	A		-
	2000- 2999	B		-
	3000- 3999	AB		-
	4000- 4999	-		-
	5000- 5999	A		A
	6000- 6999	B		A
	7000- 7999	AB		A
	8000- 8999	-		-
	9000- 9999	A		B
       10000-10999	B		B
       11000-11999	AB		B
       12000-12999	-		-
       13000-13999	A		AB
       14000-14999	B		AB
       15000-15999	AB		AB
     */

     switch((val/1000) % 4)
        { /* hundreds zone */
	 case 0:  break;
	 case 1:  dest[0] |= A_bits;
	 	  break;
	 case 2:  dest[0] |= B_bits;
	 	  break;
	 case 3:  dest[0] |= BA_bits;
	 	  break;
	} /* hundreds zone */

     switch((val/4000) % 4)
        { /* units zone */
	 case 0:  break;
	 case 1:  dest[2] |= A_bits;
	 	  break;
	 case 2:  dest[2] |= B_bits;
	 	  break;
	 case 3:  dest[2] |= BA_bits;
	 	  break;
	} /* units zone */
    }
