/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 12-Dec-85 | [1.174] Created
* 25-Feb-86 | [1.379] include<> => include ""
* 18-Nov-91 | [1.428] <jmn> memory.h => mem1401.h, avoid ANSI name
*****************************************************************************/

#include "boolean.h"
#include "btypes.h"
#include "mem1401.h"
#include "mach.h"
#include "diag.h"
#include "instr.h"
#include "poll.h"
#include "ifetch.h"
/*****************************************************************************
				1401 Simulator

				Select Stacker


				Select Stacker
				--------------
Instruction format

Mnemonic	Op Code	I-address  d-char
--------        ------- ---------  ------
SSB		K	III          x		

Function: This is the same as the select stacker instruction, except the
next instruction is taken from the I-address instead of from the next
sequential instruction address.  The program branch occurs after the card has
been selected.

Word Marks:  Word marks are not affected

Address Registers After Operation: (without indexing special feature)

I-Add		A-Add		B-Add
-----           -----           -----
NSI		BI		???

NOTE: THIS HAS BEEN REINTERPRETED ACCORDING TO THE INDEXING SPECIAL 
FEATURES ADDENDUM:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		BI		NSI



Chaining: N/A

			 Select Stacker
			 --------------
Instruction format

Mnemonic	Op Code	  d-char
--------        -------   ------
SS		K	  x

Read Select: A select stacker instruction must be given during the
first 10ms after actual card reading is completed; otherwise the
command is ineffective (this functionality is not handled in the
simulator).  After a card is read, it continues to the stackers
without stopping.  Therefore, if no select stacker signal is received
within the next 10ms the card stacks in the normal stacker (NR).  Read
select instructions cannot be used following RP and WRP instructions
because the signal cannot be given within the prescribed 10ms.

Punch select: The select stacker instruction is effective if given at
any time between two punch card instructions.  However if a punch check
occurs, the error card is directed to the normal (NP) stacker.

======             |     \                                         /       /
======             V      \                                       /       /
======  ------   ------  ------                                  ------  -----
                                 ---+    |    |    |    |    +---Read    Read
Punch   Blank    Punch   Check      |    |    |    |    |    |   station Check
Hopper  station  station station    |    |    |    |    |    |
                                    |    |    |    |    |    |
				    +----+----+----+----+----+
                                      NP   4   8/2   1    NR


d-char    feed    pocket
------    ----    ------
  1       read    1
  2       read    8/2
  4       punch	  4
  8	  punch	  8/2

In addition, this instruction is used for various kinds of selection on
other devices.

Word Marks:  Word marks are undisturbed

Address Registers After Operation:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		Ap		???

Chaining:  The instruction does not chain
	
*****************************************************************************/


/****************************************************************************
*                                   inst_SS
* Result: boolean
*       true if operation succeeded 
*	false if operation failed
* Effect: 
*       Does nothing, but makes SS a legal operation for the simulator
****************************************************************************/

boolean inst_SS()
    {
     tell_op(op_A|op_d);

     switch(I_cycle)
        { /* length dispatch */
	 case 2: /* Normal SS */
		break;

	case 5: /* SS-and-branch */
		B_addr = I_addr;
		NI_addr = A_addr;

		poll();
		break;

	 default: /* illegal length */
	 	illegal_length();
	  	return false;
	} /* length dispatch */

     single_cycle_state = single_cycle_complete;
     tell_new_state("SS");

     return true;
    }
