#include "stdio.h"
#include "boolean.h"

#include "btypes.h"
#include "scdspmsg.h"

#include "mouse.h"
#include "hercules.h"
#include "display.h"
#include "disp.h"
#include "graph.h"
#include "diag.h"
#include "periph.h"
#include "panel.h"
#include "keys.h"
#include "pr.h"
#include "print.h"
#include "cdr.h"
#include "cdp.h"
#include "button.h"
#include "kb.h"
#include "scan.h"
#include "alert.h"
#include "color.h"
#include "1401.h"


/****************************************************************************
*                              check_peripherals
* Inputs:
*       coord X: screen coordinate of mouse hit
*       coord Y: screen coordinate of mouse hit
* Effect: 
*       Switches to the peripherals control screen.  Control returns to
*	the master panel when the 'Console' button on the peripherals
*	screen is hit
****************************************************************************/

void check_peripherals(coord X,coord Y)
    {
     if(bounded(X,Y,
     		peripherals_X,peripherals_Y,
		peripherals_X+peripherals_width,
		    peripherals_Y+peripherals_height-1))
	   {
	    do_peripherals();

	    hide_mouse_cursor();
	    set_display(CONSOLE);
	    draw_current_screen();
	    show_mouse_cursor();
	   }
    }

/****************************************************************************
*                                check_console
* Inputs:
*       short X: screen X-coordinate of mouse hit
*	short Y: screen Y-coordinate of mouse hit
*
* Result: boolean
*	true if console button hit
*	false if not
****************************************************************************/

boolean check_console(coord X,coord Y)
    {
     if(bounded(X,Y,
     		console_X,console_Y,
		console_X+console_width,console_Y+console_height-1)) 
			return true;

     return false;
    }
