! RGTDOC.CMD
!
! Build documentation on RSTS/E, run as an indirect command file
! Usage information is currently disabled as the library is
! pretty big already.
!
! Note: there is an error in RSTS/E V7.0 runoff (RNO.TSK) such that
! titles, chapter headings, and page numbers don't work together.
! Therefore, there is an incredable hack here to construct the proper
! page number.  Sorry.
!
! The following accounts are used:
!
ASSIGN	SY:[5,1]DOC
ASSIGN	SY:[5,4]OTSCOM
ASSIGN	SY:[5,5]OTSIO
!
! [6,1]		TOOLS
! [6,4]	LEX
!
! Note that KWIK and SCAT must previously be built and stored in PUB:
!
$ ALLOW NO ERRORS
!
! Use GETRNO to build working copies of runoff source files
!
MCR C:GETRNO -R    >KIT.TMP    -H DOC:KIT.RNO
MCR C:GETRNO -R    >NORMAL.TMP -H DOC:CLIBHD.RNO OTSCOM:*.MAC OTSIO:*.MAC
!! MCR C:GETRNO -R -U >USEAGE.TMP -H DOC:CLIBAP.RNO OTSCOM:*.MAC OTSIO:*.MAC
MCR C:GETRNO -R -W >WIZARD.TMP -H DOC:CLIBHD.RNO OTSCOM:*.MAC OTSIO:*.MAC
MCR C:GETRNO -R    >CC.TMP     -H DOC:CC.RNO
!
! Build the library keyword index
!
MCR C:GETKWK	>GETKWK.TMP	OTSCOM:*.MAC OTSIO:*.MAC
MCR PUB:KWIK -T 10 -W 64 <GETKWK.TMP >KWIK.TMP
PIP GETKWK.TMP/DE
$ ALLOW WARNING ERRORS
PIP INDX.TMP=DOC:INDXHD.RNO,SY:KWIK.TMP/AS
$ ALLOW NO ERRORS
PIP KWIK.TMP/DE
MCR C:GETRNO -R >INDEX.TMP -H INDX.TMP
PIP INDX.TMP/DE
!
MCR C:GETKWK -W	>GETKWK.TMP	OTSCOM:*.MAC OTSIO:*.MAC
MCR PUB:KWIK -T 10 -W 64 <GETKWK.TMP >KWIK.TMP
PIP GETKWK.TMP/DE
$ ALLOW WARNING ERRORS
PIP INDX.TMP=DOC:INDXHD.RNO,SY:KWIK.TMP/AS
$ ALLOW NO ERRORS
PIP KWIK.TMP/DE
MCR C:GETRNO -R >WIZDEX.TMP -H INDX.TMP
PIP INDX.TMP/DE
!
! Concatenate files as needed
!
!! PIP NORMAL.TMP=NORMAL.TMP,USEAGE.TMP,INDEX.TMP/AS
!! PIP WIZARD.TMP=WIZARD.TMP,KIT.TMP,USEAGE.TMP,WIZDEX.TMP/AS
!! PIP USEAGE.TMP,INDEX.TMP,WIZDEX.TMP/DE
$ ALLOW WARNING ERRORS
PIP NORMAL.TMP=NORMAL.TMP,INDEX.TMP/AS
PIP WIZARD.TMP=WIZARD.TMP,KIT.TMP,WIZDEX.TMP/AS
$ ALLOW NO ERRORS
PIP INDEX.TMP,WIZDEX.TMP/DE
!
$ ALLOW WARNING ERRORS
PIP CC.TMP=CC.TMP,DOC:CBUGS.RNO/AS
$ ALLOW NO ERRORS
!
! Make the documentation
!
DEASSIGN	OTSCOM
DEASSIGN	OTSIO
ASSIGN	C:	OUT
ASSIGN	[6,1]	TOOLS
!
!
! Note that KIT.DOC (system generation information) goes onto [5,1], not C:
!
$ ALLOW FATAL ERRORS
RNO DOC.TMP/-SP=KIT.TMP/-HY/UL:N
$ ALLOW NO ERRORS
PIP KIT.TMP/DE
MCR C:FIXDOC <DOC.TMP >DOC:KIT.DOC
PIP DOC.TMP/DE
!
$ ALLOW FATAL ERRORS
RNO DOC.TMP/-SP=CC.TMP/-HY/UL:L
$ ALLOW NO ERRORS
PIP CC.TMP/DE
MCR C:FIXDOC <DOC.TMP >OUT:CC.DOC
PIP DOC.TMP/DE
!
$ ALLOW FATAL ERRORS
RNO OUT:AS/-SP=DOC:AS/-HY/UL:L
$ ALLOW NO ERRORS
!
$ ALLOW FATAL ERRORS
RNO DOC.TMP/-SP=NORMAL.TMP/-HY/UL:L
$ ALLOW NO ERRORS
PIP NORMAL.TMP/DE
MCR C:FIXDOC <DOC.TMP >OUT:CLIB.DOC
PIP DOC.TMP/DE
!
$ ALLOW FATAL ERRORS
RNO DOC.TMP/-SP=WIZARD.TMP/-HY/UL:L
$ ALLOW NO ERRORS
PIP WIZARD.TMP/DE
MCR C:FIXDOC <DOC.TMP >OUT:WIZARD.DOC
PIP DOC.TMP/DE
!
$ ALLOW FATAL ERRORS
RNO OUT:CBUGS.DOC/-SP=DOC:CBUGS.RNO/-HY/UL:N
$ ALLOW NO ERRORS
!
! Build tools
!
MCR PUB:SCAT TOOLS:*.RNO >TOOL1.TMP
$ ALLOW WARNING ERRORS
PIP TOOL2.TMP=DOC:TOOLHD.RNO,TOOL1.TMP/AS
$ ALLOW NO ERRORS
PIP TOOL1.TMP/DE
MCR C:GETRNO >TOOL3.TMP		-R -H TOOL2.TMP
PIP TOOL2.TMP/DE
$ ALLOW FATAL ERRORS
RNO DOC.TMP/-SP=TOOL3.TMP/-HY/UL:L
$ ALLOW NO ERRORS
PIP TOOL3.TMP/DE
MCR C:FIXDOC <DOC.TMP >OUT:TOOLS.DOC
PIP DOC.TMP/DE
!
DEASSIGN	TOOLS
ASSIGN	[6,4]	LEX
!
MCR C:GETRNO >LEX.TMP		-R -H LEX:LEX.RNO
$ ALLOW FATAL ERRORS
RNO DOC.TMP/-SP=LEX.TMP/-HY/UL:L
$ ALLOW NO ERRORS
PIP LEX.TMP/DE
MCR C:FIXDOC <DOC.TMP >OUT:LEX.DOC
PIP DOC.TMP/DE
!
! Copy help file and make all .DOC files accessable
!
PIP OUT:CC.HLP<40>=DOC:CC.HLP
PIP OUT:*.DOC<40>=OUT:*.DOC/RE
!
! Documentation built (deep breath).
!
                                                                                                                                                                                                                                                                                                                              