PACK.PAS
PROGRAM PACK;
(* THIS PROGRAM PACKS ONE OR MORE SOURCE FILES INTO A PACKED
   FILE FORMAT WHERE EACH SOURCE FILE TEXT IS PRECEEDED BY
   THE FILES NAME AND FOLLOWED BY '****'.  UNPACK, LISTPK,
   REPLCE, AND SELECT CAN BE USED ON FILES CREATED BY PACK
   TO RETREIVE THE SOURCE FILES.
*)
CONST BLANKS = '                     ';
VAR PACKFILE, FILENAME: ARRAY [0..20] OF CHAR;
    I,J: INTEGER;
    C: CHAR;
    INFILE, OUTFILE: TEXT;
BEGIN
  WRITE('NAME OF PACKED FILE:'); BREAK(OUTPUT);
  PACKFILE := BLANKS;
  J := 1;
  READ( PACKFILE[0] );
  WHILE NOT EOLN(INPUT) DO BEGIN
    READ( PACKFILE[J] ); J := SUCC(J) END;
  J := PRED(J);
  PACKFILE[J] := CHR(0);
  REWRITE( OUTFILE, PACKFILE, 2 );
  LOOP
    FILENAME := BLANKS;
    WRITE('FILE TO PACK:'); BREAK(OUTPUT);
    I := 1;
    READ( FILENAME[0] );
    EXIT IF EOLN( INPUT );
    WHILE NOT EOLN(INPUT) DO BEGIN
      READ( FILENAME[I] ); I := SUCC(I) END;
    I := PRED(I);
    FILENAME[I] := CHR(0);
    RESET( INFILE, FILENAME, 2 );
    IF EOF( INFILE ) THEN
      WRITELN( FILENAME:I, ' NOT FOUND')
    ELSE BEGIN
      WRITELN( OUTFILE, FILENAME:I );
      WHILE NOT EOF( INFILE ) DO BEGIN
	WHILE NOT EOLN( INFILE ) DO BEGIN
	  READ( INFILE, C ); WRITE( OUTFILE, C ) END;
	READLN( INFILE );
	WRITELN( OUTFILE )
        END;
      WRITELN( OUTFILE, '****' )
      END;
  END;
  WRITELN(PACKFILE:J,' HAS BEEN CREATED')
END.
****
LISTPK.PAS
PROGRAM LISTPACK;
(* THIS PROGRAM EXAMINES A FILE OV CONCATENATED SOURCES.
   A LIST OF THE MODULE NAMES IS PRODUCED.  EACH MODULE
   MUST START WITH ONE LINE GIVING THE FILE NAME AND
   END WITH ONE LINE CONTAINING '****'.
   SUCH PACKING IF PERFORMED BY THE PROGRAM PACK.
*)
VAR FILENAME: ARRAY [0..20] OF CHAR;
    I,J,NSTAR: INTEGER;
    C: CHAR;
    EOM: BOOLEAN;
    INFILE: TEXT;
BEGIN
  WRITE('NAME OF PACKED FILE:'); BREAK(OUTPUT);
  FOR I:=0 TO 20 DO FILENAME[J] := ' ';
  J := 1;
  READ(FILENAME[0]);
  WHILE NOT EOLN(INPUT) DO BEGIN
    READ(FILENAME[J]); J := SUCC(J) END;
  J := PRED(J);
  FILENAME[J] := CHR(0);
  BREAK(OUTPUT);
  RESET( INFILE, FILENAME, 2 );
  IF EOF(INFILE) THEN WRITELN( FILENAME:J, ' NOT FOUND')
  ELSE BEGIN
   WRITELN('CONTENTS OF ',FILENAME:J);
   WHILE NOT EOF(INFILE) DO BEGIN
    FILENAME := '                     ';
    I := 0;
    WHILE NOT EOLN(INFILE) AND (I<20) DO BEGIN
      READ(INFILE, FILENAME[I]); I := SUCC(I) END;
    READLN( INFILE );
    EOM := FALSE;
    WRITELN( FILENAME:I );
    WHILE NOT EOM DO BEGIN
      NSTAR := 0;
      FOR I := 1 TO 4 DO IF INFILE@ = '*' THEN BEGIN
        NSTAR := SUCC(NSTAR); GET(INFILE) END;
      IF NSTAR=4 THEN EOM := TRUE;
      READLN( INFILE )
      END
    END;
   WRITELN('END OF FILE')
  END
END.
****
UNPACK.PAS
PROGRAM UNPACK;
(* THIS PROGRAM WILL UNPACK ALL OF THE SOURCE MODULES IN
   A PACKED FILE.  EACH MODULE MUST START WITH ONE LINE
   GIVING THE FILE NAME AND END WITH ONE LINE CONTAINING
   '****'.  SUCH PACKING IS PERFORMED BY THE PROGRAM PACK.
*)
CONST BLANKS = '                     ';
VAR PACKFILE, FILENAME: ARRAY [0..20] OF CHAR;
    I,J,NSTAR: INTEGER;
    C: CHAR;
    EOM: BOOLEAN;
    INFILE, OUTFILE: TEXT;
BEGIN
  WRITE('NAME OF PACKED FILE:'); BREAK(OUTPUT);
  PACKFILE := BLANKS;
  J := 1;
  READ( PACKFILE[0] );
  WHILE NOT EOLN(INPUT) DO BEGIN
    READ( PACKFILE[J] ); J := SUCC(J) END;
  J := PRED(J);
  PACKFILE[J] := CHR(0);
  RESET( INFILE, PACKFILE, 2 );
  IF EOF( INFILE ) THEN
    WRITELN( PACKFILE:J,' NOT FOUND')
  ELSE LOOP
    EXIT IF EOF( INFILE );
    FILENAME := BLANKS;
    I := 0;
    WHILE NOT EOLN( INFILE ) DO BEGIN
      READ( INFILE, FILENAME[I] ); I := SUCC(I) END;
    FILENAME[I] := CHR(0);
    READLN( INFILE );
    WRITELN('WRITING ',FILENAME:I ); BREAK(OUTPUT);
    REWRITE( OUTFILE, FILENAME, 2 );
    EOM := FALSE;
    WHILE NOT EOM DO BEGIN
      NSTAR := 0;
      FOR I := 1 TO 4 DO IF INFILE@ = '*' THEN BEGIN
	NSTAR := SUCC(NSTAR); GET( INFILE ) END;
      IF NSTAR = 4 THEN EOM := TRUE
      ELSE BEGIN
	FOR I := 1 TO NSTAR DO WRITE( OUTFILE, '*' );
	WHILE NOT EOLN( INFILE ) DO BEGIN
	  READ( INFILE, C ); WRITE( OUTFILE, C ) END;
        WRITELN( OUTFILE )
	END;
      READLN( INFILE )
      END;
    END;
  WRITELN( PACKFILE:J, ' UNPACKED')
END.
****
REPLCE.PAS
PROGRAM REPLACE;
(* THIS PROGRAM REPLACES A SOURCE MODULE IN A PACKED FILE
   WITH AN UPDATED VERSION OF THE SAME MODULE.  EACH MODULE
   MUST START WITH ONE LINE GIVING THE FILE NAME AND END WITH
   ONE LINE CONTAINING '****'.  SUCH PACKING IS PERFORMED BY
   THE PROGRAM PACK.
*)
CONST BLANKS = '                     ';
VAR PACKFILE, SEARCHED, FILENAME: ARRAY [0..20] OF CHAR;
    I,J,K,NSTAR: INTEGER;
    C: CHAR;
    INFILE, NEWFILE, OLDFILE: TEXT;
    EOM, REPLACED: BOOLEAN;
BEGIN
  WRITELN('REPLACE');
  WRITE('NAME OF PACKED FILE:'); BREAK(OUTPUT);
  J := 1;
  READ( PACKFILE[0] );
  WHILE NOT EOLN(INPUT) DO BEGIN
    READ( PACKFILE[J] ); J := SUCC(J) END;
  J := PRED(J);
  PACKFILE[J] := CHR(0);
  RESET( OLDFILE, PACKFILE, 2 );
  IF EOF(OLDFILE)
  THEN WRITELN( PACKFILE:J, ' NOT FOUND')
  ELSE BEGIN
    REWRITE( NEWFILE, PACKFILE, 2 );
    FILENAME := BLANKS;
    I := 1;
    WRITE('FILE TO REPLACE:'); BREAK(OUTPUT);
    READ( FILENAME[0] );
    WHILE NOT EOLN(INPUT) DO BEGIN
      READ( FILENAME[I] ); I := SUCC(I) END;
    I := PRED(I);
    FILENAME[I] := CHR(0);
    RESET( INFILE, FILENAME, 2 );
    REPLACED := FALSE;
    IF EOF(INFILE)
    THEN WRITELN( FILENAME:I, ' NOT FOUND')
    ELSE LOOP
      SEARCHED := BLANKS;
      K := 0;
      WHILE NOT EOLN(OLDFILE) AND (K<20) DO BEGIN
	READ( OLDFILE, SEARCHED[K] ); K := SUCC(K) END;
      SEARCHED[K] := CHR(0);
      WRITELN( NEWFILE, SEARCHED:K );
      READLN( OLDFILE );
      IF FILENAME=SEARCHED
      THEN BEGIN
	WRITELN('REPLACING ', FILENAME:I );
	REPLACED := TRUE;
	WHILE NOT EOF(INFILE) DO BEGIN
	  WHILE NOT EOLN(INFILE) DO BEGIN
	    READ( INFILE, C ); WRITE( NEWFILE, C ) END;
	  READLN( INFILE );
	  WRITELN( NEWFILE )
	  END;
	WRITELN( NEWFILE, '****' );
	EOM := FALSE;
	WHILE NOT EOM DO BEGIN
	  NSTAR := 0;
	  FOR K := 1 TO 4 DO IF OLDFILE@ = '*' THEN BEGIN
	    NSTAR := SUCC(NSTAR); GET( OLDFILE ) END;
	  IF NSTAR=4 THEN EOM := TRUE;
	  READLN( OLDFILE )
	  END
	END
      ELSE BEGIN
	EOM := FALSE;
	WHILE NOT EOM DO BEGIN
	  NSTAR := 0;
	  FOR K := 1 TO 4 DO IF OLDFILE@ = '*' THEN BEGIN
	    NSTAR := SUCC(NSTAR); GET( OLDFILE ) END;
	  IF NSTAR = 4
	  THEN BEGIN
	    EOM := TRUE;
	    WRITELN( NEWFILE, '****' )
	    END
	  ELSE BEGIN
	    FOR K := 1 TO NSTAR DO WRITE( NEWFILE, '*' );
	    WHILE NOT EOLN( OLDFILE ) DO BEGIN
	      READ( OLDFILE, C ); WRITE( NEWFILE, C ) END;
	    WRITELN( NEWFILE )
	    END;
	  READLN( OLDFILE )
	  END
	END;
      EXIT IF EOF(OLDFILE) THEN
	IF NOT REPLACED THEN WRITELN( FILENAME:I, ' NOT REPLACED');
      END
    END
END.
****
SELECT.PAS
PROGRAM SELECT;
(* THIS PROGRAM CONVERTS THE CONCATENATED SOURCES OF
   A PACKED FILE INTO SEPARATE FILES.  EACH MODULES
   MUST START WITH ONE LINE GIVING THE FILE NAME AND
   END WITH ONE LINE CONTAINING '****'.
   SUCH PACKING IS PERFORMED BY THE PROGRAM PACK.
*)
VAR FILENAME,SEARCHED,PACKFILE: ARRAY [0..20] OF CHAR;
    I,J,NSTAR: INTEGER;
    C: CHAR;
    EOM: BOOLEAN;
    INFILE,OUTFILE: TEXT;
BEGIN
  WRITE('NAME OF PACKED FILE:'); BREAK(OUTPUT);
  PACKFILE := '                     ';
  J := 1;
  READ( PACKFILE[0] );
  WHILE NOT EOLN(INPUT) DO BEGIN
    READ( PACKFILE[J] ); J := SUCC(J) END;
  J := PRED(J);
  PACKFILE[J] := CHR(0);
  LOOP
    RESET( INFILE, PACKFILE, 2 );
    EXIT IF EOF( INFILE ) THEN
      WRITELN(PACKFILE:J, ' NOT FOUND');
    WRITE('SEARCHED FILE:'); BREAK(OUTPUT);
    SEARCHED := '                     ';
    I := 1;
    READ( SEARCHED[0] );
    EXIT IF EOLN(INPUT);
    WHILE NOT EOLN(INPUT) DO BEGIN
      READ( SEARCHED[I] ); I := SUCC(I) END;
    I := PRED(I);
    SEARCHED[I] := CHR(0);
    LOOP
      FILENAME := '                     ';
      I := 0;
      WHILE NOT EOLN(INFILE) AND (I<20) DO BEGIN
	READ( INFILE, FILENAME[I] ); I := SUCC(I) END;
      FILENAME[I] := CHR(0);
      READLN( INFILE );
      EXIT IF FILENAME=SEARCHED THEN BEGIN
        REWRITE( OUTFILE, FILENAME, 2 );
        EOM := FALSE;
        WRITELN('FOUND ',FILENAME:I); BREAK(OUTPUT);
	WHILE NOT EOM DO BEGIN
	  NSTAR := 0;
	  FOR I := 1 TO 4 DO IF INFILE@ = '*' THEN BEGIN
	    NSTAR := SUCC(NSTAR); GET(INFILE) END;
	  IF NSTAR=4 THEN EOM := TRUE
	  ELSE BEGIN
	    FOR I := 1 TO NSTAR DO WRITE( OUTFILE, '*' );
	    WHILE NOT EOLN( INFILE ) DO BEGIN
	      READ( INFILE, C ); WRITE( OUTFILE, C ) END;
	    WRITELN( OUTFILE )
	    END;
	  READLN( INFILE ) END
	END;
      EXIT IF EOF( INFILE ) THEN
	WRITELN(SEARCHED:I, ' NOT FOUND');
    END;
  END
END.
****
 