	SUBROUTINE GRMARK(IBUF,X,MODE,IGR)
C
C	GRMARK ALLOWS THE USER TO PLACE OR ERASE A CURSOR FOR EITHER
C	GRAPH GIVEN THE VALUE X IN USER COORDINATES, THE MODE (0=ERASE,
C	NON ZERO = SET), AND THE GRAPH
C
C
C----------------------------------------------------------------
C
C	THE ARGUMENTS FOR THE SUBROUTINE ARE AS FOLLOWS:
C
C	IBUF	THE INFORMATION BUFFER DESCRIBED IN GRDOC
C	X	THE X AXIS POSITION OF THE CURSOR (MARKER)
C		CURSOR POSITIONS ON EXIT
C	MODE	=0 THEN ERASE THE MARKER, OTHERWISE CREATE ONE
C	IGR	THE GRAPH NUMBER (0/1)
C
C	DEFAULTS::
C
C	IGRAPH ==> 0
C
C
	DIMENSION IBUF(1),TEMP(2),ITEMP(4),IB(2)
	BYTE CMD(4),ENTRGR(3),EXITGR(3),IGCODE(2)
	EQUIVALENCE (TEMP(1),ITEMP(1))	!THIS IS TO PROVIDE A QUICK MEANS
	EQUIVALENCE (TEMP(1),XMIN)	!OF GETTING SCALED VALUES FROM
	EQUIVALENCE (TEMP(2),XMAX)	!FROM IBUF INTO THE APPROPRIATE
	DATA CMD(4)/0/
	DATA IB/10,18/
	DATA ENTRGR/"33,'1',0/
	DATA EXITGR/"33,'2',0/
	DATA IGCODE/'C','K'/ !CODES FOR ACCESSING THE GRAPH MARKERS
	F(Z,ZMAX,ZMIN)=(Z-ZMIN)/(ZMAX-ZMIN) !ARITH. STAT. FUNCTION
C
C	BEGINNING OF EXECUTABLE CODE
C
	CALL IDFLT(IGRAPH,0,IGR)	!CHECK FOR DEFAULT ON GRAPH #
	IF((IGRAPH.EQ.0).OR.(IGRAPH.EQ.1))GOTO 1 !IGRAPH OK?
	CALL ERRMSG('?GRMARK - invalid graph number, must be 0/1')
	CALL EXIT
	RETURN
1	IF(IBUF(27).EQ."52525)GOTO 4 !GRINIT CALLED?
	CALL ERRMSG('?GRMARK - GRINIT not called')
	CALL EXIT
	RETURN
4	IRGN=IBUF(8+IGRAPH)
	IF(IRGN.NE.-1)GOTO 3	!FIND WHICH REGION IS BEING PLOTTED
	CALL ERRMSG('?GRMARK - graph not assigned to region')
	CALL EXIT
	RETURN
C
C	GET SCALING VALUES FOR X AXIS
C
3	IBASE=IB(IGRAPH+1)
10	IF(IBUF(2+IGRAPH).NE.0)GOTO 12	!HAVE SCALED VALUES BEEN ENTERED?
	CALL ERRMSG('?GRMARK - scaling has not been provided for graph')
	CALL EXIT
	RETURN
12	DO 15 I=1,4
15	ITEMP(I)=IBUF(IBASE+I) !GET SCALED VALUES FROM IBUF
C
	CALL OUTSTR(ENTRGR) !ENTER GRAPHICS MODE
C
C	CHECK TO SEE IF GRAPH MARKERS HAVE BEEN ENABLED, IF NOT,
C	ENABLE THEM.
C
	MASK=4 !MASK VALUE FOR GRAPH 0
	IF(IGRAPH.EQ.1)MASK=8 !MASK VALUE FOR GRAPH 1
	IF((MASK.AND.IBUF(6)).NE.0)GOTO 90
	IBUF(6)=IBUF(6).OR.MASK !SET BIT
	CMD(1)='I'
	CMD(2)=IBUF(6)
	CMD(3)=IBUF(7)
	CALL OUTSTR(CMD,3) !UPDATE REGISTER 1
C
90	CMD(1)=IGCODE(IGRAPH+1)
	IX=F(X,XMAX,XMIN)*511.
	IF(MOD(IX,128).EQ.0)GOTO 999 !DON'T ERASE UNIT MARKERS
	ISET=0
	IF(MODE.NE.0)ISET=16
	CMD(2)=32+(IX.AND."37)
	CMD(3)=32+ISET+((IX.AND."740)/32)
	CALL OUTSTR(CMD) !ERASE/CREATE MARKER
999	CALL OUTSTR(EXITGR)
	RETURN
	END
                                       