#include <sy:std.h>
#include <sy:rt11.h>

char *_prmpt = 0;

static int daytab[2][13] = {
	{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},
	{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}
};
char *monnam[] = {
	"",
	"January",
	"February",
	"March",
	"April",
	"May",
	"June",
	"July",
	"August",
	"September",
	"October",
	"November",
	"December"
};
char *daynam[] = {
	"Sunday",
	"Monday",
	"Tuesday",
	"Wednesday",
	"Thursday",
	"Friday",
	"Saturday"
};

main()
{
	int year = 0;
	int month = 0;
	int day = 0;
	int hour = 0;
	int minute = 0;
	int second = 0;
	int dow = 0;
	char ampm = '\0';

	getdate(&year,&month,&day);
	year += 1900;
	dow = weekdy(year,month,day);
	gettim(&hour,&minute,&second);
	if (hour < 12)
		ampm = 'a';
	else
		ampm = 'p';
	if (hour == 0)
	{
		hour = 12;
	}
	else if (hour > 12)
	{
		hour -= 12;
	}
	putfmt("%p, %p %i, %i  %i:%+02i:%+02i %acm\n",daynam[dow],
		monnam[month],day,year,hour,minute,second,ampm);
}

getdate(pyear,pmonth,pday)
int *pyear;
int *pmonth;
int *pday;
{
	register int x;

	if (x = emt(0374,10<<8))
	{
		*pyear = ((x & 037)+72);
		*pday = (x>>5) & 037;
		*pmonth = (x>>10) & 017;
	}
	else
		*pyear = *pday = *pmonth = 0;
	return(x);
}

weekdy(byear,month,day)		/* return 0 to 6 for SUN to SAT */
int byear;
int month;
int day;
{
	register int i;
	register int dow;	/* day of the week */

	dow = byear - 1900;
	for (i = 1900;i < byear;i += 4)
		if (i % 100 || !(i % 400))
			dow++;
	return((dow + julian(byear,month,day)) % 7);
}

julian(byear,month,day)		/* returns julian date */
int byear;
int month;
int day;
{
	register int i;
	register int leap;

	leap = byear%4 == 0 && byear%100 != 0 || byear%400 == 0;
	for (i = 1;i < month;i++)
		day += daytab[leap][i];
	return(day);
}

gettim(phour,pmin,psec)	/* get the system time */
int *phour;
int *pmin;
int *psec;
{
	long time;
	long nsec;

	emt375(021<<8,&time);
	nsec = time / 60;	/* 60 cycles */
	*phour = nsec / 3600;
	nsec -= *phour * 3600L;
	*pmin = nsec / 60;
	*psec = nsec - (*pmin * 60);
}
                                                                                                                                                                                                                                                                                                                                                                                                                                       