      PROGRAM BENBYS
C
C     BENchmark BYte Sort.
C
C     This benchmark program is used for measuring the  relative  speeds
C     computers, under different compiler options, for  byte operations.
C
C     The program:
C                   (1) Reads a file of 80-column aphorisms, APHORI.DAT;
C                   (2) Sorts it in alphabetic order,  using the classic
C                       bubble-sort algorithm with data interchange; and
C                   (3) Displays the sorted results on the console.
C
C     Note:  The bubble sort algorithm with interchange of data is a not
C            an efficient algorithm.   It was chosen here to ensure that
C            many byte comparisons and copys are done  in  a  relatively
C            short program.
C
C     Program by Harry M. Murphy,  17 June 1982.
C     
C
      BYTE TEMP,APHOR(80,300)
C
      INTEGER HI,I,J,LAST,LIM,LO,NDIM,NREC
C
      REAL TOTAL,TREAD,TSHOW,TSORT,T1,T2,T3,T4
C
      DATA NDIM/300/
C
C                   Start.  Open the aphorism file.
C
    1 OPEN (UNIT=1,NAME='APHORI.DAT',TYPE='OLD',READONLY)
C                   Mark the time and read the aphorisms.
      TYPE 100
      T1=SECNDS(0.0)
      DO 2 J=1,NDIM
      READ (1,101,END=3) (APHOR(I,J),I=1,80)
    2 CONTINUE
      J=NDIM+1
C                   Close the file and mark the time.
    3 NREC=J-1
      CLOSE (UNIT=1)
      TYPE 102, NREC
      T2=SECNDS(0.0)
C                   Bubble-shot starts here.
      LAST=NREC
    4 LIM=LAST-1
      LAST=0
      DO 8 LO=1,LIM
      HI=LO+1
C                   Compare two adjacent lines.
      DO 5 I=1,80
      IF (APHOR(I,LO)-APHOR(I,HI)) 8,5,6
    5 CONTINUE
      GO TO 8
C                   Interchange two lines and mark the place.
    6 LAST=LO
      DO 7 I=1,80
      TEMP=APHOR(I,LO)
      APHOR(I,LO)=APHOR(I,HI)
      APHOR(I,HI)=TEMP
    7 CONTINUE
C                   End of main bubble-sort loop.
C                   If interchanges, then make another pass.
    8 CONTINUE
      IF (LAST.NE.0) GO TO 4
C                   Bubble-sort complete.  Mark the time.
      TYPE 103
      T3=SECNDS(0.0)
C                   Display the sorted aphorisms.
      DO 9 J=1,NREC
      TYPE 104,(APHOR(I,J),I=1,80)
    9 CONTINUE
C                   Mark the time and report all times.
      T4=SECNDS(0.0)
      TREAD=T2-T1
      TSORT=T3-T2
      TSHOW=T4-T3
      TOTAL=T4-T1
C
      TYPE 105,NREC,TREAD,TSORT,TSHOW,TOTAL
      STOP
C
  100 FORMAT (1X/' B E N B Y S   (BENchmark BYte Sort)'/' FORTRAN'/1X/
     .  ' Reading now.')
  101 FORMAT (80A1)
  102 FORMAT (' Sorting',I4,' records now.')
  103 FORMAT (' Sorted output:'/1X)
  104 FORMAT (1X,80A1)
  105 FORMAT (1X/' Lines sorted =',I4/
     .           '    Read time =',F6.1,' seconds.'/
     .           '    Sort time =',F6.1,' seconds.'/
     .           '    Show time =',F6.1,' seconds.'/
     .           '   Total time =',F6.1,' seconds.'/1X/
     .           ' FORTRAN BENchmark BYte Sort.'/1X)
      END
                   