C** CONSOL ** PROGRAM TO CHANGE EFFECTIVE RT11 CONSOLE DEVICE
C
C
	IMPLICIT INTEGER (A-Z)
	DIMENSION VECTOR(4),TVEC(6),TADDER(6)
C
C--SET UP TVEC TO CONTAIN THE VECTORS OF THE TERMINALS INSTALLED
C	ON THE SYSTEM.  THE FIRST ENTRY MUST BE FOR THE STANDARD CONSOLE,
C	TT0:, OTHERS ARE FOR TT1: THRU TT5:.
C	NOTE THAT TVEC CONTAINS THE FIRST OF THE 4 VECTORS
C	USED BY A GIVEN TERMINAL, CONSOL ASSUMES THAT THE 4 LOCATIONS ARE
C	CONTIGUOUS, BEGINNING AT THE ONE SPECIFIED IN TVEC.
C
	DATA TVEC/"60,"300,"310,"320,"320,"320/
C
C--SET UP TADDER TO CONTAIN THE ADDRESSES OF TERMINALS INSTALLED
C	ON THE SYSTEM.  THE FIRST ENTRY MUST BE FOR THE STANDARD CONSOLE,
C	TT0:, OHTERS ARE FOR TT1: THRU TT5:, IN ORDER.  THE ADDRESSES
C	MUST MATCH THE ORDER OF THE VECTORS ASSIGNED IN TVEC. NOTE THAT
C	TADDER CONTAINS THE FIRST OF THE 4 ADDRESSES USED BY A GIVEN
C	TERMINAL, CONSOL ASSUMES THAT THE 4 ADDRESSES ARE CONTIGUOUS,
C	BEGINNING AT THE ONE SPECIFIED IN TADDER.
C
	DATA TADDER/"177560,"176500,"175610,"175620,"175620,"175620/
C
C--NOTE: CONSOL ASSUMES THAT THE MONITOR IS PERMINATELY PATCHED
C	TO PROTECT THE VECTORS USED BY ALL INSTALLED TERMINALS AND 
C	THEREFORE DOES NOT MODIFY THE BITMAP TO PROTECT THE VECTORS
C	OF THE SELECTED TERMINAL.
C
C
	RMON=IPEEK("54)		!GET START OF RESIDENT MONITOR
	PAGEAD=RMON+"304		!OFFSET TO TTY I/O POINTERS
C
9	CALL PRINT ('WHICH TERMINAL DO YOU WANT TO BECOME THE CONSOLE?
	* (1-6):')
C
1	I=ITTINR()		!GET A CHAR. FROM TERMINAL
	IF (I .LT. 0) GO TO 1		!WAS ONE THERE??
	ITERM=I-"60			!CONVERT DIGIT TO A NUMBER
	IF (I .LT. "60 .OR. I .GT. "65) GO TO 9		!LEGAL DIGIT?
	ITERM=ITERM+1			!OFFSET FOR TT0
C
C--GET CONTENTS OF CURRENT CONSOLE VECTORS
C
	DO 8 I=1,6				!WHICH TERM IS NOW IN USE?
	IF (IPEEK(PAGEAD) .EQ. TADDER(I)) GO TO 7
8	CONTINUE
C
7	J=TVEC(I)
	DO 2 I=1,4
	VECTOR(I)=IPEEK(J)
2	J=J+2
C
C--PUT ADDERS IN NEW VECTOR AND NEW ADDERS INTO I/O PAGE POINTERS
C
	DO 4 I=0,3
	CALL IPOKE (TVEC(ITERM)+2*I,VECTOR(I+1))
	CALL IPOKE (PAGEAD+2*I,TADDER(ITERM)+2*I)
4	CONTINUE
C
	CALL PRINT ('ACTIVE CONSOLE')
	CALL EXIT
	END
                                                                                                                                                                                                                                                                                                                                                                                                                                                       